/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dependency;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.maven.MavenUtils;
import org.apache.maven.java.ImportStatementVisitor;
import org.apache.maven.java.SourceTool;
import org.apache.maven.java.parser.JavaParserVisitor;

public class ProjectResolver {
    private File base;
    private List packageReferences;
    private List packageExcludes;
    private File mapFile;
    private List projectReferences;
    private SourceTool st = new SourceTool();
    private ImportStatementVisitor isv = new ImportStatementVisitor();

    public ProjectResolver() {
        this.st.setVisitor((JavaParserVisitor)this.isv);
        this.packageReferences = new LinkedList();
        this.packageExcludes = new LinkedList();
        this.projectReferences = new LinkedList();
    }

    public void setPackageExcludes(String packageExcludesList) {
        StringTokenizer st = new StringTokenizer(packageExcludesList, ",");
        while (st.hasMoreTokens()) {
            String packageExclude = st.nextToken();
            this.packageExcludes.add(packageExclude);
        }
    }

    public void setBase(File base) {
        this.base = base;
    }

    public File getBase() {
        return this.base;
    }

    public void setMapFile(File mapFile) {
        this.mapFile = mapFile;
    }

    public List getPackageReferences() {
        return this.packageReferences;
    }

    public List getProjectReferences() {
        return this.projectReferences;
    }

    public void resolveDependencies() throws Exception {
        if (this.base.isDirectory()) {
            String[] files = MavenUtils.getFiles((String)this.base.getAbsolutePath(), (String)"**/*.java");
            int i = 0;
            while (i < files.length) {
                String file = files[i];
                try {
                    this.st.parse((InputStream)new FileInputStream(file));
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
        }
        Iterator j = this.isv.getImportStatements().iterator();
        while (j.hasNext()) {
            String classReference = (String)j.next();
            this.processClassReference(classReference);
        }
        Properties map = new Properties();
        try {
            map.load(new FileInputStream(this.mapFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap projects = new HashMap();
        List packageReferences = this.getPackageReferences();
        Iterator i = packageReferences.iterator();
        while (i.hasNext()) {
            String classReference = (String)i.next();
            Iterator j2 = ((Hashtable)map).keySet().iterator();
            while (j2.hasNext()) {
                String packageKey = (String)j2.next();
                if (classReference.indexOf(packageKey) != 0) continue;
                Object o = ((Hashtable)map).get(packageKey);
                projects.put(o, o);
            }
        }
        this.projectReferences.addAll(projects.values());
    }

    private void processClassReference(String classReference) {
        boolean includePackage = true;
        Iterator j = this.packageExcludes.iterator();
        while (j.hasNext()) {
            String packageExclude = (String)j.next();
            if (!classReference.startsWith(packageExclude)) continue;
            includePackage = false;
            break;
        }
        if (includePackage) {
            this.packageReferences.add(classReference);
        }
    }

    public void execute() throws Exception {
        try {
            this.resolveDependencies();
            List projectReferences = this.getProjectReferences();
            File f = new File(this.getBase(), "deps.xml");
            PrintStream ps = new PrintStream(new FileOutputStream(new File(this.getBase(), "deps.xml")));
            ps.println("<project>");
            Iterator i = projectReferences.iterator();
            while (i.hasNext()) {
                String projectReference = (String)i.next();
                ps.println("  <dependency>");
                ps.println("    <id>" + projectReference + "</id>");
                ps.println("    <version>???</version>");
                ps.println("  </dependency>");
            }
            ps.println("</project>");
            ps.flush();
            ps.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

