/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.eclipsejdt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

public class NameEnvironment
implements INameEnvironment {
    private static final int END_OF_STREAM = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private ClassLoader classLoader;

    public NameEnvironment(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
        String result = "";
        String sep = "";
        for (int i = 0; i < compoundTypeName.length; ++i) {
            result = result + sep;
            result = result + new String(compoundTypeName[i]);
            sep = ".";
        }
        return this.findType(result);
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        String result = "";
        String sep = "";
        for (int i = 0; i < packageName.length; ++i) {
            result = result + sep;
            result = result + new String(packageName[i]);
            sep = ".";
        }
        result = result + sep;
        result = result + new String(typeName);
        return this.findType(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NameEnvironmentAnswer findType(String className) {
        NameEnvironmentAnswer nameEnvironmentAnswer;
        String resourceName = className.replace('.', '/') + ".class";
        InputStream is = this.classLoader.getResourceAsStream(resourceName);
        if (is == null) {
            return null;
        }
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while ((n = is.read(buffer)) != -1) {
                output.write(buffer, 0, n);
            }
            byte[] classBytes = output.toByteArray();
            char[] fileName = className.toCharArray();
            ClassFileReader classFileReader = new ClassFileReader(classBytes, fileName, true);
            nameEnvironmentAnswer = new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
            catch (ClassFormatException e) {
                return null;
            }
        }
        is.close();
        return nameEnvironmentAnswer;
    }

    private boolean isPackage(String result) {
        String resourceName = "/" + result.replace('.', '/') + ".class";
        InputStream is = this.classLoader.getResourceAsStream(resourceName);
        return is == null;
    }

    public boolean isPackage(char[][] parentPackageName, char[] packageName) {
        String result = "";
        String sep = "";
        if (parentPackageName != null) {
            for (int i = 0; i < parentPackageName.length; ++i) {
                result = result + sep;
                result = result + new String(parentPackageName[i]);
                sep = ".";
            }
        }
        if (Character.isUpperCase(packageName[0])) {
            return false;
        }
        String str = new String(packageName);
        result = result + sep;
        result = result + str;
        return this.isPackage(result);
    }

    public void cleanup() {
    }
}

