/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator;

import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import ma.glasnost.orika.impl.generator.ByteCodeClassLoader;
import ma.glasnost.orika.impl.generator.eclipsejdt.CompilationUnit;
import ma.glasnost.orika.impl.generator.eclipsejdt.CompilerRequestor;
import ma.glasnost.orika.impl.generator.eclipsejdt.NameEnvironment;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseJdtCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseJdtCompiler.class);
    private static final String JAVA_COMPILER_SOURCE_VERSION = "1.5";
    private static final String JAVA_COMPILER_COMPLIANCE_VERSION = "1.5";
    private static final String JAVA_COMPILER_CODEGEN_TARGET_PLATFORM_VERSION = "1.5";
    private static final String JAVA_SOURCE_ENCODING = "UTF-8";
    private final ByteCodeClassLoader byteCodeClassLoader = new ByteCodeClassLoader(this.getClass().getClassLoader());
    private final CodeFormatter formatter = ToolFactory.createCodeFormatter(this.getFormattingOptions());
    private final INameEnvironment compilerNameEnvironment = new NameEnvironment(this.byteCodeClassLoader);
    private final CompilerRequestor compilerRequester = new CompilerRequestor();
    private final Compiler compiler = new Compiler(this.compilerNameEnvironment, DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.getCompilerOptions(), (ICompilerRequestor)this.compilerRequester, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()));

    private Map<Object, Object> getFormattingOptions() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.jdt.core.compiler.source", "1.5");
        options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        return options;
    }

    private CompilerOptions getCompilerOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        options.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", "enabled");
        options.put("org.eclipse.jdt.core.compiler.source", "1.5");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        options.put("org.eclipse.jdt.core.encoding", JAVA_SOURCE_ENCODING);
        options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        return new CompilerOptions(options);
    }

    public String formatSource(String code) {
        String lineSeparator = "\n";
        TextEdit te = this.formatter.format(8, code, 0, code.length(), 0, lineSeparator);
        if (te == null) {
            throw new IllegalArgumentException("source code was unable to be formatted; \n//--- BEGIN ---\n" + code + "\n//--- END ---");
        }
        Document doc = new Document(code);
        try {
            te.apply((IDocument)doc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String formattedCode = doc.get();
        return formattedCode;
    }

    public void assertTypeAccessible(Class<?> type) throws IllegalStateException {
        if (!type.isPrimitive() && type.getClassLoader() != null) {
            String resourceName = type.isArray() ? type.getComponentType().getName() : type.getName();
            URL url = this.byteCodeClassLoader.getResource(resourceName = resourceName.replace('.', '/') + ".class");
            if (url == null) {
                throw new IllegalStateException(type + " is not accessible");
            }
        }
    }

    public Class<?> compileAndLoad(String source, String packageName, String classSimpleName) throws ClassNotFoundException {
        String className = packageName + "." + classSimpleName;
        return this.load(className, this.compile(source, packageName, classSimpleName));
    }

    public byte[] compile(String source, String packageName, String classSimpleName) {
        Map<String, byte[]> compiledClasses = this.compile(source, packageName, classSimpleName, Thread.currentThread().getContextClassLoader());
        String className = packageName + "." + classSimpleName;
        byte[] data = compiledClasses.get(className);
        return data;
    }

    public Class<?> load(String className, byte[] data) throws ClassNotFoundException {
        this.byteCodeClassLoader.putClassData(className, data);
        return this.byteCodeClassLoader.loadClass(className);
    }

    public byte[] getBytes(String className) {
        return this.byteCodeClassLoader.getBytes(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, byte[]> compile(String source, String packageName, String className, ClassLoader classLoader) {
        CompilationUnit unit = new CompilationUnit(source, packageName, className);
        Map<String, byte[]> compiledClasses = null;
        Compiler compiler = this.compiler;
        synchronized (compiler) {
            this.compilerRequester.reset();
            this.compiler.compile(new ICompilationUnit[]{unit});
            if (this.compilerRequester.getProblems() != null) {
                StringBuilder warningText = new StringBuilder();
                StringBuilder errorText = new StringBuilder();
                boolean hasErrors = false;
                for (IProblem p : this.compilerRequester.getProblems()) {
                    if (p.isError()) {
                        hasErrors = true;
                        errorText.append("ERROR: " + p.toString() + "\n\n");
                        continue;
                    }
                    warningText.append("WARNING: " + p.toString() + "\n\n");
                }
                if (hasErrors) {
                    throw new RuntimeException("Compilation encountered errors:\n" + errorText.toString() + "\n\n" + warningText.toString());
                }
                LOG.warn("Compiler warnings:" + warningText.toString());
            }
            compiledClasses = this.compilerRequester.getCompiledClassFiles();
        }
        return compiledClasses;
    }
}

