/*
 * Decompiled with CFR 0.152.
 */
package ltd.dolink.arch.adapter;

import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewbinding.ViewBinding;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import ltd.dolink.arch.adapter.CellAdapter;
import ltd.dolink.arch.adapter.CellState;
import ltd.dolink.arch.adapter.CellView;

public abstract class CellViewHolder<STATE extends CellState, VB extends ViewBinding>
extends RecyclerView.ViewHolder
implements CellView<STATE> {
    private final VB viewBinding;
    private final LifecycleOwner lifecycleOwner = new LifecycleOwner(){
        private final LifecycleRegistry lifecycleRegistry = new LifecycleRegistry((LifecycleOwner)this);

        @NonNull
        public Lifecycle getLifecycle() {
            return this.lifecycleRegistry;
        }
    };
    private CellAdapter adapter;

    public CellViewHolder(@NonNull VB viewBinding) {
        super(viewBinding.getRoot());
        this.viewBinding = viewBinding;
        if (this.lifecycleOwner.getLifecycle() instanceof LifecycleRegistry) {
            LifecycleRegistry lifecycleRegistry = (LifecycleRegistry)this.lifecycleOwner.getLifecycle();
            lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_CREATE);
        }
    }

    protected CellAdapter getAdapter() {
        return this.adapter;
    }

    void setAdapter(@NonNull CellAdapter adapter) {
        this.adapter = adapter;
    }

    protected void onViewAttachedToWindow() {
        if (this.lifecycleOwner.getLifecycle() instanceof LifecycleRegistry) {
            LifecycleRegistry lifecycleRegistry = (LifecycleRegistry)this.lifecycleOwner.getLifecycle();
            lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_START);
        }
    }

    protected void onViewDetachedFromWindow() {
        if (this.lifecycleOwner.getLifecycle() instanceof LifecycleRegistry) {
            LifecycleRegistry lifecycleRegistry = (LifecycleRegistry)this.lifecycleOwner.getLifecycle();
            lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_DESTROY);
        }
    }

    protected void onViewRecycled() {
    }

    protected boolean onFailedToRecycleView() {
        return false;
    }

    public VB getViewBinding() {
        return this.viewBinding;
    }

    public final void setState(@NonNull STATE state) {
        this.setState((CellState)state, null);
    }

    @NonNull
    public LifecycleOwner getLifecycleOwner() {
        return this.lifecycleOwner;
    }

    public static class DefaultFactory<STATE extends CellState, VB extends ViewBinding, VH extends CellViewHolder<STATE, VB>>
    implements Factory<STATE, VB, VH> {
        @NonNull
        private final Class<VH> viewHolderClass;

        public DefaultFactory(@NonNull Class<VH> viewHolderClass) {
            Objects.requireNonNull(viewHolderClass);
            this.viewHolderClass = viewHolderClass;
        }

        @Override
        public VH create(@NonNull VB viewBinding) {
            try {
                Constructor<VH> constructor = this.viewHolderClass.getConstructor(viewBinding.getClass());
                constructor.setAccessible(true);
                return (VH)((CellViewHolder)constructor.newInstance(viewBinding));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface Factory<STATE extends CellState, VB extends ViewBinding, VH extends CellViewHolder<STATE, VB>> {
        public VH create(@NonNull VB var1);
    }
}

