/*
 * Decompiled with CFR 0.152.
 */
package ltd.dolink.arch.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.viewbinding.ViewBinding;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ltd.dolink.arch.Effect;
import ltd.dolink.arch.Intent;
import ltd.dolink.arch.adapter.CellState;
import ltd.dolink.arch.adapter.CellViewHolder;
import ltd.dolink.arch.viewbinding.ViewBindingFactory;

public abstract class CellBinder {
    private final Map<Integer, ViewHolderFactoryBoundViewBinding> viewHolderFactoryMap = new HashMap<Integer, ViewHolderFactoryBoundViewBinding>();

    public abstract CellState getItem(int var1);

    public abstract int getItemCount();

    public <STATE extends CellState, EFFECT extends Effect, INTENT extends Intent, VB extends ViewBinding, VH extends CellViewHolder<STATE, EFFECT, INTENT, VB>> void link(int cellType, @NonNull Class<STATE> stateClass, @NonNull Class<VB> viewBindingClass, @NonNull Class<VH> viewHolderClass) {
        this.link(cellType, stateClass, ViewBindingFactory.of(viewBindingClass), new CellViewHolder.DefaultFactory(viewHolderClass));
    }

    public <STATE extends CellState, EFFECT extends Effect, INTENT extends Intent, VB extends ViewBinding, VH extends CellViewHolder<STATE, EFFECT, INTENT, VB>> void link(int cellType, @NonNull Class<STATE> stateClass, @NonNull ViewBindingFactory<VB> viewBindingFactory, @NonNull Class<VH> viewHolderClass) {
        this.link(cellType, stateClass, viewBindingFactory, new CellViewHolder.DefaultFactory(viewHolderClass));
    }

    public <STATE extends CellState, EFFECT extends Effect, INTENT extends Intent, VB extends ViewBinding, VH extends CellViewHolder<STATE, EFFECT, INTENT, VB>> void link(int cellType, @NonNull Class<STATE> stateClass, @NonNull Class<VB> viewBindingClass, @NonNull CellViewHolder.Factory<STATE, EFFECT, INTENT, VB, VH> viewHolderFactory) {
        this.link(cellType, stateClass, ViewBindingFactory.of(viewBindingClass), viewHolderFactory);
    }

    public <STATE extends CellState, EFFECT extends Effect, INTENT extends Intent, VB extends ViewBinding, VH extends CellViewHolder<STATE, EFFECT, INTENT, VB>> void link(int cellType, @NonNull Class<STATE> stateClass, @NonNull ViewBindingFactory<VB> viewBindingFactory, @NonNull CellViewHolder.Factory<STATE, EFFECT, INTENT, VB, VH> viewHolderFactory) {
        this.viewHolderFactoryMap.put(cellType, new ViewHolderFactoryBoundViewBinding<STATE, EFFECT, INTENT, VB, VH>(stateClass, viewBindingFactory, viewHolderFactory));
    }

    protected <STATE extends CellState, EFFECT extends Effect, INTENT extends Intent, VB extends ViewBinding, VH extends CellViewHolder<STATE, EFFECT, INTENT, VB>> VH createViewHolder(@NonNull ViewGroup parent, int cellType) {
        ViewHolderFactoryBoundViewBinding viewHolderFactory = this.viewHolderFactoryMap.get(cellType);
        Objects.requireNonNull(viewHolderFactory);
        ViewBinding viewBinding = viewHolderFactory.viewBindingFactory.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
        return viewHolderFactory.create(viewBinding);
    }

    static class ViewHolderFactoryBoundViewBinding<STATE extends CellState, EFFECT extends Effect, INTENT extends Intent, VB extends ViewBinding, VH extends CellViewHolder<STATE, EFFECT, INTENT, VB>>
    implements CellViewHolder.Factory<STATE, EFFECT, INTENT, VB, VH> {
        @NonNull
        private final ViewBindingFactory<VB> viewBindingFactory;
        @NonNull
        private final Class<STATE> stateClass;
        @NonNull
        private final CellViewHolder.Factory<STATE, EFFECT, INTENT, VB, VH> viewHolderFactory;

        ViewHolderFactoryBoundViewBinding(@NonNull Class<STATE> stateClass, @NonNull ViewBindingFactory<VB> viewBindingFactory, @NonNull CellViewHolder.Factory<STATE, EFFECT, INTENT, VB, VH> viewHolderFactory) {
            this.stateClass = stateClass;
            this.viewBindingFactory = viewBindingFactory;
            this.viewHolderFactory = viewHolderFactory;
        }

        @Override
        public VH create(@NonNull VB viewBinding) {
            return this.viewHolderFactory.create(viewBinding);
        }
    }

    public static class ArrayBinder<STATE extends CellState>
    extends CellBinder {
        @NonNull
        private final STATE[] data;

        public ArrayBinder(@NonNull STATE[] data) {
            this.data = data;
        }

        @NonNull
        public STATE[] getData() {
            return this.data;
        }

        public STATE getItem(int position) {
            return this.data[position];
        }

        @Override
        public int getItemCount() {
            return this.data.length;
        }
    }

    public static class ListCellBinder<STATE extends CellState>
    extends CellBinder {
        @NonNull
        private final List<STATE> data;

        public ListCellBinder(@NonNull List<STATE> data) {
            this.data = data;
        }

        @NonNull
        public List<STATE> getData() {
            return this.data;
        }

        public STATE getItem(int position) {
            return (STATE)((CellState)this.data.get(position));
        }

        @Override
        public int getItemCount() {
            return this.data.size();
        }
    }
}

