/*
 * Decompiled with CFR 0.152.
 */
package ltd.dolink.arch.adapter;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewbinding.ViewBinding;
import java.util.List;
import java.util.Objects;
import ltd.dolink.arch.Effect;
import ltd.dolink.arch.Intent;
import ltd.dolink.arch.adapter.CellBinder;
import ltd.dolink.arch.adapter.CellState;
import ltd.dolink.arch.adapter.CellViewHolder;

public abstract class CellAdapter
extends RecyclerView.Adapter<CellViewHolder<CellState, Effect, Intent, ViewBinding>> {
    @NonNull
    private final CellBinder cellBinder = this.initializeCellBinder();

    protected CellAdapter() {
        Objects.requireNonNull(this.cellBinder);
    }

    @NonNull
    public CellBinder getCellBinder() {
        return this.cellBinder;
    }

    protected abstract CellBinder initializeCellBinder();

    public int getItemCount() {
        return this.cellBinder.getItemCount();
    }

    public CellState getItem(int position) {
        return this.cellBinder.getItem(position);
    }

    public int getItemViewType(int position) {
        return this.getItem(position).getStateType();
    }

    @NonNull
    public CellViewHolder<CellState, Effect, Intent, ViewBinding> onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        Object viewHolder = this.cellBinder.createViewHolder(parent, viewType);
        ((CellViewHolder)viewHolder).setAdapter(this);
        return viewHolder;
    }

    public void onViewAttachedToWindow(@NonNull CellViewHolder<CellState, Effect, Intent, ViewBinding> holder) {
        holder.onViewAttachedToWindow();
    }

    public void onViewDetachedFromWindow(@NonNull CellViewHolder<CellState, Effect, Intent, ViewBinding> holder) {
        holder.onViewDetachedFromWindow();
    }

    public void onViewRecycled(@NonNull CellViewHolder<CellState, Effect, Intent, ViewBinding> holder) {
        holder.onViewRecycled();
    }

    public boolean onFailedToRecycleView(@NonNull CellViewHolder<CellState, Effect, Intent, ViewBinding> holder) {
        return holder.onFailedToRecycleView();
    }

    public void onBindViewHolder(@NonNull CellViewHolder<CellState, Effect, Intent, ViewBinding> holder, int position) {
        holder.setState(this.getItem(position));
    }

    public void onBindViewHolder(@NonNull CellViewHolder<CellState, Effect, Intent, ViewBinding> holder, int position, @NonNull List<Object> payloads) {
        holder.setState(this.getItem(position), payloads);
    }
}

