/*
 * Decompiled with CFR 0.152.
 */
package ltd.dolink.arch.adapter;

import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewbinding.ViewBinding;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import ltd.dolink.arch.Effect;
import ltd.dolink.arch.Intent;
import ltd.dolink.arch.adapter.CellAdapter;
import ltd.dolink.arch.adapter.CellState;
import ltd.dolink.arch.adapter.CellView;

public abstract class CellViewHolder<STATE extends CellState, EFFECT extends Effect, INTENT extends Intent, VB extends ViewBinding>
extends RecyclerView.ViewHolder
implements CellView<STATE, EFFECT, INTENT> {
    private final VB viewBinding;
    private final LifecycleOwner lifecycleOwner = new LifecycleOwner(){
        private final LifecycleRegistry lifecycleRegistry = new LifecycleRegistry((LifecycleOwner)this);

        @NonNull
        public Lifecycle getLifecycle() {
            return this.lifecycleRegistry;
        }
    };
    private CellAdapter adapter;

    public CellViewHolder(@NonNull VB viewBinding) {
        super(viewBinding.getRoot());
        this.viewBinding = viewBinding;
        if (this.lifecycleOwner.getLifecycle() instanceof LifecycleRegistry) {
            LifecycleRegistry lifecycleRegistry = (LifecycleRegistry)this.lifecycleOwner.getLifecycle();
            lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_CREATE);
        }
    }

    protected CellAdapter getAdapter() {
        return this.adapter;
    }

    void setAdapter(@NonNull CellAdapter adapter) {
        this.adapter = adapter;
    }

    protected void onViewAttachedToWindow() {
        if (this.lifecycleOwner.getLifecycle() instanceof LifecycleRegistry) {
            LifecycleRegistry lifecycleRegistry = (LifecycleRegistry)this.lifecycleOwner.getLifecycle();
            lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_START);
        }
    }

    protected void onViewDetachedFromWindow() {
        if (this.lifecycleOwner.getLifecycle() instanceof LifecycleRegistry) {
            LifecycleRegistry lifecycleRegistry = (LifecycleRegistry)this.lifecycleOwner.getLifecycle();
            lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_DESTROY);
        }
    }

    protected void onViewRecycled() {
    }

    protected boolean onFailedToRecycleView() {
        return false;
    }

    public VB getViewBinding() {
        return this.viewBinding;
    }

    @NonNull
    public LifecycleOwner getLifecycleOwner() {
        return this.lifecycleOwner;
    }

    public static class DefaultFactory<STATE extends CellState, EFFECT extends Effect, INTENT extends Intent, VB extends ViewBinding, VH extends CellViewHolder<STATE, EFFECT, INTENT, VB>>
    implements Factory<STATE, EFFECT, INTENT, VB, VH> {
        @NonNull
        private final Class<VH> viewHolderClass;

        public DefaultFactory(@NonNull Class<VH> viewHolderClass) {
            Objects.requireNonNull(viewHolderClass);
            this.viewHolderClass = viewHolderClass;
        }

        @Override
        public VH create(@NonNull VB viewBinding) {
            try {
                Constructor<VH> constructor = this.viewHolderClass.getConstructor(viewBinding.getClass());
                constructor.setAccessible(true);
                return (VH)((CellViewHolder)constructor.newInstance(viewBinding));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface Factory<STATE extends CellState, EFFECT extends Effect, INTENT extends Intent, VB extends ViewBinding, VH extends CellViewHolder<STATE, EFFECT, INTENT, VB>> {
        public VH create(@NonNull VB var1);
    }
}

