/*
 * Decompiled with CFR 0.152.
 */
package ltd.dolink.arch.adapter;

import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewbinding.ViewBinding;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import ltd.dolink.arch.State;
import ltd.dolink.arch.adapter.CellAdapter;
import ltd.dolink.arch.adapter.CellState;
import ltd.dolink.arch.adapter.CellView;

public abstract class CellViewHolder<VB extends ViewBinding, STATE extends State>
extends RecyclerView.ViewHolder
implements CellView<STATE> {
    private final VB viewBinding;
    private final LifecycleOwner lifecycleOwner = new LifecycleOwner(){
        private final LifecycleRegistry lifecycleRegistry = new LifecycleRegistry((LifecycleOwner)this);

        @NonNull
        public Lifecycle getLifecycle() {
            return this.lifecycleRegistry;
        }
    };
    private CellAdapter adapter;

    public CellViewHolder(@NonNull VB viewBinding) {
        super(viewBinding.getRoot());
        this.viewBinding = viewBinding;
    }

    protected CellAdapter getAdapter() {
        return this.adapter;
    }

    CellViewHolder<VB, STATE> setAdapter(@NonNull CellAdapter adapter) {
        this.adapter = adapter;
        return this;
    }

    protected void onViewAttachedToWindow() {
        if (this.lifecycleOwner.getLifecycle() instanceof LifecycleRegistry) {
            LifecycleRegistry lifecycleRegistry = (LifecycleRegistry)this.lifecycleOwner.getLifecycle();
            lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_CREATE);
        }
    }

    protected void onViewDetachedFromWindow() {
        if (this.lifecycleOwner.getLifecycle() instanceof LifecycleRegistry) {
            LifecycleRegistry lifecycleRegistry = (LifecycleRegistry)this.lifecycleOwner.getLifecycle();
            lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_DESTROY);
        }
    }

    protected void onViewRecycled() {
    }

    protected boolean onFailedToRecycleView() {
        return false;
    }

    public VB getViewBinding() {
        return this.viewBinding;
    }

    @NonNull
    public LifecycleOwner getLifecycleOwner() {
        return this.lifecycleOwner;
    }

    public static class DefaultFactory<VB extends ViewBinding, STATE extends CellState, VH extends CellViewHolder<VB, STATE>>
    implements Factory<VB, STATE, VH> {
        @NonNull
        private final Class<VH> viewHolderClass;

        public DefaultFactory(@NonNull Class<VH> viewHolderClass) {
            Objects.requireNonNull(viewHolderClass);
            this.viewHolderClass = viewHolderClass;
        }

        @Override
        public VH create(@NonNull VB viewBinding) {
            try {
                return (VH)((CellViewHolder)this.viewHolderClass.getConstructor(viewBinding.getClass()).newInstance(viewBinding));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface Factory<VB extends ViewBinding, STATE extends CellState, VH extends CellViewHolder<VB, STATE>> {
        public VH create(@NonNull VB var1);
    }
}

