/*
 * Decompiled with CFR 0.152.
 */
package ltd.dolink.arch.adapter;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewbinding.ViewBinding;
import java.util.List;
import java.util.Objects;
import ltd.dolink.arch.adapter.CellBinder;
import ltd.dolink.arch.adapter.CellState;
import ltd.dolink.arch.adapter.CellViewHolder;

public abstract class CellAdapter
extends RecyclerView.Adapter<CellViewHolder<ViewBinding, CellState>> {
    @NonNull
    private final CellBinder cellBinder = this.initializeCellBinder();

    protected CellAdapter() {
        Objects.requireNonNull(this.cellBinder);
    }

    @NonNull
    public CellBinder getCellBinder() {
        return this.cellBinder;
    }

    protected abstract CellBinder initializeCellBinder();

    public int getItemCount() {
        return this.cellBinder.getItemCount();
    }

    public CellState getItem(int position) {
        return this.cellBinder.getItem(position);
    }

    public int getItemViewType(int position) {
        return this.getItem(position).getStateType();
    }

    @NonNull
    public CellViewHolder<ViewBinding, CellState> onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return ((CellViewHolder)this.cellBinder.createViewHolder(parent, viewType)).setAdapter(this);
    }

    public void onViewAttachedToWindow(@NonNull CellViewHolder<ViewBinding, CellState> holder) {
        holder.onViewAttachedToWindow();
    }

    public void onViewDetachedFromWindow(@NonNull CellViewHolder<ViewBinding, CellState> holder) {
        holder.onViewDetachedFromWindow();
    }

    public void onViewRecycled(@NonNull CellViewHolder<ViewBinding, CellState> holder) {
        holder.onViewRecycled();
    }

    public boolean onFailedToRecycleView(@NonNull CellViewHolder<ViewBinding, CellState> holder) {
        return holder.onFailedToRecycleView();
    }

    public void onBindViewHolder(@NonNull CellViewHolder<ViewBinding, CellState> holder, int position) {
        holder.setState(this.getItem(position));
    }

    public void onBindViewHolder(@NonNull CellViewHolder<ViewBinding, CellState> holder, int position, @NonNull List<Object> payloads) {
        holder.setState(this.getItem(position), payloads);
    }
}

