/*
 * Decompiled with CFR 0.152.
 */
package lt.neworld.spanner;

import android.app.PendingIntent;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.EmbossMaskFilter;
import android.graphics.MaskFilter;
import android.graphics.drawable.Drawable;
import android.os.LocaleList;
import android.support.annotation.ColorInt;
import android.support.annotation.Dimension;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.support.annotation.RequiresApi;
import android.text.Layout;
import android.text.style.EasyEditSpan;
import android.text.style.LocaleSpan;
import android.text.style.MaskFilterSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.ScaleXSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuggestionSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TabStopSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.view.View;
import java.util.Locale;
import lt.neworld.spanner.AbsoluteSizeSpanBuilder;
import lt.neworld.spanner.AlignmentSpanBuilder;
import lt.neworld.spanner.BulletSpanBuilder;
import lt.neworld.spanner.ClickSpanBuilder;
import lt.neworld.spanner.ColorSpanBuilder;
import lt.neworld.spanner.ImageSpan;
import lt.neworld.spanner.ImageSpanBuilder;
import lt.neworld.spanner.LeadingMarginSpanBuilder;
import lt.neworld.spanner.LineBackgroundSpanBuilder;
import lt.neworld.spanner.LineHeightSpanBuilder;
import lt.neworld.spanner.QuoteSpanBuilder;
import lt.neworld.spanner.Span;
import lt.neworld.spanner.SpanBuilder;
import lt.neworld.spanner.StyleSpanBuilder;

public class Spans {
    private Spans() {
    }

    public static Span sizePX(@Dimension(unit=1) int px) {
        return new Span(new AbsoluteSizeSpanBuilder(px, false));
    }

    public static Span sizeDP(@Dimension(unit=0) int dp) {
        return new Span(new AbsoluteSizeSpanBuilder(dp, true));
    }

    public static Span sizeSP(@Dimension(unit=2) int sp) {
        return new Span(new AbsoluteSizeSpanBuilder(sp, true));
    }

    public static Span scaleSize(final @FloatRange(from=0.0) float proportion) {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new RelativeSizeSpan(proportion);
            }
        });
    }

    public static Span scaleXSize(final @FloatRange(from=0.0) float proportion) {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new ScaleXSpan(proportion);
            }
        });
    }

    public static Span bold() {
        return new Span(new StyleSpanBuilder(1));
    }

    public static Span italic() {
        return new Span(new StyleSpanBuilder(2));
    }

    public static Span boldItalic() {
        return new Span(new StyleSpanBuilder(3));
    }

    public static Span font(final @Nullable String font) {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new TypefaceSpan(font);
            }
        });
    }

    public static Span strikeThrough() {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new StrikethroughSpan();
            }
        });
    }

    public static Span underline() {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new UnderlineSpan();
            }
        });
    }

    public static Span background(@ColorInt int color) {
        return new Span(new ColorSpanBuilder(1, color));
    }

    public static Span foreground(@ColorInt int color) {
        return new Span(new ColorSpanBuilder(0, color));
    }

    @RequiresApi(api=29)
    public static Span lineBackground(@ColorInt int color) {
        return new Span(new LineBackgroundSpanBuilder(color));
    }

    @RequiresApi(api=29)
    public static Span lineHeight(@Px @IntRange(from=1L) int height) {
        return new Span(new LineHeightSpanBuilder(height));
    }

    public static Span subscript() {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new SubscriptSpan();
            }
        });
    }

    public static Span superscript() {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new SuperscriptSpan();
            }
        });
    }

    public static ImageSpan image(final @NonNull Drawable drawable) {
        return new ImageSpan(new SpanBuilder(){

            @Override
            public Object build() {
                return new android.text.style.ImageSpan(drawable);
            }
        });
    }

    public static ImageSpan image(final @NonNull Drawable drawable, final int verticalAlignment) {
        return new ImageSpan(new SpanBuilder(){

            @Override
            public Object build() {
                return new android.text.style.ImageSpan(drawable, verticalAlignment);
            }
        });
    }

    public static ImageSpan image(final Context context, final @DrawableRes int drawableId, final int verticalAlignment) {
        return new ImageSpan(new SpanBuilder(){

            @Override
            public Object build() {
                return new android.text.style.ImageSpan(context, drawableId, verticalAlignment);
            }
        });
    }

    public static ImageSpan image(final Context context, final @DrawableRes int drawableId) {
        return new ImageSpan(new SpanBuilder(){

            @Override
            public Object build() {
                return new android.text.style.ImageSpan(context, drawableId);
            }
        });
    }

    public static Span quote() {
        return new Span(new QuoteSpanBuilder(null));
    }

    public static Span quote(@ColorInt int color) {
        return new Span(new QuoteSpanBuilder(color));
    }

    public static Span image(@NonNull Context context, Bitmap bitmap) {
        return Spans.image(context, bitmap, 0);
    }

    public static Span image(final @NonNull Context context, final Bitmap bitmap, final int verticalAlignment) {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new android.text.style.ImageSpan(context, bitmap, verticalAlignment);
            }
        });
    }

    public static Span custom(@NonNull SpanBuilder builder) {
        return new Span(builder);
    }

    public static Span click(@NonNull View.OnClickListener onClickListener) {
        return new Span(new ClickSpanBuilder(onClickListener));
    }

    public static Span url(final @NonNull String url) {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new URLSpan(url);
            }
        });
    }

    public static Span center() {
        return new Span(new AlignmentSpanBuilder(Layout.Alignment.ALIGN_CENTER));
    }

    public static Span alignmentOpposite() {
        return new Span(new AlignmentSpanBuilder(Layout.Alignment.ALIGN_OPPOSITE));
    }

    public static Span alignmentNormal() {
        return new Span(new AlignmentSpanBuilder(Layout.Alignment.ALIGN_NORMAL));
    }

    public static Span bullet(int gapWidth, @ColorInt int color) {
        return new Span(new BulletSpanBuilder(gapWidth, color));
    }

    public static Span bullet(int gapWidth) {
        return new Span(new BulletSpanBuilder(gapWidth, null));
    }

    public static Span bullet() {
        return new Span(new BulletSpanBuilder(null, null));
    }

    public static Span imageMargin(@NonNull Drawable drawable) {
        return new Span(new ImageSpanBuilder(drawable, null, null));
    }

    public static Span imageMargin(@NonNull Drawable drawable, int pad) {
        return new Span(new ImageSpanBuilder(drawable, null, pad));
    }

    public static Span edit() {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new EasyEditSpan();
            }
        });
    }

    @RequiresApi(api=18)
    public static Span edit(final @NonNull PendingIntent pendingIntent) {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new EasyEditSpan(pendingIntent);
            }
        });
    }

    public static Span imageMargin(@NonNull Bitmap image) {
        return new Span(new ImageSpanBuilder(null, image, null));
    }

    public static Span imageMargin(@NonNull Bitmap image, int pad) {
        return new Span(new ImageSpanBuilder(null, image, pad));
    }

    public static Span leadingMargin(int first, int rest) {
        return new Span(new LeadingMarginSpanBuilder(first, rest));
    }

    public static Span leadingMargin(int every) {
        return new Span(new LeadingMarginSpanBuilder(every, null));
    }

    public static Span blur(final float radius, final @NonNull BlurMaskFilter.Blur style) {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new MaskFilterSpan((MaskFilter)new BlurMaskFilter(radius, style));
            }
        });
    }

    public static Span emboss(final @NonNull float[] direction, final float ambient, final float specular, final float blurRadius) {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new MaskFilterSpan((MaskFilter)new EmbossMaskFilter(direction, ambient, specular, blurRadius));
            }
        });
    }

    public static Span tabStop(final int where) {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new TabStopSpan.Standard(where);
            }
        });
    }

    public static Span appearance(final @NonNull Context context, final int appearance) {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new TextAppearanceSpan(context, appearance);
            }
        });
    }

    public static Span appearance(final @NonNull Context context, final int appearance, final int colorList) {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new TextAppearanceSpan(context, appearance, colorList);
            }
        });
    }

    public static Span appearance(final @Nullable String family, final int style, final int size, final @Nullable ColorStateList color, final @Nullable ColorStateList linkColor) {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new TextAppearanceSpan(family, style, size, color, linkColor);
            }
        });
    }

    @RequiresApi(api=17)
    public static Span locale(final @NonNull Locale locale) {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new LocaleSpan(locale);
            }
        });
    }

    @RequiresApi(api=24)
    public static Span locale(final @NonNull LocaleList localeList) {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new LocaleSpan(localeList);
            }
        });
    }

    public static Span suggestion(final @NonNull Context context, final @NonNull String[] suggestions, final int flags) {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new SuggestionSpan(context, suggestions, flags);
            }
        });
    }

    public static Span suggestion(final @NonNull Locale locale, final @NonNull String[] suggestions, final int flags) {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new SuggestionSpan(locale, suggestions, flags);
            }
        });
    }

    public static Span suggestion(final @NonNull Context context, final @NonNull Locale locale, final @NonNull String[] suggestions, final int flags, final @NonNull Class<?> notificationTargetClass) {
        return new Span(new SpanBuilder(){

            @Override
            public Object build() {
                return new SuggestionSpan(context, locale, suggestions, flags, notificationTargetClass);
            }
        });
    }
}

