/*
 * Decompiled with CFR 0.152.
 */
package love.forte.simboot.utils;

import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Llove/forte/simboot/utils/Globs;", "", "()V", "EOL", "", "globMetaChars", "", "regexMetaChars", "isGlobMeta", "", "c", "isRegexMeta", "next", "glob", "i", "", "toRegex", "globPattern", "isDos", "toUnixRegex", "toWindowsRegex", "simboot-api"})
public final class Globs {
    @NotNull
    public static final Globs INSTANCE = new Globs();
    @NotNull
    private static final String regexMetaChars = ".^$+{[]|()";
    @NotNull
    private static final String globMetaChars = "\\*?[{";
    private static final char EOL = '\u0000';

    private Globs() {
    }

    private final boolean isRegexMeta(char c) {
        return StringsKt.contains$default((CharSequence)regexMetaChars, (char)c, (boolean)false, (int)2, null);
    }

    private final boolean isGlobMeta(char c) {
        return StringsKt.contains$default((CharSequence)globMetaChars, (char)c, (boolean)false, (int)2, null);
    }

    private final char next(String glob, int i) {
        return i < glob.length() ? glob.charAt(i) : (char)'\u0000';
    }

    private final String toRegex(String globPattern, boolean isDos) {
        StringBuilder stringBuilder;
        boolean inGroup = false;
        char i = '\u0000';
        int n = globPattern.length();
        StringBuilder $this$toRegex_u24lambda_u2d1 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        $this$toRegex_u24lambda_u2d1.append("^");
        while (i < globPattern.length()) {
            char c = '\u0000';
            char c2 = i;
            i = c2 + 1;
            c = globPattern.charAt(c2);
            if ((c2 = (char)c) == '\\') {
                if (i == globPattern.length()) {
                    throw new PatternSyntaxException("No character to escape", globPattern, i - 1);
                }
                char c3 = i;
                i = c3 + 1;
                char next = globPattern.charAt(c3);
                if (INSTANCE.isGlobMeta(next) || INSTANCE.isRegexMeta(next)) {
                    $this$toRegex_u24lambda_u2d1.append('\\');
                }
                $this$toRegex_u24lambda_u2d1.append(next);
                continue;
            }
            if (c2 == '/') {
                if (isDos) {
                    $this$toRegex_u24lambda_u2d1.append("\\\\");
                    continue;
                }
                $this$toRegex_u24lambda_u2d1.append(c);
                continue;
            }
            if (c2 == '[') {
                if (isDos) {
                    $this$toRegex_u24lambda_u2d1.append("[[^\\\\]&&[");
                } else {
                    $this$toRegex_u24lambda_u2d1.append("[[^/]&&[");
                }
                if (INSTANCE.next(globPattern, i) == '^') {
                    $this$toRegex_u24lambda_u2d1.append("\\^");
                    ++i;
                } else {
                    if (INSTANCE.next(globPattern, i) == '!') {
                        $this$toRegex_u24lambda_u2d1.append('^');
                        ++i;
                    }
                    if (INSTANCE.next(globPattern, i) == '-') {
                        $this$toRegex_u24lambda_u2d1.append('-');
                        ++i;
                    }
                }
                boolean hasRangeStart = false;
                char last = '\u0000';
                while (i < globPattern.length()) {
                    char c4 = i;
                    i = c4 + 1;
                    c = globPattern.charAt(c4);
                    if (c == ']') break;
                    if (c == '/' || isDos && c == '\\') {
                        throw new PatternSyntaxException("Explicit 'name separator' in class", globPattern, i - 1);
                    }
                    if (c == '\\' || c == '[' || c == '&' && INSTANCE.next(globPattern, i) == '&') {
                        $this$toRegex_u24lambda_u2d1.append('\\');
                    }
                    $this$toRegex_u24lambda_u2d1.append(c);
                    if (c == '-') {
                        if (!hasRangeStart) {
                            throw new PatternSyntaxException("Invalid range", globPattern, i - 1);
                        }
                        c4 = i;
                        i = c4 + 1;
                        char it = c4 = (char)INSTANCE.next(globPattern, c4);
                        boolean bl2 = false;
                        c = it;
                        if (c4 == '\u0000' || c == ']') break;
                        if (Intrinsics.compare((int)c, (int)last) < 0) {
                            throw new PatternSyntaxException("Invalid range", globPattern, i - 3);
                        }
                        $this$toRegex_u24lambda_u2d1.append(c);
                        hasRangeStart = false;
                        continue;
                    }
                    hasRangeStart = true;
                    last = c;
                }
                if (c != ']') {
                    throw new PatternSyntaxException("Missing ']", globPattern, i - 1);
                }
                $this$toRegex_u24lambda_u2d1.append("]]");
                continue;
            }
            if (c2 == '{') {
                if (inGroup) {
                    throw new PatternSyntaxException("Cannot nest groups", globPattern, i - 1);
                }
                $this$toRegex_u24lambda_u2d1.append("(?:(?:");
                inGroup = true;
                continue;
            }
            if (c2 == '}') {
                if (inGroup) {
                    $this$toRegex_u24lambda_u2d1.append("))");
                    inGroup = false;
                    continue;
                }
                $this$toRegex_u24lambda_u2d1.append('}');
                continue;
            }
            if (c2 == ',') {
                if (inGroup) {
                    $this$toRegex_u24lambda_u2d1.append(")|(?:");
                    continue;
                }
                $this$toRegex_u24lambda_u2d1.append(',');
                continue;
            }
            if (c2 == '*') {
                if (INSTANCE.next(globPattern, i) == '*') {
                    $this$toRegex_u24lambda_u2d1.append(".*");
                    ++i;
                    continue;
                }
                if (isDos) {
                    $this$toRegex_u24lambda_u2d1.append("[^\\\\]*");
                    continue;
                }
                $this$toRegex_u24lambda_u2d1.append("[^/]*");
                continue;
            }
            if (c2 == '?') {
                if (isDos) {
                    $this$toRegex_u24lambda_u2d1.append("[^\\\\]");
                    continue;
                }
                $this$toRegex_u24lambda_u2d1.append("[^/]");
                continue;
            }
            if (INSTANCE.isRegexMeta(c)) {
                $this$toRegex_u24lambda_u2d1.append('\\');
            }
            $this$toRegex_u24lambda_u2d1.append(c);
        }
        if (inGroup) {
            throw new PatternSyntaxException("Missing '}", globPattern, i - 1);
        }
        $this$toRegex_u24lambda_u2d1.append('$');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    @NotNull
    public final String toUnixRegex(@NotNull String glob) {
        Intrinsics.checkNotNullParameter((Object)glob, (String)"glob");
        return this.toRegex(glob, false);
    }

    @NotNull
    public final String toWindowsRegex(@NotNull String glob) {
        Intrinsics.checkNotNullParameter((Object)glob, (String)"glob");
        return this.toRegex(glob, true);
    }

    @NotNull
    public final String toRegex(@NotNull String glob) {
        Intrinsics.checkNotNullParameter((Object)glob, (String)"glob");
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        boolean isWindows = StringsKt.contains((CharSequence)string, (CharSequence)"windows", (boolean)true);
        return isWindows ? this.toWindowsRegex(glob) : this.toUnixRegex(glob);
    }
}

