/*
 * Decompiled with CFR 0.152.
 */
package live.hms.videoview.common;

import android.os.Handler;
import android.os.Looper;
import hms.webrtc.RendererCommon;
import hms.webrtc.VideoSink;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.media.settings.HMSLayer;
import live.hms.video.media.settings.HMSSimulcastLayerDefinition;
import live.hms.video.media.tracks.HMSLocalVideoTrack;
import live.hms.video.media.tracks.HMSRemoteVideoTrack;
import live.hms.video.media.tracks.HMSVideoTrack;
import live.hms.videoview.ResolutionChangeListener;
import live.hms.videoview.VideoViewStateChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001BO\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\"\u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010$\u001a\u00020\u000bJ\b\u0010%\u001a\u0004\u0018\u00010\u0017J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0017H\u0002J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0017H\u0002J\b\u0010(\u001a\u00020\u0007H\u0002J\b\u0010)\u001a\u00020\u0007H\u0002J\r\u0010*\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b+J\u0017\u0010,\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0000\u00a2\u0006\u0002\b-J\b\u0010.\u001a\u00020\u0007H\u0016J \u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u00020\u001dH\u0016J\u001d\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b6J\b\u00107\u001a\u00020\u0007H\u0002J\u001a\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020\u00172\u0006\u0010;\u001a\u00020\u000bH\u0002J\u001e\u0010<\u001a\u0004\u0018\u000109*\u00020=2\u0006\u0010>\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020\u001dH\u0002J\u0015\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\bBR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Llive/hms/videoview/common/VideoTrackManager;", "Lhms/webrtc/RendererCommon$RendererEvents;", "attachedVideoSink", "Lkotlin/Function0;", "Lhms/webrtc/VideoSink;", "initRenderer", "Lkotlin/Function1;", "", "releaseRenderer", "clearFrame", "enableAutoSimulcast", "", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Z)V", "getAttachedVideoSink", "()Lkotlin/jvm/functions/Function0;", "getInitRenderer", "()Lkotlin/jvm/functions/Function1;", "getReleaseRenderer", "getClearFrame", "getEnableAutoSimulcast", "()Z", "currentTrack", "Llive/hms/video/media/tracks/HMSVideoTrack;", "videoViewStateChangeListener", "Llive/hms/videoview/VideoViewStateChangeListener;", "resolutionChangeListener", "Llive/hms/videoview/ResolutionChangeListener;", "currentWidth", "", "currentHeight", "isAutoSimulcastEnabled", "pendingTrackUpdate", "isInitialised", "addTrack", "track", "enableBlackFrame", "getCurrentTrack", "bind", "unbind", "safeInit", "safeRelease", "removeTrack", "removeTrack$videoview_release", "setVideoViewStateChangeListener", "setVideoViewStateChangeListener$videoview_release", "onFirstFrameRendered", "onFrameResolutionChanged", "videoWidth", "videoHeight", "rotation", "onSizeChanged", "changedWidth", "changedHeight", "onSizeChanged$videoview_release", "dispatchAutoSimulcastLayerUpdate", "updateSimulcastLayer", "Llive/hms/video/media/settings/HMSLayer;", "remoteVideoTrack", "dispatchLayerInfoToSfu", "pickTheClosestLayerBasedOnResolution", "Llive/hms/video/media/tracks/HMSRemoteVideoTrack;", "width", "height", "disableAutoSimulcastLayerSelect", "isDisabled", "disableAutoSimulcastLayerSelect$videoview_release", "videoview_release"})
public final class VideoTrackManager
implements RendererCommon.RendererEvents {
    @NotNull
    private final Function0<VideoSink> attachedVideoSink;
    @NotNull
    private final Function1<RendererCommon.RendererEvents, Unit> initRenderer;
    @NotNull
    private final Function0<Unit> releaseRenderer;
    @NotNull
    private final Function0<Unit> clearFrame;
    private final boolean enableAutoSimulcast;
    @Nullable
    private HMSVideoTrack currentTrack;
    @Nullable
    private VideoViewStateChangeListener videoViewStateChangeListener;
    @Nullable
    private ResolutionChangeListener resolutionChangeListener;
    private int currentWidth;
    private int currentHeight;
    private boolean isAutoSimulcastEnabled;
    private boolean pendingTrackUpdate;
    private boolean isInitialised;

    public VideoTrackManager(@NotNull Function0<? extends VideoSink> attachedVideoSink, @NotNull Function1<? super RendererCommon.RendererEvents, Unit> initRenderer, @NotNull Function0<Unit> releaseRenderer, @NotNull Function0<Unit> clearFrame, boolean enableAutoSimulcast) {
        Intrinsics.checkNotNullParameter(attachedVideoSink, (String)"attachedVideoSink");
        Intrinsics.checkNotNullParameter(initRenderer, (String)"initRenderer");
        Intrinsics.checkNotNullParameter(releaseRenderer, (String)"releaseRenderer");
        Intrinsics.checkNotNullParameter(clearFrame, (String)"clearFrame");
        this.attachedVideoSink = attachedVideoSink;
        this.initRenderer = initRenderer;
        this.releaseRenderer = releaseRenderer;
        this.clearFrame = clearFrame;
        this.enableAutoSimulcast = enableAutoSimulcast;
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.isAutoSimulcastEnabled = this.enableAutoSimulcast;
    }

    public /* synthetic */ VideoTrackManager(Function0 function0, Function1 function1, Function0 function02, Function0 function03, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this((Function0<? extends VideoSink>)function0, (Function1<? super RendererCommon.RendererEvents, Unit>)function1, (Function0<Unit>)function02, (Function0<Unit>)function03, bl);
    }

    @NotNull
    public final Function0<VideoSink> getAttachedVideoSink() {
        return this.attachedVideoSink;
    }

    @NotNull
    public final Function1<RendererCommon.RendererEvents, Unit> getInitRenderer() {
        return this.initRenderer;
    }

    @NotNull
    public final Function0<Unit> getReleaseRenderer() {
        return this.releaseRenderer;
    }

    @NotNull
    public final Function0<Unit> getClearFrame() {
        return this.clearFrame;
    }

    public final boolean getEnableAutoSimulcast() {
        return this.enableAutoSimulcast;
    }

    public final void addTrack(@Nullable HMSVideoTrack track, boolean enableBlackFrame) {
        block8: {
            this.safeInit();
            if (track instanceof HMSRemoteVideoTrack && this.currentTrack instanceof HMSRemoteVideoTrack) {
                HMSVideoTrack hMSVideoTrack = this.currentTrack;
                if ((hMSVideoTrack != null ? hMSVideoTrack.getTrackId() : null) == ((HMSRemoteVideoTrack)track).getTrackId()) {
                    HMSVideoTrack hMSVideoTrack2 = this.currentTrack;
                    HMSRemoteVideoTrack hMSRemoteVideoTrack = hMSVideoTrack2 instanceof HMSRemoteVideoTrack ? (HMSRemoteVideoTrack)hMSVideoTrack2 : null;
                    boolean bl = hMSRemoteVideoTrack != null ? hMSRemoteVideoTrack.getSsrc() == ((HMSRemoteVideoTrack)track).getSsrc() : false;
                    if (bl) {
                        return;
                    }
                }
            }
            if (track instanceof HMSLocalVideoTrack && this.currentTrack instanceof HMSLocalVideoTrack) {
                HMSVideoTrack hMSVideoTrack = this.currentTrack;
                if ((hMSVideoTrack != null ? hMSVideoTrack.getTrackId() : null) == ((HMSLocalVideoTrack)track).getTrackId()) {
                    return;
                }
            }
            if (this.currentTrack != null) {
                HMSVideoTrack hMSVideoTrack = this.currentTrack;
                if (hMSVideoTrack != null) {
                    HMSVideoTrack it = hMSVideoTrack;
                    boolean bl = false;
                    this.unbind(it);
                    if (enableBlackFrame) {
                        this.clearFrame.invoke();
                    }
                }
            }
            HMSVideoTrack hMSVideoTrack = track;
            if (hMSVideoTrack == null) break block8;
            HMSVideoTrack it = hMSVideoTrack;
            boolean bl = false;
            this.bind(it);
        }
    }

    public static /* synthetic */ void addTrack$default(VideoTrackManager videoTrackManager, HMSVideoTrack hMSVideoTrack, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        videoTrackManager.addTrack(hMSVideoTrack, bl);
    }

    @Nullable
    public final HMSVideoTrack getCurrentTrack() {
        return this.currentTrack;
    }

    private final void bind(HMSVideoTrack track) {
        HMSLayer optimalLayer = this.updateSimulcastLayer(track, false);
        HMSVideoTrack hMSVideoTrack = track;
        if (hMSVideoTrack instanceof HMSRemoteVideoTrack) {
            HMSRemoteVideoTrack hMSRemoteVideoTrack = (HMSRemoteVideoTrack)track;
            VideoSink videoSink = (VideoSink)this.attachedVideoSink.invoke();
            HMSLayer hMSLayer = optimalLayer;
            if (hMSLayer == null) {
                hMSLayer = ((HMSRemoteVideoTrack)track).getLayer();
            }
            hMSRemoteVideoTrack.addSinkInternal(videoSink, hMSLayer);
        } else if (hMSVideoTrack instanceof HMSLocalVideoTrack) {
            HMSVideoTrack.addSink$default((HMSVideoTrack)track, (VideoSink)((VideoSink)this.attachedVideoSink.invoke()), null, (int)2, null);
        }
        this.currentTrack = track;
    }

    private final void unbind(HMSVideoTrack track) {
        track.removeSink((VideoSink)this.attachedVideoSink.invoke());
        this.currentTrack = null;
    }

    private final void safeInit() {
        if (!this.isInitialised) {
            this.initRenderer.invoke((Object)this);
            this.isInitialised = true;
        }
    }

    private final void safeRelease() {
        if (this.isInitialised) {
            this.releaseRenderer.invoke();
            this.isInitialised = false;
        }
    }

    public final void removeTrack$videoview_release() {
        if (this.currentTrack == null) {
            this.safeRelease();
            return;
        }
        HMSVideoTrack hMSVideoTrack = this.currentTrack;
        if (hMSVideoTrack != null) {
            HMSVideoTrack it = hMSVideoTrack;
            boolean bl = false;
            this.unbind(it);
        }
        this.safeRelease();
    }

    public final void setVideoViewStateChangeListener$videoview_release(@Nullable VideoViewStateChangeListener videoViewStateChangeListener) {
        this.videoViewStateChangeListener = videoViewStateChangeListener;
    }

    public void onFirstFrameRendered() {
        new Handler(Looper.getMainLooper()).post(() -> VideoTrackManager.onFirstFrameRendered$lambda$3(this));
    }

    public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
        new Handler(Looper.getMainLooper()).post(() -> VideoTrackManager.onFrameResolutionChanged$lambda$4(this, videoWidth, videoHeight));
    }

    public final void onSizeChanged$videoview_release(int changedWidth, int changedHeight) {
        if (this.currentWidth != changedWidth || this.currentHeight != changedHeight) {
            this.currentWidth = changedWidth;
            this.currentHeight = changedHeight;
            this.dispatchAutoSimulcastLayerUpdate();
        }
    }

    private final void dispatchAutoSimulcastLayerUpdate() {
        block3: {
            block2: {
                if (!this.isAutoSimulcastEnabled || this.pendingTrackUpdate) {
                    return;
                }
                if (this.currentTrack != null) break block2;
                this.pendingTrackUpdate = true;
                break block3;
            }
            if (!(this.currentTrack instanceof HMSRemoteVideoTrack)) break block3;
            this.pendingTrackUpdate = true;
            HMSVideoTrack hMSVideoTrack = this.currentTrack;
            HMSRemoteVideoTrack hMSRemoteVideoTrack = hMSVideoTrack instanceof HMSRemoteVideoTrack ? (HMSRemoteVideoTrack)hMSVideoTrack : null;
            if (hMSRemoteVideoTrack != null) {
                HMSRemoteVideoTrack it = hMSRemoteVideoTrack;
                boolean bl = false;
                this.updateSimulcastLayer((HMSVideoTrack)it, true);
            }
        }
    }

    private final HMSLayer updateSimulcastLayer(HMSVideoTrack remoteVideoTrack, boolean dispatchLayerInfoToSfu) {
        HMSLayer preferredLayer = null;
        if (this.pendingTrackUpdate && this.isAutoSimulcastEnabled && remoteVideoTrack instanceof HMSRemoteVideoTrack) {
            preferredLayer = this.pickTheClosestLayerBasedOnResolution((HMSRemoteVideoTrack)remoteVideoTrack, this.currentWidth, this.currentHeight);
            if (preferredLayer != null && dispatchLayerInfoToSfu) {
                HMSRemoteVideoTrack.setLayer$default((HMSRemoteVideoTrack)((HMSRemoteVideoTrack)remoteVideoTrack), (HMSLayer)preferredLayer, null, (int)2, null);
            }
            this.pendingTrackUpdate = false;
        }
        return preferredLayer;
    }

    private final HMSLayer pickTheClosestLayerBasedOnResolution(HMSRemoteVideoTrack $this$pickTheClosestLayerBasedOnResolution, int width, int height) {
        Collection collection = $this$pickTheClosestLayerBasedOnResolution.getLayerDefinition();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        HMSSimulcastLayerDefinition selectedLayer = (HMSSimulcastLayerDefinition)$this$pickTheClosestLayerBasedOnResolution.getLayerDefinition().get($this$pickTheClosestLayerBasedOnResolution.getLayerDefinition().size() - 1);
        int min = Integer.MAX_VALUE;
        Iterator iterator = $this$pickTheClosestLayerBasedOnResolution.getLayerDefinition().iterator();
        while (iterator.hasNext()) {
            int videoViewSurfaceArea = width * height;
            HMSSimulcastLayerDefinition layer = (HMSSimulcastLayerDefinition)iterator.next();
            int layerSurfaceArea = layer.getResolution().getWidth() * layer.getResolution().getHeight();
            int diff = Math.abs(videoViewSurfaceArea - layerSurfaceArea);
            if (diff >= min) continue;
            selectedLayer = layer;
            min = diff;
        }
        return selectedLayer.getLayer();
    }

    public final void disableAutoSimulcastLayerSelect$videoview_release(boolean isDisabled) {
        this.isAutoSimulcastEnabled = !isDisabled;
        this.dispatchAutoSimulcastLayerUpdate();
    }

    private static final void onFirstFrameRendered$lambda$3(VideoTrackManager this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            VideoViewStateChangeListener videoViewStateChangeListener = this$0.videoViewStateChangeListener;
            if (videoViewStateChangeListener == null) break block0;
            videoViewStateChangeListener.onFirstFrameRendered();
        }
    }

    private static final void onFrameResolutionChanged$lambda$4(VideoTrackManager this$0, int $videoWidth, int $videoHeight) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            VideoViewStateChangeListener videoViewStateChangeListener = this$0.videoViewStateChangeListener;
            if (videoViewStateChangeListener == null) break block0;
            videoViewStateChangeListener.onResolutionChange($videoWidth, $videoHeight);
        }
    }
}

