/*
 * Decompiled with CFR 0.152.
 */
package live.hms.videoview.textureview;

import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import hms.webrtc.EglBase;
import hms.webrtc.GlRectDrawer;
import hms.webrtc.RendererCommon;
import hms.webrtc.SurfaceEglRenderer;
import hms.webrtc.ThreadUtils;
import hms.webrtc.VideoSink;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.media.tracks.HMSVideoTrack;
import live.hms.video.utils.SharedEglContext;
import live.hms.videoview.VideoViewStateChangeListener;
import live.hms.videoview.common.VideoTrackManager;
import live.hms.videoview.textureview.HMSTextureRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0006\u0010\u0015\u001a\u00020\u0013J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00172\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u000e\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001bJ\u0016\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006%"}, d2={"Llive/hms/videoview/textureview/HMSTextureRenderer;", "", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "<init>", "(Landroid/graphics/SurfaceTexture;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "renderer", "Lhms/webrtc/SurfaceEglRenderer;", "videoTrackManager", "Llive/hms/videoview/common/VideoTrackManager;", "getVideoTrackManager", "()Llive/hms/videoview/common/VideoTrackManager;", "videoTrackManager$delegate", "Lkotlin/Lazy;", "init", "", "release", "removeTrack", "getTrack", "Llive/hms/video/media/tracks/HMSVideoTrack;", "addTrack", "track", "enableBlackFrame", "", "addVideoViewStateChangeListener", "videoViewStateChangeListener", "Llive/hms/videoview/VideoViewStateChangeListener;", "disableAutoSimulcastLayerSelect", "isDisabled", "displayResolution", "width", "", "height", "videoview_release"})
public final class HMSTextureRenderer {
    @NotNull
    private final SurfaceTexture surfaceTexture;
    @NotNull
    private final String TAG;
    @Nullable
    private SurfaceEglRenderer renderer;
    @NotNull
    private final Lazy videoTrackManager$delegate;

    public HMSTextureRenderer(@NotNull SurfaceTexture surfaceTexture) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.surfaceTexture = surfaceTexture;
        this.TAG = "HMSTextureRenderer";
        this.videoTrackManager$delegate = LazyKt.lazy(() -> HMSTextureRenderer.videoTrackManager_delegate$lambda$4(this));
    }

    @NotNull
    public final String getTAG() {
        return this.TAG;
    }

    private final VideoTrackManager getVideoTrackManager() {
        Lazy lazy = this.videoTrackManager$delegate;
        return (VideoTrackManager)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void init() {
        void $this$init_u24lambda_u245;
        SurfaceEglRenderer surfaceEglRenderer;
        SurfaceEglRenderer surfaceEglRenderer2 = surfaceEglRenderer = new SurfaceEglRenderer(UUID.randomUUID().toString());
        HMSTextureRenderer hMSTextureRenderer = this;
        boolean bl = false;
        ThreadUtils.checkIsOnMainThread();
        $this$init_u24lambda_u245.init(SharedEglContext.INSTANCE.getContext(), new RendererCommon.RendererEvents(this){
            final /* synthetic */ HMSTextureRenderer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onFirstFrameRendered() {
                new Handler(Looper.getMainLooper()).post(() -> init.1.1.onFirstFrameRendered$lambda$0(this.this$0));
            }

            public void onFrameResolutionChanged(int width, int height, int rotation) {
                int rotatedWidth = rotation % 180 == 0 ? width : height;
                int rotatedHeight = rotation % 180 == 0 ? height : width;
                new Handler(Looper.getMainLooper()).post(() -> init.1.1.onFrameResolutionChanged$lambda$1(this.this$0, rotatedWidth, rotatedHeight, rotation));
            }

            private static final void onFirstFrameRendered$lambda$0(HMSTextureRenderer this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                HMSTextureRenderer.access$getVideoTrackManager(this$0).onFirstFrameRendered();
            }

            private static final void onFrameResolutionChanged$lambda$1(HMSTextureRenderer this$0, int $rotatedWidth, int $rotatedHeight, int $rotation) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                HMSTextureRenderer.access$getVideoTrackManager(this$0).onFrameResolutionChanged($rotatedWidth, $rotatedHeight, $rotation);
                HMSTextureRenderer.access$getSurfaceTexture$p(this$0).setDefaultBufferSize($rotatedWidth, $rotatedHeight);
            }
        }, EglBase.CONFIG_PLAIN, (RendererCommon.GlDrawer)new GlRectDrawer());
        $this$init_u24lambda_u245.createEglSurface(this.surfaceTexture);
        hMSTextureRenderer.renderer = surfaceEglRenderer;
    }

    private final void release() {
        if (this.renderer == null) {
            Log.d((String)this.TAG, (String)"HMSTextureRenderer Release called without init ");
            return;
        }
        ThreadUtils.checkIsOnMainThread();
        CountDownLatch completionLatch = new CountDownLatch(1);
        SurfaceEglRenderer surfaceEglRenderer = this.renderer;
        if (surfaceEglRenderer != null) {
            surfaceEglRenderer.releaseEglSurface(completionLatch::countDown);
        }
        ThreadUtils.awaitUninterruptibly((CountDownLatch)completionLatch);
    }

    public final void removeTrack() {
        this.getVideoTrackManager().removeTrack$videoview_release();
    }

    @Nullable
    public final HMSVideoTrack getTrack() {
        return this.getVideoTrackManager().getCurrentTrack();
    }

    public final void addTrack(@NotNull HMSVideoTrack track) {
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        VideoTrackManager.addTrack$default(this.getVideoTrackManager(), track, false, 2, null);
    }

    public final void addTrack(@NotNull HMSVideoTrack track, boolean enableBlackFrame) {
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        this.getVideoTrackManager().addTrack(track, enableBlackFrame);
    }

    public static /* synthetic */ void addTrack$default(HMSTextureRenderer hMSTextureRenderer, HMSVideoTrack hMSVideoTrack, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        hMSTextureRenderer.addTrack(hMSVideoTrack, bl);
    }

    public final void addVideoViewStateChangeListener(@Nullable VideoViewStateChangeListener videoViewStateChangeListener) {
        this.getVideoTrackManager().setVideoViewStateChangeListener$videoview_release(videoViewStateChangeListener);
    }

    public final void disableAutoSimulcastLayerSelect(boolean isDisabled) {
        this.getVideoTrackManager().disableAutoSimulcastLayerSelect$videoview_release(isDisabled);
    }

    public final void displayResolution(int width, int height) {
        this.getVideoTrackManager().onSizeChanged$videoview_release(width, height);
    }

    private static final VideoSink videoTrackManager_delegate$lambda$4$lambda$0(HMSTextureRenderer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SurfaceEglRenderer surfaceEglRenderer = this$0.renderer;
        Intrinsics.checkNotNull((Object)surfaceEglRenderer);
        return (VideoSink)surfaceEglRenderer;
    }

    private static final Unit videoTrackManager_delegate$lambda$4$lambda$1(HMSTextureRenderer this$0, RendererCommon.RendererEvents it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.init();
        return Unit.INSTANCE;
    }

    private static final Unit videoTrackManager_delegate$lambda$4$lambda$2(HMSTextureRenderer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.release();
        return Unit.INSTANCE;
    }

    private static final Unit videoTrackManager_delegate$lambda$4$lambda$3(HMSTextureRenderer this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            SurfaceEglRenderer surfaceEglRenderer = this$0.renderer;
            if (surfaceEglRenderer == null) break block0;
            surfaceEglRenderer.clearFrame();
        }
        return Unit.INSTANCE;
    }

    private static final VideoTrackManager videoTrackManager_delegate$lambda$4(HMSTextureRenderer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new VideoTrackManager((Function0<? extends VideoSink>)((Function0)() -> HMSTextureRenderer.videoTrackManager_delegate$lambda$4$lambda$0(this$0)), (Function1<? super RendererCommon.RendererEvents, Unit>)((Function1)arg_0 -> HMSTextureRenderer.videoTrackManager_delegate$lambda$4$lambda$1(this$0, arg_0)), (Function0<Unit>)((Function0)() -> HMSTextureRenderer.videoTrackManager_delegate$lambda$4$lambda$2(this$0)), (Function0<Unit>)((Function0)() -> HMSTextureRenderer.videoTrackManager_delegate$lambda$4$lambda$3(this$0)), false);
    }

    public static final /* synthetic */ VideoTrackManager access$getVideoTrackManager(HMSTextureRenderer $this) {
        return $this.getVideoTrackManager();
    }

    public static final /* synthetic */ SurfaceTexture access$getSurfaceTexture$p(HMSTextureRenderer $this) {
        return $this.surfaceTexture;
    }
}

