/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.util;

import android.content.Context;
import android.media.MediaPlayer;
import androidx.annotation.RawRes;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0007J\u0006\u0010\f\u001a\u00020\nJ\b\u0010\r\u001a\u00020\nH\u0002J\u0006\u0010\u000e\u001a\u00020\nJ\u001a\u0010\u000f\u001a\u00020\n2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\n2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Llive/hms/roomkit/util/MediaPlayerManager;", "Landroidx/lifecycle/LifecycleObserver;", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "(Landroidx/lifecycle/Lifecycle;)V", "mediaPlayer", "Landroid/media/MediaPlayer;", "onMediaPlayerPrepared", "Landroid/media/MediaPlayer$OnPreparedListener;", "onDestroy", "", "onStop", "pause", "releaseMediaPlayer", "resume", "setSource", "raw", "", "context", "Landroid/content/Context;", "startPlay", "stop", "room-kit_release"})
@StabilityInferred(parameters=0)
public final class MediaPlayerManager
implements LifecycleObserver {
    @NotNull
    private final Lifecycle lifecycle;
    @Nullable
    private MediaPlayer mediaPlayer;
    @NotNull
    private final MediaPlayer.OnPreparedListener onMediaPlayerPrepared;
    public static final int $stable = 8;

    public MediaPlayerManager(@NotNull Lifecycle lifecycle) {
        Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
        this.lifecycle = lifecycle;
        this.lifecycle.addObserver((LifecycleObserver)this);
        this.onMediaPlayerPrepared = arg_0 -> MediaPlayerManager.onMediaPlayerPrepared$lambda$0(this, arg_0);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public final void onDestroy() {
        this.releaseMediaPlayer();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public final void onStop() {
        this.releaseMediaPlayer();
    }

    /*
     * WARNING - void declaration
     */
    private final void setSource(@RawRes int raw2, Context context) {
        try {
            void $this$setSource_u24lambda_u241;
            MediaPlayer mediaPlayer;
            MediaPlayer mediaPlayer2 = mediaPlayer = MediaPlayer.create((Context)context, (int)raw2);
            MediaPlayerManager mediaPlayerManager2 = this;
            boolean bl = false;
            $this$setSource_u24lambda_u241.start();
            mediaPlayerManager2.mediaPlayer = mediaPlayer;
        }
        catch (Exception e) {
            Exception exception = e;
        }
    }

    private final void releaseMediaPlayer() {
        try {
            if (this.mediaPlayer != null) {
                MediaPlayer mediaPlayer;
                MediaPlayer mediaPlayer2 = this.mediaPlayer;
                boolean bl = mediaPlayer2 != null ? mediaPlayer2.isPlaying() : false;
                if (bl) {
                    MediaPlayer mediaPlayer3 = this.mediaPlayer;
                    if (mediaPlayer3 != null) {
                        mediaPlayer3.stop();
                    }
                }
                MediaPlayer mediaPlayer4 = mediaPlayer = this.mediaPlayer;
                if (mediaPlayer4 != null) {
                    mediaPlayer4.release();
                }
                this.mediaPlayer = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void startPlay(@RawRes int raw2, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.lifecycle.getCurrentState().isAtLeast(Lifecycle.State.STARTED) && this.lifecycle.getCurrentState() != Lifecycle.State.DESTROYED) {
            try {
                this.releaseMediaPlayer();
                this.setSource(raw2, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void pause() {
        block1: {
            MediaPlayer mediaPlayer = this.mediaPlayer;
            boolean bl = mediaPlayer != null ? mediaPlayer.isPlaying() : false;
            if (!bl) break block1;
            MediaPlayer mediaPlayer2 = this.mediaPlayer;
            if (mediaPlayer2 != null) {
                mediaPlayer2.pause();
            }
        }
    }

    public final void resume() {
        block1: {
            MediaPlayer mediaPlayer = this.mediaPlayer;
            boolean bl = mediaPlayer != null ? !mediaPlayer.isPlaying() : false;
            if (!bl) break block1;
            MediaPlayer mediaPlayer2 = this.mediaPlayer;
            if (mediaPlayer2 != null) {
                mediaPlayer2.start();
            }
        }
    }

    public final void stop() {
        block0: {
            MediaPlayer mediaPlayer = this.mediaPlayer;
            if (mediaPlayer == null) break block0;
            mediaPlayer.stop();
        }
    }

    private static final void onMediaPlayerPrepared$lambda$0(MediaPlayerManager this$0, MediaPlayer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            if (this$0.lifecycle.getCurrentState().isAtLeast(Lifecycle.State.STARTED) && this$0.lifecycle.getCurrentState() != Lifecycle.State.DESTROYED) {
                MediaPlayer mediaPlayer;
                MediaPlayer mediaPlayer2 = mediaPlayer = this$0.mediaPlayer;
                if (mediaPlayer2 != null) {
                    mediaPlayer2.start();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

