/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.notification;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import live.hms.roomkit.ui.notification.CardStackDataObserver;
import live.hms.roomkit.ui.notification.CardStackLayoutManager;
import live.hms.roomkit.ui.notification.CardStackSnapHelper;

public class CardStackView
extends RecyclerView {
    private final CardStackDataObserver observer = new CardStackDataObserver(this);

    public CardStackView(Context context) {
        this(context, null);
    }

    public CardStackView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CardStackView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialize();
    }

    public void setLayoutManager(RecyclerView.LayoutManager manager) {
        if (!(manager instanceof CardStackLayoutManager)) {
            throw new IllegalArgumentException("CardStackView must be set CardStackLayoutManager.");
        }
        super.setLayoutManager(manager);
    }

    public void setAdapter(RecyclerView.Adapter adapter2) {
        if (this.getLayoutManager() == null) {
            this.setLayoutManager(new CardStackLayoutManager(this.getContext()));
        }
        if (this.getAdapter() != null) {
            this.getAdapter().unregisterAdapterDataObserver((RecyclerView.AdapterDataObserver)this.observer);
            this.getAdapter().onDetachedFromRecyclerView((RecyclerView)this);
        }
        adapter2.registerAdapterDataObserver((RecyclerView.AdapterDataObserver)this.observer);
        super.setAdapter(adapter2);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        CardStackLayoutManager manager;
        if (event.getAction() == 0 && (manager = (CardStackLayoutManager)this.getLayoutManager()) != null) {
            manager.updateProportion(event.getX(), event.getY());
        }
        return super.onInterceptTouchEvent(event);
    }

    public void swipe() {
        if (this.getLayoutManager() instanceof CardStackLayoutManager) {
            CardStackLayoutManager manager = (CardStackLayoutManager)this.getLayoutManager();
            this.smoothScrollToPosition(manager.getTopPosition() + 1);
        }
    }

    public void rewind() {
        if (this.getLayoutManager() instanceof CardStackLayoutManager) {
            CardStackLayoutManager manager = (CardStackLayoutManager)this.getLayoutManager();
            this.smoothScrollToPosition(manager.getTopPosition() - 1);
        }
    }

    private void initialize() {
        new CardStackSnapHelper().attachToRecyclerView(this);
        this.setOverScrollMode(2);
    }
}

