/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.notification;

import android.content.Context;
import android.graphics.PointF;
import android.os.Handler;
import android.view.View;
import android.view.animation.Interpolator;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import live.hms.roomkit.ui.notification.CardStackListener;
import live.hms.roomkit.ui.notification.CardStackSetting;
import live.hms.roomkit.ui.notification.CardStackSmoothScroller;
import live.hms.roomkit.ui.notification.CardStackState;
import live.hms.roomkit.ui.notification.Direction;
import live.hms.roomkit.ui.notification.DisplayUtil;
import live.hms.roomkit.ui.notification.RewindAnimationSetting;
import live.hms.roomkit.ui.notification.StackFrom;
import live.hms.roomkit.ui.notification.SwipeAnimationSetting;
import live.hms.roomkit.ui.notification.SwipeableMethod;

public class CardStackLayoutManager
extends RecyclerView.LayoutManager
implements RecyclerView.SmoothScroller.ScrollVectorProvider {
    private final Context context;
    private CardStackListener listener = CardStackListener.DEFAULT;
    private CardStackSetting setting = new CardStackSetting();
    private CardStackState state = new CardStackState();

    public CardStackLayoutManager(Context context) {
        this(context, CardStackListener.DEFAULT);
    }

    public CardStackLayoutManager(Context context, CardStackListener listener2) {
        this.context = context;
        this.listener = listener2;
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-1, -1);
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State s) {
        View topView;
        this.update(recycler);
        if (s.didStructureChange() && (topView = this.getTopView()) != null) {
            this.listener.onCardAppeared(this.getTopView(), this.state.topPosition);
        }
    }

    public boolean canScrollHorizontally() {
        return this.setting.swipeableMethod.canSwipe() && this.setting.canScrollHorizontal;
    }

    public boolean canScrollVertically() {
        return this.setting.swipeableMethod.canSwipe() && this.setting.canScrollVertical;
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State s) {
        if (this.state.topPosition == this.getItemCount()) {
            return 0;
        }
        switch (this.state.status) {
            case Idle: {
                if (!this.setting.swipeableMethod.canSwipeManually()) break;
                this.state.dx -= dx;
                this.update(recycler);
                return dx;
            }
            case Dragging: {
                if (!this.setting.swipeableMethod.canSwipeManually()) break;
                this.state.dx -= dx;
                this.update(recycler);
                return dx;
            }
            case RewindAnimating: {
                this.state.dx -= dx;
                this.update(recycler);
                return dx;
            }
            case AutomaticSwipeAnimating: {
                if (!this.setting.swipeableMethod.canSwipeAutomatically()) break;
                this.state.dx -= dx;
                this.update(recycler);
                return dx;
            }
            case AutomaticSwipeAnimated: {
                break;
            }
            case ManualSwipeAnimating: {
                if (!this.setting.swipeableMethod.canSwipeManually()) break;
                this.state.dx -= dx;
                this.update(recycler);
                return dx;
            }
        }
        return 0;
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State s) {
        if (this.state.topPosition == this.getItemCount()) {
            return 0;
        }
        switch (this.state.status) {
            case Idle: {
                if (!this.setting.swipeableMethod.canSwipeManually()) break;
                this.state.dy -= dy;
                this.update(recycler);
                return dy;
            }
            case Dragging: {
                if (!this.setting.swipeableMethod.canSwipeManually()) break;
                this.state.dy -= dy;
                this.update(recycler);
                return dy;
            }
            case RewindAnimating: {
                this.state.dy -= dy;
                this.update(recycler);
                return dy;
            }
            case AutomaticSwipeAnimating: {
                if (!this.setting.swipeableMethod.canSwipeAutomatically()) break;
                this.state.dy -= dy;
                this.update(recycler);
                return dy;
            }
            case AutomaticSwipeAnimated: {
                break;
            }
            case ManualSwipeAnimating: {
                if (!this.setting.swipeableMethod.canSwipeManually()) break;
                this.state.dy -= dy;
                this.update(recycler);
                return dy;
            }
        }
        return 0;
    }

    public void onScrollStateChanged(int s) {
        switch (s) {
            case 0: {
                if (this.state.targetPosition == -1) {
                    this.state.next(CardStackState.Status.Idle);
                    this.state.targetPosition = -1;
                    break;
                }
                if (this.state.topPosition == this.state.targetPosition) {
                    this.state.next(CardStackState.Status.Idle);
                    this.state.targetPosition = -1;
                    break;
                }
                if (this.state.topPosition < this.state.targetPosition) {
                    this.smoothScrollToNext(this.state.targetPosition);
                    break;
                }
                this.smoothScrollToPrevious(this.state.targetPosition);
                break;
            }
            case 1: {
                if (!this.setting.swipeableMethod.canSwipeManually()) break;
                this.state.next(CardStackState.Status.Dragging);
                break;
            }
        }
    }

    public PointF computeScrollVectorForPosition(int targetPosition) {
        return null;
    }

    public void scrollToPosition(int position) {
        if (this.setting.swipeableMethod.canSwipeAutomatically() && this.state.canScrollToPosition(position, this.getItemCount())) {
            this.state.topPosition = position;
            this.requestLayout();
        }
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State s, int position) {
        if (this.setting.swipeableMethod.canSwipeAutomatically() && this.state.canScrollToPosition(position, this.getItemCount())) {
            this.smoothScrollToPosition(position);
        }
    }

    @NonNull
    public CardStackSetting getCardStackSetting() {
        return this.setting;
    }

    @NonNull
    public CardStackState getCardStackState() {
        return this.state;
    }

    @NonNull
    public CardStackListener getCardStackListener() {
        return this.listener;
    }

    void updateProportion(float x, float y) {
        View view;
        if (this.getTopPosition() < this.getItemCount() && (view = this.findViewByPosition(this.getTopPosition())) != null) {
            float half = (float)this.getHeight() / 2.0f;
            this.state.proportion = -(y - half - (float)view.getTop()) / half;
        }
    }

    private void update(RecyclerView.Recycler recycler) {
        this.state.width = this.getWidth();
        this.state.height = this.getHeight();
        if (this.state.isSwipeCompleted()) {
            this.removeAndRecycleView(this.getTopView(), recycler);
            final Direction direction = this.state.getDirection();
            this.state.next(this.state.status.toAnimatedStatus());
            ++this.state.topPosition;
            this.state.dx = 0;
            this.state.dy = 0;
            if (this.state.topPosition == this.state.targetPosition) {
                this.state.targetPosition = -1;
            }
            new Handler().post(new Runnable(){

                @Override
                public void run() {
                    CardStackLayoutManager.this.listener.onCardSwiped(direction);
                    View topView = CardStackLayoutManager.this.getTopView();
                    if (topView != null) {
                        CardStackLayoutManager.this.listener.onCardAppeared(CardStackLayoutManager.this.getTopView(), CardStackLayoutManager.this.state.topPosition);
                    }
                }
            });
        }
        this.detachAndScrapAttachedViews(recycler);
        int parentTop = this.getPaddingTop();
        int parentLeft = this.getPaddingLeft();
        int parentRight = this.getWidth() - this.getPaddingLeft();
        int parentBottom = this.getHeight() - this.getPaddingBottom();
        for (int i = this.state.topPosition; i < this.state.topPosition + this.setting.visibleCount && i < this.getItemCount(); ++i) {
            View child = recycler.getViewForPosition(i);
            this.addView(child, 0);
            this.measureChildWithMargins(child, 0, 0);
            this.layoutDecoratedWithMargins(child, parentLeft, parentTop, parentRight, parentBottom);
            this.resetTranslation(child);
            this.resetScale(child);
            this.resetRotation(child);
            if (i == this.state.topPosition) {
                this.updateTranslation(child);
                this.resetScale(child);
                this.updateRotation(child);
                continue;
            }
            int currentIndex = i - this.state.topPosition;
            this.updateTranslation(child, currentIndex);
            this.updateScale(child, currentIndex);
            this.resetRotation(child);
        }
        if (this.state.status.isDragging()) {
            this.listener.onCardDragging(this.state.getDirection(), this.state.getRatio());
        }
    }

    private void updateTranslation(View view) {
        view.setTranslationX((float)this.state.dx);
        view.setTranslationY((float)this.state.dy);
    }

    private void updateTranslation(View view, int index) {
        int nextIndex = index - 1;
        int translationPx = DisplayUtil.dpToPx(this.context, this.setting.translationInterval);
        float currentTranslation = index * translationPx;
        float nextTranslation = nextIndex * translationPx;
        float targetTranslation = currentTranslation - (currentTranslation - nextTranslation) * this.state.getRatio();
        switch (this.setting.stackFrom) {
            case None: {
                break;
            }
            case Top: {
                view.setTranslationY(-targetTranslation);
                break;
            }
            case TopAndLeft: {
                view.setTranslationY(-targetTranslation);
                view.setTranslationX(-targetTranslation);
                break;
            }
            case TopAndRight: {
                view.setTranslationY(-targetTranslation);
                view.setTranslationX(targetTranslation);
                break;
            }
            case Bottom: {
                view.setTranslationY(targetTranslation);
                break;
            }
            case BottomAndLeft: {
                view.setTranslationY(targetTranslation);
                view.setTranslationX(-targetTranslation);
                break;
            }
            case BottomAndRight: {
                view.setTranslationY(targetTranslation);
                view.setTranslationX(targetTranslation);
                break;
            }
            case Left: {
                view.setTranslationX(-targetTranslation);
                break;
            }
            case Right: {
                view.setTranslationX(targetTranslation);
            }
        }
    }

    private void resetTranslation(View view) {
        view.setTranslationX(0.0f);
        view.setTranslationY(0.0f);
    }

    private void updateScale(View view, int index) {
        int nextIndex = index - 1;
        float currentScale = 1.0f - (float)index * (1.0f - this.setting.scaleInterval);
        float nextScale = 1.0f - (float)nextIndex * (1.0f - this.setting.scaleInterval);
        float targetScale = currentScale + (nextScale - currentScale) * this.state.getRatio();
        switch (this.setting.stackFrom) {
            case None: {
                view.setScaleX(targetScale);
                view.setScaleY(targetScale);
                break;
            }
            case Top: {
                view.setScaleX(targetScale);
                break;
            }
            case TopAndLeft: {
                view.setScaleX(targetScale);
                break;
            }
            case TopAndRight: {
                view.setScaleX(targetScale);
                break;
            }
            case Bottom: {
                view.setScaleX(targetScale);
                break;
            }
            case BottomAndLeft: {
                view.setScaleX(targetScale);
                break;
            }
            case BottomAndRight: {
                view.setScaleX(targetScale);
                break;
            }
            case Left: {
                view.setScaleY(targetScale);
                break;
            }
            case Right: {
                view.setScaleY(targetScale);
            }
        }
    }

    private void resetScale(View view) {
        view.setScaleX(1.0f);
        view.setScaleY(1.0f);
    }

    private void updateRotation(View view) {
        float degree = (float)this.state.dx * this.setting.maxDegree / (float)this.getWidth() * this.state.proportion;
        view.setRotation(degree);
    }

    private void resetRotation(View view) {
        view.setRotation(0.0f);
    }

    private void smoothScrollToPosition(int position) {
        if (this.state.topPosition < position) {
            this.smoothScrollToNext(position);
        } else {
            this.smoothScrollToPrevious(position);
        }
    }

    private void smoothScrollToNext(int position) {
        this.state.proportion = 0.0f;
        this.state.targetPosition = position;
        CardStackSmoothScroller scroller = new CardStackSmoothScroller(CardStackSmoothScroller.ScrollType.AutomaticSwipe, this);
        scroller.setTargetPosition(this.state.topPosition);
        this.startSmoothScroll(scroller);
    }

    private void smoothScrollToPrevious(int position) {
        View topView = this.getTopView();
        if (topView != null) {
            this.listener.onCardDisappeared(this.getTopView(), this.state.topPosition);
        }
        this.state.proportion = 0.0f;
        this.state.targetPosition = position;
        --this.state.topPosition;
        CardStackSmoothScroller scroller = new CardStackSmoothScroller(CardStackSmoothScroller.ScrollType.AutomaticRewind, this);
        scroller.setTargetPosition(this.state.topPosition);
        this.startSmoothScroll(scroller);
    }

    public View getTopView() {
        return this.findViewByPosition(this.state.topPosition);
    }

    public int getTopPosition() {
        return this.state.topPosition;
    }

    public void setTopPosition(int topPosition) {
        this.state.topPosition = topPosition;
    }

    public void setStackFrom(@NonNull StackFrom stackFrom) {
        this.setting.stackFrom = stackFrom;
    }

    public void setVisibleCount(@IntRange(from=1L) int visibleCount) {
        if (visibleCount < 1) {
            throw new IllegalArgumentException("VisibleCount must be greater than 0.");
        }
        this.setting.visibleCount = visibleCount;
    }

    public void setTranslationInterval(@FloatRange(from=0.0) float translationInterval) {
        if (translationInterval < 0.0f) {
            throw new IllegalArgumentException("TranslationInterval must be greater than or equal 0.0f");
        }
        this.setting.translationInterval = translationInterval;
    }

    public void setScaleInterval(@FloatRange(from=0.0) float scaleInterval) {
        if (scaleInterval < 0.0f) {
            throw new IllegalArgumentException("ScaleInterval must be greater than or equal 0.0f.");
        }
        this.setting.scaleInterval = scaleInterval;
    }

    public void setSwipeThreshold(@FloatRange(from=0.0, to=1.0) float swipeThreshold) {
        if (swipeThreshold < 0.0f || 1.0f < swipeThreshold) {
            throw new IllegalArgumentException("SwipeThreshold must be 0.0f to 1.0f.");
        }
        this.setting.swipeThreshold = swipeThreshold;
    }

    public void setMaxDegree(@FloatRange(from=-360.0, to=360.0) float maxDegree) {
        if (maxDegree < -360.0f || 360.0f < maxDegree) {
            throw new IllegalArgumentException("MaxDegree must be -360.0f to 360.0f");
        }
        this.setting.maxDegree = maxDegree;
    }

    public void setDirections(@NonNull List<Direction> directions) {
        this.setting.directions = directions;
    }

    public void setCanScrollHorizontal(boolean canScrollHorizontal) {
        this.setting.canScrollHorizontal = canScrollHorizontal;
    }

    public void setCanScrollVertical(boolean canScrollVertical) {
        this.setting.canScrollVertical = canScrollVertical;
    }

    public void setSwipeableMethod(SwipeableMethod swipeableMethod) {
        this.setting.swipeableMethod = swipeableMethod;
    }

    public void setSwipeAnimationSetting(@NonNull SwipeAnimationSetting swipeAnimationSetting) {
        this.setting.swipeAnimationSetting = swipeAnimationSetting;
    }

    public void setRewindAnimationSetting(@NonNull RewindAnimationSetting rewindAnimationSetting) {
        this.setting.rewindAnimationSetting = rewindAnimationSetting;
    }

    public void setOverlayInterpolator(@NonNull Interpolator overlayInterpolator) {
        this.setting.overlayInterpolator = overlayInterpolator;
    }
}

