/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.meeting.pinnedvideo;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.MainThread;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewTreeLifecycleOwner;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.card.MaterialCardView;
import hms.webrtc.RendererCommon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import live.hms.prebuilt_themes.HMSPrebuiltTheme;
import live.hms.prebuilt_themes.ThemeExtKt;
import live.hms.roomkit.databinding.ListItemVideoBinding;
import live.hms.roomkit.helpers.NetworkQualityHelper;
import live.hms.roomkit.ui.meeting.CustomPeerMetadata;
import live.hms.roomkit.ui.meeting.MeetingTrack;
import live.hms.roomkit.ui.meeting.pinnedvideo.StatsInterpreter;
import live.hms.roomkit.ui.meeting.pinnedvideo.VideoListItem;
import live.hms.roomkit.ui.meeting.pinnedvideo.VideoListItemDiffUtil;
import live.hms.roomkit.util.NameUtils;
import live.hms.roomkit.util.UtilsKt;
import live.hms.video.connection.stats.quality.HMSNetworkQuality;
import live.hms.video.media.tracks.HMSAudioTrack;
import live.hms.video.media.tracks.HMSVideoTrack;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.sdk.models.HMSPeerType;
import live.hms.video.sdk.models.enums.HMSPeerUpdate;
import live.hms.video.signal.init.HMSRoomLayout;
import live.hms.videoview.HMSVideoView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u0000 72\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0003789BJ\u0012!\u0010\u0003\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0004\u0012\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001eH\u0016J\u001a\u0010\"\u001a\u00020\t2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$J\u001c\u0010'\u001a\u00020\t2\n\u0010(\u001a\u00060\u0002R\u00020\u00002\u0006\u0010!\u001a\u00020\u001eH\u0016J*\u0010'\u001a\u00020\t2\n\u0010(\u001a\u00060\u0002R\u00020\u00002\u0006\u0010!\u001a\u00020\u001e2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017H\u0016J\u001c\u0010*\u001a\u00060\u0002R\u00020\u00002\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u001eH\u0016J\u0014\u0010.\u001a\u00020\t2\n\u0010(\u001a\u00060\u0002R\u00020\u0000H\u0016J\u0014\u0010/\u001a\u00020\t2\n\u0010(\u001a\u00060\u0002R\u00020\u0000H\u0016J\u0014\u00100\u001a\u00020\t2\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u0005H\u0007J\u000e\u00102\u001a\u00020\t2\u0006\u00103\u001a\u00020\u0005J\u0014\u00104\u001a\u00020\t2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000506R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0003\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter$VideoItemViewHolder;", "onVideoItemClick", "Lkotlin/Function1;", "Llive/hms/roomkit/ui/meeting/MeetingTrack;", "Lkotlin/ParameterName;", "name", "item", "", "itemStats", "Lkotlinx/coroutines/flow/Flow;", "", "", "", "statsActive", "", "(Lkotlin/jvm/functions/Function1;Lkotlinx/coroutines/flow/Flow;Z)V", "currentTrackItem", "Ljava/util/ArrayList;", "Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListItem;", "Lkotlin/collections/ArrayList;", "currentTrackSource", "", "pinnedTrack", "getPinnedTrack", "()Llive/hms/roomkit/ui/meeting/MeetingTrack;", "setPinnedTrack", "(Llive/hms/roomkit/ui/meeting/MeetingTrack;)V", "getItemCount", "", "getItemId", "", "position", "itemChanged", "changedPeer", "Lkotlin/Pair;", "Llive/hms/video/sdk/models/HMSPeer;", "Llive/hms/video/sdk/models/enums/HMSPeerUpdate;", "onBindViewHolder", "holder", "payloads", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onViewAttachedToWindow", "onViewDetachedFromWindow", "setItems", "excludeTrack", "updatePinnedVideo", "track", "updateTotalSource", "newItems", "", "Companion", "PeerUpdatePayloads", "VideoItemViewHolder", "room-kit_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nVideoListAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoListAdapter.kt\nlive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,262:1\n774#2:263\n865#2,2:264\n1053#2:266\n1567#2:267\n1598#2,4:268\n1734#2,3:272\n1863#2,2:275\n1#3:277\n*S KotlinDebug\n*F\n+ 1 VideoListAdapter.kt\nlive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter\n*L\n148#1:263\n148#1:264,2\n149#1:266\n150#1:267\n150#1:268,4\n182#1:272,3\n186#1:275,2\n*E\n"})
public final class VideoListAdapter
extends RecyclerView.Adapter<VideoItemViewHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<MeetingTrack, Unit> onVideoItemClick;
    @NotNull
    private final Flow<Map<String, Object>> itemStats;
    private final boolean statsActive;
    @Nullable
    private MeetingTrack pinnedTrack;
    @NotNull
    private final ArrayList<VideoListItem> currentTrackItem;
    @NotNull
    private final List<MeetingTrack> currentTrackSource;
    public static final int $stable = 8;
    @NotNull
    private static final String TAG = "VideoListAdapter";

    public VideoListAdapter(@NotNull Function1<? super MeetingTrack, Unit> onVideoItemClick, @NotNull Flow<? extends Map<String, ? extends Object>> itemStats, boolean statsActive) {
        Intrinsics.checkNotNullParameter(onVideoItemClick, (String)"onVideoItemClick");
        Intrinsics.checkNotNullParameter(itemStats, (String)"itemStats");
        this.onVideoItemClick = onVideoItemClick;
        this.itemStats = itemStats;
        this.statsActive = statsActive;
        this.currentTrackItem = new ArrayList();
        this.currentTrackSource = new ArrayList();
    }

    @Nullable
    public final MeetingTrack getPinnedTrack() {
        return this.pinnedTrack;
    }

    public final void setPinnedTrack(@Nullable MeetingTrack meetingTrack) {
        this.pinnedTrack = meetingTrack;
    }

    public long getItemId(int position) {
        return this.currentTrackItem.get(position).getId();
    }

    public void onViewAttachedToWindow(@NotNull VideoItemViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        Log.d((String)TAG, (String)("onViewAttachedToWindow(" + holder + ")"));
        holder.bindSurfaceView();
    }

    public void onViewDetachedFromWindow(@NotNull VideoItemViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        Log.d((String)TAG, (String)("onViewDetachedFromWindow(" + holder + ")"));
        holder.unbindSurfaceView();
    }

    public final void updateTotalSource(@NotNull List<MeetingTrack> newItems) {
        Intrinsics.checkNotNullParameter(newItems, (String)"newItems");
        this.currentTrackSource.clear();
        CollectionsKt.addAll((Collection)this.currentTrackSource, (Iterable)newItems);
    }

    /*
     * WARNING - void declaration
     */
    @MainThread
    public final void setItems(@Nullable MeetingTrack excludeTrack) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.currentTrackSource;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MeetingTrack it = (MeetingTrack)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)excludeTrack))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Iterable $this$mapIndexed$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                MeetingTrack it = (MeetingTrack)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getPeer().getName());
                it = (MeetingTrack)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPeer().getName())));
            }
        });
        boolean $i$f$mapIndexed = false;
        $this$filterTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void track;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MeetingTrack meetingTrack = (MeetingTrack)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            HMSAudioTrack hMSAudioTrack = track.getPeer().getAudioTrack();
            collection.add(new VideoListItem((long)index, (MeetingTrack)track, hMSAudioTrack != null ? hMSAudioTrack.isMute() : false));
        }
        List newVideoItems = (List)destination$iv$iv;
        VideoListItemDiffUtil callback = new VideoListItemDiffUtil((List<VideoListItem>)this.currentTrackItem, newVideoItems);
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)callback);
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(callback)");
        DiffUtil.DiffResult diff = diffResult;
        diff.dispatchUpdatesTo((RecyclerView.Adapter)this);
        this.currentTrackItem.clear();
        this.currentTrackItem.addAll(newVideoItems);
    }

    public static /* synthetic */ void setItems$default(VideoListAdapter videoListAdapter2, MeetingTrack meetingTrack, int n, Object object) {
        if ((n & 1) != 0) {
            meetingTrack = null;
        }
        videoListAdapter2.setItems(meetingTrack);
    }

    @NotNull
    public VideoItemViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        ListItemVideoBinding listItemVideoBinding = ListItemVideoBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)listItemVideoBinding, (String)"inflate(\n      LayoutInf\u2026parent,\n      false\n    )");
        ListItemVideoBinding binding = listItemVideoBinding;
        return new VideoItemViewHolder(binding, this.itemStats);
    }

    public void onBindViewHolder(@NotNull VideoItemViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        VideoListItem videoListItem = this.currentTrackItem.get(position);
        Intrinsics.checkNotNullExpressionValue((Object)videoListItem, (String)"currentTrackItem[position]");
        holder.bind(videoListItem);
    }

    public void onBindViewHolder(@NotNull VideoItemViewHolder holder, int position, @NotNull List<Object> payloads) {
        Object element$iv;
        Iterator iterator;
        boolean bl;
        block14: {
            Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
            Intrinsics.checkNotNullParameter(payloads, (String)"payloads");
            if (payloads.isEmpty()) {
                super.onBindViewHolder((RecyclerView.ViewHolder)holder, position, payloads);
                return;
            }
            Iterable $this$all$iv = payloads;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    Object it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (it instanceof PeerUpdatePayloads) continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
        }
        if (bl) {
            Iterable $this$forEach$iv = payloads;
            boolean $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object payload = element$iv = iterator.next();
                boolean bl3 = false;
                if (!(payload instanceof PeerUpdatePayloads)) continue;
                PeerUpdatePayloads peerUpdatePayloads = (PeerUpdatePayloads)payload;
                if (peerUpdatePayloads instanceof PeerUpdatePayloads.MetadataChanged) {
                    holder.getBinding().raisedHand.setVisibility(UtilsKt.visibility(((PeerUpdatePayloads.MetadataChanged)payload).isHandRaised()));
                    continue;
                }
                if (peerUpdatePayloads instanceof PeerUpdatePayloads.NameChanged) {
                    holder.getBinding().nameInitials.setText((CharSequence)NameUtils.INSTANCE.getGetInitials().invoke((Object)((PeerUpdatePayloads.NameChanged)payload).getName()));
                    holder.getBinding().name.setText((CharSequence)((PeerUpdatePayloads.NameChanged)payload).getName());
                    continue;
                }
                if (peerUpdatePayloads instanceof PeerUpdatePayloads.NetworkQualityChanged) {
                    Function0<Unit> function0;
                    Context context;
                    Context context2 = context = holder.getBinding().getRoot().getContext();
                    if (context2 != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
                        Context context3 = context;
                        boolean bl4 = false;
                        holder.getBinding().networkQuality.setVisibility(0);
                        if (NetworkQualityHelper.Companion.getNetworkResource(((PeerUpdatePayloads.NetworkQualityChanged)payload).getDownlinkSpeed(), context3) != null) {
                            Drawable it;
                            boolean bl5 = false;
                            Integer n = ((PeerUpdatePayloads.NetworkQualityChanged)payload).getDownlinkSpeed();
                            if (n != null && n == 0) {
                                HMSRoomLayout.HMSRoomLayoutData.HMSRoomTheme.HMSColorPalette hMSColorPalette = HMSPrebuiltTheme.INSTANCE.getColours();
                                holder.getBinding().networkQuality.setColorFilter(ThemeExtKt.getColorOrDefault((String)(hMSColorPalette != null ? hMSColorPalette.getAlertSuccess() : null), (String)HMSPrebuiltTheme.INSTANCE.getDefaults().getError_default()), PorterDuff.Mode.SRC_IN);
                            } else {
                                holder.getBinding().networkQuality.setColorFilter(null);
                            }
                            holder.getBinding().networkQuality.setImageDrawable(it);
                            function0 = Unit.INSTANCE;
                            continue;
                        }
                        function0 = new Function0<Unit>(holder){
                            final /* synthetic */ VideoItemViewHolder $holder;
                            {
                                this.$holder = $holder;
                                super(0);
                            }

                            public final void invoke() {
                                this.$holder.getBinding().networkQuality.setVisibility(8);
                            }
                        };
                        continue;
                    }
                    function0 = null;
                    continue;
                }
                if (!(peerUpdatePayloads instanceof PeerUpdatePayloads.SpeakerMuteUnmute)) continue;
                holder.getBinding().iconAudioOff.setVisibility(UtilsKt.visibility(((PeerUpdatePayloads.SpeakerMuteUnmute)payload).isMute()));
            }
        } else {
            holder.unbindSurfaceView();
            VideoListItem videoListItem = this.currentTrackItem.get(position);
            Intrinsics.checkNotNullExpressionValue((Object)videoListItem, (String)"currentTrackItem[position]");
            holder.bind(videoListItem);
            holder.bindSurfaceView();
        }
    }

    public int getItemCount() {
        return this.currentTrackItem.size();
    }

    public final void itemChanged(@NotNull Pair<? extends HMSPeer, ? extends HMSPeerUpdate> changedPeer) {
        block9: {
            Object v0;
            block8: {
                Intrinsics.checkNotNullParameter(changedPeer, (String)"changedPeer");
                Iterable iterable = this.currentTrackItem;
                for (Object t : iterable) {
                    VideoListItem it = (VideoListItem)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getTrack().getPeer().getPeerID(), (Object)((HMSPeer)changedPeer.getFirst()).getPeerID())) continue;
                    v0 = t;
                    break block8;
                }
                v0 = null;
            }
            VideoListItem videoListItem = v0;
            Long updatedItemId = videoListItem != null ? Long.valueOf(videoListItem.getId()) : null;
            PeerUpdatePayloads payload = switch (WhenMappings.$EnumSwitchMapping$0[((HMSPeerUpdate)changedPeer.getSecond()).ordinal()]) {
                case 1 -> new PeerUpdatePayloads.MetadataChanged(CustomPeerMetadata.Companion.fromJson(((HMSPeer)changedPeer.getFirst()).getMetadata()), ((HMSPeer)changedPeer.getFirst()).isHandRaised());
                case 2 -> {
                    PeerUpdatePayloads.NetworkQualityChanged v4;
                    if (((HMSPeer)changedPeer.getFirst()).getType() != HMSPeerType.SIP) {
                        HMSNetworkQuality v3 = ((HMSPeer)changedPeer.getFirst()).getNetworkQuality();
                        v4 = new PeerUpdatePayloads.NetworkQualityChanged(v3 != null ? Integer.valueOf(v3.getDownlinkQuality()) : null);
                    } else {
                        v4 = null;
                    }
                    yield v4;
                }
                case 3 -> new PeerUpdatePayloads.NameChanged(((HMSPeer)changedPeer.getFirst()).getName());
                default -> null;
            };
            Long l = updatedItemId;
            if (l == null) break block9;
            int it = (int)l.longValue();
            boolean bl = false;
            this.notifyItemChanged(it, payload);
        }
    }

    public final void updatePinnedVideo(@NotNull MeetingTrack track) {
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        this.setItems(track);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter$Companion;", "", "()V", "TAG", "", "room-kit_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter$PeerUpdatePayloads;", "", "()V", "MetadataChanged", "NameChanged", "NetworkQualityChanged", "SpeakerMuteUnmute", "Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter$PeerUpdatePayloads$MetadataChanged;", "Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter$PeerUpdatePayloads$NameChanged;", "Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter$PeerUpdatePayloads$NetworkQualityChanged;", "Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter$PeerUpdatePayloads$SpeakerMuteUnmute;", "room-kit_release"})
    @StabilityInferred(parameters=0)
    public static abstract class PeerUpdatePayloads {
        public static final int $stable;

        private PeerUpdatePayloads() {
        }

        public /* synthetic */ PeerUpdatePayloads(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter$PeerUpdatePayloads$MetadataChanged;", "Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter$PeerUpdatePayloads;", "metadata", "Llive/hms/roomkit/ui/meeting/CustomPeerMetadata;", "isHandRaised", "", "(Llive/hms/roomkit/ui/meeting/CustomPeerMetadata;Z)V", "()Z", "getMetadata", "()Llive/hms/roomkit/ui/meeting/CustomPeerMetadata;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "room-kit_release"})
        @StabilityInferred(parameters=0)
        public static final class MetadataChanged
        extends PeerUpdatePayloads {
            @Nullable
            private final CustomPeerMetadata metadata;
            private final boolean isHandRaised;
            public static final int $stable;

            public MetadataChanged(@Nullable CustomPeerMetadata metadata, boolean isHandRaised) {
                super(null);
                this.metadata = metadata;
                this.isHandRaised = isHandRaised;
            }

            @Nullable
            public final CustomPeerMetadata getMetadata() {
                return this.metadata;
            }

            public final boolean isHandRaised() {
                return this.isHandRaised;
            }

            @Nullable
            public final CustomPeerMetadata component1() {
                return this.metadata;
            }

            public final boolean component2() {
                return this.isHandRaised;
            }

            @NotNull
            public final MetadataChanged copy(@Nullable CustomPeerMetadata metadata, boolean isHandRaised) {
                return new MetadataChanged(metadata, isHandRaised);
            }

            public static /* synthetic */ MetadataChanged copy$default(MetadataChanged metadataChanged, CustomPeerMetadata customPeerMetadata, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    customPeerMetadata = metadataChanged.metadata;
                }
                if ((n & 2) != 0) {
                    bl = metadataChanged.isHandRaised;
                }
                return metadataChanged.copy(customPeerMetadata, bl);
            }

            @NotNull
            public String toString() {
                return "MetadataChanged(metadata=" + this.metadata + ", isHandRaised=" + this.isHandRaised + ")";
            }

            public int hashCode() {
                int result = this.metadata == null ? 0 : this.metadata.hashCode();
                int n = this.isHandRaised ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                result = result * 31 + n;
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MetadataChanged)) {
                    return false;
                }
                MetadataChanged metadataChanged = (MetadataChanged)other;
                if (!Intrinsics.areEqual((Object)this.metadata, (Object)metadataChanged.metadata)) {
                    return false;
                }
                return this.isHandRaised == metadataChanged.isHandRaised;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter$PeerUpdatePayloads$NameChanged;", "Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter$PeerUpdatePayloads;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "room-kit_release"})
        @StabilityInferred(parameters=0)
        public static final class NameChanged
        extends PeerUpdatePayloads {
            @NotNull
            private final String name;
            public static final int $stable;

            public NameChanged(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                super(null);
                this.name = name;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final NameChanged copy(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return new NameChanged(name);
            }

            public static /* synthetic */ NameChanged copy$default(NameChanged nameChanged, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = nameChanged.name;
                }
                return nameChanged.copy(string2);
            }

            @NotNull
            public String toString() {
                return "NameChanged(name=" + this.name + ")";
            }

            public int hashCode() {
                return this.name.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NameChanged)) {
                    return false;
                }
                NameChanged nameChanged = (NameChanged)other;
                return Intrinsics.areEqual((Object)this.name, (Object)nameChanged.name);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter$PeerUpdatePayloads$NetworkQualityChanged;", "Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter$PeerUpdatePayloads;", "downlinkSpeed", "", "(Ljava/lang/Integer;)V", "getDownlinkSpeed", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "copy", "(Ljava/lang/Integer;)Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter$PeerUpdatePayloads$NetworkQualityChanged;", "equals", "", "other", "", "hashCode", "toString", "", "room-kit_release"})
        @StabilityInferred(parameters=0)
        public static final class NetworkQualityChanged
        extends PeerUpdatePayloads {
            @Nullable
            private final Integer downlinkSpeed;
            public static final int $stable;

            public NetworkQualityChanged(@Nullable Integer downlinkSpeed) {
                super(null);
                this.downlinkSpeed = downlinkSpeed;
            }

            @Nullable
            public final Integer getDownlinkSpeed() {
                return this.downlinkSpeed;
            }

            @Nullable
            public final Integer component1() {
                return this.downlinkSpeed;
            }

            @NotNull
            public final NetworkQualityChanged copy(@Nullable Integer downlinkSpeed) {
                return new NetworkQualityChanged(downlinkSpeed);
            }

            public static /* synthetic */ NetworkQualityChanged copy$default(NetworkQualityChanged networkQualityChanged, Integer n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = networkQualityChanged.downlinkSpeed;
                }
                return networkQualityChanged.copy(n);
            }

            @NotNull
            public String toString() {
                return "NetworkQualityChanged(downlinkSpeed=" + this.downlinkSpeed + ")";
            }

            public int hashCode() {
                return this.downlinkSpeed == null ? 0 : ((Object)this.downlinkSpeed).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NetworkQualityChanged)) {
                    return false;
                }
                NetworkQualityChanged networkQualityChanged = (NetworkQualityChanged)other;
                return Intrinsics.areEqual((Object)this.downlinkSpeed, (Object)networkQualityChanged.downlinkSpeed);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0006\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0007\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\b\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\nH\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0005\u00a8\u0006\u000f"}, d2={"Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter$PeerUpdatePayloads$SpeakerMuteUnmute;", "Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter$PeerUpdatePayloads;", "isMute", "", "(Z)V", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "room-kit_release"})
        @StabilityInferred(parameters=0)
        public static final class SpeakerMuteUnmute
        extends PeerUpdatePayloads {
            private final boolean isMute;
            public static final int $stable;

            public SpeakerMuteUnmute(boolean isMute) {
                super(null);
                this.isMute = isMute;
            }

            public final boolean isMute() {
                return this.isMute;
            }

            public final boolean component1() {
                return this.isMute;
            }

            @NotNull
            public final SpeakerMuteUnmute copy(boolean isMute) {
                return new SpeakerMuteUnmute(isMute);
            }

            public static /* synthetic */ SpeakerMuteUnmute copy$default(SpeakerMuteUnmute speakerMuteUnmute, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = speakerMuteUnmute.isMute;
                }
                return speakerMuteUnmute.copy(bl);
            }

            @NotNull
            public String toString() {
                return "SpeakerMuteUnmute(isMute=" + this.isMute + ")";
            }

            public int hashCode() {
                int n = this.isMute ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                return n;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SpeakerMuteUnmute)) {
                    return false;
                }
                SpeakerMuteUnmute speakerMuteUnmute = (SpeakerMuteUnmute)other;
                return this.isMute == speakerMuteUnmute.isMute;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fJ\u0006\u0010\u0015\u001a\u00020\u0013J\u0006\u0010\u0016\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter$VideoItemViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Llive/hms/roomkit/databinding/ListItemVideoBinding;", "itemStats", "Lkotlinx/coroutines/flow/Flow;", "", "", "", "(Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter;Llive/hms/roomkit/databinding/ListItemVideoBinding;Lkotlinx/coroutines/flow/Flow;)V", "getBinding", "()Llive/hms/roomkit/databinding/ListItemVideoBinding;", "isSurfaceViewBinded", "", "itemRef", "Llive/hms/roomkit/ui/meeting/pinnedvideo/VideoListItem;", "statsInterpreter", "Llive/hms/roomkit/ui/meeting/pinnedvideo/StatsInterpreter;", "bind", "", "item", "bindSurfaceView", "unbindSurfaceView", "room-kit_release"})
    @SourceDebugExtension(value={"SMAP\nVideoListAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoListAdapter.kt\nlive/hms/roomkit/ui/meeting/pinnedvideo/VideoListAdapter$VideoItemViewHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,262:1\n1#2:263\n*E\n"})
    public final class VideoItemViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final ListItemVideoBinding binding;
        @NotNull
        private final Flow<Map<String, Object>> itemStats;
        @Nullable
        private VideoListItem itemRef;
        @NotNull
        private final StatsInterpreter statsInterpreter;
        private boolean isSurfaceViewBinded;

        public VideoItemViewHolder(@NotNull ListItemVideoBinding binding, Flow<? extends Map<String, ? extends Object>> itemStats) {
            Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
            Intrinsics.checkNotNullParameter(itemStats, (String)"itemStats");
            super((View)binding.getRoot());
            this.binding = binding;
            this.itemStats = itemStats;
            this.statsInterpreter = new StatsInterpreter(VideoListAdapter.this.statsActive);
        }

        @NotNull
        public final ListItemVideoBinding getBinding() {
            return this.binding;
        }

        public final void bind(@NotNull VideoListItem item) {
            HMSVideoView hMSVideoView;
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            this.binding.nameInitials.setText((CharSequence)NameUtils.INSTANCE.getGetInitials().invoke((Object)item.getTrack().getPeer().getName()));
            this.binding.name.setText((CharSequence)item.getTrack().getPeer().getName());
            this.binding.iconScreenShare.setVisibility(item.getTrack().isScreen() ? 0 : 8);
            HMSVideoView $this$bind_u24lambda_u241 = hMSVideoView = this.binding.hmsVideoView;
            boolean bl = false;
            $this$bind_u24lambda_u241.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_FIT);
            $this$bind_u24lambda_u241.setVisibility(8);
            HMSVideoTrack hMSVideoTrack = item.getTrack().getVideo();
            if (hMSVideoTrack != null) {
                HMSVideoTrack it = hMSVideoTrack;
                boolean bl2 = false;
                this.binding.hmsVideoView.addTrack(it);
            }
            this.itemRef = item;
            this.isSurfaceViewBinded = false;
            boolean isHandRaised = item.getTrack().getPeer().isHandRaised();
            this.binding.raisedHand.setVisibility(UtilsKt.visibility(isHandRaised));
            this.binding.getRoot().setOnClickListener(arg_0 -> VideoItemViewHolder.bind$lambda$2(VideoListAdapter.this, item, arg_0));
        }

        public final void bindSurfaceView() {
            block2: {
                Object object;
                if (this.isSurfaceViewBinded) {
                    Log.d((String)VideoListAdapter.TAG, (String)"bindSurfaceView: Surface view already initialized");
                    return;
                }
                MaterialCardView materialCardView = this.binding.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)materialCardView, (String)"binding.root");
                LifecycleOwner lifecycleOwner = ViewTreeLifecycleOwner.get((View)((View)materialCardView));
                if (lifecycleOwner != null) {
                    Object object2;
                    Object object3;
                    LifecycleOwner it = lifecycleOwner;
                    boolean bl = false;
                    Object object4 = this.itemRef;
                    this.statsInterpreter.initiateStats(it, this.itemStats, object4 != null && (object4 = ((VideoListItem)object4).getTrack()) != null ? ((MeetingTrack)object4).getVideo() : null, (object3 = this.itemRef) != null && (object3 = ((VideoListItem)object3).getTrack()) != null ? ((MeetingTrack)object3).getAudio() : null, (object2 = this.itemRef) != null && (object2 = ((VideoListItem)object2).getTrack()) != null && (object2 = ((MeetingTrack)object2).getPeer()) != null ? object2.isLocal() : false, (Function1<? super CharSequence, Unit>)((Function1)new Function1<CharSequence, Unit>(this){
                        final /* synthetic */ VideoItemViewHolder this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull CharSequence it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            this.this$0.getBinding().stats.setText(it);
                        }
                    }));
                }
                if ((object = this.itemRef) == null || (object = ((VideoListItem)object).getTrack()) == null || (object = ((MeetingTrack)object).getVideo()) == null) break block2;
                Object it = object;
                boolean bl = false;
                this.binding.hmsVideoView.addTrack((HMSVideoTrack)it);
                Object object5 = this.itemRef;
                this.binding.hmsVideoView.setVisibility((object5 != null && (object5 = ((VideoListItem)object5).getTrack()) != null && (object5 = ((MeetingTrack)object5).getVideo()) != null ? object5.isDegraded() : false) ? 4 : 0);
                this.isSurfaceViewBinded = true;
            }
        }

        public final void unbindSurfaceView() {
            if (!this.isSurfaceViewBinded) {
                return;
            }
            this.binding.hmsVideoView.removeTrack();
            this.isSurfaceViewBinded = false;
            this.binding.hmsVideoView.setVisibility(8);
        }

        private static final void bind$lambda$2(VideoListAdapter this$0, VideoListItem $item, View it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$item, (String)"$item");
            this$0.onVideoItemClick.invoke((Object)$item.getTrack());
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HMSPeerUpdate.values().length];
            try {
                nArray[HMSPeerUpdate.METADATA_CHANGED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSPeerUpdate.NETWORK_QUALITY_UPDATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSPeerUpdate.NAME_CHANGED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

