/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.meeting.participants;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.LayoutRes;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.recyclerview.widget.RecyclerView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import live.hms.prebuilt_themes.ViewExtKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Llive/hms/roomkit/ui/meeting/participants/MessageHeaderItemDecoration;", "Landroidx/recyclerview/widget/RecyclerView$ItemDecoration;", "background", "", "sidePaddingPixels", "headerViewType", "(III)V", "paint", "Landroid/graphics/Paint;", "getItemOffsets", "", "outRect", "Landroid/graphics/Rect;", "view", "Landroid/view/View;", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "isHeader", "", "child", "onDraw", "c", "Landroid/graphics/Canvas;", "room-kit_release"})
@StabilityInferred(parameters=0)
public final class MessageHeaderItemDecoration
extends RecyclerView.ItemDecoration {
    private final int sidePaddingPixels;
    private final int headerViewType;
    @NotNull
    private final Paint paint;
    public static final int $stable = 8;

    public MessageHeaderItemDecoration(@ColorInt int background, int sidePaddingPixels, @LayoutRes int headerViewType) {
        this.sidePaddingPixels = sidePaddingPixels;
        this.headerViewType = headerViewType;
        this.paint = new Paint();
        this.paint.setColor(background);
        this.paint.setStrokeWidth(ViewExtKt.dp((float)1.0f));
    }

    public final boolean isHeader(@Nullable View child, @NotNull RecyclerView parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        Intrinsics.checkNotNull((Object)layoutManager);
        View view = child;
        Intrinsics.checkNotNull((Object)view);
        int viewType = layoutManager.getItemViewType(view);
        return viewType == this.headerViewType;
    }

    public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.isHeader(view, parent)) {
            return;
        }
        outRect.left = this.sidePaddingPixels;
        outRect.right = this.sidePaddingPixels;
    }

    public void onDraw(@NotNull Canvas c, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int n = parent.getChildCount();
        for (int i = 0; i < n; ++i) {
            RecyclerView.LayoutManager lm;
            View child = parent.getChildAt(i);
            if (!this.isHeader(child, parent)) continue;
            RecyclerView.LayoutManager layoutManager = lm = parent.getLayoutManager();
            Intrinsics.checkNotNull((Object)layoutManager);
            float top = (float)layoutManager.getDecoratedTop(child) + child.getTranslationY();
            float right = (float)lm.getDecoratedRight(child) + child.getTranslationX();
            float left = (float)lm.getDecoratedLeft(child) + child.getTranslationX();
            c.drawLine(left, top, right, top, this.paint);
        }
    }
}

