/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.meeting.chat;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.sdk.models.HMSMessageRecipient;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.sdk.models.enums.HMSMessageRecipientType;
import live.hms.video.sdk.models.role.HMSRole;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00032\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Llive/hms/roomkit/ui/meeting/chat/Recipient;", "", "()V", "Companion", "Everyone", "Peer", "Role", "Llive/hms/roomkit/ui/meeting/chat/Recipient$Everyone;", "Llive/hms/roomkit/ui/meeting/chat/Recipient$Peer;", "Llive/hms/roomkit/ui/meeting/chat/Recipient$Role;", "room-kit_release"})
@StabilityInferred(parameters=0)
public abstract class Recipient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    private Recipient() {
    }

    public /* synthetic */ Recipient(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Llive/hms/roomkit/ui/meeting/chat/Recipient$Companion;", "", "()V", "toRecipient", "Llive/hms/roomkit/ui/meeting/chat/Recipient;", "message", "Llive/hms/video/sdk/models/HMSMessageRecipient;", "room-kit_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Recipient toRecipient(@NotNull HMSMessageRecipient message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return switch (WhenMappings.$EnumSwitchMapping$0[message.getRecipientType().ordinal()]) {
                case 1 -> Everyone.INSTANCE;
                case 2 -> {
                    HMSPeer v1 = message.getRecipientPeer();
                    Intrinsics.checkNotNull((Object)v1);
                    yield new Peer(v1);
                }
                case 3 -> {
                    Object v2 = CollectionsKt.firstOrNull((List)message.getRecipientRoles());
                    Intrinsics.checkNotNull((Object)v2);
                    yield new Role((HMSRole)v2);
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[HMSMessageRecipientType.values().length];
                try {
                    nArray[HMSMessageRecipientType.BROADCAST.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HMSMessageRecipientType.PEER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HMSMessageRecipientType.ROLES.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Llive/hms/roomkit/ui/meeting/chat/Recipient$Everyone;", "Llive/hms/roomkit/ui/meeting/chat/Recipient;", "()V", "toString", "", "room-kit_release"})
    @StabilityInferred(parameters=0)
    public static final class Everyone
    extends Recipient {
        @NotNull
        public static final Everyone INSTANCE = new Everyone();
        public static final int $stable;

        private Everyone() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "Everyone";
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/hms/roomkit/ui/meeting/chat/Recipient$Peer;", "Llive/hms/roomkit/ui/meeting/chat/Recipient;", "peer", "Llive/hms/video/sdk/models/HMSPeer;", "(Llive/hms/video/sdk/models/HMSPeer;)V", "getPeer", "()Llive/hms/video/sdk/models/HMSPeer;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "room-kit_release"})
    @StabilityInferred(parameters=0)
    public static final class Peer
    extends Recipient {
        @NotNull
        private final HMSPeer peer;
        public static final int $stable = 8;

        public Peer(@NotNull HMSPeer peer) {
            Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
            super(null);
            this.peer = peer;
        }

        @NotNull
        public final HMSPeer getPeer() {
            return this.peer;
        }

        @NotNull
        public String toString() {
            return this.peer.getName();
        }

        @NotNull
        public final HMSPeer component1() {
            return this.peer;
        }

        @NotNull
        public final Peer copy(@NotNull HMSPeer peer) {
            Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
            return new Peer(peer);
        }

        public static /* synthetic */ Peer copy$default(Peer peer, HMSPeer hMSPeer, int n, Object object) {
            if ((n & 1) != 0) {
                hMSPeer = peer.peer;
            }
            return peer.copy(hMSPeer);
        }

        public int hashCode() {
            return this.peer.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Peer)) {
                return false;
            }
            Peer peer = (Peer)other;
            return Intrinsics.areEqual((Object)this.peer, (Object)peer.peer);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/hms/roomkit/ui/meeting/chat/Recipient$Role;", "Llive/hms/roomkit/ui/meeting/chat/Recipient;", "role", "Llive/hms/video/sdk/models/role/HMSRole;", "(Llive/hms/video/sdk/models/role/HMSRole;)V", "getRole", "()Llive/hms/video/sdk/models/role/HMSRole;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "room-kit_release"})
    @StabilityInferred(parameters=0)
    public static final class Role
    extends Recipient {
        @NotNull
        private final HMSRole role;
        public static final int $stable = 8;

        public Role(@NotNull HMSRole role) {
            Intrinsics.checkNotNullParameter((Object)role, (String)"role");
            super(null);
            this.role = role;
        }

        @NotNull
        public final HMSRole getRole() {
            return this.role;
        }

        @NotNull
        public String toString() {
            return this.role.getName();
        }

        @NotNull
        public final HMSRole component1() {
            return this.role;
        }

        @NotNull
        public final Role copy(@NotNull HMSRole role) {
            Intrinsics.checkNotNullParameter((Object)role, (String)"role");
            return new Role(role);
        }

        public static /* synthetic */ Role copy$default(Role role, HMSRole hMSRole, int n, Object object) {
            if ((n & 1) != 0) {
                hMSRole = role.role;
            }
            return role.copy(hMSRole);
        }

        public int hashCode() {
            return this.role.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Role)) {
                return false;
            }
            Role role = (Role)other;
            return Intrinsics.areEqual((Object)this.role, (Object)role.role);
        }
    }
}

