/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.meeting.chat;

import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import live.hms.roomkit.ui.meeting.chat.ChatMessage;
import live.hms.roomkit.ui.meeting.chat.Recipient;
import live.hms.video.error.HMSException;
import live.hms.video.sdk.HMSMessageResultListener;
import live.hms.video.sdk.HMSSDK;
import live.hms.video.sdk.models.HMSLocalPeer;
import live.hms.video.sdk.models.HMSMessage;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.sdk.models.enums.HMSMessageRecipientType;
import live.hms.video.sdk.models.role.HMSRole;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\b\u0007\u0018\u0000 92\u00020\u0001:\u00019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nH\u0002J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nH\u0002J\u0006\u0010!\u001a\u00020\u001eJ\b\u0010\"\u001a\u0004\u0018\u00010\u0007J\u0018\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010'\u001a\u00020(H\u0002J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\u001eJ\u000e\u0010,\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nJ\u000e\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u0010J\u0018\u0010/\u001a\u00020\u001e2\b\u00100\u001a\u0004\u0018\u00010\u00072\u0006\u00101\u001a\u00020\fJ\u0010\u00102\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020\nH\u0002J\u0016\u00103\u001a\u00020\u001e2\u000e\u00104\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fJ\u0014\u00105\u001a\u00020\u001e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0010\u00106\u001a\u00020\u001e2\b\u00107\u001a\u0004\u0018\u00010\u0010J\u0010\u00108\u001a\u00020\u001e2\b\u00100\u001a\u0004\u0018\u00010\u0007R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00180\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0014\u00a8\u0006:"}, d2={"Llive/hms/roomkit/ui/meeting/chat/ChatViewModel;", "Landroidx/lifecycle/ViewModel;", "hmssdk", "Llive/hms/video/sdk/HMSSDK;", "(Llive/hms/video/sdk/HMSSDK;)V", "_currentlySelectedRecipient", "Landroidx/lifecycle/MutableLiveData;", "Llive/hms/roomkit/ui/meeting/chat/Recipient;", "_messages", "", "Llive/hms/roomkit/ui/meeting/chat/ChatMessage;", "_unreadMessagesCount", "", "kotlin.jvm.PlatformType", "blockedPeerIds", "", "", "currentlySelectedRecipientRbac", "Landroidx/lifecycle/LiveData;", "getCurrentlySelectedRecipientRbac", "()Landroidx/lifecycle/LiveData;", "lastRecipientNum", "messageIdsToHide", "messages", "", "getMessages", "()Landroidx/lifecycle/MutableLiveData;", "unreadMessagesCount", "getUnreadMessagesCount", "addMessage", "", "message", "broadcast", "clearMessages", "currentlySelectedRbacRecipient", "directMessage", "peer", "Llive/hms/video/sdk/models/HMSPeer;", "groupMessage", "role", "Llive/hms/video/sdk/models/role/HMSRole;", "isUserBlockedFromChat", "", "markAllMessagesRead", "receivedMessage", "sendMessage", "messageStr", "setInitialRecipient", "recipient", "num", "shouldBlockMessage", "updateBlockList", "chatBlockedPeerIdsList", "updateMessageHideList", "updatePeerLeave", "leavingPeerId", "updateSelectedRecipientChatBottomSheet", "Companion", "room-kit_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nChatViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatViewModel.kt\nlive/hms/roomkit/ui/meeting/chat/ChatViewModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n1#2:263\n774#3:264\n865#3,2:265\n774#3:267\n865#3,2:268\n*S KotlinDebug\n*F\n+ 1 ChatViewModel.kt\nlive/hms/roomkit/ui/meeting/chat/ChatViewModel\n*L\n220#1:264\n220#1:265,2\n238#1:267\n238#1:268,2\n*E\n"})
public final class ChatViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HMSSDK hmssdk;
    @NotNull
    private final MutableLiveData<Recipient> _currentlySelectedRecipient;
    private int lastRecipientNum;
    @NotNull
    private final LiveData<Recipient> currentlySelectedRecipientRbac;
    @NotNull
    private List<ChatMessage> _messages;
    @NotNull
    private final MutableLiveData<List<ChatMessage>> messages;
    @NotNull
    private final MutableLiveData<Integer> _unreadMessagesCount;
    @NotNull
    private final LiveData<Integer> unreadMessagesCount;
    @NotNull
    private Set<String> blockedPeerIds;
    @Nullable
    private Set<String> messageIdsToHide;
    public static final int $stable = 8;
    @NotNull
    private static final String TAG = "ChatViewModel";

    public ChatViewModel(@NotNull HMSSDK hmssdk) {
        Intrinsics.checkNotNullParameter((Object)hmssdk, (String)"hmssdk");
        this.hmssdk = hmssdk;
        this._currentlySelectedRecipient = new MutableLiveData(null);
        this.currentlySelectedRecipientRbac = (LiveData)this._currentlySelectedRecipient;
        this._messages = new ArrayList();
        this.messages = new MutableLiveData();
        this._unreadMessagesCount = new MutableLiveData((Object)0);
        this.unreadMessagesCount = (LiveData)this._unreadMessagesCount;
        this.blockedPeerIds = SetsKt.emptySet();
    }

    public final void setInitialRecipient(@Nullable Recipient recipient, int num) {
        if (this.lastRecipientNum < num) {
            this.lastRecipientNum = num;
            this.updateSelectedRecipientChatBottomSheet(recipient);
        }
    }

    public final void updateSelectedRecipientChatBottomSheet(@Nullable Recipient recipient) {
        this._currentlySelectedRecipient.postValue((Object)recipient);
    }

    @NotNull
    public final LiveData<Recipient> getCurrentlySelectedRecipientRbac() {
        return this.currentlySelectedRecipientRbac;
    }

    public final void sendMessage(@NotNull String messageStr) {
        Intrinsics.checkNotNullParameter((Object)messageStr, (String)"messageStr");
        Recipient recipient = (Recipient)this.currentlySelectedRecipientRbac.getValue();
        if (recipient != null) {
            if (Intrinsics.areEqual((Object)recipient, (Object)Recipient.Everyone.INSTANCE)) {
                Object object = this.hmssdk.getLocalPeer();
                if (object == null || (object = object.getName()) == null) {
                    object = "Participant";
                }
                String string2 = ChatMessage.Companion.sendTo(HMSMessageRecipientType.BROADCAST, null, null, false);
                HMSLocalPeer hMSLocalPeer = this.hmssdk.getLocalPeer();
                String string3 = hMSLocalPeer != null ? hMSLocalPeer.getPeerID() : null;
                HMSLocalPeer hMSLocalPeer2 = this.hmssdk.getLocalPeer();
                String string4 = hMSLocalPeer2 != null && (hMSLocalPeer2 = hMSLocalPeer2.getHmsRole()) != null ? hMSLocalPeer2.getName() : null;
                Object object2 = this.hmssdk.getLocalPeer();
                if (object2 == null || (object2 = object2.getCustomerUserID()) == null) {
                    object2 = "";
                }
                this.broadcast(new ChatMessage("You", (String)object, null, messageStr, true, false, false, null, string2, string3, string4, (String)object2));
            } else if (recipient instanceof Recipient.Peer) {
                Object object = this.hmssdk.getLocalPeer();
                if (object == null || (object = object.getName()) == null) {
                    object = "Participant";
                }
                String string5 = ChatMessage.Companion.sendTo(HMSMessageRecipientType.PEER, ((Recipient.Peer)recipient).getPeer(), null, false);
                HMSLocalPeer hMSLocalPeer = this.hmssdk.getLocalPeer();
                String string6 = hMSLocalPeer != null ? hMSLocalPeer.getPeerID() : null;
                HMSLocalPeer hMSLocalPeer3 = this.hmssdk.getLocalPeer();
                String string7 = hMSLocalPeer3 != null && (hMSLocalPeer3 = hMSLocalPeer3.getHmsRole()) != null ? hMSLocalPeer3.getName() : null;
                Object object3 = this.hmssdk.getLocalPeer();
                if (object3 == null || (object3 = object3.getCustomerUserID()) == null) {
                    object3 = "";
                }
                this.directMessage(new ChatMessage("You", (String)object, null, messageStr, true, false, true, null, string5, string6, string7, (String)object3), ((Recipient.Peer)recipient).getPeer());
            } else if (recipient instanceof Recipient.Role) {
                HMSLocalPeer hMSLocalPeer;
                Object object = this.hmssdk.getLocalPeer();
                if (object == null || (object = object.getName()) == null) {
                    object = "Participant";
                }
                HMSLocalPeer hMSLocalPeer4 = this.hmssdk.getLocalPeer();
                HMSLocalPeer hMSLocalPeer5 = this.hmssdk.getLocalPeer();
                this.groupMessage(new ChatMessage("You", (String)object, null, messageStr, true, false, false, null, ChatMessage.Companion.sendTo(HMSMessageRecipientType.ROLES, null, CollectionsKt.listOf((Object)((Recipient.Role)recipient).getRole()), false), hMSLocalPeer4 != null ? hMSLocalPeer4.getPeerID() : null, (hMSLocalPeer = this.hmssdk.getLocalPeer()) != null && (hMSLocalPeer = hMSLocalPeer.getHmsRole()) != null ? hMSLocalPeer.getName() : null, hMSLocalPeer5 != null ? hMSLocalPeer5.getCustomerUserID() : null), ((Recipient.Role)recipient).getRole());
            }
        }
    }

    private final void directMessage(ChatMessage message, HMSPeer peer) {
        this.hmssdk.sendDirectMessage(message.getMessage(), "chat", peer, new HMSMessageResultListener(this){
            final /* synthetic */ ChatViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onError(@NotNull HMSException error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                Log.e((String)"ChatViewModel", (String)error.getMessage());
            }

            public void onSuccess(@NotNull HMSMessage hmsMessage) {
                Intrinsics.checkNotNullParameter((Object)hmsMessage, (String)"hmsMessage");
                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.MainScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, hmsMessage, null){
                    int label;
                    final /* synthetic */ ChatViewModel this$0;
                    final /* synthetic */ HMSMessage $hmsMessage;
                    {
                        this.this$0 = $receiver;
                        this.$hmsMessage = $hmsMessage;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                ChatViewModel.access$addMessage(this.this$0, new ChatMessage(this.$hmsMessage, true, false));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        });
    }

    private final void groupMessage(ChatMessage message, HMSRole role) {
        this.hmssdk.sendGroupMessage(message.getMessage(), "chat", CollectionsKt.listOf((Object)role), new HMSMessageResultListener(this){
            final /* synthetic */ ChatViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onError(@NotNull HMSException error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                Log.e((String)"ChatViewModel", (String)error.getMessage());
            }

            public void onSuccess(@NotNull HMSMessage hmsMessage) {
                Intrinsics.checkNotNullParameter((Object)hmsMessage, (String)"hmsMessage");
                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.MainScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, hmsMessage, null){
                    int label;
                    final /* synthetic */ ChatViewModel this$0;
                    final /* synthetic */ HMSMessage $hmsMessage;
                    {
                        this.this$0 = $receiver;
                        this.$hmsMessage = $hmsMessage;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                ChatViewModel.access$addMessage(this.this$0, new ChatMessage(this.$hmsMessage, true, false));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        });
    }

    private final void broadcast(ChatMessage message) {
        this.hmssdk.sendBroadcastMessage(message.getMessage(), "chat", new HMSMessageResultListener(this){
            final /* synthetic */ ChatViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onError(@NotNull HMSException error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                Log.e((String)"ChatViewModel", (String)error.getMessage());
            }

            public void onSuccess(@NotNull HMSMessage hmsMessage) {
                Intrinsics.checkNotNullParameter((Object)hmsMessage, (String)"hmsMessage");
                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.MainScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, hmsMessage, null){
                    int label;
                    final /* synthetic */ ChatViewModel this$0;
                    final /* synthetic */ HMSMessage $hmsMessage;
                    {
                        this.this$0 = $receiver;
                        this.$hmsMessage = $hmsMessage;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                ChatViewModel.access$addMessage(this.this$0, new ChatMessage(this.$hmsMessage, true, false));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        });
    }

    @NotNull
    public final MutableLiveData<List<ChatMessage>> getMessages() {
        return this.messages;
    }

    @NotNull
    public final LiveData<Integer> getUnreadMessagesCount() {
        return this.unreadMessagesCount;
    }

    public final void markAllMessagesRead() {
        this._unreadMessagesCount.postValue((Object)0);
    }

    public final void clearMessages() {
        this._messages.clear();
        this.messages.postValue(this._messages);
        this._unreadMessagesCount.postValue((Object)0);
    }

    private final void addMessage(ChatMessage message) {
        Object v2;
        block5: {
            if (this.shouldBlockMessage(message)) {
                return;
            }
            Set<String> set = this.messageIdsToHide;
            boolean bl = set != null ? CollectionsKt.contains((Iterable)set, (Object)message.getMessageId()) : false;
            if (bl) {
                return;
            }
            Iterable iterable = this._messages;
            for (Object t : iterable) {
                ChatMessage it = (ChatMessage)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getMessageId(), (Object)message.getMessageId())) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        if (v2 == null) {
            if (!message.isSentByMe()) {
                Integer n = (Integer)this._unreadMessagesCount.getValue();
                this._unreadMessagesCount.postValue((Object)(n != null ? n + 1 : 1));
            }
            this._messages.add(message);
            this.messages.postValue(this._messages);
        }
    }

    public final void receivedMessage(@NotNull ChatMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Log.v((String)TAG, (String)("receivedMessage: " + message));
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.MainScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, message, null){
            int label;
            final /* synthetic */ ChatViewModel this$0;
            final /* synthetic */ ChatMessage $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ChatViewModel.access$addMessage(this.this$0, this.$message);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final boolean shouldBlockMessage(ChatMessage message) {
        return CollectionsKt.contains((Iterable)this.blockedPeerIds, (Object)message.getUserIdForBlockList());
    }

    /*
     * WARNING - void declaration
     */
    public final void updateMessageHideList(@NotNull Set<String> messageIdsToHide) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(messageIdsToHide, (String)"messageIdsToHide");
        if (messageIdsToHide.isEmpty()) {
            return;
        }
        this.messageIdsToHide = messageIdsToHide;
        Iterable iterable = this._messages;
        ChatViewModel chatViewModel2 = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChatMessage it = (ChatMessage)element$iv$iv;
            boolean bl = false;
            if (!(!CollectionsKt.contains((Iterable)messageIdsToHide, (Object)it.getMessageId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        chatViewModel2._messages = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        this.messages.postValue(this._messages);
    }

    public final void updateBlockList(@Nullable Set<String> chatBlockedPeerIdsList) {
        boolean removeBlockedUserMessages = false;
        Collection collection = chatBlockedPeerIdsList;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        this.blockedPeerIds = chatBlockedPeerIdsList;
    }

    public final boolean isUserBlockedFromChat() {
        HMSLocalPeer hMSLocalPeer = this.hmssdk.getLocalPeer();
        String customerUserId = hMSLocalPeer != null ? hMSLocalPeer.getCustomerUserID() : null;
        return customerUserId != null && this.blockedPeerIds.contains(customerUserId);
    }

    @Nullable
    public final Recipient currentlySelectedRbacRecipient() {
        return (Recipient)this._currentlySelectedRecipient.getValue();
    }

    public final void updatePeerLeave(@Nullable String leavingPeerId) {
        if (leavingPeerId == null) {
            return;
        }
        Recipient current = (Recipient)this._currentlySelectedRecipient.getValue();
        if (current instanceof Recipient.Peer && Intrinsics.areEqual((Object)((Recipient.Peer)current).getPeer().getPeerID(), (Object)leavingPeerId)) {
            this._currentlySelectedRecipient.postValue(null);
        }
    }

    public static final /* synthetic */ void access$addMessage(ChatViewModel $this, ChatMessage message) {
        $this.addMessage(message);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/roomkit/ui/meeting/chat/ChatViewModel$Companion;", "", "()V", "TAG", "", "room-kit_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

