/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.meeting.chat;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import live.hms.prebuilt_themes.HMSPrebuiltTheme;
import live.hms.prebuilt_themes.ThemeExtKt;
import live.hms.roomkit.R;
import live.hms.roomkit.ui.meeting.AllowedToMessageParticipants;
import live.hms.roomkit.ui.meeting.ChatPauseState;
import live.hms.roomkit.ui.meeting.MeetingViewModel;
import live.hms.roomkit.ui.meeting.chat.ChatAdapter;
import live.hms.roomkit.ui.meeting.chat.ChatMessage;
import live.hms.roomkit.ui.meeting.chat.ChatViewModel;
import live.hms.roomkit.ui.meeting.chat.Recipient;
import live.hms.roomkit.ui.meeting.chat.SingleSideFadeRecyclerview;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.signal.init.HMSRoomLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u00017B\u0005\u00a2\u0006\u0002\u0010\u0002J\\\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\n2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\nH\u0002J\u00ec\u0001\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u00162\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00162\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\n2\u000e\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\n2\u000e\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e03J@\u00104\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00105\u001a\u00020\u0004H\u0002J\"\u00106\u001a\u00020\u00142\b\u0010$\u001a\u0004\u0018\u00010%2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017H\u0002\u00a8\u00068"}, d2={"Llive/hms/roomkit/ui/meeting/chat/ChatUseCase;", "", "()V", "getOverallChatState", "Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState;", "meetingViewModel", "Llive/hms/roomkit/ui/meeting/MeetingViewModel;", "chatViewModel", "Llive/hms/roomkit/ui/meeting/chat/ChatViewModel;", "isChatEnabled", "Lkotlin/Function0;", "", "isUserBlocked", "getCurrentRecipient", "Llive/hms/roomkit/ui/meeting/chat/Recipient;", "chatPauseState", "Llive/hms/roomkit/ui/meeting/ChatPauseState;", "getAllowedRecipients", "Llive/hms/roomkit/ui/meeting/AllowedToMessageParticipants;", "initiate", "", "messages", "Landroidx/lifecycle/MutableLiveData;", "", "Llive/hms/roomkit/ui/meeting/chat/ChatMessage;", "roleChanged", "Llive/hms/video/sdk/models/HMSPeer;", "blockList", "", "", "viewlifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "chatAdapter", "Llive/hms/roomkit/ui/meeting/chat/ChatAdapter;", "recyclerview", "Llive/hms/roomkit/ui/meeting/chat/SingleSideFadeRecyclerview;", "emptyIndicator", "Landroid/view/View;", "sendButton", "Landroid/widget/ImageView;", "editText", "Landroid/widget/EditText;", "bannedText", "Landroid/widget/TextView;", "chatPausedBy", "chatPausedContainer", "Landroidx/appcompat/widget/LinearLayoutCompat;", "recipientPickerContainer", "Landroid/widget/LinearLayout;", "currentRbac", "currentlySelectedRecipientRbac", "Landroidx/lifecycle/LiveData;", "pauseBlockRegularUi", "state", "toggleEmptyIndicator", "ChatUiVisibilityState", "room-kit_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nChatUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatUseCase.kt\nlive/hms/roomkit/ui/meeting/chat/ChatUseCase\n+ 2 TextView.kt\nandroidx/core/widget/TextViewKt\n*L\n1#1,253:1\n58#2,23:254\n93#2,3:277\n*S KotlinDebug\n*F\n+ 1 ChatUseCase.kt\nlive/hms/roomkit/ui/meeting/chat/ChatUseCase\n*L\n96#1:254,23\n96#1:277,3\n*E\n"})
public final class ChatUseCase {
    public static final int $stable;

    private final ChatUiVisibilityState getOverallChatState(MeetingViewModel meetingViewModel2, ChatViewModel chatViewModel2, Function0<Boolean> isChatEnabled2, Function0<Boolean> isUserBlocked, Function0<? extends Recipient> getCurrentRecipient, ChatPauseState chatPauseState, Function0<AllowedToMessageParticipants> getAllowedRecipients) {
        ChatUiVisibilityState chatUiVisibilityState;
        if (!((Boolean)isChatEnabled2.invoke()).booleanValue()) {
            chatUiVisibilityState = ChatUiVisibilityState.DisabledFromLayout.INSTANCE;
        } else if (((Boolean)isUserBlocked.invoke()).booleanValue()) {
            chatUiVisibilityState = ChatUiVisibilityState.Blocked.INSTANCE;
        } else if (!chatPauseState.getEnabled()) {
            chatUiVisibilityState = new ChatUiVisibilityState.Paused(chatPauseState);
        } else {
            Recipient recToMessage;
            AllowedToMessageParticipants allowedToMessageParticipants = (AllowedToMessageParticipants)getAllowedRecipients.invoke();
            Boolean chatSendingEnabled = allowedToMessageParticipants != null ? Boolean.valueOf(allowedToMessageParticipants.isChatSendingEnabled()) : null;
            Recipient tempRecipient = (Recipient)getCurrentRecipient.invoke();
            if (tempRecipient == null && Intrinsics.areEqual((Object)chatSendingEnabled, (Object)true)) {
                recToMessage = meetingViewModel2.defaultRecipientToMessage();
                chatViewModel2.updateSelectedRecipientChatBottomSheet(recToMessage);
            }
            if (tempRecipient != null && Intrinsics.areEqual((Object)chatSendingEnabled, (Object)false)) {
                recToMessage = meetingViewModel2.defaultRecipientToMessage();
                chatViewModel2.updateSelectedRecipientChatBottomSheet(recToMessage);
            }
            if (getCurrentRecipient.invoke() == null && meetingViewModel2.defaultRecipientToMessage() == null) {
                AllowedToMessageParticipants allowedToMessageParticipants2 = (AllowedToMessageParticipants)getAllowedRecipients.invoke();
                chatUiVisibilityState = (allowedToMessageParticipants2 != null ? allowedToMessageParticipants2.getPeers() : false) ? (ChatUiVisibilityState)ChatUiVisibilityState.RecipientSelectNeeded.INSTANCE : (ChatUiVisibilityState)ChatUiVisibilityState.NoRecipients.INSTANCE;
            } else {
                chatUiVisibilityState = ChatUiVisibilityState.Enabled.INSTANCE;
            }
        }
        return chatUiVisibilityState;
    }

    public final void initiate(@NotNull MutableLiveData<List<ChatMessage>> messages, @NotNull MutableLiveData<ChatPauseState> chatPauseState, @NotNull MutableLiveData<HMSPeer> roleChanged, @NotNull MutableLiveData<Set<String>> blockList, @NotNull LifecycleOwner viewlifecycleOwner, @NotNull ChatAdapter chatAdapter2, @NotNull SingleSideFadeRecyclerview recyclerview, @NotNull ChatViewModel chatViewModel2, @NotNull MeetingViewModel meetingViewModel2, @Nullable View emptyIndicator, @NotNull ImageView sendButton, @NotNull EditText editText, @NotNull TextView bannedText, @NotNull TextView chatPausedBy, @NotNull LinearLayoutCompat chatPausedContainer, @NotNull LinearLayout recipientPickerContainer, @NotNull Function0<Boolean> isChatEnabled2, @NotNull Function0<AllowedToMessageParticipants> getAllowedRecipients, @NotNull Function0<? extends Recipient> currentRbac, @NotNull LiveData<Recipient> currentlySelectedRecipientRbac) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter(chatPauseState, (String)"chatPauseState");
        Intrinsics.checkNotNullParameter(roleChanged, (String)"roleChanged");
        Intrinsics.checkNotNullParameter(blockList, (String)"blockList");
        Intrinsics.checkNotNullParameter((Object)viewlifecycleOwner, (String)"viewlifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)((Object)chatAdapter2), (String)"chatAdapter");
        Intrinsics.checkNotNullParameter((Object)((Object)recyclerview), (String)"recyclerview");
        Intrinsics.checkNotNullParameter((Object)((Object)chatViewModel2), (String)"chatViewModel");
        Intrinsics.checkNotNullParameter((Object)((Object)meetingViewModel2), (String)"meetingViewModel");
        Intrinsics.checkNotNullParameter((Object)sendButton, (String)"sendButton");
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        Intrinsics.checkNotNullParameter((Object)bannedText, (String)"bannedText");
        Intrinsics.checkNotNullParameter((Object)chatPausedBy, (String)"chatPausedBy");
        Intrinsics.checkNotNullParameter((Object)chatPausedContainer, (String)"chatPausedContainer");
        Intrinsics.checkNotNullParameter((Object)recipientPickerContainer, (String)"recipientPickerContainer");
        Intrinsics.checkNotNullParameter(isChatEnabled2, (String)"isChatEnabled");
        Intrinsics.checkNotNullParameter(getAllowedRecipients, (String)"getAllowedRecipients");
        Intrinsics.checkNotNullParameter(currentRbac, (String)"currentRbac");
        Intrinsics.checkNotNullParameter(currentlySelectedRecipientRbac, (String)"currentlySelectedRecipientRbac");
        TextView $this$doAfterTextChanged$iv = (TextView)editText;
        boolean $i$f$doAfterTextChanged = false;
        TextView $this$addTextChangedListener_u24default$iv$iv = $this$doAfterTextChanged$iv;
        boolean $i$f$addTextChangedListener = false;
        TextWatcher textWatcher$iv$iv = new TextWatcher(sendButton){
            final /* synthetic */ ImageView $sendButton$inlined;
            {
                this.$sendButton$inlined = imageView;
            }

            public void afterTextChanged(@Nullable Editable s) {
                int n;
                Editable editable = s;
                boolean bl = false;
                Editable editable2 = editable;
                if ((editable2 != null ? editable2.length() : 0) > 0) {
                    HMSRoomLayout.HMSRoomLayoutData.HMSRoomTheme.HMSColorPalette hMSColorPalette = HMSPrebuiltTheme.INSTANCE.getColours();
                    n = ThemeExtKt.getColorOrDefault((String)(hMSColorPalette != null ? hMSColorPalette.getOnSurfaceHigh() : null), (String)HMSPrebuiltTheme.INSTANCE.getDefaults().getOnsurface_high_emp());
                } else {
                    HMSRoomLayout.HMSRoomLayoutData.HMSRoomTheme.HMSColorPalette hMSColorPalette = HMSPrebuiltTheme.INSTANCE.getColours();
                    n = ThemeExtKt.getColorOrDefault((String)(hMSColorPalette != null ? hMSColorPalette.getOnSurfaceLow() : null), (String)HMSPrebuiltTheme.INSTANCE.getDefaults().getOnsurface_low_emp());
                }
                int colour = n;
                this.$sendButton$inlined.getDrawable().setTint(colour);
            }

            public void beforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
                boolean bl = false;
            }

            public void onTextChanged(@Nullable CharSequence text, int start, int before, int count) {
                boolean bl = false;
            }
        };
        $this$addTextChangedListener_u24default$iv$iv.addTextChangedListener(textWatcher$iv$iv);
        recyclerview.setAdapter((RecyclerView.Adapter)chatAdapter2);
        this.toggleEmptyIndicator(emptyIndicator, (List)messages.getValue());
        Function1 function1 = (Function1)new Function1<Recipient, Unit>(this, meetingViewModel2, chatViewModel2, isChatEnabled2, currentRbac, chatPauseState, getAllowedRecipients, sendButton, editText, bannedText, chatPausedBy, chatPausedContainer, recipientPickerContainer){
            final /* synthetic */ ChatUseCase this$0;
            final /* synthetic */ MeetingViewModel $meetingViewModel;
            final /* synthetic */ ChatViewModel $chatViewModel;
            final /* synthetic */ Function0<Boolean> $isChatEnabled;
            final /* synthetic */ Function0<Recipient> $currentRbac;
            final /* synthetic */ MutableLiveData<ChatPauseState> $chatPauseState;
            final /* synthetic */ Function0<AllowedToMessageParticipants> $getAllowedRecipients;
            final /* synthetic */ ImageView $sendButton;
            final /* synthetic */ EditText $editText;
            final /* synthetic */ TextView $bannedText;
            final /* synthetic */ TextView $chatPausedBy;
            final /* synthetic */ LinearLayoutCompat $chatPausedContainer;
            final /* synthetic */ LinearLayout $recipientPickerContainer;
            {
                this.this$0 = $receiver;
                this.$meetingViewModel = $meetingViewModel;
                this.$chatViewModel = $chatViewModel;
                this.$isChatEnabled = $isChatEnabled;
                this.$currentRbac = $currentRbac;
                this.$chatPauseState = $chatPauseState;
                this.$getAllowedRecipients = $getAllowedRecipients;
                this.$sendButton = $sendButton;
                this.$editText = $editText;
                this.$bannedText = $bannedText;
                this.$chatPausedBy = $chatPausedBy;
                this.$chatPausedContainer = $chatPausedContainer;
                this.$recipientPickerContainer = $recipientPickerContainer;
                super(1);
            }

            public final void invoke(@Nullable Recipient it) {
                ChatUseCase.initiate$updateState$default(this.this$0, this.$meetingViewModel, this.$chatViewModel, this.$isChatEnabled, this.$currentRbac, this.$chatPauseState, this.$getAllowedRecipients, this.$sendButton, this.$editText, this.$bannedText, this.$chatPausedBy, this.$chatPausedContainer, this.$recipientPickerContainer, null, 8192, null);
            }
        };
        currentlySelectedRecipientRbac.observe(viewlifecycleOwner, new Observer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onChanged(Object value) {
                this.function.invoke(value);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
        function1 = (Function1)new Function1<Set<? extends String>, Unit>(this, meetingViewModel2, chatViewModel2, isChatEnabled2, currentRbac, chatPauseState, getAllowedRecipients, sendButton, editText, bannedText, chatPausedBy, chatPausedContainer, recipientPickerContainer){
            final /* synthetic */ ChatUseCase this$0;
            final /* synthetic */ MeetingViewModel $meetingViewModel;
            final /* synthetic */ ChatViewModel $chatViewModel;
            final /* synthetic */ Function0<Boolean> $isChatEnabled;
            final /* synthetic */ Function0<Recipient> $currentRbac;
            final /* synthetic */ MutableLiveData<ChatPauseState> $chatPauseState;
            final /* synthetic */ Function0<AllowedToMessageParticipants> $getAllowedRecipients;
            final /* synthetic */ ImageView $sendButton;
            final /* synthetic */ EditText $editText;
            final /* synthetic */ TextView $bannedText;
            final /* synthetic */ TextView $chatPausedBy;
            final /* synthetic */ LinearLayoutCompat $chatPausedContainer;
            final /* synthetic */ LinearLayout $recipientPickerContainer;
            {
                this.this$0 = $receiver;
                this.$meetingViewModel = $meetingViewModel;
                this.$chatViewModel = $chatViewModel;
                this.$isChatEnabled = $isChatEnabled;
                this.$currentRbac = $currentRbac;
                this.$chatPauseState = $chatPauseState;
                this.$getAllowedRecipients = $getAllowedRecipients;
                this.$sendButton = $sendButton;
                this.$editText = $editText;
                this.$bannedText = $bannedText;
                this.$chatPausedBy = $chatPausedBy;
                this.$chatPausedContainer = $chatPausedContainer;
                this.$recipientPickerContainer = $recipientPickerContainer;
                super(1);
            }

            public final void invoke(Set<String> it) {
                ChatUseCase.initiate$updateState$default(this.this$0, this.$meetingViewModel, this.$chatViewModel, this.$isChatEnabled, this.$currentRbac, this.$chatPauseState, this.$getAllowedRecipients, this.$sendButton, this.$editText, this.$bannedText, this.$chatPausedBy, this.$chatPausedContainer, this.$recipientPickerContainer, null, 8192, null);
            }
        };
        blockList.observe(viewlifecycleOwner, new /* invalid duplicate definition of identical inner class */);
        function1 = (Function1)new Function1<HMSPeer, Unit>(this, meetingViewModel2, chatViewModel2, isChatEnabled2, currentRbac, chatPauseState, getAllowedRecipients, sendButton, editText, bannedText, chatPausedBy, chatPausedContainer, recipientPickerContainer){
            final /* synthetic */ ChatUseCase this$0;
            final /* synthetic */ MeetingViewModel $meetingViewModel;
            final /* synthetic */ ChatViewModel $chatViewModel;
            final /* synthetic */ Function0<Boolean> $isChatEnabled;
            final /* synthetic */ Function0<Recipient> $currentRbac;
            final /* synthetic */ MutableLiveData<ChatPauseState> $chatPauseState;
            final /* synthetic */ Function0<AllowedToMessageParticipants> $getAllowedRecipients;
            final /* synthetic */ ImageView $sendButton;
            final /* synthetic */ EditText $editText;
            final /* synthetic */ TextView $bannedText;
            final /* synthetic */ TextView $chatPausedBy;
            final /* synthetic */ LinearLayoutCompat $chatPausedContainer;
            final /* synthetic */ LinearLayout $recipientPickerContainer;
            {
                this.this$0 = $receiver;
                this.$meetingViewModel = $meetingViewModel;
                this.$chatViewModel = $chatViewModel;
                this.$isChatEnabled = $isChatEnabled;
                this.$currentRbac = $currentRbac;
                this.$chatPauseState = $chatPauseState;
                this.$getAllowedRecipients = $getAllowedRecipients;
                this.$sendButton = $sendButton;
                this.$editText = $editText;
                this.$bannedText = $bannedText;
                this.$chatPausedBy = $chatPausedBy;
                this.$chatPausedContainer = $chatPausedContainer;
                this.$recipientPickerContainer = $recipientPickerContainer;
                super(1);
            }

            public final void invoke(HMSPeer it) {
                ChatUseCase.initiate$updateState$default(this.this$0, this.$meetingViewModel, this.$chatViewModel, this.$isChatEnabled, this.$currentRbac, this.$chatPauseState, this.$getAllowedRecipients, this.$sendButton, this.$editText, this.$bannedText, this.$chatPausedBy, this.$chatPausedContainer, this.$recipientPickerContainer, null, 8192, null);
            }
        };
        roleChanged.observe(viewlifecycleOwner, new /* invalid duplicate definition of identical inner class */);
        function1 = (Function1)new Function1<ChatPauseState, Unit>(this, meetingViewModel2, chatViewModel2, isChatEnabled2, currentRbac, chatPauseState, getAllowedRecipients, sendButton, editText, bannedText, chatPausedBy, chatPausedContainer, recipientPickerContainer){
            final /* synthetic */ ChatUseCase this$0;
            final /* synthetic */ MeetingViewModel $meetingViewModel;
            final /* synthetic */ ChatViewModel $chatViewModel;
            final /* synthetic */ Function0<Boolean> $isChatEnabled;
            final /* synthetic */ Function0<Recipient> $currentRbac;
            final /* synthetic */ MutableLiveData<ChatPauseState> $chatPauseState;
            final /* synthetic */ Function0<AllowedToMessageParticipants> $getAllowedRecipients;
            final /* synthetic */ ImageView $sendButton;
            final /* synthetic */ EditText $editText;
            final /* synthetic */ TextView $bannedText;
            final /* synthetic */ TextView $chatPausedBy;
            final /* synthetic */ LinearLayoutCompat $chatPausedContainer;
            final /* synthetic */ LinearLayout $recipientPickerContainer;
            {
                this.this$0 = $receiver;
                this.$meetingViewModel = $meetingViewModel;
                this.$chatViewModel = $chatViewModel;
                this.$isChatEnabled = $isChatEnabled;
                this.$currentRbac = $currentRbac;
                this.$chatPauseState = $chatPauseState;
                this.$getAllowedRecipients = $getAllowedRecipients;
                this.$sendButton = $sendButton;
                this.$editText = $editText;
                this.$bannedText = $bannedText;
                this.$chatPausedBy = $chatPausedBy;
                this.$chatPausedContainer = $chatPausedContainer;
                this.$recipientPickerContainer = $recipientPickerContainer;
                super(1);
            }

            public final void invoke(ChatPauseState pauseState) {
                ChatUseCase.access$initiate$updateState(this.this$0, this.$meetingViewModel, this.$chatViewModel, this.$isChatEnabled, this.$currentRbac, this.$chatPauseState, this.$getAllowedRecipients, this.$sendButton, this.$editText, this.$bannedText, this.$chatPausedBy, this.$chatPausedContainer, this.$recipientPickerContainer, pauseState);
            }
        };
        chatPauseState.observe(viewlifecycleOwner, new /* invalid duplicate definition of identical inner class */);
        function1 = (Function1)new Function1<List<? extends ChatMessage>, Unit>(isChatEnabled2, this, emptyIndicator, chatAdapter2, recyclerview, chatViewModel2){
            final /* synthetic */ Function0<Boolean> $isChatEnabled;
            final /* synthetic */ ChatUseCase this$0;
            final /* synthetic */ View $emptyIndicator;
            final /* synthetic */ ChatAdapter $chatAdapter;
            final /* synthetic */ SingleSideFadeRecyclerview $recyclerview;
            final /* synthetic */ ChatViewModel $chatViewModel;
            {
                this.$isChatEnabled = $isChatEnabled;
                this.this$0 = $receiver;
                this.$emptyIndicator = $emptyIndicator;
                this.$chatAdapter = $chatAdapter;
                this.$recyclerview = $recyclerview;
                this.$chatViewModel = $chatViewModel;
                super(1);
            }

            public final void invoke(List<ChatMessage> it) {
                if (((Boolean)this.$isChatEnabled.invoke()).booleanValue()) {
                    ChatUseCase.access$toggleEmptyIndicator(this.this$0, this.$emptyIndicator, it);
                    List chatList = new ArrayList<E>();
                    Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                    chatList.addAll((Collection)it);
                    this.$chatAdapter.submitList(chatList);
                    int position = it.size() - 1;
                    if (position >= 0) {
                        Context context = this.$recyclerview.getContext();
                        RecyclerView.SmoothScroller smoothScroller2 = (RecyclerView.SmoothScroller)new LinearSmoothScroller(context){

                            protected int getVerticalSnapPreference() {
                                return -1;
                            }
                        };
                        smoothScroller2.setTargetPosition(position);
                        RecyclerView.LayoutManager layoutManager = this.$recyclerview.getLayoutManager();
                        Intrinsics.checkNotNull((Object)layoutManager);
                        layoutManager.startSmoothScroll(smoothScroller2);
                        if (this.$recyclerview.getVisibility() == 0 && this.$recyclerview.isAttachedToWindow()) {
                            this.$chatViewModel.markAllMessagesRead();
                        }
                    }
                }
            }
        };
        messages.observe(viewlifecycleOwner, new /* invalid duplicate definition of identical inner class */);
    }

    public static /* synthetic */ void initiate$default(ChatUseCase chatUseCase, MutableLiveData mutableLiveData, MutableLiveData mutableLiveData2, MutableLiveData mutableLiveData3, MutableLiveData mutableLiveData4, LifecycleOwner lifecycleOwner, ChatAdapter chatAdapter2, SingleSideFadeRecyclerview singleSideFadeRecyclerview, ChatViewModel chatViewModel2, MeetingViewModel meetingViewModel2, View view, ImageView imageView, EditText editText, TextView textView, TextView textView2, LinearLayoutCompat linearLayoutCompat, LinearLayout linearLayout, Function0 function0, Function0 function02, Function0 function03, LiveData liveData, int n, Object object) {
        if ((n & 0x200) != 0) {
            view = null;
        }
        chatUseCase.initiate((MutableLiveData<List<ChatMessage>>)mutableLiveData, (MutableLiveData<ChatPauseState>)mutableLiveData2, (MutableLiveData<HMSPeer>)mutableLiveData3, (MutableLiveData<Set<String>>)mutableLiveData4, lifecycleOwner, chatAdapter2, singleSideFadeRecyclerview, chatViewModel2, meetingViewModel2, view, imageView, editText, textView, textView2, linearLayoutCompat, linearLayout, (Function0<Boolean>)function0, (Function0<AllowedToMessageParticipants>)function02, (Function0<? extends Recipient>)function03, (LiveData<Recipient>)liveData);
    }

    private final void pauseBlockRegularUi(ImageView sendButton, EditText editText, TextView bannedText, TextView chatPausedBy, LinearLayoutCompat chatPausedContainer, LinearLayout recipientPickerContainer, ChatUiVisibilityState state) {
        sendButton.setVisibility(state.getMsgEdit() ? 0 : 8);
        editText.setVisibility(state.getMsgEdit() ? 0 : 8);
        recipientPickerContainer.setVisibility(state.getMsgRecPicker() ? 0 : 8);
        ChatUiVisibilityState chatUiVisibilityState = state;
        if (Intrinsics.areEqual((Object)chatUiVisibilityState, (Object)ChatUiVisibilityState.Blocked.INSTANCE)) {
            bannedText.setVisibility(0);
            chatPausedContainer.setVisibility(8);
        } else if (!Intrinsics.areEqual((Object)chatUiVisibilityState, (Object)ChatUiVisibilityState.DisabledFromLayout.INSTANCE)) {
            if (Intrinsics.areEqual((Object)chatUiVisibilityState, (Object)ChatUiVisibilityState.NoRecipients.INSTANCE)) {
                bannedText.setVisibility(8);
                chatPausedContainer.setVisibility(8);
            } else if (chatUiVisibilityState instanceof ChatUiVisibilityState.Paused) {
                Object[] objectArray = new Object[]{((ChatUiVisibilityState.Paused)state).getPausedState().getUpdatedBy().getUserName()};
                chatPausedBy.setText((CharSequence)bannedText.getContext().getString(R.string.chat_paused_by, objectArray));
                chatPausedContainer.setVisibility(0);
                bannedText.setVisibility(8);
            } else if (Intrinsics.areEqual((Object)chatUiVisibilityState, (Object)ChatUiVisibilityState.RecipientSelectNeeded.INSTANCE)) {
                bannedText.setVisibility(8);
                chatPausedContainer.setVisibility(8);
            } else if (Intrinsics.areEqual((Object)chatUiVisibilityState, (Object)ChatUiVisibilityState.Enabled.INSTANCE)) {
                bannedText.setVisibility(8);
                chatPausedContainer.setVisibility(8);
            }
        }
    }

    private final void toggleEmptyIndicator(View emptyIndicator, List<ChatMessage> messages) {
        View view = emptyIndicator;
        if (view != null) {
            Collection collection = messages;
            view.setVisibility(collection == null || collection.isEmpty() ? 0 : 8);
        }
    }

    private static final void initiate$updateState(ChatUseCase this$0, MeetingViewModel $meetingViewModel, ChatViewModel $chatViewModel, Function0<Boolean> $isChatEnabled, Function0<? extends Recipient> $currentRbac, MutableLiveData<ChatPauseState> $chatPauseState, Function0<AllowedToMessageParticipants> $getAllowedRecipients, ImageView $sendButton, EditText $editText, TextView $bannedText, TextView $chatPausedBy, LinearLayoutCompat $chatPausedContainer, LinearLayout $recipientPickerContainer, ChatPauseState externalChatPauseState) {
        Function0 function0 = (Function0)new Function0<Boolean>((Object)$chatViewModel){

            @NotNull
            public final Boolean invoke() {
                return ((ChatViewModel)((Object)this.receiver)).isUserBlockedFromChat();
            }
        };
        ChatPauseState chatPauseState = externalChatPauseState;
        if (chatPauseState == null) {
            Object object = $chatPauseState.getValue();
            Intrinsics.checkNotNull((Object)object);
            chatPauseState = (ChatPauseState)object;
        }
        ChatUiVisibilityState overallChatState2 = this$0.getOverallChatState($meetingViewModel, $chatViewModel, $isChatEnabled, (Function0<Boolean>)function0, $currentRbac, chatPauseState, $getAllowedRecipients);
        this$0.pauseBlockRegularUi($sendButton, $editText, $bannedText, $chatPausedBy, $chatPausedContainer, $recipientPickerContainer, overallChatState2);
    }

    static /* synthetic */ void initiate$updateState$default(ChatUseCase chatUseCase, MeetingViewModel meetingViewModel2, ChatViewModel chatViewModel2, Function0 function0, Function0 function02, MutableLiveData mutableLiveData, Function0 function03, ImageView imageView, EditText editText, TextView textView, TextView textView2, LinearLayoutCompat linearLayoutCompat, LinearLayout linearLayout, ChatPauseState chatPauseState, int n, Object object) {
        if ((n & 0x2000) != 0) {
            chatPauseState = null;
        }
        ChatUseCase.initiate$updateState(chatUseCase, meetingViewModel2, chatViewModel2, (Function0<Boolean>)function0, (Function0<? extends Recipient>)function02, (MutableLiveData<ChatPauseState>)mutableLiveData, (Function0<AllowedToMessageParticipants>)function03, imageView, editText, textView, textView2, linearLayoutCompat, linearLayout, chatPauseState);
    }

    public static final /* synthetic */ void access$initiate$updateState(ChatUseCase this$0, MeetingViewModel $meetingViewModel, ChatViewModel $chatViewModel, Function0 $isChatEnabled, Function0 $currentRbac, MutableLiveData $chatPauseState, Function0 $getAllowedRecipients, ImageView $sendButton, EditText $editText, TextView $bannedText, TextView $chatPausedBy, LinearLayoutCompat $chatPausedContainer, LinearLayout $recipientPickerContainer, ChatPauseState externalChatPauseState) {
        ChatUseCase.initiate$updateState(this$0, $meetingViewModel, $chatViewModel, (Function0<Boolean>)$isChatEnabled, (Function0<? extends Recipient>)$currentRbac, (MutableLiveData<ChatPauseState>)$chatPauseState, (Function0<AllowedToMessageParticipants>)$getAllowedRecipients, $sendButton, $editText, $bannedText, $chatPausedBy, $chatPausedContainer, $recipientPickerContainer, externalChatPauseState);
    }

    public static final /* synthetic */ void access$toggleEmptyIndicator(ChatUseCase $this, View emptyIndicator, List messages) {
        $this.toggleEmptyIndicator(emptyIndicator, messages);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0006\u000b\f\r\u000e\u000f\u0010B\u001f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u0082\u0001\u0006\u0011\u0012\u0013\u0014\u0015\u0016\u00a8\u0006\u0017"}, d2={"Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState;", "", "msgView", "", "msgEdit", "msgRecPicker", "(ZZZ)V", "getMsgEdit", "()Z", "getMsgRecPicker", "getMsgView", "Blocked", "DisabledFromLayout", "Enabled", "NoRecipients", "Paused", "RecipientSelectNeeded", "Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState$Blocked;", "Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState$DisabledFromLayout;", "Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState$Enabled;", "Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState$NoRecipients;", "Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState$Paused;", "Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState$RecipientSelectNeeded;", "room-kit_release"})
    @StabilityInferred(parameters=0)
    public static abstract class ChatUiVisibilityState {
        private final boolean msgView;
        private final boolean msgEdit;
        private final boolean msgRecPicker;
        public static final int $stable;

        private ChatUiVisibilityState(boolean msgView, boolean msgEdit, boolean msgRecPicker) {
            this.msgView = msgView;
            this.msgEdit = msgEdit;
            this.msgRecPicker = msgRecPicker;
        }

        public final boolean getMsgView() {
            return this.msgView;
        }

        public final boolean getMsgEdit() {
            return this.msgEdit;
        }

        public final boolean getMsgRecPicker() {
            return this.msgRecPicker;
        }

        public /* synthetic */ ChatUiVisibilityState(boolean msgView, boolean msgEdit, boolean msgRecPicker, DefaultConstructorMarker $constructor_marker) {
            this(msgView, msgEdit, msgRecPicker);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState$Blocked;", "Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState;", "()V", "room-kit_release"})
        @StabilityInferred(parameters=0)
        public static final class Blocked
        extends ChatUiVisibilityState {
            @NotNull
            public static final Blocked INSTANCE = new Blocked();
            public static final int $stable;

            private Blocked() {
                super(true, false, false, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState$DisabledFromLayout;", "Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState;", "()V", "room-kit_release"})
        @StabilityInferred(parameters=0)
        public static final class DisabledFromLayout
        extends ChatUiVisibilityState {
            @NotNull
            public static final DisabledFromLayout INSTANCE = new DisabledFromLayout();
            public static final int $stable;

            private DisabledFromLayout() {
                super(false, false, false, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState$Enabled;", "Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState;", "()V", "room-kit_release"})
        @StabilityInferred(parameters=0)
        public static final class Enabled
        extends ChatUiVisibilityState {
            @NotNull
            public static final Enabled INSTANCE = new Enabled();
            public static final int $stable;

            private Enabled() {
                super(true, true, true, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState$NoRecipients;", "Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState;", "()V", "room-kit_release"})
        @StabilityInferred(parameters=0)
        public static final class NoRecipients
        extends ChatUiVisibilityState {
            @NotNull
            public static final NoRecipients INSTANCE = new NoRecipients();
            public static final int $stable;

            private NoRecipients() {
                super(true, false, false, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState$Paused;", "Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState;", "pausedState", "Llive/hms/roomkit/ui/meeting/ChatPauseState;", "(Llive/hms/roomkit/ui/meeting/ChatPauseState;)V", "getPausedState", "()Llive/hms/roomkit/ui/meeting/ChatPauseState;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "room-kit_release"})
        @StabilityInferred(parameters=0)
        public static final class Paused
        extends ChatUiVisibilityState {
            @NotNull
            private final ChatPauseState pausedState;
            public static final int $stable;

            public Paused(@NotNull ChatPauseState pausedState) {
                Intrinsics.checkNotNullParameter((Object)pausedState, (String)"pausedState");
                super(true, false, false, null);
                this.pausedState = pausedState;
            }

            @NotNull
            public final ChatPauseState getPausedState() {
                return this.pausedState;
            }

            @NotNull
            public final ChatPauseState component1() {
                return this.pausedState;
            }

            @NotNull
            public final Paused copy(@NotNull ChatPauseState pausedState) {
                Intrinsics.checkNotNullParameter((Object)pausedState, (String)"pausedState");
                return new Paused(pausedState);
            }

            public static /* synthetic */ Paused copy$default(Paused paused, ChatPauseState chatPauseState, int n, Object object) {
                if ((n & 1) != 0) {
                    chatPauseState = paused.pausedState;
                }
                return paused.copy(chatPauseState);
            }

            @NotNull
            public String toString() {
                return "Paused(pausedState=" + this.pausedState + ")";
            }

            public int hashCode() {
                return this.pausedState.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Paused)) {
                    return false;
                }
                Paused paused = (Paused)other;
                return Intrinsics.areEqual((Object)this.pausedState, (Object)paused.pausedState);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState$RecipientSelectNeeded;", "Llive/hms/roomkit/ui/meeting/chat/ChatUseCase$ChatUiVisibilityState;", "()V", "room-kit_release"})
        @StabilityInferred(parameters=0)
        public static final class RecipientSelectNeeded
        extends ChatUiVisibilityState {
            @NotNull
            public static final RecipientSelectNeeded INSTANCE = new RecipientSelectNeeded();
            public static final int $stable;

            private RecipientSelectNeeded() {
                super(true, false, true, null);
            }
        }
    }
}

