/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.meeting.audiomode;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.recyclerview.widget.DiffUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import live.hms.roomkit.ui.meeting.audiomode.AudioItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0012B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0016R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0013"}, d2={"Llive/hms/roomkit/ui/meeting/audiomode/AudioItemsDiffUtil;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "oldItems", "", "Llive/hms/roomkit/ui/meeting/audiomode/AudioItem;", "newItems", "([Llive/hms/roomkit/ui/meeting/audiomode/AudioItem;[Llive/hms/roomkit/ui/meeting/audiomode/AudioItem;)V", "[Llive/hms/roomkit/ui/meeting/audiomode/AudioItem;", "areContentsTheSame", "", "oldItemPosition", "", "newItemPosition", "areItemsTheSame", "getChangePayload", "", "getNewListSize", "getOldListSize", "PayloadKey", "room-kit_release"})
@StabilityInferred(parameters=0)
public final class AudioItemsDiffUtil
extends DiffUtil.Callback {
    @NotNull
    private final AudioItem[] oldItems;
    @NotNull
    private final AudioItem[] newItems;
    public static final int $stable = 8;

    public AudioItemsDiffUtil(@NotNull AudioItem[] oldItems, @NotNull AudioItem[] newItems) {
        Intrinsics.checkNotNullParameter((Object)oldItems, (String)"oldItems");
        Intrinsics.checkNotNullParameter((Object)newItems, (String)"newItems");
        this.oldItems = oldItems;
        this.newItems = newItems;
    }

    public int getOldListSize() {
        return this.oldItems.length;
    }

    public int getNewListSize() {
        return this.newItems.length;
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        if (oldItemPosition >= this.oldItems.length || newItemPosition >= this.newItems.length) {
            return false;
        }
        AudioItem old = this.oldItems[oldItemPosition];
        AudioItem audioItem = this.newItems[newItemPosition];
        return Intrinsics.areEqual((Object)old.getPeerId(), (Object)audioItem.getPeerId());
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        return false;
    }

    @Nullable
    public Object getChangePayload(int oldItemPosition, int newItemPosition) {
        if (oldItemPosition >= this.oldItems.length || newItemPosition >= this.newItems.length) {
            return null;
        }
        AudioItem old = this.oldItems[oldItemPosition];
        AudioItem audioItem = this.newItems[newItemPosition];
        if (old.isTrackMute() != audioItem.isTrackMute()) {
            return PayloadKey.TRACK_STATUS;
        }
        if (old.getAudioLevel() != audioItem.getAudioLevel()) {
            return PayloadKey.AUDIO_LEVEL;
        }
        return PayloadKey.SAME;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Llive/hms/roomkit/ui/meeting/audiomode/AudioItemsDiffUtil$PayloadKey;", "", "(Ljava/lang/String;I)V", "AUDIO_LEVEL", "TRACK_STATUS", "SAME", "room-kit_release"})
    public static final class PayloadKey
    extends Enum<PayloadKey> {
        public static final /* enum */ PayloadKey AUDIO_LEVEL = new PayloadKey();
        public static final /* enum */ PayloadKey TRACK_STATUS = new PayloadKey();
        public static final /* enum */ PayloadKey SAME = new PayloadKey();
        private static final /* synthetic */ PayloadKey[] $VALUES;

        public static PayloadKey[] values() {
            return (PayloadKey[])$VALUES.clone();
        }

        public static PayloadKey valueOf(String value) {
            return Enum.valueOf(PayloadKey.class, value);
        }

        static {
            $VALUES = payloadKeyArray = new PayloadKey[]{PayloadKey.AUDIO_LEVEL, PayloadKey.TRACK_STATUS, PayloadKey.SAME};
        }
    }
}

