/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.meeting.activespeaker;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.media3.common.Player;
import androidx.media3.common.VideoSize;
import androidx.media3.common.text.Cue;
import androidx.media3.common.text.CueGroup;
import androidx.media3.common.util.UnstableApi;
import com.google.common.collect.ImmutableList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import live.hms.hls_player.HmsHlsCue;
import live.hms.hls_player.HmsHlsException;
import live.hms.hls_player.HmsHlsPlaybackEvents;
import live.hms.hls_player.HmsHlsPlaybackState;
import live.hms.hls_player.HmsHlsPlayer;
import live.hms.roomkit.ui.meeting.activespeaker.DisplayHlsCuesUseCase;
import live.hms.roomkit.ui.meeting.activespeaker.HlsViewModel;
import live.hms.roomkit.util.SingleLiveEvent;
import live.hms.video.sdk.HMSSDK;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010,\u001a\u00020\u0018J\u0006\u0010-\u001a\u00020\u000bJ\u0010\u0010.\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u001f\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00050\u00050\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00180\u00180\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u001f\u0010\u001a\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00180\u00180\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u001f\u0010\u001b\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00180\u00180\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0014R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001f\u0010*\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00180\u00180\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0014\u00a8\u0006/"}, d2={"Llive/hms/roomkit/ui/meeting/activespeaker/HlsViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "hlsStreamUrl", "", "hmsSdk", "Llive/hms/video/sdk/HMSSDK;", "hlsPlayerBeganToPlay", "Lkotlin/Function1;", "Llive/hms/hls_player/HmsHlsPlaybackState;", "", "displayHlsCuesUseCase", "Lkotlin/Function0;", "Llive/hms/roomkit/ui/meeting/activespeaker/DisplayHlsCuesUseCase;", "(Landroid/app/Application;Ljava/lang/String;Llive/hms/video/sdk/HMSSDK;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "behindLiveByLiveData", "Landroidx/lifecycle/MutableLiveData;", "kotlin.jvm.PlatformType", "getBehindLiveByLiveData", "()Landroidx/lifecycle/MutableLiveData;", "currentSubtitles", "getCurrentSubtitles", "failed", "", "isLive", "isPlaying", "isZoomEnabled", "player", "Llive/hms/hls_player/HmsHlsPlayer;", "getPlayer", "()Llive/hms/hls_player/HmsHlsPlayer;", "playerReady", "getPlayerReady", "progressBarVisible", "Landroidx/lifecycle/LiveData;", "getProgressBarVisible", "()Landroidx/lifecycle/LiveData;", "streamEndedEvent", "Llive/hms/roomkit/util/SingleLiveEvent;", "getStreamEndedEvent", "()Llive/hms/roomkit/util/SingleLiveEvent;", "videoVisible", "getVideoVisible", "areClosedCaptionsSupported", "restarted", "setListeners", "room-kit_release"})
@UnstableApi
@StabilityInferred(parameters=0)
public final class HlsViewModel
extends AndroidViewModel {
    @NotNull
    private final String hlsStreamUrl;
    @NotNull
    private final HMSSDK hmsSdk;
    @NotNull
    private final Function1<HmsHlsPlaybackState, Unit> hlsPlayerBeganToPlay;
    @NotNull
    private final Function0<DisplayHlsCuesUseCase> displayHlsCuesUseCase;
    @NotNull
    private final MutableLiveData<Boolean> isPlaying;
    @NotNull
    private final MutableLiveData<Boolean> videoVisible;
    @NotNull
    private final LiveData<Boolean> progressBarVisible;
    @NotNull
    private final MutableLiveData<Boolean> isZoomEnabled;
    @NotNull
    private final MutableLiveData<Boolean> isLive;
    @NotNull
    private final MutableLiveData<String> behindLiveByLiveData;
    @NotNull
    private final SingleLiveEvent<Unit> streamEndedEvent;
    @NotNull
    private final MutableLiveData<String> currentSubtitles;
    @NotNull
    private final MutableLiveData<Boolean> playerReady;
    private boolean failed;
    @NotNull
    private final HmsHlsPlayer player;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public HlsViewModel(@NotNull Application application, @NotNull String hlsStreamUrl, @NotNull HMSSDK hmsSdk, @NotNull Function1<? super HmsHlsPlaybackState, Unit> hlsPlayerBeganToPlay2, @NotNull Function0<DisplayHlsCuesUseCase> displayHlsCuesUseCase2) {
        void $this$player_u24lambda_u240;
        HmsHlsPlayer hmsHlsPlayer;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)hlsStreamUrl, (String)"hlsStreamUrl");
        Intrinsics.checkNotNullParameter((Object)hmsSdk, (String)"hmsSdk");
        Intrinsics.checkNotNullParameter(hlsPlayerBeganToPlay2, (String)"hlsPlayerBeganToPlay");
        Intrinsics.checkNotNullParameter(displayHlsCuesUseCase2, (String)"displayHlsCuesUseCase");
        super(application);
        this.hlsStreamUrl = hlsStreamUrl;
        this.hmsSdk = hmsSdk;
        this.hlsPlayerBeganToPlay = hlsPlayerBeganToPlay2;
        this.displayHlsCuesUseCase = displayHlsCuesUseCase2;
        this.isPlaying = new MutableLiveData((Object)true);
        this.videoVisible = new MutableLiveData((Object)false);
        this.progressBarVisible = Transformations.map((LiveData)((LiveData)this.videoVisible), (Function1)progressBarVisible.1.INSTANCE);
        this.isZoomEnabled = new MutableLiveData((Object)false);
        this.isLive = new MutableLiveData((Object)true);
        this.behindLiveByLiveData = new MutableLiveData((Object)"0:0");
        this.streamEndedEvent = new SingleLiveEvent();
        this.currentSubtitles = new MutableLiveData();
        this.playerReady = new MutableLiveData((Object)false);
        HmsHlsPlayer hmsHlsPlayer2 = hmsHlsPlayer = new HmsHlsPlayer((Context)application, this.hmsSdk);
        HlsViewModel hlsViewModel2 = this;
        boolean bl = false;
        this.setListeners((HmsHlsPlayer)$this$player_u24lambda_u240);
        $this$player_u24lambda_u240.play(this.hlsStreamUrl);
        hlsViewModel2.player = hmsHlsPlayer;
    }

    @NotNull
    public final MutableLiveData<Boolean> isPlaying() {
        return this.isPlaying;
    }

    @NotNull
    public final MutableLiveData<Boolean> getVideoVisible() {
        return this.videoVisible;
    }

    @NotNull
    public final LiveData<Boolean> getProgressBarVisible() {
        return this.progressBarVisible;
    }

    @NotNull
    public final MutableLiveData<Boolean> isZoomEnabled() {
        return this.isZoomEnabled;
    }

    @NotNull
    public final MutableLiveData<Boolean> isLive() {
        return this.isLive;
    }

    @NotNull
    public final MutableLiveData<String> getBehindLiveByLiveData() {
        return this.behindLiveByLiveData;
    }

    @NotNull
    public final SingleLiveEvent<Unit> getStreamEndedEvent() {
        return this.streamEndedEvent;
    }

    @NotNull
    public final MutableLiveData<String> getCurrentSubtitles() {
        return this.currentSubtitles;
    }

    @NotNull
    public final MutableLiveData<Boolean> getPlayerReady() {
        return this.playerReady;
    }

    @NotNull
    public final HmsHlsPlayer getPlayer() {
        return this.player;
    }

    public final boolean areClosedCaptionsSupported() {
        return this.player.areClosedCaptionsSupported();
    }

    public final void restarted() {
        if (this.failed) {
            this.player.play(this.hlsStreamUrl);
            this.failed = false;
        }
    }

    private final void setListeners(HmsHlsPlayer player2) {
        player2.getNativePlayer().addListener(new Player.Listener(this){
            final /* synthetic */ HlsViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onIsPlayingChanged(boolean isPlaying) {
                super.onIsPlayingChanged(isPlaying);
                if (isPlaying) {
                    this.this$0.getVideoVisible().postValue((Object)true);
                    this.this$0.getPlayerReady().postValue((Object)true);
                }
            }

            @SuppressLint(value={"UnsafeOptInUsageError"})
            public void onSurfaceSizeChanged(int width, int height) {
                super.onSurfaceSizeChanged(width, height);
            }

            public void onVideoSizeChanged(@NotNull VideoSize videoSize) {
                Intrinsics.checkNotNullParameter((Object)videoSize, (String)"videoSize");
                super.onVideoSizeChanged(videoSize);
            }

            public void onCues(@NotNull CueGroup cueGroup) {
                Intrinsics.checkNotNullParameter((Object)cueGroup, (String)"cueGroup");
                super.onCues(cueGroup);
                MutableLiveData<String> mutableLiveData = this.this$0.getCurrentSubtitles();
                ImmutableList immutableList = cueGroup.cues;
                Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"cueGroup.cues");
                Object object = (Cue)CollectionsKt.firstOrNull((List)((List)immutableList));
                mutableLiveData.postValue(object != null && (object = ((Cue)object).text) != null ? object.toString() : null);
            }
        });
        player2.addPlayerEventListener(new HmsHlsPlaybackEvents(this){
            final /* synthetic */ HlsViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onPlaybackFailure(@NotNull HmsHlsException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                HlsViewModel.access$setFailed$p(this.this$0, true);
            }

            @SuppressLint(value={"UnsafeOptInUsageError"})
            public void onPlaybackStateChanged(@NotNull HmsHlsPlaybackState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                if (state == HmsHlsPlaybackState.playing) {
                    HlsViewModel.access$getHlsPlayerBeganToPlay$p(this.this$0).invoke((Object)state);
                    this.this$0.isPlaying().postValue((Object)true);
                } else if (state == HmsHlsPlaybackState.stopped) {
                    HlsViewModel.access$getHlsPlayerBeganToPlay$p(this.this$0).invoke((Object)state);
                    this.this$0.getStreamEndedEvent().postValue(Unit.INSTANCE);
                    this.this$0.isPlaying().postValue((Object)false);
                }
            }

            public void onCue(@NotNull HmsHlsCue cue) {
                Intrinsics.checkNotNullParameter((Object)cue, (String)"cue");
                BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)((ViewModel)this.this$0)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, cue, null){
                    int label;
                    final /* synthetic */ HlsViewModel this$0;
                    final /* synthetic */ HmsHlsCue $cue;
                    {
                        this.this$0 = $receiver;
                        this.$cue = $cue;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = ((DisplayHlsCuesUseCase)HlsViewModel.access$getDisplayHlsCuesUseCase$p(this.this$0).invoke()).addCue(this.$cue, (Continuation<? super Unit>)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        });
    }

    public static final /* synthetic */ void access$setFailed$p(HlsViewModel $this, boolean bl) {
        $this.failed = bl;
    }

    public static final /* synthetic */ Function1 access$getHlsPlayerBeganToPlay$p(HlsViewModel $this) {
        return $this.hlsPlayerBeganToPlay;
    }

    public static final /* synthetic */ Function0 access$getDisplayHlsCuesUseCase$p(HlsViewModel $this) {
        return $this.displayHlsCuesUseCase;
    }
}

