/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.meeting;

import androidx.compose.runtime.internal.StabilityInferred;
import java.text.SimpleDateFormat;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.sdk.models.HMSBrowserRecordingState;
import live.hms.video.sdk.models.HMSRoom;
import live.hms.video.sdk.models.HMSRtmpStreamingState;
import live.hms.video.sdk.models.HMSServerRecordingState;
import live.hms.video.sdk.models.enums.HMSRecordingState;
import live.hms.video.sdk.models.enums.HMSStreamingState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Llive/hms/roomkit/ui/meeting/RecordingTimesUseCase;", "", "()V", "dateFormat", "Ljava/text/SimpleDateFormat;", "convertTimes", "Lkotlin/Pair;", "", "startedAt", "", "stoppedAt", "(Ljava/lang/Long;Ljava/lang/Long;)Lkotlin/Pair;", "showHlsInfo", "room", "Llive/hms/video/sdk/models/HMSRoom;", "isRecordingEvent", "", "showRecordInfo", "showRtmpInfo", "showServerInfo", "room-kit_release"})
@StabilityInferred(parameters=0)
public final class RecordingTimesUseCase {
    @NotNull
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    public static final int $stable = 8;

    @NotNull
    public final String showServerInfo(@NotNull HMSRoom room) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        HMSServerRecordingState hMSServerRecordingState = room.getServerRecordingState();
        Pair<String, String> startStop = this.convertTimes(hMSServerRecordingState != null ? hMSServerRecordingState.getStartedAt() : null, null);
        return "Server\nStarted: " + startStop.getFirst();
    }

    @NotNull
    public final String showRecordInfo(@NotNull HMSRoom room) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        HMSBrowserRecordingState hMSBrowserRecordingState = room.getBrowserRecordingState();
        HMSBrowserRecordingState hMSBrowserRecordingState2 = room.getBrowserRecordingState();
        Pair<String, String> startStop = this.convertTimes(hMSBrowserRecordingState != null ? hMSBrowserRecordingState.getStartedAt() : null, hMSBrowserRecordingState2 != null ? hMSBrowserRecordingState2.getStoppedAt() : null);
        return "Recording\nStarted:" + startStop.getFirst() + "\nStopped:" + startStop.getSecond();
    }

    @NotNull
    public final String showRtmpInfo(@NotNull HMSRoom room) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        HMSRtmpStreamingState hMSRtmpStreamingState = room.getRtmpHMSRtmpStreamingState();
        HMSRtmpStreamingState hMSRtmpStreamingState2 = room.getRtmpHMSRtmpStreamingState();
        Pair<String, String> startStop = this.convertTimes(hMSRtmpStreamingState != null ? hMSRtmpStreamingState.getStartedAt() : null, hMSRtmpStreamingState2 != null ? hMSRtmpStreamingState2.getStoppedAt() : null);
        return "Rtmp\nStarted:" + startStop.getFirst() + "\nStopped:" + startStop.getSecond();
    }

    @NotNull
    public final String showHlsInfo(@NotNull HMSRoom room, boolean isRecordingEvent) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        String prefix = isRecordingEvent ? "RecordingEvent:" : "StreamingEvent:";
        return prefix + ": HLS Streaming: " + (room.getHlsStreamingState().getState() == HMSStreamingState.STARTED) + ", Recording: " + (room.getHlsRecordingState().getState() == HMSRecordingState.STARTED) + ", Variants: " + room.getHlsStreamingState().getVariants() + ", Recording Config: " + room.getHlsRecordingState().getHlsRecordingConfig();
    }

    private final Pair<String, String> convertTimes(Long startedAt, Long stoppedAt) {
        String startedAt2 = startedAt == null ? "Empty" : this.dateFormat.format(startedAt);
        String stoppedAt2 = stoppedAt == null ? "Empty" : this.dateFormat.format(stoppedAt);
        return new Pair((Object)startedAt2, (Object)stoppedAt2);
    }
}

