/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.meeting;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.xwray.groupie.GroupieViewHolder;

public class InsetItemDecoration
extends RecyclerView.ItemDecoration {
    private final Paint paint;
    private final int padding;
    private final String key;
    private final String value;

    public InsetItemDecoration(@ColorInt int backgroundColor, @Dimension int padding, String key, String value) {
        this.key = key;
        this.value = value;
        this.paint = new Paint();
        this.paint.setColor(backgroundColor);
        this.padding = padding;
    }

    private boolean isInset(View view, RecyclerView parent) {
        GroupieViewHolder viewHolder = (GroupieViewHolder)parent.getChildViewHolder(view);
        if (viewHolder.getExtras().containsKey(this.key)) {
            return viewHolder.getExtras().get(this.key).equals(this.value);
        }
        return false;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        if (!this.isInset(view, parent)) {
            return;
        }
        GridLayoutManager.LayoutParams layoutParams = (GridLayoutManager.LayoutParams)view.getLayoutParams();
        GridLayoutManager gridLayoutManager = (GridLayoutManager)parent.getLayoutManager();
        float spanSize = layoutParams.getSpanSize();
        float totalSpanSize = gridLayoutManager.getSpanCount();
        float n = totalSpanSize / spanSize;
        float c = (float)layoutParams.getSpanIndex() / spanSize;
        float leftPadding = (float)this.padding * ((n - c) / n);
        float rightPadding = (float)this.padding * ((c + 1.0f) / n);
        outRect.left = (int)leftPadding;
        outRect.right = (int)rightPadding;
        outRect.bottom = this.padding;
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        RecyclerView.LayoutManager lm = parent.getLayoutManager();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            if (!this.isInset(child, parent)) continue;
            if (child.getTranslationX() != 0.0f || child.getTranslationY() != 0.0f) {
                c.drawRect((float)lm.getDecoratedLeft(child), (float)lm.getDecoratedTop(child), (float)lm.getDecoratedRight(child), (float)lm.getDecoratedBottom(child), this.paint);
                continue;
            }
            boolean isLast = i == childCount - 1;
            float top = (float)child.getTop() + child.getTranslationY();
            float bottom = (float)child.getBottom() + child.getTranslationY();
            c.drawRect((float)lm.getDecoratedLeft(child) + child.getTranslationX(), top, (float)child.getLeft() + child.getTranslationX(), bottom, this.paint);
            float right = (float)lm.getDecoratedRight(child) + child.getTranslationX();
            if (isLast) {
                right = Math.max(right, (float)parent.getWidth());
            }
            c.drawRect((float)child.getRight() + child.getTranslationX(), top, right, bottom, this.paint);
            c.drawRect((float)lm.getDecoratedLeft(child) + child.getTranslationY(), bottom, right, (float)lm.getDecoratedBottom(child) + child.getTranslationY(), this.paint);
        }
    }
}

