/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.meeting;

import android.app.Application;
import android.app.Dialog;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentViewModelLazyKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.xwray.groupie.Group;
import com.xwray.groupie.GroupieAdapter;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import live.hms.prebuilt_themes.HMSPrebuiltTheme;
import live.hms.prebuilt_themes.ThemeExtKt;
import live.hms.roomkit.R;
import live.hms.roomkit.ViewExtKt;
import live.hms.roomkit.databinding.BottomSheetAudioSwitchBinding;
import live.hms.roomkit.ui.meeting.AudioItem;
import live.hms.roomkit.ui.meeting.MeetingViewModel;
import live.hms.roomkit.ui.meeting.MeetingViewModelFactory;
import live.hms.roomkit.util.ViewBindingLifecycleExtensionKt;
import live.hms.video.audio.HMSAudioDeviceInfo;
import live.hms.video.audio.HMSAudioManager;
import live.hms.video.sdk.models.HMSRoom;
import live.hms.video.signal.init.HMSRoomLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u001e\b\u0002\u0010\u0002\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0004J\b\u0010\u001f\u001a\u00020\u001dH\u0016J\u0012\u0010 \u001a\u00020\u00062\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J$\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u001a\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020$2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u0004H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R$\u0010\u0002\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Llive/hms/roomkit/ui/meeting/AudioOutputSwitchBottomSheet;", "Lcom/google/android/material/bottomsheet/BottomSheetDialogFragment;", "onOptionItemClicked", "Lkotlin/Function2;", "Llive/hms/video/audio/HMSAudioManager$AudioDevice;", "", "", "(Lkotlin/jvm/functions/Function2;)V", "audioDeviceAdapter", "Lcom/xwray/groupie/GroupieAdapter;", "<set-?>", "Llive/hms/roomkit/databinding/BottomSheetAudioSwitchBinding;", "binding", "getBinding", "()Llive/hms/roomkit/databinding/BottomSheetAudioSwitchBinding;", "setBinding", "(Llive/hms/roomkit/databinding/BottomSheetAudioSwitchBinding;)V", "binding$delegate", "Lkotlin/properties/ReadWriteProperty;", "meetingViewModel", "Llive/hms/roomkit/ui/meeting/MeetingViewModel;", "getMeetingViewModel", "()Llive/hms/roomkit/ui/meeting/MeetingViewModel;", "meetingViewModel$delegate", "Lkotlin/Lazy;", "capitalizeAndReplaceUnderscore", "", "input", "getDrawableBasedOnDeviceType", "", "device", "getTheme", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onViewCreated", "view", "setAudioType", "audioDevice", "room-kit_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAudioOutputSwitchBottomSheet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioOutputSwitchBottomSheet.kt\nlive/hms/roomkit/ui/meeting/AudioOutputSwitchBottomSheet\n+ 2 FragmentViewModelLazy.kt\nandroidx/fragment/app/FragmentViewModelLazyKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n172#2,9:207\n1#3:216\n*S KotlinDebug\n*F\n+ 1 AudioOutputSwitchBottomSheet.kt\nlive/hms/roomkit/ui/meeting/AudioOutputSwitchBottomSheet\n*L\n34#1:207,9\n*E\n"})
public final class AudioOutputSwitchBottomSheet
extends BottomSheetDialogFragment {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @Nullable
    private final Function2<HMSAudioManager.AudioDevice, Boolean, Unit> onOptionItemClicked;
    @NotNull
    private final ReadWriteProperty binding$delegate;
    @NotNull
    private final GroupieAdapter audioDeviceAdapter;
    @NotNull
    private final Lazy meetingViewModel$delegate;
    public static final int $stable;

    /*
     * WARNING - void declaration
     */
    public AudioOutputSwitchBottomSheet(@Nullable Function2<? super HMSAudioManager.AudioDevice, ? super Boolean, Unit> onOptionItemClicked) {
        void $this$activityViewModels_u24default$iv;
        this.onOptionItemClicked = onOptionItemClicked;
        this.binding$delegate = ViewBindingLifecycleExtensionKt.viewLifecycle((Fragment)this);
        this.audioDeviceAdapter = new GroupieAdapter();
        Fragment fragment = (Fragment)this;
        Function0 factoryProducer$iv = (Function0)new Function0<ViewModelProvider.Factory>(this){
            final /* synthetic */ AudioOutputSwitchBottomSheet this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelProvider.Factory invoke() {
                Application application = this.this$0.requireActivity().getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"requireActivity().application");
                return (ViewModelProvider.Factory)new MeetingViewModelFactory(application);
            }
        };
        Function0 extrasProducer$iv = null;
        boolean $i$f$activityViewModels = false;
        this.meetingViewModel$delegate = FragmentViewModelLazyKt.createViewModelLazy((Fragment)$this$activityViewModels_u24default$iv, (KClass)Reflection.getOrCreateKotlinClass(MeetingViewModel.class), (Function0)((Function0)new Function0<ViewModelStore>((Fragment)$this$activityViewModels_u24default$iv){
            final /* synthetic */ Fragment $this_activityViewModels;
            {
                this.$this_activityViewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                ViewModelStore viewModelStore = this.$this_activityViewModels.requireActivity().getViewModelStore();
                Intrinsics.checkNotNullExpressionValue((Object)viewModelStore, (String)"requireActivity().viewModelStore");
                return viewModelStore;
            }
        }), (Function0)((Function0)new Function0<CreationExtras>(extrasProducer$iv, (Fragment)$this$activityViewModels_u24default$iv){
            final /* synthetic */ Function0 $extrasProducer;
            final /* synthetic */ Fragment $this_activityViewModels;
            {
                this.$extrasProducer = $extrasProducer;
                this.$this_activityViewModels = $receiver;
                super(0);
            }

            @NotNull
            public final CreationExtras invoke() {
                Function0 function0 = this.$extrasProducer;
                if (function0 == null || (function0 = (CreationExtras)function0.invoke()) == null) {
                    CreationExtras creationExtras = this.$this_activityViewModels.requireActivity().getDefaultViewModelCreationExtras();
                    function0 = creationExtras;
                    Intrinsics.checkNotNullExpressionValue((Object)creationExtras, (String)"requireActivity().defaultViewModelCreationExtras");
                }
                return function0;
            }
        }), (Function0)factoryProducer$iv);
    }

    public /* synthetic */ AudioOutputSwitchBottomSheet(Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function2 = null;
        }
        this((Function2<? super HMSAudioManager.AudioDevice, ? super Boolean, Unit>)function2);
    }

    private final BottomSheetAudioSwitchBinding getBinding() {
        return (BottomSheetAudioSwitchBinding)this.binding$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setBinding(BottomSheetAudioSwitchBinding bottomSheetAudioSwitchBinding) {
        this.binding$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bottomSheetAudioSwitchBinding);
    }

    private final MeetingViewModel getMeetingViewModel() {
        Lazy lazy = this.meetingViewModel$delegate;
        return (MeetingViewModel)((Object)lazy.getValue());
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, R.style.AppBottomSheetDialogTheme);
    }

    @NotNull
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        BottomSheetAudioSwitchBinding bottomSheetAudioSwitchBinding = BottomSheetAudioSwitchBinding.inflate(inflater, container, false);
        Intrinsics.checkNotNullExpressionValue((Object)bottomSheetAudioSwitchBinding, (String)"inflate(inflater, container, false)");
        this.setBinding(bottomSheetAudioSwitchBinding);
        FrameLayout frameLayout = this.getBinding().getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.root");
        return (View)frameLayout;
    }

    /*
     * WARNING - void declaration
     */
    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        RecyclerView recyclerView;
        void $this$onViewCreated_u24lambda_u241;
        Drawable drawable2;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        Dialog dialog = this.getDialog();
        if (dialog != null) {
            Dialog it = dialog;
            boolean bl = false;
            BottomSheetDialog sheet = (BottomSheetDialog)it;
            sheet.getBehavior().setState(3);
        }
        TextView textView = this.getBinding().audioOt;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.audioOt");
        Drawable drawable3 = ViewExtKt.getDrawableStart(textView);
        if (drawable3 != null) {
            HMSRoomLayout.HMSRoomLayoutData.HMSRoomTheme.HMSColorPalette hMSColorPalette = HMSPrebuiltTheme.INSTANCE.getColours();
            drawable3.setTint(ThemeExtKt.getColorOrDefault((String)(hMSColorPalette != null ? hMSColorPalette.getOnSurfaceHigh() : null), (String)HMSPrebuiltTheme.INSTANCE.getDefaults().getOnsurface_high_emp()));
        }
        HMSRoomLayout.HMSRoomLayoutData.HMSRoomTheme.HMSColorPalette hMSColorPalette = HMSPrebuiltTheme.INSTANCE.getColours();
        this.getBinding().audioOt.setTextColor(ThemeExtKt.getColorOrDefault((String)(hMSColorPalette != null ? hMSColorPalette.getOnSurfaceHigh() : null), (String)HMSPrebuiltTheme.INSTANCE.getDefaults().getOnsurface_high_emp()));
        HMSRoomLayout.HMSRoomLayoutData.HMSRoomTheme.HMSColorPalette hMSColorPalette2 = HMSPrebuiltTheme.INSTANCE.getColours();
        this.getBinding().border5.setBackgroundColor(ThemeExtKt.getColorOrDefault((String)(hMSColorPalette2 != null ? hMSColorPalette2.getBorderDefault() : null), (String)HMSPrebuiltTheme.INSTANCE.getDefaults().getBorder_bright()));
        Drawable drawable4 = drawable2 = this.getBinding().getRoot().getContext().getResources().getDrawable(R.drawable.gray_shape_round_dialog);
        FrameLayout frameLayout = this.getBinding().getRoot();
        boolean bl = false;
        HMSRoomLayout.HMSRoomLayoutData.HMSRoomTheme.HMSColorPalette hMSColorPalette3 = HMSPrebuiltTheme.INSTANCE.getColours();
        int color = ThemeExtKt.getColorOrDefault((String)(hMSColorPalette3 != null ? hMSColorPalette3.getBackgroundDefault() : null), (String)HMSPrebuiltTheme.INSTANCE.getDefaults().getBackground_default());
        $this$onViewCreated_u24lambda_u241.setColorFilter(color, PorterDuff.Mode.ADD);
        frameLayout.setBackground(drawable2);
        HMSRoomLayout.HMSRoomLayoutData.HMSRoomTheme.HMSColorPalette hMSColorPalette4 = HMSPrebuiltTheme.INSTANCE.getColours();
        this.getBinding().closeBtn.getDrawable().setTint(ThemeExtKt.getColorOrDefault((String)(hMSColorPalette4 != null ? hMSColorPalette4.getOnSurfaceHigh() : null), (String)HMSPrebuiltTheme.INSTANCE.getDefaults().getOnsurface_high_emp()));
        this.getBinding().closeBtn.setOnClickListener(arg_0 -> AudioOutputSwitchBottomSheet.onViewCreated$lambda$2(this, arg_0));
        this.audioDeviceAdapter.clear();
        List devicesList = this.getMeetingViewModel().getHmsSDK().getAudioDevicesInfoList();
        HMSRoom hMSRoom = this.getMeetingViewModel().getHmsSDK().getRoom();
        Boolean showAudioOption = hMSRoom != null && (hMSRoom = hMSRoom.getLocalPeer()) != null ? Boolean.valueOf(hMSRoom.isWebrtcPeer()) : null;
        boolean isMute = false;
        HMSAudioManager.AudioDevice selectedDeviceType = null;
        if (!this.getMeetingViewModel().isPeerAudioEnabled()) {
            isMute = true;
        } else {
            selectedDeviceType = this.getMeetingViewModel().getHmsSDK().getAudioOutputRouteType();
        }
        if (Intrinsics.areEqual((Object)showAudioOption, (Object)true)) {
            recyclerView = devicesList.iterator();
            while (recyclerView.hasNext()) {
                HMSAudioDeviceInfo deviceInfo = (HMSAudioDeviceInfo)recyclerView.next();
                boolean isSelected = selectedDeviceType == deviceInfo.getType();
                String string2 = this.capitalizeAndReplaceUnderscore(deviceInfo.getType().name());
                String string3 = deviceInfo.getName();
                if (string3 == null) {
                    string3 = "";
                }
                String string4 = string3;
                HMSAudioManager.AudioDevice audioDevice = deviceInfo.getType();
                int n = this.getDrawableBasedOnDeviceType(deviceInfo.getType());
                this.audioDeviceAdapter.add((Group)new AudioItem(string2, string4, isSelected, n, audioDevice, null, (Function2)new Function2<HMSAudioManager.AudioDevice, Integer, Unit>(this){
                    final /* synthetic */ AudioOutputSwitchBottomSheet this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull HMSAudioManager.AudioDevice type, @Nullable Integer id2) {
                        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                        AudioOutputSwitchBottomSheet.access$setAudioType(this.this$0, type);
                    }
                }, 32, null));
            }
        }
        this.audioDeviceAdapter.add((Group)new AudioItem("Mute", null, isMute, R.drawable.ic_volume_off_24, null, null, (Function2)new Function2<HMSAudioManager.AudioDevice, Integer, Unit>(this){
            final /* synthetic */ AudioOutputSwitchBottomSheet this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull HMSAudioManager.AudioDevice type, @Nullable Integer id2) {
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                AudioOutputSwitchBottomSheet.access$getMeetingViewModel(this.this$0).setPeerAudioEnabled(false);
                Function2 function2 = AudioOutputSwitchBottomSheet.access$getOnOptionItemClicked$p(this.this$0);
                if (function2 != null) {
                    function2.invoke(null, (Object)true);
                }
                this.this$0.dismiss();
            }
        }, 50, null));
        RecyclerView $this$onViewCreated_u24lambda_u243 = recyclerView = this.getBinding().deviceList;
        boolean bl2 = false;
        $this$onViewCreated_u24lambda_u243.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.requireContext()));
        $this$onViewCreated_u24lambda_u243.setAdapter((RecyclerView.Adapter)this.audioDeviceAdapter);
    }

    public final int getDrawableBasedOnDeviceType(@NotNull HMSAudioManager.AudioDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        return switch (WhenMappings.$EnumSwitchMapping$0[device.ordinal()]) {
            case 1 -> R.drawable.bt;
            case 2 -> R.drawable.ic_icon_speaker;
            case 3 -> R.drawable.phone;
            case 4 -> R.drawable.wired;
            case 5 -> R.drawable.ic_icon_speaker;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String capitalizeAndReplaceUnderscore(@NotNull String input) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (((CharSequence)input).length() == 0) {
            return "";
        }
        String string3 = input.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String string4 = string3;
        if (((CharSequence)string4).length() > 0) {
            void it;
            char c = string4.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string5 = String.valueOf((char)it);
            Intrinsics.checkNotNull((Object)string5, (String)"null cannot be cast to non-null type java.lang.String");
            String string6 = string5.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toUpperCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string6);
            String string7 = string4;
            int n = 1;
            String string8 = string7.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
            string2 = stringBuilder2.append(string8).toString();
        } else {
            string2 = string4;
        }
        String capitalized = string2;
        return StringsKt.replace$default((String)capitalized, (char)'_', (char)' ', (boolean)false, (int)4, null);
    }

    public int getTheme() {
        return R.style.AppBottomSheetDialogTheme;
    }

    private final void setAudioType(HMSAudioManager.AudioDevice audioDevice) {
        this.getMeetingViewModel().setPeerAudioEnabled(true);
        this.getMeetingViewModel().getHmsSDK().switchAudioOutput(audioDevice);
        Function2<HMSAudioManager.AudioDevice, Boolean, Unit> function2 = this.onOptionItemClicked;
        if (function2 != null) {
            function2.invoke((Object)this.getMeetingViewModel().getHmsSDK().getAudioOutputRouteType(), (Object)true);
        }
        this.dismiss();
    }

    private static final void onViewCreated$lambda$2(AudioOutputSwitchBottomSheet this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.dismissAllowingStateLoss();
    }

    public AudioOutputSwitchBottomSheet() {
        this(null, 1, null);
    }

    public static final /* synthetic */ void access$setAudioType(AudioOutputSwitchBottomSheet $this, HMSAudioManager.AudioDevice audioDevice) {
        $this.setAudioType(audioDevice);
    }

    public static final /* synthetic */ MeetingViewModel access$getMeetingViewModel(AudioOutputSwitchBottomSheet $this) {
        return $this.getMeetingViewModel();
    }

    public static final /* synthetic */ Function2 access$getOnOptionItemClicked$p(AudioOutputSwitchBottomSheet $this) {
        return $this.onOptionItemClicked;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AudioOutputSwitchBottomSheet.class, "binding", "getBinding()Llive/hms/roomkit/databinding/BottomSheetAudioSwitchBinding;", 0)))};
        $$delegatedProperties = kPropertyArray;
        $stable = 8;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HMSAudioManager.AudioDevice.values().length];
            try {
                nArray[HMSAudioManager.AudioDevice.BLUETOOTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSAudioManager.AudioDevice.SPEAKER_PHONE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSAudioManager.AudioDevice.EARPIECE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSAudioManager.AudioDevice.WIRED_HEADSET.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSAudioManager.AudioDevice.AUTOMATIC.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

