/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.inset;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.res.Resources;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.core.view.GestureDetectorCompat;
import androidx.interpolator.view.animation.FastOutLinearInInterpolator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import live.hms.roomkit.R;
import live.hms.roomkit.ui.inset.InsetViewState;
import live.hms.roomkit.ui.inset.Mode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\u001a.\u0010\u0007\u001a\u00020\b*\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0000\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\tH\u0000\u001a\f\u0010\u0012\u001a\u00020\u0011*\u00020\tH\u0000\u001a\f\u0010\u0013\u001a\u00020\u0011*\u00020\tH\u0000\u001a\f\u0010\u0014\u001a\u00020\u0011*\u00020\tH\u0000\u001a&\u0010\u0015\u001a\u00020\b*\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\f\u001a\u00020\rH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"DRAG_TOLERANCE", "", "DURATION_MILLIS", "", "dp", "getDp", "(I)I", "makeInset", "", "Landroid/view/View;", "stickyAxis", "Llive/hms/roomkit/ui/inset/Mode;", "animated", "", "onDoubleTap", "Lkotlin/Function0;", "marginBottom", "", "marginEnd", "marginStart", "marginTop", "resetUI", "currentX", "currentY", "room-kit_release"})
public final class InsetExtKt {
    public static final int DRAG_TOLERANCE = 16;
    public static final long DURATION_MILLIS = 250L;

    public static final float marginStart(@NotNull View $this$marginStart) {
        Intrinsics.checkNotNullParameter((Object)$this$marginStart, (String)"<this>");
        ViewGroup.LayoutParams layoutParams = $this$marginStart.getLayoutParams();
        ViewGroup.MarginLayoutParams marginLayoutParams = layoutParams instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)layoutParams : null;
        return marginLayoutParams != null ? marginLayoutParams.getMarginStart() : 0;
    }

    public static final float marginEnd(@NotNull View $this$marginEnd) {
        Intrinsics.checkNotNullParameter((Object)$this$marginEnd, (String)"<this>");
        ViewGroup.LayoutParams layoutParams = $this$marginEnd.getLayoutParams();
        ViewGroup.MarginLayoutParams marginLayoutParams = layoutParams instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)layoutParams : null;
        return marginLayoutParams != null ? marginLayoutParams.getMarginEnd() : 0;
    }

    public static final float marginTop(@NotNull View $this$marginTop) {
        Intrinsics.checkNotNullParameter((Object)$this$marginTop, (String)"<this>");
        ViewGroup.LayoutParams layoutParams = $this$marginTop.getLayoutParams();
        ViewGroup.MarginLayoutParams marginLayoutParams = layoutParams instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)layoutParams : null;
        return marginLayoutParams != null ? marginLayoutParams.topMargin : 0;
    }

    public static final float marginBottom(@NotNull View $this$marginBottom) {
        Intrinsics.checkNotNullParameter((Object)$this$marginBottom, (String)"<this>");
        ViewGroup.LayoutParams layoutParams = $this$marginBottom.getLayoutParams();
        ViewGroup.MarginLayoutParams marginLayoutParams = layoutParams instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)layoutParams : null;
        return marginLayoutParams != null ? marginLayoutParams.bottomMargin : 0;
    }

    public static final void makeInset(@NotNull View $this$makeInset, @NotNull Mode stickyAxis, boolean animated, @NotNull Function0<Unit> onDoubleTap2) {
        Intrinsics.checkNotNullParameter((Object)$this$makeInset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)stickyAxis), (String)"stickyAxis");
        Intrinsics.checkNotNullParameter(onDoubleTap2, (String)"onDoubleTap");
        Ref.FloatRef widgetInitialX = new Ref.FloatRef();
        Ref.FloatRef widgetDX = new Ref.FloatRef();
        Ref.FloatRef widgetInitialY = new Ref.FloatRef();
        Ref.FloatRef widgetDY = new Ref.FloatRef();
        float marginStart = InsetExtKt.marginStart($this$makeInset);
        float marginTop = InsetExtKt.marginTop($this$makeInset);
        float marginEnd = InsetExtKt.marginEnd($this$makeInset);
        float marginBottom = InsetExtKt.marginBottom($this$makeInset);
        InsetViewState viewState = new InsetViewState(false, false);
        GestureDetectorCompat gestureDetector2 = new GestureDetectorCompat($this$makeInset.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(viewState, onDoubleTap2){
            final /* synthetic */ InsetViewState $viewState;
            final /* synthetic */ Function0<Unit> $onDoubleTap;
            {
                this.$viewState = $viewState;
                this.$onDoubleTap = $onDoubleTap;
            }

            public void onLongPress(@NotNull MotionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.$viewState.isMoving()) {
                    return;
                }
                this.$viewState.setLongPressRegistered(true);
            }

            public boolean onSingleTapConfirmed(@NotNull MotionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$onDoubleTap.invoke();
                return super.onSingleTapConfirmed(e);
            }
        });
        $this$makeInset.setOnTouchListener((arg_0, arg_1) -> InsetExtKt.makeInset$lambda$4(marginEnd, marginBottom, gestureDetector2, viewState, widgetDX, widgetDY, widgetInitialX, widgetInitialY, marginStart, marginTop, stickyAxis, animated, $this$makeInset, arg_0, arg_1));
    }

    public static /* synthetic */ void makeInset$default(View view, Mode mode, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            mode = Mode.STICKY_XY;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        InsetExtKt.makeInset(view, mode, bl, (Function0<Unit>)function0);
    }

    public static final void resetUI(@NotNull View $this$resetUI, float currentX, float currentY, boolean animated) {
        Intrinsics.checkNotNullParameter((Object)$this$resetUI, (String)"<this>");
        ViewParent viewParent = $this$resetUI.getParent();
        Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.View");
        int xMiddle = ((View)viewParent).getWidth() / 2;
        ViewParent viewParent2 = $this$resetUI.getParent();
        Intrinsics.checkNotNull((Object)viewParent2, (String)"null cannot be cast to non-null type android.view.View");
        int yMiddle = ((View)viewParent2).getHeight() / 2;
        ViewParent viewParent3 = $this$resetUI.getParent();
        Intrinsics.checkNotNull((Object)viewParent3, (String)"null cannot be cast to non-null type android.view.View");
        View viewParent4 = (View)viewParent3;
        int parentHeight = viewParent4.getHeight();
        int parentWidth = viewParent4.getWidth();
        float xMax = (float)(parentWidth - $this$resetUI.getWidth()) - InsetExtKt.marginEnd($this$resetUI);
        float yMax = (float)(parentHeight - $this$resetUI.getHeight()) - InsetExtKt.marginBottom($this$resetUI);
        float marginStart = InsetExtKt.marginStart($this$resetUI);
        float marginTop = InsetExtKt.marginTop($this$resetUI);
        float marginEnd = InsetExtKt.marginEnd($this$resetUI);
        float marginBottom = InsetExtKt.marginBottom($this$resetUI);
        if (currentX >= (float)xMiddle) {
            int rightMarging = $this$resetUI.getResources().getDimensionPixelSize(R.dimen.eight_dp);
            float xMaxWithPadding = Math.min(xMax, xMax - (float)rightMarging);
            if (animated) {
                $this$resetUI.animate().setInterpolator((TimeInterpolator)new FastOutLinearInInterpolator()).x(xMaxWithPadding).setDuration(250L).setUpdateListener(InsetExtKt::resetUI$lambda$5).start();
            } else {
                $this$resetUI.setX(xMaxWithPadding);
            }
        } else {
            int leftMargin = $this$resetUI.getResources().getDimensionPixelSize(R.dimen.eight_dp);
            float maxMarginStart = Math.max(marginStart, marginStart + (float)leftMargin);
            if (animated) {
                $this$resetUI.animate().setInterpolator((TimeInterpolator)new FastOutLinearInInterpolator()).x(maxMarginStart).setDuration(250L).setUpdateListener(InsetExtKt::resetUI$lambda$6).start();
            }
            $this$resetUI.setX(maxMarginStart);
        }
        int bottomMargin = $this$resetUI.getResources().getDimensionPixelSize(R.dimen.sizeteen_dp);
        float yMaxWithPadding = Math.min(yMax, yMax - (float)bottomMargin);
        if (currentY >= (float)yMiddle) {
            if (animated) {
                $this$resetUI.animate().setInterpolator((TimeInterpolator)new FastOutLinearInInterpolator()).y(yMaxWithPadding).setDuration(250L).setUpdateListener(InsetExtKt::resetUI$lambda$7).start();
            } else {
                $this$resetUI.setY(yMaxWithPadding);
            }
        } else {
            int topMargin = $this$resetUI.getResources().getDimensionPixelSize(R.dimen.sizeteen_dp);
            float maxMarginTop = Math.max(marginTop, marginTop + (float)topMargin);
            if (animated) {
                $this$resetUI.animate().setInterpolator((TimeInterpolator)new FastOutLinearInInterpolator()).y(maxMarginTop).setDuration(250L).setUpdateListener(InsetExtKt::resetUI$lambda$8).start();
            } else {
                $this$resetUI.setY(maxMarginTop);
            }
        }
    }

    public static /* synthetic */ void resetUI$default(View view, float f, float f2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        InsetExtKt.resetUI(view, f, f2, bl);
    }

    public static final int getDp(int $this$dp) {
        return (int)((float)$this$dp / Resources.getSystem().getDisplayMetrics().density);
    }

    private static final void makeInset$lambda$4$lambda$0(ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void makeInset$lambda$4$lambda$1(ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void makeInset$lambda$4$lambda$2(ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void makeInset$lambda$4$lambda$3(ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final boolean makeInset$lambda$4(float $marginEnd, float $marginBottom, GestureDetectorCompat $gestureDetector, InsetViewState $viewState, Ref.FloatRef $widgetDX, Ref.FloatRef $widgetDY, Ref.FloatRef $widgetInitialX, Ref.FloatRef $widgetInitialY, float $marginStart, float $marginTop, Mode $stickyAxis, boolean $animated, View $this_makeInset, View v, MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)$gestureDetector, (String)"$gestureDetector");
        Intrinsics.checkNotNullParameter((Object)$viewState, (String)"$viewState");
        Intrinsics.checkNotNullParameter((Object)$widgetDX, (String)"$widgetDX");
        Intrinsics.checkNotNullParameter((Object)$widgetDY, (String)"$widgetDY");
        Intrinsics.checkNotNullParameter((Object)$widgetInitialX, (String)"$widgetInitialX");
        Intrinsics.checkNotNullParameter((Object)$widgetInitialY, (String)"$widgetInitialY");
        Intrinsics.checkNotNullParameter((Object)((Object)$stickyAxis), (String)"$stickyAxis");
        Intrinsics.checkNotNullParameter((Object)$this_makeInset, (String)"$this_makeInset");
        ViewParent viewParent = v.getParent();
        Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.View");
        View viewParent2 = (View)viewParent;
        int parentHeight = viewParent2.getHeight();
        int parentWidth = viewParent2.getWidth();
        float xMax = (float)(parentWidth - v.getWidth()) - $marginEnd;
        int xMiddle = parentWidth / 2;
        float yMax = (float)(parentHeight - v.getHeight()) - $marginBottom;
        int yMiddle = parentHeight / 2;
        $gestureDetector.onTouchEvent(event);
        switch (event.getActionMasked()) {
            case 0: {
                $viewState.setLongPressRegistered(false);
                $widgetDX.element = v.getX() - event.getRawX();
                $widgetDY.element = v.getY() - event.getRawY();
                $widgetInitialX.element = v.getX();
                $widgetInitialY.element = v.getY();
                break;
            }
            case 2: {
                float newX = event.getRawX() + $widgetDX.element;
                newX = Math.max($marginStart, newX);
                newX = Math.min(xMax, newX);
                if (Math.abs(v.getX() - newX) > 16.0f) {
                    $viewState.setMoving(true);
                }
                v.setX(newX);
                float newY = event.getRawY() + $widgetDY.element;
                newY = Math.max($marginTop, newY);
                newY = Math.min(yMax, newY);
                if (Math.abs(v.getY() - newY) > 16.0f) {
                    $viewState.setMoving(true);
                }
                v.setY(newY);
                break;
            }
            case 1: {
                $viewState.setMoving(false);
                switch (WhenMappings.$EnumSwitchMapping$0[$stickyAxis.ordinal()]) {
                    case 1: {
                        if (event.getRawX() >= (float)xMiddle) {
                            if ($animated) {
                                v.animate().x(xMax).setDuration(250L).setUpdateListener(InsetExtKt::makeInset$lambda$4$lambda$0).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                                    public void onAnimationEnd(@NotNull Animator animation) {
                                        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                                        super.onAnimationEnd(animation);
                                        Log.d((String)"drg", (String)"Animate END Sticky X RIGHT");
                                    }
                                }).start();
                                break;
                            }
                            v.setX(xMax);
                            break;
                        }
                        if ($animated) {
                            v.animate().x($marginStart).setDuration(250L).setUpdateListener(InsetExtKt::makeInset$lambda$4$lambda$1).start();
                            break;
                        }
                        v.setX($marginStart);
                        break;
                    }
                    case 2: {
                        if (event.getRawY() >= (float)yMiddle) {
                            if ($animated) {
                                v.animate().y(yMax).setDuration(250L).setUpdateListener(InsetExtKt::makeInset$lambda$4$lambda$2).start();
                                break;
                            }
                            v.setY(yMax);
                            break;
                        }
                        if ($animated) {
                            v.animate().y($marginTop).setDuration(250L).setUpdateListener(InsetExtKt::makeInset$lambda$4$lambda$3).start();
                            break;
                        }
                        v.setY($marginTop);
                        break;
                    }
                    case 3: {
                        InsetExtKt.resetUI$default($this_makeInset, event.getRawX(), event.getRawY(), false, 4, null);
                    }
                }
                if ($viewState.isLongPressRegistered()) {
                    return true;
                }
                if (!(Math.abs(v.getX() - $widgetInitialX.element) <= 16.0f) || !(Math.abs(v.getY() - $widgetInitialY.element) <= 16.0f)) break;
                $this_makeInset.performClick();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static final void resetUI$lambda$5(ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void resetUI$lambda$6(ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void resetUI$lambda$7(ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void resetUI$lambda$8(ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.STICKY_X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.STICKY_Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.STICKY_XY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

