/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.filters;

import android.content.Context;
import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public class PickerLayoutManager
extends LinearLayoutManager {
    private float scaleDownBy = 0.66f;
    private float scaleDownDistance = 0.9f;
    private boolean changeAlpha = true;
    private onScrollStopListener onScrollStopListener;

    public PickerLayoutManager(Context context, int orientation, boolean reverseLayout) {
        super(context, orientation, reverseLayout);
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        super.onLayoutChildren(recycler, state);
        this.scaleDownView();
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        int orientation = this.getOrientation();
        if (orientation == 0) {
            int scrolled = super.scrollHorizontallyBy(dx, recycler, state);
            this.scaleDownView();
            return scrolled;
        }
        return 0;
    }

    private void scaleDownView() {
        float mid = (float)this.getWidth() / 2.0f;
        float unitScaleDownDist = this.scaleDownDistance * mid;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child == null) continue;
            float childMid = (float)(this.getDecoratedLeft(child) + this.getDecoratedRight(child)) / 2.0f;
            float scale = 1.0f + -1.0f * this.scaleDownBy * Math.min(unitScaleDownDist, Math.abs(mid - childMid)) / unitScaleDownDist;
            child.setScaleX(scale);
            child.setScaleY(scale);
            if (!this.changeAlpha) continue;
            child.setAlpha(scale);
        }
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        if (state == 0 && this.onScrollStopListener != null) {
            int selected = 0;
            float lastHeight = 0.0f;
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (child == null || !(lastHeight < child.getScaleY())) continue;
                lastHeight = child.getScaleY();
                selected = i;
            }
            this.onScrollStopListener.selectedView(this.getChildAt(selected));
        }
    }

    public float getScaleDownBy() {
        return this.scaleDownBy;
    }

    public void setScaleDownBy(float scaleDownBy) {
        this.scaleDownBy = scaleDownBy;
    }

    public float getScaleDownDistance() {
        return this.scaleDownDistance;
    }

    public void setScaleDownDistance(float scaleDownDistance) {
        this.scaleDownDistance = scaleDownDistance;
    }

    public boolean isChangeAlpha() {
        return this.changeAlpha;
    }

    public void setChangeAlpha(boolean changeAlpha) {
        this.changeAlpha = changeAlpha;
    }

    public void setOnScrollStopListener(onScrollStopListener onScrollStopListener2) {
        this.onScrollStopListener = onScrollStopListener2;
    }

    public static interface onScrollStopListener {
        public void selectedView(View var1);
    }
}

