/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.diagnostic;

import android.app.Application;
import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.MutableLiveData;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import live.hms.roomkit.ui.diagnostic.DiagnosticProvider;
import live.hms.video.audio.HMSAudioDeviceInfo;
import live.hms.video.audio.HMSAudioManager;
import live.hms.video.diagnostics.ConnectivityCheckListener;
import live.hms.video.diagnostics.HMSAudioDeviceCheckListener;
import live.hms.video.diagnostics.HMSCameraCheckListener;
import live.hms.video.diagnostics.HMSDiagnostics;
import live.hms.video.diagnostics.models.ConnectivityCheckResult;
import live.hms.video.diagnostics.models.ConnectivityState;
import live.hms.video.error.HMSException;
import live.hms.video.media.settings.HMSVideoTrackSettings;
import live.hms.video.media.tracks.HMSVideoTrack;
import live.hms.video.sdk.HMSSDK;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010(\u001a\u00020)J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+J\u0006\u0010-\u001a\u00020.J\u0018\u0010/\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020'000+J\u0006\u00101\u001a\u00020)J\u000e\u00102\u001a\u00020)2\u0006\u00103\u001a\u00020'J\u0006\u00104\u001a\u00020)J\u0006\u00105\u001a\u00020)J\u0006\u00106\u001a\u00020)J\u0006\u00107\u001a\u00020)J\u0006\u00108\u001a\u00020)J\u0006\u00109\u001a\u00020)J\u0006\u0010:\u001a\u00020)J\u000e\u0010;\u001a\u00020)2\u0006\u0010<\u001a\u00020.R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0019\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0019\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010!R\u001a\u0010$\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001f\"\u0004\b%\u0010!R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Llive/hms/roomkit/ui/diagnostic/DiagnosticViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "audioLevelLiveData", "Landroidx/lifecycle/MutableLiveData;", "", "getAudioLevelLiveData", "()Landroidx/lifecycle/MutableLiveData;", "cameraTrackLiveData", "Llive/hms/video/media/tracks/HMSVideoTrack;", "getCameraTrackLiveData", "connectivityLiveData", "Llive/hms/video/diagnostics/models/ConnectivityCheckResult;", "getConnectivityLiveData", "connectivityStateLiveData", "Llive/hms/video/diagnostics/models/ConnectivityState;", "getConnectivityStateLiveData", "diagnosticProvider", "Llive/hms/roomkit/ui/diagnostic/DiagnosticProvider;", "diagnosticSDK", "Llive/hms/video/diagnostics/HMSDiagnostics;", "getDiagnosticSDK", "()Llive/hms/video/diagnostics/HMSDiagnostics;", "hmsSDK", "Llive/hms/video/sdk/HMSSDK;", "getHmsSDK", "()Llive/hms/video/sdk/HMSSDK;", "isMediaCaptured", "", "()Z", "setMediaCaptured", "(Z)V", "isMediaPublished", "setMediaPublished", "isRecording", "setRecording", "regionCode", "", "cameraPermssionGranted", "", "getAudioDevicesInfoList", "", "Llive/hms/video/audio/HMSAudioDeviceInfo;", "getAudioOutputRouteType", "Llive/hms/video/audio/HMSAudioManager$AudioDevice;", "getRegionList", "Lkotlin/Pair;", "initSDK", "setRegionPreference", "regionName", "startConnectivityTest", "startMicRecording", "startSpeakerTest", "stopCameraCheck", "stopConnectivityTest", "stopMicCheck", "stopRecording", "switchAudioOutput", "audioDevice", "room-kit_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDiagnosticViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticViewModel.kt\nlive/hms/roomkit/ui/diagnostic/DiagnosticViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1863#2,2:152\n1#3:154\n*S KotlinDebug\n*F\n+ 1 DiagnosticViewModel.kt\nlive/hms/roomkit/ui/diagnostic/DiagnosticViewModel\n*L\n48#1:152,2\n*E\n"})
public final class DiagnosticViewModel
extends AndroidViewModel {
    @NotNull
    private String regionCode;
    @NotNull
    private final DiagnosticProvider diagnosticProvider;
    @NotNull
    private final MutableLiveData<HMSVideoTrack> cameraTrackLiveData;
    private boolean isRecording;
    @NotNull
    private final MutableLiveData<Integer> audioLevelLiveData;
    @NotNull
    private final MutableLiveData<ConnectivityCheckResult> connectivityLiveData;
    @NotNull
    private final MutableLiveData<ConnectivityState> connectivityStateLiveData;
    private boolean isMediaCaptured;
    private boolean isMediaPublished;
    public static final int $stable = 8;

    public DiagnosticViewModel(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application);
        this.regionCode = "in";
        this.diagnosticProvider = new DiagnosticProvider(application);
        this.cameraTrackLiveData = new MutableLiveData();
        this.audioLevelLiveData = new MutableLiveData();
        this.connectivityLiveData = new MutableLiveData(null);
        this.connectivityStateLiveData = new MutableLiveData(null);
    }

    private final HMSDiagnostics getDiagnosticSDK() {
        return this.diagnosticProvider.getDiagnosticSdk();
    }

    private final HMSSDK getHmsSDK() {
        return this.diagnosticProvider.getSdk();
    }

    @NotNull
    public final MutableLiveData<HMSVideoTrack> getCameraTrackLiveData() {
        return this.cameraTrackLiveData;
    }

    public final void cameraPermssionGranted() {
        this.getDiagnosticSDK().startCameraCheck(HMSVideoTrackSettings.CameraFacing.FRONT, new HMSCameraCheckListener(this){
            final /* synthetic */ DiagnosticViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onError(@NotNull HMSException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            }

            public void onVideoTrack(@NotNull HMSVideoTrack localVideoTrack) {
                Intrinsics.checkNotNullParameter((Object)localVideoTrack, (String)"localVideoTrack");
                this.this$0.getCameraTrackLiveData().postValue((Object)localVideoTrack);
            }
        });
    }

    @NotNull
    public final List<Pair<String, String>> getRegionList() {
        Object[] objectArray = new Pair[]{new Pair((Object)"in", (Object)"India"), new Pair((Object)"eu", (Object)"Europe"), new Pair((Object)"us", (Object)"US")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public final void setRegionPreference(@NotNull String regionName) {
        Intrinsics.checkNotNullParameter((Object)regionName, (String)"regionName");
        Iterable $this$forEach$iv = this.getRegionList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getSecond(), (Object)regionName)) continue;
            this.regionCode = (String)it.getFirst();
        }
    }

    public final void stopCameraCheck() {
        this.getDiagnosticSDK().stopCameraCheck();
        this.cameraTrackLiveData.postValue(null);
    }

    public final void initSDK() {
    }

    public final void stopMicCheck() {
        this.isRecording = false;
        try {
            boolean bl = false;
            this.getDiagnosticSDK().stopMicCheck();
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final boolean isRecording() {
        return this.isRecording;
    }

    public final void setRecording(boolean bl) {
        this.isRecording = bl;
    }

    @NotNull
    public final MutableLiveData<Integer> getAudioLevelLiveData() {
        return this.audioLevelLiveData;
    }

    public final void startMicRecording() {
        this.isRecording = true;
        this.getDiagnosticSDK().startMicCheck((Context)this.getApplication(), new HMSAudioDeviceCheckListener(this){
            final /* synthetic */ DiagnosticViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onError(@NotNull HMSException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            }

            public void onSuccess() {
            }

            public void onAudioLevelChanged(int decibel) {
                HMSAudioDeviceCheckListener.DefaultImpls.onAudioLevelChanged((HMSAudioDeviceCheckListener)this, (int)decibel);
                this.this$0.getAudioLevelLiveData().postValue((Object)decibel);
            }
        });
    }

    public final void stopRecording() {
        this.isRecording = false;
        try {
            boolean bl = false;
            this.getDiagnosticSDK().stopMicCheck();
            this.getDiagnosticSDK().stopSpeakerCheck();
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void switchAudioOutput(@NotNull HMSAudioManager.AudioDevice audioDevice) {
        Intrinsics.checkNotNullParameter((Object)audioDevice, (String)"audioDevice");
        this.getHmsSDK().switchAudioOutput(audioDevice);
    }

    @NotNull
    public final List<HMSAudioDeviceInfo> getAudioDevicesInfoList() {
        return this.getHmsSDK().getAudioDevicesInfoList();
    }

    @NotNull
    public final HMSAudioManager.AudioDevice getAudioOutputRouteType() {
        return this.getHmsSDK().getAudioOutputRouteType();
    }

    @NotNull
    public final MutableLiveData<ConnectivityCheckResult> getConnectivityLiveData() {
        return this.connectivityLiveData;
    }

    @NotNull
    public final MutableLiveData<ConnectivityState> getConnectivityStateLiveData() {
        return this.connectivityStateLiveData;
    }

    public final boolean isMediaCaptured() {
        return this.isMediaCaptured;
    }

    public final void setMediaCaptured(boolean bl) {
        this.isMediaCaptured = bl;
    }

    public final boolean isMediaPublished() {
        return this.isMediaPublished;
    }

    public final void setMediaPublished(boolean bl) {
        this.isMediaPublished = bl;
    }

    public final void startConnectivityTest() {
        this.diagnosticProvider.disposeOfDiagnostic();
        this.isMediaPublished = false;
        this.isMediaCaptured = false;
        this.connectivityLiveData.postValue(null);
        this.connectivityStateLiveData.postValue(null);
        HMSDiagnostics.startConnectivityCheck$default((HMSDiagnostics)this.getDiagnosticSDK(), (String)this.regionCode, (ConnectivityCheckListener)new ConnectivityCheckListener(this){
            final /* synthetic */ DiagnosticViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onCompleted(@NotNull ConnectivityCheckResult result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                this.this$0.getConnectivityLiveData().postValue((Object)result);
            }

            public void onConnectivityStateChanged(@NotNull ConnectivityState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                this.this$0.getConnectivityStateLiveData().postValue((Object)state);
                if (state == ConnectivityState.MEDIA_CAPTURED) {
                    this.this$0.setMediaCaptured(true);
                }
                if (state == ConnectivityState.MEDIA_PUBLISHED) {
                    this.this$0.setMediaPublished(true);
                }
            }
        }, (long)0L, (int)4, null);
    }

    public final void stopConnectivityTest() {
        this.getDiagnosticSDK().stopConnectivityCheck();
        this.connectivityLiveData.postValue(null);
        this.connectivityStateLiveData.postValue(null);
    }

    public final void startSpeakerTest() {
        try {
            boolean bl = false;
            this.getDiagnosticSDK().startSpeakerCheck();
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }
}

