/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.api;

import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import live.hms.roomkit.api.RetrofitBuilder;
import live.hms.roomkit.model.TokenRequestWithCode;
import live.hms.roomkit.model.TokenRequestWithRoomId;
import live.hms.roomkit.model.TokenResponse;
import live.hms.roomkit.util.InternalUtilsKt;
import live.hms.video.utils.ExtensionUtilsKt;
import live.hms.video.utils.GsonUtils;
import live.hms.video.utils.HMSLogger;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0006H\u0002J\u001e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013J&\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Llive/hms/roomkit/api/RetrofitBuilder;", "", "()V", "JSON", "Lokhttp3/MediaType;", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "client$delegate", "Lkotlin/Lazy;", "fetchAuthToken", "Llive/hms/roomkit/model/TokenResponse;", "request", "Lokhttp3/Request;", "(Lokhttp3/Request;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "makeClient", "makeTokenWithCodeRequest", "subdomain", "", "code", "environment", "makeTokenWithRoomIdRequest", "roomId", "role", "room-kit_release"})
@StabilityInferred(parameters=0)
public final class RetrofitBuilder {
    @NotNull
    public static final RetrofitBuilder INSTANCE = new RetrofitBuilder();
    @NotNull
    private static final MediaType JSON = MediaType.Companion.get("application/json; charset=utf-8");
    @NotNull
    private static final Lazy client$delegate = LazyKt.lazy((Function0)client.2.INSTANCE);
    public static final int $stable = 8;

    private RetrofitBuilder() {
    }

    private final OkHttpClient getClient() {
        Lazy lazy = client$delegate;
        return (OkHttpClient)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final OkHttpClient makeClient() {
        void $this$makeClient_u24lambda_u240;
        HttpLoggingInterceptor httpLoggingInterceptor;
        HttpLoggingInterceptor httpLoggingInterceptor2 = httpLoggingInterceptor = new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)makeClient.1.INSTANCE);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        boolean bl = false;
        $this$makeClient_u24lambda_u240.level(HttpLoggingInterceptor.Level.BODY);
        return builder.addInterceptor((Interceptor)httpLoggingInterceptor).retryOnConnectionFailure(true).followRedirects(true).followSslRedirects(true).callTimeout(10L, TimeUnit.SECONDS).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).build();
    }

    @NotNull
    public final Request makeTokenWithRoomIdRequest(@NotNull String subdomain, @NotNull String roomId, @NotNull String role, @NotNull String environment) {
        Intrinsics.checkNotNullParameter((Object)subdomain, (String)"subdomain");
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        String url = InternalUtilsKt.getTokenEndpointForRoomId(environment, subdomain);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        RequestBody body = RequestBody.Companion.create(ExtensionUtilsKt.toJson((Object)new TokenRequestWithRoomId(roomId, string, role)), JSON);
        return new Request.Builder().url(url).addHeader("Accept-Type", "application/json").post(body).build();
    }

    @NotNull
    public final Request makeTokenWithCodeRequest(@NotNull String subdomain, @NotNull String code, @NotNull String environment) {
        Intrinsics.checkNotNullParameter((Object)subdomain, (String)"subdomain");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        String url = InternalUtilsKt.getTokenEndpointForCode(environment);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        RequestBody body = RequestBody.Companion.create(ExtensionUtilsKt.toJson((Object)new TokenRequestWithCode(code, string)), JSON);
        return new Request.Builder().url(url).addHeader("Accept-Type", "application/json").addHeader("subdomain", subdomain).post(body).build();
    }

    @Nullable
    public final Object fetchAuthToken(@NotNull Request request, @NotNull Continuation<? super TokenResponse> $completion) {
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        long fetchAuthTokenStartedAt = System.currentTimeMillis();
        this.getClient().newCall(request).enqueue(new Callback((CompletableDeferred<TokenResponse>)deferred, fetchAuthTokenStartedAt){
            final /* synthetic */ CompletableDeferred<TokenResponse> $deferred;
            final /* synthetic */ long $fetchAuthTokenStartedAt;
            {
                this.$deferred = $deferred;
                this.$fetchAuthTokenStartedAt = $fetchAuthTokenStartedAt;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Log.e((String)"RetrofitBuilder", (String)("fetchAuthToken: " + e.getMessage()), (Throwable)e);
                this.$deferred.completeExceptionally((Throwable)e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Log.d((String)"RetrofitBuilder", (String)("fetchAuthToken: response=" + response));
                Log.d((String)"RetrofitBuilder", (String)("~~ Took " + (System.currentTimeMillis() - this.$fetchAuthTokenStartedAt) + " ms to fetch token ~~"));
                if (response.code() != 200) {
                    Exception ex = new Exception("Expected response code 200 but received " + response.code() + " [response=" + response + "]");
                    this.$deferred.completeExceptionally((Throwable)ex);
                    return;
                }
                Object object = response.body();
                if (object == null || (object = object.string()) == null) {
                    object = "";
                }
                Object body = object;
                try {
                    TokenResponse token = (TokenResponse)GsonUtils.INSTANCE.getGson().fromJson((String)body, TokenResponse.class);
                    try {
                        if (Intrinsics.areEqual((Object)token.getToken(), (Object)"null") || StringsKt.isBlank((CharSequence)token.getToken())) {
                            throw new Exception("Could not fetch token, check if your environment is correct.");
                        }
                    }
                    catch (NullPointerException ex) {
                        throw new Exception("Could not fetch token, check if your environment is correct.");
                    }
                    HMSLogger.d((String)"RetrofitBuilder", (String)("fetchAuthToken: token=" + token));
                    Intrinsics.checkNotNullExpressionValue((Object)token, (String)"token");
                    this.$deferred.complete((Object)token);
                }
                catch (Exception e) {
                    HMSLogger.INSTANCE.e("RetrofitBuilder", "fetchAuthToken: " + e.getMessage(), (Throwable)e);
                    this.$deferred.completeExceptionally((Throwable)e);
                }
            }
        });
        return deferred.await($completion);
    }

    public static final /* synthetic */ OkHttpClient access$makeClient(RetrofitBuilder $this) {
        return $this.makeClient();
    }
}

