/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.animation;

import android.annotation.SuppressLint;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import androidx.dynamicanimation.animation.FloatValueHolder;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bH\u0002\u001a\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0003\u001a0\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\u0012\u001a\u00020\b\u001a\u0012\u0010\u0013\u001a\u00020\t*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010\u0017\u001a\u00020\t*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003\u001a)\u0010\u0018\u001a\u00020\u0011*\u00020\u00112\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\u001bH\u0086\b\u00f8\u0001\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"tmpIntArr", "", "tryHiddenSuppressLayout", "", "createFloatValueHolder", "Landroidx/dynamicanimation/animation/FloatValueHolder;", "setter", "Lkotlin/Function1;", "", "", "getter", "Lkotlin/Function0;", "hiddenSuppressLayout", "group", "Landroid/view/ViewGroup;", "suppress", "springAnimationOf", "Landroidx/dynamicanimation/animation/SpringAnimation;", "finalPosition", "copyBoundsInWindow", "Landroid/view/View;", "rect", "Landroid/graphics/Rect;", "suppressLayoutCompat", "withSpringForceProperties", "func", "Landroidx/dynamicanimation/animation/SpringForce;", "Lkotlin/ExtensionFunctionType;", "room-kit_release"})
public final class UtilsKt {
    @NotNull
    private static final int[] tmpIntArr = new int[2];
    private static boolean tryHiddenSuppressLayout = true;

    public static final void copyBoundsInWindow(@NotNull View $this$copyBoundsInWindow, @NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)$this$copyBoundsInWindow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        if (!$this$copyBoundsInWindow.isLaidOut() || !$this$copyBoundsInWindow.isAttachedToWindow()) {
            throw new IllegalArgumentException("Can not copy bounds as view is not laid out or attached to window");
        }
        rect.set(0, 0, $this$copyBoundsInWindow.getWidth(), $this$copyBoundsInWindow.getHeight());
        $this$copyBoundsInWindow.getLocationInWindow(tmpIntArr);
        rect.offset(tmpIntArr[0], tmpIntArr[1]);
    }

    public static final void suppressLayoutCompat(@NotNull ViewGroup $this$suppressLayoutCompat, boolean suppress) {
        Intrinsics.checkNotNullParameter((Object)$this$suppressLayoutCompat, (String)"<this>");
        if (Build.VERSION.SDK_INT >= 29) {
            $this$suppressLayoutCompat.suppressLayout(suppress);
        } else {
            UtilsKt.hiddenSuppressLayout($this$suppressLayoutCompat, suppress);
        }
    }

    @SuppressLint(value={"NewApi"})
    private static final void hiddenSuppressLayout(ViewGroup group2, boolean suppress) {
        if (tryHiddenSuppressLayout) {
            try {
                group2.suppressLayout(suppress);
            }
            catch (NoSuchMethodError e) {
                tryHiddenSuppressLayout = false;
            }
        }
    }

    @NotNull
    public static final SpringAnimation springAnimationOf(@NotNull Function1<? super Float, Unit> setter, @NotNull Function0<Float> getter, float finalPosition) {
        Intrinsics.checkNotNullParameter(setter, (String)"setter");
        Intrinsics.checkNotNullParameter(getter, (String)"getter");
        FloatValueHolder valueHolder = UtilsKt.createFloatValueHolder(setter, getter);
        valueHolder.getValue();
        return Float.isNaN(finalPosition) ? new SpringAnimation(valueHolder) : new SpringAnimation(valueHolder, finalPosition);
    }

    private static final FloatValueHolder createFloatValueHolder(Function1<? super Float, Unit> setter, Function0<Float> getter) {
        return new FloatValueHolder(getter, setter){
            final /* synthetic */ Function0<Float> $getter;
            final /* synthetic */ Function1<Float, Unit> $setter;
            {
                this.$getter = $getter;
                this.$setter = $setter;
            }

            public float getValue() {
                return ((Number)this.$getter.invoke()).floatValue();
            }

            public void setValue(float value) {
                this.$setter.invoke((Object)Float.valueOf(value));
            }
        };
    }

    @NotNull
    public static final SpringAnimation withSpringForceProperties(@NotNull SpringAnimation $this$withSpringForceProperties, @NotNull Function1<? super SpringForce, Unit> func) {
        Intrinsics.checkNotNullParameter((Object)$this$withSpringForceProperties, (String)"<this>");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        boolean $i$f$withSpringForceProperties = false;
        if ($this$withSpringForceProperties.getSpring() == null) {
            $this$withSpringForceProperties.setSpring(new SpringForce());
        }
        SpringForce springForce = $this$withSpringForceProperties.getSpring();
        Intrinsics.checkNotNullExpressionValue((Object)springForce, (String)"spring");
        func.invoke((Object)springForce);
        return $this$withSpringForceProperties;
    }
}

