/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.animation;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsetsAnimation;
import android.widget.LinearLayout;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.view.NestedScrollingParent3;
import androidx.core.view.NestedScrollingParentHelper;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsAnimationControllerCompat;
import androidx.core.view.WindowInsetsCompat;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.roomkit.animation.InsetsAnimationLinearLayoutKt;
import live.hms.roomkit.animation.SimpleImeAnimationController;
import live.hms.roomkit.animation.UtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0013\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001dH\u0002J(\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0012H\u0016J0\u0010'\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\bH\u0016J8\u0010+\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bH\u0016J@\u0010+\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\b2\u0006\u0010*\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u001bH\u0016J \u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\bH\u0016J(\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bH\u0016J(\u00103\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bH\u0016J\u0010\u00104\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u000bH\u0016J\u0018\u00104\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\bH\u0016J\b\u00105\u001a\u00020\u001dH\u0002J\b\u00106\u001a\u00020\u001dH\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Llive/hms/roomkit/animation/InsetsAnimationLinearLayout;", "Landroid/widget/LinearLayout;", "Landroidx/core/view/NestedScrollingParent3;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "currentNestedScrollingChild", "Landroid/view/View;", "dropNextY", "imeAnimController", "Llive/hms/roomkit/animation/SimpleImeAnimationController;", "nestedScrollingParentHelper", "Landroidx/core/view/NestedScrollingParentHelper;", "scrollImeOffScreenWhenVisible", "", "getScrollImeOffScreenWhenVisible", "()Z", "setScrollImeOffScreenWhenVisible", "(Z)V", "scrollImeOnScreenWhenNotVisible", "getScrollImeOnScreenWhenNotVisible", "setScrollImeOnScreenWhenNotVisible", "startViewLocation", "", "dispatchWindowInsetsAnimationPrepare", "", "animation", "Landroid/view/WindowInsetsAnimation;", "onControllerReady", "onNestedFling", "target", "velocityX", "", "velocityY", "consumed", "onNestedPreScroll", "dx", "dy", "type", "onNestedScroll", "dxConsumed", "dyConsumed", "dxUnconsumed", "dyUnconsumed", "onNestedScrollAccepted", "child", "axes", "onStartNestedScroll", "onStopNestedScroll", "reset", "startControlRequest", "room-kit_release"})
@StabilityInferred(parameters=0)
public final class InsetsAnimationLinearLayout
extends LinearLayout
implements NestedScrollingParent3 {
    @NotNull
    private final NestedScrollingParentHelper nestedScrollingParentHelper;
    @Nullable
    private View currentNestedScrollingChild;
    @NotNull
    private final SimpleImeAnimationController imeAnimController;
    private int dropNextY;
    @NotNull
    private final int[] startViewLocation;
    private boolean scrollImeOffScreenWhenVisible;
    private boolean scrollImeOnScreenWhenNotVisible;
    public static final int $stable = 8;

    @JvmOverloads
    public InsetsAnimationLinearLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.nestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.imeAnimController = new SimpleImeAnimationController();
        this.startViewLocation = new int[2];
        this.scrollImeOffScreenWhenVisible = true;
        this.scrollImeOnScreenWhenNotVisible = true;
    }

    public /* synthetic */ InsetsAnimationLinearLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final boolean getScrollImeOffScreenWhenVisible() {
        return this.scrollImeOffScreenWhenVisible;
    }

    public final void setScrollImeOffScreenWhenVisible(boolean bl) {
        this.scrollImeOffScreenWhenVisible = bl;
    }

    public final boolean getScrollImeOnScreenWhenNotVisible() {
        return this.scrollImeOnScreenWhenNotVisible;
    }

    public final void setScrollImeOnScreenWhenNotVisible(boolean bl) {
        this.scrollImeOnScreenWhenNotVisible = bl;
    }

    public boolean onStartNestedScroll(@NotNull View child, @NotNull View target, int axes, int type) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return (axes & 2) != 0 && type == 0;
    }

    public void onNestedScrollAccepted(@NotNull View child, @NotNull View target, int axes, int type) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.nestedScrollingParentHelper.onNestedScrollAccepted(child, target, axes, type);
        this.currentNestedScrollingChild = child;
    }

    public void onNestedPreScroll(@NotNull View target, int dx, int dy, @NotNull int[] consumed, int type) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)consumed, (String)"consumed");
        if (this.imeAnimController.isInsetAnimationRequestPending()) {
            consumed[0] = dx;
            consumed[1] = dy;
            return;
        }
        int deltaY = dy;
        if (this.dropNextY != 0) {
            consumed[1] = this.dropNextY;
            deltaY -= this.dropNextY;
            this.dropNextY = 0;
        }
        if (deltaY < 0) {
            if (this.imeAnimController.isInsetAnimationInProgress()) {
                consumed[1] = consumed[1] - this.imeAnimController.insetBy(-deltaY);
            } else if (this.scrollImeOffScreenWhenVisible && !this.imeAnimController.isInsetAnimationRequestPending()) {
                WindowInsetsCompat windowInsetsCompat = ViewCompat.getRootWindowInsets((View)((View)this));
                boolean bl = windowInsetsCompat != null ? windowInsetsCompat.isVisible(WindowInsetsCompat.Type.ime()) : false;
                if (bl) {
                    this.startControlRequest();
                    consumed[1] = deltaY;
                }
            }
        }
    }

    public void onNestedScroll(@NotNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type, @NotNull int[] consumed) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)consumed, (String)"consumed");
        if (dyUnconsumed > 0) {
            if (this.imeAnimController.isInsetAnimationInProgress()) {
                consumed[1] = -this.imeAnimController.insetBy(-dyUnconsumed);
            } else if (this.scrollImeOnScreenWhenNotVisible && !this.imeAnimController.isInsetAnimationRequestPending()) {
                WindowInsetsCompat windowInsetsCompat = ViewCompat.getRootWindowInsets((View)((View)this));
                boolean bl = windowInsetsCompat != null ? !windowInsetsCompat.isVisible(WindowInsetsCompat.Type.ime()) : false;
                if (bl) {
                    this.startControlRequest();
                    consumed[1] = dyUnconsumed;
                }
            }
        }
    }

    public boolean onNestedFling(@NotNull View target, float velocityX, float velocityY, boolean consumed) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (this.imeAnimController.isInsetAnimationInProgress()) {
            this.imeAnimController.animateToFinish(Float.valueOf(velocityY));
            return true;
        }
        WindowInsetsCompat windowInsetsCompat = ViewCompat.getRootWindowInsets((View)((View)this));
        boolean imeVisible = windowInsetsCompat != null ? windowInsetsCompat.isVisible(WindowInsetsCompat.Type.ime()) : false;
        if (velocityY > 0.0f && this.scrollImeOnScreenWhenNotVisible && !imeVisible) {
            this.imeAnimController.startAndFling((View)this, velocityY);
            return true;
        }
        if (velocityY < 0.0f && this.scrollImeOffScreenWhenVisible && imeVisible) {
            this.imeAnimController.startAndFling((View)this, velocityY);
            return true;
        }
        return false;
    }

    public void onStopNestedScroll(@NotNull View target, int type) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.nestedScrollingParentHelper.onStopNestedScroll(target, type);
        if (this.imeAnimController.isInsetAnimationInProgress() && !this.imeAnimController.isInsetAnimationFinishing()) {
            SimpleImeAnimationController.animateToFinish$default(this.imeAnimController, null, 1, null);
        }
        this.reset();
    }

    public void dispatchWindowInsetsAnimationPrepare(@NotNull WindowInsetsAnimation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        super.dispatchWindowInsetsAnimationPrepare(animation);
        UtilsKt.suppressLayoutCompat((ViewGroup)this, false);
    }

    private final void startControlRequest() {
        UtilsKt.suppressLayoutCompat((ViewGroup)this, true);
        View view = this.currentNestedScrollingChild;
        if (view != null) {
            view.getLocationInWindow(this.startViewLocation);
        }
        this.imeAnimController.startControlRequest((View)this, (Function1<? super WindowInsetsAnimationControllerCompat, Unit>)((Function1)new Function1<WindowInsetsAnimationControllerCompat, Unit>(this){
            final /* synthetic */ InsetsAnimationLinearLayout this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull WindowInsetsAnimationControllerCompat it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                InsetsAnimationLinearLayout.access$onControllerReady(this.this$0);
            }
        }));
    }

    private final void onControllerReady() {
        View scrollingChild = this.currentNestedScrollingChild;
        if (scrollingChild != null) {
            this.imeAnimController.insetBy(0);
            int[] location = InsetsAnimationLinearLayoutKt.access$getTempIntArray2$p();
            scrollingChild.getLocationInWindow(location);
            this.dropNextY = location[1] - this.startViewLocation[1];
        }
    }

    private final void reset() {
        this.dropNextY = 0;
        ArraysKt.fill$default((int[])this.startViewLocation, (int)0, (int)0, (int)0, (int)6, null);
        UtilsKt.suppressLayoutCompat((ViewGroup)this, false);
    }

    public void onNestedScrollAccepted(@NotNull View child, @NotNull View target, int axes) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.onNestedScrollAccepted(child, target, axes, 0);
    }

    public void onNestedScroll(@NotNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.onNestedScroll(target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, type, InsetsAnimationLinearLayoutKt.access$getTempIntArray2$p());
    }

    public void onStopNestedScroll(@NotNull View target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.onStopNestedScroll(target, 0);
    }

    @JvmOverloads
    public InsetsAnimationLinearLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public InsetsAnimationLinearLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$onControllerReady(InsetsAnimationLinearLayout $this) {
        $this.onControllerReady();
    }
}

