/*
 * Decompiled with CFR 0.152.
 */
package live.hms.stats;

import android.os.Handler;
import android.os.Looper;
import androidx.media3.common.Format;
import androidx.media3.common.PlaybackException;
import androidx.media3.exoplayer.DecoderReuseEvaluation;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.analytics.AnalyticsListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import live.hms.stats.PlayerStatsListener;
import live.hms.stats.model.InitConfig;
import live.hms.stats.model.PlayerStatsModel;
import live.hms.video.error.HMSException;
import live.hms.video.sdk.HMSSDK;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 22\u00020\u0001:\u00012B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0017J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u000fJ\b\u0010\u001c\u001a\u00020\u0017H\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0002J(\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0016J\u0018\u0010'\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010(\u001a\u00020)H\u0016J\"\u0010*\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J \u0010/\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020%H\u0016R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Llive/hms/stats/PlayerEventsCollector;", "Landroidx/media3/exoplayer/analytics/AnalyticsListener;", "hmsSdk", "Llive/hms/video/sdk/HMSSDK;", "initConfig", "Llive/hms/stats/model/InitConfig;", "<init>", "(Llive/hms/video/sdk/HMSSDK;Llive/hms/stats/model/InitConfig;)V", "getHmsSdk", "()Llive/hms/video/sdk/HMSSDK;", "setHmsSdk", "(Llive/hms/video/sdk/HMSSDK;)V", "exoPlayer", "Landroidx/media3/exoplayer/ExoPlayer;", "playerStatsListener", "Llive/hms/stats/PlayerStatsListener;", "playerPlayerStatsModel", "Llive/hms/stats/model/PlayerStatsModel;", "eventsHandler", "Landroid/os/Handler;", "eventsRunnable", "Ljava/lang/Runnable;", "setExoPlayer", "", "removeStatsListener", "removeListener", "addStatsListener", "playerEventsListener", "init", "setInitialValues", "fireEvent", "onBandwidthEstimate", "eventTime", "Landroidx/media3/exoplayer/analytics/AnalyticsListener$EventTime;", "totalLoadTimeMs", "", "totalBytesLoaded", "", "bitrateEstimate", "onPlayerError", "error", "Landroidx/media3/common/PlaybackException;", "onVideoInputFormatChanged", "format", "Landroidx/media3/common/Format;", "decoderReuseEvaluation", "Landroidx/media3/exoplayer/DecoderReuseEvaluation;", "onDroppedVideoFrames", "droppedFrames", "elapsedMs", "Companion", "stats_release"})
@SourceDebugExtension(value={"SMAP\nPlayerEventsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerEventsCollector.kt\nlive/hms/stats/PlayerEventsCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public final class PlayerEventsCollector
implements AnalyticsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private HMSSDK hmsSdk;
    @NotNull
    private final InitConfig initConfig;
    @Nullable
    private ExoPlayer exoPlayer;
    @Nullable
    private PlayerStatsListener playerStatsListener;
    @Nullable
    private PlayerStatsModel playerPlayerStatsModel;
    @Nullable
    private Handler eventsHandler;
    @Nullable
    private Runnable eventsRunnable;
    @NotNull
    public static final String TAG = "PlayerEventsCollector";

    public PlayerEventsCollector(@Nullable HMSSDK hmsSdk, @NotNull InitConfig initConfig) {
        Intrinsics.checkNotNullParameter((Object)initConfig, (String)"initConfig");
        this.hmsSdk = hmsSdk;
        this.initConfig = initConfig;
        this.playerPlayerStatsModel = new PlayerStatsModel(null, null, null, 0L, 0L, 31, null);
    }

    public /* synthetic */ PlayerEventsCollector(HMSSDK hMSSDK, InitConfig initConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            initConfig = new InitConfig(0L, 1, null);
        }
        this(hMSSDK, initConfig);
    }

    @Nullable
    public final HMSSDK getHmsSdk() {
        return this.hmsSdk;
    }

    public final void setHmsSdk(@Nullable HMSSDK hMSSDK) {
        this.hmsSdk = hMSSDK;
    }

    public final void setExoPlayer(@Nullable ExoPlayer exoPlayer) {
        ExoPlayer exoPlayer2 = this.exoPlayer = exoPlayer;
        if (exoPlayer2 != null) {
            exoPlayer2.addAnalyticsListener((AnalyticsListener)this);
        }
        this.init();
    }

    public final void removeStatsListener() {
        this.playerStatsListener = null;
    }

    public final void removeListener() {
        Runnable runnable = this.eventsRunnable;
        if (runnable != null) {
            Runnable it = runnable;
            boolean bl = false;
            Handler handler = this.eventsHandler;
            if (handler != null) {
                handler.removeCallbacks(it);
            }
        }
        ExoPlayer exoPlayer = this.exoPlayer;
        if (exoPlayer != null) {
            exoPlayer.removeAnalyticsListener((AnalyticsListener)this);
        }
        this.eventsRunnable = null;
    }

    public final void addStatsListener(@NotNull PlayerStatsListener playerEventsListener) {
        Intrinsics.checkNotNullParameter((Object)playerEventsListener, (String)"playerEventsListener");
        this.playerStatsListener = playerEventsListener;
    }

    private final void init() {
        block1: {
            this.setInitialValues();
            this.eventsRunnable = () -> PlayerEventsCollector.init$lambda$2(this);
            this.eventsHandler = new Handler(Looper.getMainLooper());
            Runnable runnable = this.eventsRunnable;
            if (runnable == null) break block1;
            Runnable it = runnable;
            boolean bl = false;
            Handler handler = this.eventsHandler;
            if (handler != null) {
                handler.post(it);
            }
        }
    }

    private final void setInitialValues() {
        block2: {
            Object object;
            Object object2;
            Integer videoWidth;
            ExoPlayer exoPlayer = this.exoPlayer;
            int averageBitrate = exoPlayer != null && (exoPlayer = exoPlayer.getVideoFormat()) != null ? exoPlayer.bitrate : -1;
            ExoPlayer exoPlayer2 = this.exoPlayer;
            Integer videoHeight = exoPlayer2 != null && (exoPlayer2 = exoPlayer2.getVideoSize()) != null ? Integer.valueOf(exoPlayer2.height) : null;
            ExoPlayer exoPlayer3 = this.exoPlayer;
            Integer n = videoWidth = exoPlayer3 != null && (exoPlayer3 = exoPlayer3.getVideoSize()) != null ? Integer.valueOf(exoPlayer3.width) : null;
            Object object3 = this.playerPlayerStatsModel;
            if (object3 != null && (object3 = ((PlayerStatsModel)object3).getVideoInfo()) != null) {
                ((PlayerStatsModel.VideoInfo)object3).setAverageBitrate(averageBitrate);
            }
            if (videoHeight != null && (object2 = this.playerPlayerStatsModel) != null && (object2 = ((PlayerStatsModel)object2).getVideoInfo()) != null) {
                ((PlayerStatsModel.VideoInfo)object2).setVideoHeight(videoHeight);
            }
            if (videoWidth == null || (object = this.playerPlayerStatsModel) == null || (object = ((PlayerStatsModel)object).getVideoInfo()) == null) break block2;
            ((PlayerStatsModel.VideoInfo)object).setVideoWidth(videoWidth);
        }
    }

    private final void fireEvent() {
        block2: {
            ExoPlayer exoPlayer = this.exoPlayer;
            if (exoPlayer == null) {
                return;
            }
            long currentBufferedPosition = exoPlayer.getBufferedPosition() - exoPlayer.getCurrentPosition();
            long distanceFromLive = exoPlayer.getDuration() - exoPlayer.getCurrentPosition();
            PlayerStatsModel playerStatsModel = this.playerPlayerStatsModel;
            if (playerStatsModel == null) break block2;
            PlayerStatsModel playerPlayerStatsModel = playerStatsModel;
            boolean bl = false;
            playerPlayerStatsModel.setBufferedDuration(currentBufferedPosition);
            playerPlayerStatsModel.setDistanceFromLive(distanceFromLive);
            PlayerStatsListener playerStatsListener = this.playerStatsListener;
            if (playerStatsListener != null) {
                playerStatsListener.onEventUpdate(playerPlayerStatsModel);
            }
        }
    }

    public void onBandwidthEstimate(@NotNull AnalyticsListener.EventTime eventTime, int totalLoadTimeMs, long totalBytesLoaded, long bitrateEstimate) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
            super.onBandwidthEstimate(eventTime, totalLoadTimeMs, totalBytesLoaded, bitrateEstimate);
            PlayerStatsModel playerStatsModel = this.playerPlayerStatsModel;
            if (playerStatsModel == null) break block0;
            playerStatsModel.setBandwidth(new PlayerStatsModel.Bandwidth(bitrateEstimate, totalBytesLoaded, eventTime));
        }
    }

    public void onPlayerError(@NotNull AnalyticsListener.EventTime eventTime, @NotNull PlaybackException error) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            super.onPlayerError(eventTime, error);
            int n = error.errorCode;
            String string = String.valueOf(error.getMessage());
            String string2 = String.valueOf(error.getMessage());
            String string3 = String.valueOf(error.getMessage());
            HMSException hmsException = new HMSException(n, "hlsstream.failure", string, string3, string2, (Throwable)error, true, null, 128, null);
            PlayerStatsListener playerStatsListener = this.playerStatsListener;
            if (playerStatsListener != null) {
                playerStatsListener.onError(hmsException);
            }
            HMSSDK hMSSDK = this.hmsSdk;
            if (hMSSDK == null) break block1;
            hMSSDK.sendErrorEvent(hmsException);
        }
    }

    public void onVideoInputFormatChanged(@NotNull AnalyticsListener.EventTime eventTime, @NotNull Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            super.onVideoInputFormatChanged(eventTime, format, decoderReuseEvaluation);
            PlayerStatsModel playerStatsModel = this.playerPlayerStatsModel;
            if (playerStatsModel == null) break block0;
            int n = format.height;
            int n2 = format.width;
            float f = format.frameRate;
            int n3 = format.bitrate;
            playerStatsModel.setVideoInfo(new PlayerStatsModel.VideoInfo(n, n2, n3, f, eventTime));
        }
    }

    public void onDroppedVideoFrames(@NotNull AnalyticsListener.EventTime eventTime, int droppedFrames, long elapsedMs) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
            super.onDroppedVideoFrames(eventTime, droppedFrames, elapsedMs);
            PlayerStatsModel playerStatsModel = this.playerPlayerStatsModel;
            if (playerStatsModel == null) break block0;
            playerStatsModel.setFrameInfo(new PlayerStatsModel.FrameInfo(droppedFrames, 0, eventTime, 2, null));
        }
    }

    private static final void init$lambda$2(PlayerEventsCollector this$0) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.fireEvent();
            Runnable runnable = this$0.eventsRunnable;
            if (runnable == null) break block1;
            Runnable it = runnable;
            boolean bl = false;
            Handler handler = this$0.eventsHandler;
            if (handler != null) {
                handler.postDelayed(it, this$0.initConfig.getEventRate());
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llive/hms/stats/PlayerEventsCollector$Companion;", "", "<init>", "()V", "TAG", "", "stats_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

