/*
 * Decompiled with CFR 0.152.
 */
package live.hms.stats;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.decoder.DecoderReuseEvaluation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.stats.PlayerEventsListener;
import live.hms.stats.model.InitConfig;
import live.hms.stats.model.PlayerStats;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002J(\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J \u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0019H\u0016J\"\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0006\u0010#\u001a\u00020\u0010R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Llive/hms/stats/PlayerEventsCollector;", "Lcom/google/android/exoplayer2/analytics/AnalyticsListener;", "exoPlayer", "Lcom/google/android/exoplayer2/ExoPlayer;", "initConfig", "Llive/hms/stats/model/InitConfig;", "(Lcom/google/android/exoplayer2/ExoPlayer;Llive/hms/stats/model/InitConfig;)V", "eventsHandler", "Landroid/os/Handler;", "eventsRunnable", "Ljava/lang/Runnable;", "playerEventsListener", "Llive/hms/stats/PlayerEventsListener;", "playerPlayerStats", "Llive/hms/stats/model/PlayerStats;", "addListener", "", "fireEvent", "init", "onBandwidthEstimate", "eventTime", "Lcom/google/android/exoplayer2/analytics/AnalyticsListener$EventTime;", "totalLoadTimeMs", "", "totalBytesLoaded", "", "bitrateEstimate", "onDroppedVideoFrames", "droppedFrames", "elapsedMs", "onVideoInputFormatChanged", "format", "Lcom/google/android/exoplayer2/Format;", "decoderReuseEvaluation", "Lcom/google/android/exoplayer2/decoder/DecoderReuseEvaluation;", "removeListener", "Companion", "stats_release"})
public final class PlayerEventsCollector
implements AnalyticsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExoPlayer exoPlayer;
    @NotNull
    private final InitConfig initConfig;
    @Nullable
    private PlayerEventsListener playerEventsListener;
    @Nullable
    private PlayerStats playerPlayerStats;
    @Nullable
    private Handler eventsHandler;
    @Nullable
    private Runnable eventsRunnable;
    @NotNull
    public static final String TAG = "PlayerEventsCollector";

    public PlayerEventsCollector(@NotNull ExoPlayer exoPlayer, @NotNull InitConfig initConfig) {
        Intrinsics.checkNotNullParameter((Object)exoPlayer, (String)"exoPlayer");
        Intrinsics.checkNotNullParameter((Object)initConfig, (String)"initConfig");
        this.exoPlayer = exoPlayer;
        this.initConfig = initConfig;
        this.playerPlayerStats = new PlayerStats(null, null, null, 0L, 0L, 31, null);
    }

    public /* synthetic */ PlayerEventsCollector(ExoPlayer exoPlayer, InitConfig initConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            initConfig = new InitConfig(0L, 1, null);
        }
        this(exoPlayer, initConfig);
    }

    public final void removeListener() {
        Runnable runnable = this.eventsRunnable;
        if (runnable != null) {
            Runnable runnable2 = runnable;
            boolean bl = false;
            boolean bl2 = false;
            Runnable it = runnable2;
            boolean bl3 = false;
            Handler handler = this.eventsHandler;
            if (handler != null) {
                handler.removeCallbacks(it);
            }
        }
        this.exoPlayer.removeAnalyticsListener((AnalyticsListener)this);
    }

    public final void addListener(@NotNull PlayerEventsListener playerEventsListener) {
        Intrinsics.checkNotNullParameter((Object)playerEventsListener, (String)"playerEventsListener");
        this.playerEventsListener = playerEventsListener;
        this.init();
    }

    private final void init() {
        this.removeListener();
        this.exoPlayer.addAnalyticsListener((AnalyticsListener)this);
        this.eventsRunnable = () -> PlayerEventsCollector.init$lambda-2(this);
        this.eventsHandler = new Handler(Looper.getMainLooper());
        Runnable runnable = this.eventsRunnable;
        if (runnable != null) {
            Runnable runnable2 = runnable;
            boolean bl = false;
            boolean bl2 = false;
            Runnable it = runnable2;
            boolean bl3 = false;
            Handler handler = this.eventsHandler;
            if (handler != null) {
                handler.post(it);
            }
        }
    }

    private final void fireEvent() {
        long currentBufferedPosition = this.exoPlayer.getBufferedPosition() - this.exoPlayer.getCurrentPosition();
        long distanceFromLive = this.exoPlayer.getDuration() - this.exoPlayer.getCurrentPosition();
        int videoHeight = this.exoPlayer.getVideoSize().height;
        int videoWidth = this.exoPlayer.getVideoSize().width;
        PlayerStats playerStats = this.playerPlayerStats;
        if (playerStats != null) {
            Object object;
            PlayerStats playerStats2 = playerStats;
            boolean bl = false;
            boolean bl2 = false;
            PlayerStats playerPlayerStatsModel = playerStats2;
            boolean bl3 = false;
            playerPlayerStatsModel.setCurrentBufferedPosition(currentBufferedPosition);
            playerPlayerStatsModel.setDistanceFromLive(distanceFromLive);
            PlayerStats playerStats3 = this.playerPlayerStats;
            Object object2 = object = playerStats3 == null ? null : playerStats3.getVideoInfo();
            if (object != null) {
                ((PlayerStats.VideoInfo)object).setVideoHeight(videoHeight);
            }
            playerStats3 = this.playerPlayerStats;
            Object object3 = object = playerStats3 == null ? null : playerStats3.getVideoInfo();
            if (object != null) {
                ((PlayerStats.VideoInfo)object).setVideoWidth(videoWidth);
            }
            object = this.playerEventsListener;
            if (object != null) {
                object.onEventUpdate(playerPlayerStatsModel);
            }
        }
    }

    public void onBandwidthEstimate(@NotNull AnalyticsListener.EventTime eventTime, int totalLoadTimeMs, long totalBytesLoaded, long bitrateEstimate) {
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        super.onBandwidthEstimate(eventTime, totalLoadTimeMs, totalBytesLoaded, bitrateEstimate);
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"bandwidth Estimate : ", (Object)bitrateEstimate));
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"totalBytesLoaded : ", (Object)totalBytesLoaded));
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"event time  : ", (Object)eventTime.realtimeMs));
        PlayerStats playerStats = this.playerPlayerStats;
        if (playerStats != null) {
            playerStats.setBandwidth(new PlayerStats.Bandwidth(bitrateEstimate, totalBytesLoaded, eventTime));
        }
    }

    public void onVideoInputFormatChanged(@NotNull AnalyticsListener.EventTime eventTime, @NotNull Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        super.onVideoInputFormatChanged(eventTime, format, decoderReuseEvaluation);
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"frame rate  : ", (Object)Float.valueOf(format.frameRate)));
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"video height  : ", (Object)format.height));
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"video width  : ", (Object)format.width));
        PlayerStats playerStats = this.playerPlayerStats;
        if (playerStats != null) {
            float f = format.frameRate;
            int n = format.bitrate;
            playerStats.setVideoInfo(new PlayerStats.VideoInfo(0, 0, n, f, eventTime, 3, null));
        }
    }

    public void onDroppedVideoFrames(@NotNull AnalyticsListener.EventTime eventTime, int droppedFrames, long elapsedMs) {
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        super.onDroppedVideoFrames(eventTime, droppedFrames, elapsedMs);
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"dropped frames  : ", (Object)droppedFrames));
        PlayerStats playerStats = this.playerPlayerStats;
        if (playerStats != null) {
            playerStats.setFrameInfo(new PlayerStats.FrameInfo(droppedFrames, 0, eventTime, 2, null));
        }
    }

    private static final void init$lambda-2(PlayerEventsCollector this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.fireEvent();
        Runnable runnable = this$0.eventsRunnable;
        if (runnable != null) {
            Runnable runnable2 = runnable;
            boolean bl = false;
            boolean bl2 = false;
            Runnable it = runnable2;
            boolean bl3 = false;
            Handler handler = this$0.eventsHandler;
            if (handler != null) {
                handler.postDelayed(it, this$0.initConfig.getEventRate());
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/stats/PlayerEventsCollector$Companion;", "", "()V", "TAG", "", "stats_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

