/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk.managers;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.error.HMSException;
import live.hms.video.sdk.SDKStore;
import live.hms.video.sdk.managers.IManager;
import live.hms.video.sdk.models.HMSBrowserRecordingState;
import live.hms.video.sdk.models.HMSHlsRecordingConfig;
import live.hms.video.sdk.models.HMSNotifications;
import live.hms.video.sdk.models.HMSRoom;
import live.hms.video.sdk.models.HMSServerRecordingState;
import live.hms.video.sdk.models.HmsHlsRecordingState;
import live.hms.video.sdk.models.RecordingType;
import live.hms.video.sdk.models.SDKUpdate;
import live.hms.video.sdk.models.enums.HMSRecordingState;
import live.hms.video.sdk.models.enums.HMSRoomUpdate;
import live.hms.video.sdk.peerlist.models.BeamRecordingStates;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Llive/hms/video/sdk/managers/RecordingUpdateManager;", "Llive/hms/video/sdk/managers/IManager;", "Llive/hms/video/sdk/models/HMSNotifications$RecordUpdateNotification;", "store", "Llive/hms/video/sdk/SDKStore;", "<init>", "(Llive/hms/video/sdk/SDKStore;)V", "getStore", "()Llive/hms/video/sdk/SDKStore;", "manage", "", "Llive/hms/video/sdk/models/SDKUpdate;", "params", "lib_release"})
public final class RecordingUpdateManager
implements IManager<HMSNotifications.RecordUpdateNotification> {
    @NotNull
    private final SDKStore store;

    public RecordingUpdateManager(@NotNull SDKStore store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.store = store;
    }

    @Override
    @NotNull
    public SDKStore getStore() {
        return this.store;
    }

    @Override
    @NotNull
    public List<SDKUpdate> manage(@NotNull HMSNotifications.RecordUpdateNotification params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        HMSRoom hMSRoom = this.getStore().get_room();
        if (hMSRoom == null) {
            return CollectionsKt.emptyList();
        }
        HMSRoom localRoom = hMSRoom;
        List updates2 = new ArrayList();
        switch (WhenMappings.$EnumSwitchMapping$0[params.getType().ordinal()]) {
            case 1: {
                BeamRecordingStates beamRecordingStates = params.getState();
                if (localRoom.getServerRecordingState().getState() == (beamRecordingStates != null ? beamRecordingStates.toHMSRecordingState() : null)) break;
                boolean bl = params.getState() == BeamRecordingStates.started || params.getState() == BeamRecordingStates.resumed;
                HMSNotifications.ServerError serverError = params.getError();
                HMSException hMSException = serverError != null ? serverError.toHmsException() : null;
                Long l = params.getStartedAt();
                Enum enum_ = params.getState();
                if (enum_ == null || (enum_ = ((BeamRecordingStates)enum_).toHMSRecordingState()) == null) {
                    enum_ = HMSRecordingState.NONE;
                }
                localRoom.setServerRecordingState$lib_release(new HMSServerRecordingState(bl, hMSException, l, (HMSRecordingState)enum_));
                updates2.add(new SDKUpdate.Room(HMSRoomUpdate.SERVER_RECORDING_STATE_UPDATED));
                break;
            }
            case 2: {
                BeamRecordingStates beamRecordingStates = params.getState();
                if (localRoom.getBrowserRecordingState().getState() == (beamRecordingStates != null ? beamRecordingStates.toHMSRecordingState() : null)) break;
                boolean bl = params.getState() == BeamRecordingStates.started || params.getState() == BeamRecordingStates.resumed;
                HMSNotifications.ServerError serverError = params.getError();
                HMSException hMSException = serverError != null ? serverError.toHmsException() : null;
                Long l = params.getStartedAt();
                Long l2 = params.getStoppedAt();
                boolean bl2 = params.getState() == BeamRecordingStates.initialised;
                Enum enum_ = params.getState();
                if (enum_ == null || (enum_ = ((BeamRecordingStates)enum_).toHMSRecordingState()) == null) {
                    enum_ = HMSRecordingState.NONE;
                }
                localRoom.setBrowserRecordingState$lib_release(new HMSBrowserRecordingState(bl, hMSException, l, l2, bl2, (HMSRecordingState)enum_));
                updates2.add(new SDKUpdate.Room(HMSRoomUpdate.BROWSER_RECORDING_STATE_UPDATED));
                break;
            }
            case 3: {
                BeamRecordingStates beamRecordingStates = params.getState();
                if (localRoom.getHlsRecordingState().getState() == (beamRecordingStates != null ? beamRecordingStates.toHMSRecordingState() : null)) break;
                Boolean bl = params.getState() == BeamRecordingStates.started || params.getState() == BeamRecordingStates.resumed;
                Long l = params.getStartedAt();
                HMSHlsRecordingConfig hMSHlsRecordingConfig = localRoom.getHlsRecordingState().getHlsRecordingConfig();
                HMSNotifications.ServerError serverError = params.getError();
                HMSException hMSException = serverError != null ? serverError.toHmsException() : null;
                Enum enum_ = params.getState();
                if (enum_ == null || (enum_ = ((BeamRecordingStates)enum_).toHMSRecordingState()) == null) {
                    enum_ = HMSRecordingState.NONE;
                }
                localRoom.setHlsRecordingState$lib_release(new HmsHlsRecordingState(bl, l, hMSHlsRecordingConfig, hMSException, (HMSRecordingState)enum_));
                updates2.add(new SDKUpdate.Room(HMSRoomUpdate.HLS_RECORDING_STATE_UPDATED));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return updates2;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RecordingType.values().length];
            try {
                nArray[RecordingType.SFU.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordingType.BROWSER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordingType.HLS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

