/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import live.hms.video.media.settings.HMSLayer;
import live.hms.video.media.settings.HMSSimulcastLayerDefinition;
import live.hms.video.media.settings.HMSVideoResolution;
import live.hms.video.media.tracks.HMSRemoteAudioTrack;
import live.hms.video.media.tracks.HMSRemoteTrack;
import live.hms.video.media.tracks.HMSRemoteVideoTrack;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.media.tracks.HMSTrackType;
import live.hms.video.sdk.SDKStore;
import live.hms.video.sdk.managers.IManager;
import live.hms.video.sdk.models.HMSNotifications;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.sdk.models.HMSRemotePeer;
import live.hms.video.sdk.models.SDKUpdate;
import live.hms.video.sdk.models.enums.HMSTrackUpdate;
import live.hms.video.sdk.models.role.HMSRole;
import live.hms.video.sdk.models.role.LayerParams;
import live.hms.video.sdk.models.role.PublishParams;
import live.hms.video.sdk.models.role.Simulcast;
import live.hms.video.sdk.models.role.VideoParams;
import live.hms.video.sdk.models.role.VideoSimulcastLayersParams;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0002H\u0016J-\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0015\u001a\u00020\u0016J(\u0010\u0017\u001a\u00020\u0018*\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Llive/hms/video/sdk/managers/OnTrackAddManager;", "Llive/hms/video/sdk/managers/IManager;", "Llive/hms/video/sdk/models/HMSNotifications$TrackMetadata;", "store", "Llive/hms/video/sdk/SDKStore;", "<init>", "(Llive/hms/video/sdk/SDKStore;)V", "getStore", "()Llive/hms/video/sdk/SDKStore;", "manage", "", "Llive/hms/video/sdk/models/SDKUpdate;", "params", "manageMetadata", "", "data", "Llive/hms/video/sdk/models/HMSNotifications$Track;", "peerId", "", "(Llive/hms/video/sdk/models/HMSNotifications$Track;Ljava/lang/String;Llive/hms/video/sdk/models/HMSNotifications$TrackMetadata;)[Llive/hms/video/sdk/models/SDKUpdate;", "manageNativeTrack", "track", "Llive/hms/video/media/tracks/HMSTrack;", "addSimulcastLayerDefinitionFromPeer", "", "peer", "Llive/hms/video/sdk/models/HMSRemotePeer;", "rolesMap", "", "Llive/hms/video/sdk/models/role/HMSRole;", "applyPeerToTrack", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nOnTrackAddManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OnTrackAddManager.kt\nlive/hms/video/sdk/managers/OnTrackAddManager\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n37#2,2:245\n1557#3:247\n1628#3,3:248\n*S KotlinDebug\n*F\n+ 1 OnTrackAddManager.kt\nlive/hms/video/sdk/managers/OnTrackAddManager\n*L\n96#1:245,2\n222#1:247\n222#1:248,3\n*E\n"})
public final class OnTrackAddManager
implements IManager<HMSNotifications.TrackMetadata> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SDKStore store;
    @NotNull
    private static final String TAG = "OnTrackAddManager";

    public OnTrackAddManager(@NotNull SDKStore store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.store = store;
    }

    @Override
    @NotNull
    public SDKStore getStore() {
        return this.store;
    }

    @Override
    @NotNull
    public List<SDKUpdate> manage(@NotNull HMSNotifications.TrackMetadata params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        ArrayList updates2 = new ArrayList();
        for (HMSNotifications.Track data : params.getTracks()) {
            CollectionsKt.addAll((Collection)updates2, (Object[])this.manageMetadata(data, params.getPeer().getPeerId(), params));
        }
        return updates2;
    }

    @NotNull
    public final SDKUpdate[] manageMetadata(@NotNull HMSNotifications.Track data, @NotNull String peerId, @Nullable HMSNotifications.TrackMetadata params) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
        ArrayList<SDKUpdate.Track> updates2 = new ArrayList<SDKUpdate.Track>();
        HMSPeer hmsPeer = null;
        hmsPeer = this.getStore().getPeerById(peerId);
        if (hmsPeer == null) {
            HMSNotifications.TrackMetadata trackMetadata = params;
            if (trackMetadata != null) {
                HMSNotifications.TrackMetadata it = trackMetadata;
                boolean bl = false;
                hmsPeer = this.getStore().add(it.getPeer().toPeerJoin());
            }
        }
        HMSPeer hMSPeer = hmsPeer;
        if (hMSPeer != null) {
            HMSPeer peer = hMSPeer;
            boolean bl = false;
            HMSRemotePeer cfr_ignored_0 = (HMSRemotePeer)peer;
            HMSTrack hMSTrack = this.getStore().getNativeTrackById(data.getTrackId());
            if (hMSTrack != null) {
                HMSTrack track = hMSTrack;
                boolean bl2 = false;
                this.getStore().updateRTCTrack(data);
                this.applyPeerToTrack((HMSRemotePeer)peer, track);
                updates2.add(new SDKUpdate.Track(HMSTrackUpdate.TRACK_ADDED, track, peer));
            }
            this.getStore().addTrackMetadata(data, peerId);
        }
        Collection $this$toTypedArray$iv = updates2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new SDKUpdate[0]);
    }

    public static /* synthetic */ SDKUpdate[] manageMetadata$default(OnTrackAddManager onTrackAddManager, HMSNotifications.Track track, String string, HMSNotifications.TrackMetadata trackMetadata, int n, Object object) {
        if ((n & 4) != 0) {
            trackMetadata = null;
        }
        return onTrackAddManager.manageMetadata(track, string, trackMetadata);
    }

    @NotNull
    public final List<SDKUpdate> manageNativeTrack(@NotNull HMSTrack track) {
        HMSTrack remoteTrack;
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        List updates2 = new ArrayList();
        SDKStore.TrackMetadataPair trackMetadataPair = this.getStore().getTrackMetadata(track.getTrackId());
        if (trackMetadataPair != null) {
            SDKStore.TrackMetadataPair trackMetadata = trackMetadataPair;
            boolean bl = false;
            HMSLogger.d(TAG, "Track metadata already present for trackId : " + track.getTrackId());
            HMSPeer hMSPeer = this.getStore().getPeerById(trackMetadata.getPeerId());
            if (hMSPeer != null) {
                HMSPeer peer = hMSPeer;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)peer, (String)"null cannot be cast to non-null type live.hms.video.sdk.models.HMSRemotePeer");
                HMSRemotePeer cfr_ignored_0 = (HMSRemotePeer)peer;
                HMSTrack hMSTrack = this.getStore().getNativeTrackById(track.getTrackId());
                if (hMSTrack != null) {
                    HMSTrack currentTrack = hMSTrack;
                    boolean bl3 = false;
                    HMSRemoteTrack cfr_ignored_1 = (HMSRemoteTrack)((Object)currentTrack);
                    HMSLogger.d(TAG, "TRACK%% tracks old_ssrc:" + ((HMSRemoteTrack)((Object)currentTrack)).getSsrc() + "  new_ssrc:" + ((HMSRemoteTrack)((Object)track)).getSsrc());
                    if (((HMSRemoteTrack)((Object)currentTrack)).getSsrc() != ((HMSRemoteTrack)((Object)track)).getSsrc()) {
                        HMSRemotePeer hMSRemotePeer;
                        String string = peer.getPeerID();
                        String string2 = peer.getCustomerUserID();
                        Intrinsics.checkNotNull((Object)string2);
                        HMSRemotePeer $this$manageNativeTrack_u24lambda_u248_u24lambda_u246_u24lambda_u244_u24lambda_u243 = hMSRemotePeer = new HMSRemotePeer(string, string2, peer.getName(), peer.getHmsRole(), peer.getJoinedAt(), null, peer.getType(), 32, null);
                        boolean bl4 = false;
                        $this$manageNativeTrack_u24lambda_u248_u24lambda_u246_u24lambda_u244_u24lambda_u243.setGroups$lib_release(peer.getGroups$lib_release());
                        HMSRemotePeer currentPeer = hMSRemotePeer;
                        currentPeer.setAudioTrack$lib_release(((HMSRemotePeer)peer).getAudioTrack());
                        currentPeer.setVideoTrack$lib_release(((HMSRemotePeer)peer).getVideoTrack());
                        switch (WhenMappings.$EnumSwitchMapping$0[track.getType().ordinal()]) {
                            case 1: {
                                currentPeer.setAudioTrack$lib_release(null);
                                break;
                            }
                            case 2: {
                                currentPeer.setVideoTrack$lib_release(null);
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        HMSLogger.INSTANCE.i(TAG, "TRACK%% RECEIVED_ADDREQ_SEND_TRACK_REMOVE type: " + (Object)((Object)track.getType()) + " audioTrack:" + currentPeer.getAudioTrack() + " videoTrack: " + currentPeer.getVideoTrack() + ' ');
                        this.getStore().removeNativeTrack(currentTrack);
                        updates2.add(new SDKUpdate.Track(HMSTrackUpdate.TRACK_REMOVED, currentTrack, currentPeer));
                    }
                } else {
                    OnTrackAddManager $this$manageNativeTrack_u24lambda_u248_u24lambda_u246_u24lambda_u245 = this;
                    boolean bl5 = false;
                    HMSLogger.d(TAG, "No native track exists in store with trackId : " + track.getTrackId());
                }
                this.getStore().addNativeTrack(track);
                this.getStore().updateRTCTrack(trackMetadata.getTrackData());
                this.applyPeerToTrack((HMSRemotePeer)peer, track);
                updates2.add(new SDKUpdate.Track(HMSTrackUpdate.TRACK_ADDED, track, peer));
            } else {
                OnTrackAddManager $this$manageNativeTrack_u24lambda_u248_u24lambda_u247 = this;
                boolean bl6 = false;
                HMSLogger.e(TAG, "No peer found for trackID : " + track.getTrackId());
            }
        } else {
            OnTrackAddManager $this$manageNativeTrack_u24lambda_u249 = this;
            boolean bl = false;
            HMSLogger.d(TAG, "Track metadata not yet received for trackId : " + track.getTrackId());
            $this$manageNativeTrack_u24lambda_u249.getStore().addNativeTrack(track);
        }
        if (this.getStore().getLocalTracksMute() && (remoteTrack = this.getStore().getNativeTrackById(track.getTrackId())) instanceof HMSRemoteAudioTrack) {
            ((HMSRemoteAudioTrack)remoteTrack).setVolume(0.0);
        }
        return updates2;
    }

    /*
     * WARNING - void declaration
     */
    private final void addSimulcastLayerDefinitionFromPeer(HMSTrack $this$addSimulcastLayerDefinitionFromPeer, HMSRemotePeer peer, Map<String, HMSRole> rolesMap) {
        block4: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object = rolesMap.get(peer.getHmsRole().getName());
            VideoSimulcastLayersParams simulcastRemoteParams = object != null && (object = ((HMSRole)object).getPublishParams()) != null && (object = ((PublishParams)object).getSimulcast()) != null ? ((Simulcast)object).getVideo() : null;
            Object object2 = rolesMap.get(peer.getHmsRole().getName());
            VideoParams videoParams = object2 != null && (object2 = ((HMSRole)object2).getPublishParams()) != null ? ((PublishParams)object2).getVideo() : null;
            VideoSimulcastLayersParams videoSimulcastLayersParams = simulcastRemoteParams;
            List list = videoSimulcastLayersParams != null ? videoSimulcastLayersParams.getLayers() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable iterable = list;
            boolean $i$f$map = false;
            void var9_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void layer;
                LayerParams layerParams = (LayerParams)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                VideoParams videoParams2 = videoParams;
                int n = videoParams2 != null ? videoParams2.getWidth() : 0;
                Number number = layer.getScaleResolutionDownBy();
                if (number == null) {
                    number = 1;
                }
                int n2 = n / ((Number)number).intValue();
                VideoParams videoParams3 = videoParams;
                int n3 = videoParams3 != null ? videoParams3.getHeight() : 0;
                Number number2 = layer.getScaleResolutionDownBy();
                if (number2 == null) {
                    number2 = 1;
                }
                collection.add(new HMSSimulcastLayerDefinition(new HMSVideoResolution(n2, n3 / ((Number)number2).intValue()), OnTrackAddManager.addSimulcastLayerDefinitionFromPeer$ridToHMSLayerMapper((LayerParams)layer)));
            }
            List hmsSimulcastLayerDefinitions = (List)destination$iv$iv;
            HMSRemoteVideoTrack hMSRemoteVideoTrack = $this$addSimulcastLayerDefinitionFromPeer instanceof HMSRemoteVideoTrack ? (HMSRemoteVideoTrack)$this$addSimulcastLayerDefinitionFromPeer : null;
            if (hMSRemoteVideoTrack == null) break block4;
            hMSRemoteVideoTrack.setLayerDefinition$lib_release(hmsSimulcastLayerDefinitions);
        }
    }

    private final void applyPeerToTrack(HMSRemotePeer peer, HMSTrack track) {
        block5: {
            block4: {
                if (!Intrinsics.areEqual((Object)track.getSource(), (Object)"regular")) break block4;
                switch (WhenMappings.$EnumSwitchMapping$0[track.getType().ordinal()]) {
                    case 1: {
                        Intrinsics.checkNotNull((Object)track, (String)"null cannot be cast to non-null type live.hms.video.media.tracks.HMSRemoteAudioTrack");
                        peer.setAudioTrack$lib_release((HMSRemoteAudioTrack)track);
                        break block5;
                    }
                    case 2: {
                        Intrinsics.checkNotNull((Object)track, (String)"null cannot be cast to non-null type live.hms.video.media.tracks.HMSRemoteVideoTrack");
                        peer.setVideoTrack$lib_release((HMSRemoteVideoTrack)track);
                        break block5;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            peer.getAuxiliaryTracks().add(track);
        }
        this.addSimulcastLayerDefinitionFromPeer(track, peer, this.getStore().getRolesMap());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final HMSLayer addSimulcastLayerDefinitionFromPeer$ridToHMSLayerMapper(LayerParams layerParams) {
        HMSLayer hMSLayer;
        String string = layerParams.getRid();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 113: {
                    if (!string.equals("q")) break;
                    n = 1;
                    break;
                }
                case 102: {
                    if (!string.equals("f")) break;
                    n = 2;
                    break;
                }
                case 104: {
                    if (!string.equals("h")) break;
                    n = 3;
                    break;
                }
            }
            switch (n) {
                case 2: {
                    hMSLayer = HMSLayer.HIGH;
                    return hMSLayer;
                }
                case 3: {
                    hMSLayer = HMSLayer.MEDIUM;
                    return hMSLayer;
                }
                case 1: {
                    hMSLayer = HMSLayer.LOW;
                    return hMSLayer;
                }
            }
        }
        hMSLayer = HMSLayer.HIGH;
        return hMSLayer;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llive/hms/video/sdk/managers/OnTrackAddManager$Companion;", "", "<init>", "()V", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HMSTrackType.values().length];
            try {
                nArray[HMSTrackType.AUDIO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSTrackType.VIDEO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

