/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.streams;

import hms.webrtc.MediaStream;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.connection.subscribe.HMSSubscribeConnection;
import live.hms.video.media.settings.HMSSimulcastLayer;
import live.hms.video.media.streams.HMSMediaStream;
import live.hms.video.media.streams.models.PreferLayer;
import live.hms.video.media.streams.models.PreferLayerAudio;
import live.hms.video.media.streams.models.PreferStateResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Llive/hms/video/media/streams/HMSRemoteStream;", "Llive/hms/video/media/streams/HMSMediaStream;", "nativeStream", "Lhms/webrtc/MediaStream;", "connection", "Llive/hms/video/connection/subscribe/HMSSubscribeConnection;", "<init>", "(Lhms/webrtc/MediaStream;Llive/hms/video/connection/subscribe/HMSSubscribeConnection;)V", "shouldSubscribeToAudio", "", "videoSimulcastLayer", "Llive/hms/video/media/settings/HMSSimulcastLayer;", "frameRate", "setAudio", "", "trackId", "", "isEnabled", "(Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setVideo", "Llive/hms/video/media/streams/models/PreferStateResponse;", "layer", "(Llive/hms/video/media/settings/HMSSimulcastLayer;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "compareNative", "with", "lib_release"})
public final class HMSRemoteStream
extends HMSMediaStream {
    @NotNull
    private final HMSSubscribeConnection connection;
    private boolean shouldSubscribeToAudio;
    @NotNull
    private HMSSimulcastLayer videoSimulcastLayer;
    @NotNull
    private HMSSimulcastLayer frameRate;

    public HMSRemoteStream(@NotNull MediaStream nativeStream, @NotNull HMSSubscribeConnection connection) {
        Intrinsics.checkNotNullParameter((Object)nativeStream, (String)"nativeStream");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        super(nativeStream);
        this.connection = connection;
        this.shouldSubscribeToAudio = true;
        this.videoSimulcastLayer = HMSSimulcastLayer.HIGH;
        this.frameRate = HMSSimulcastLayer.HIGH;
    }

    @Nullable
    public final Object setAudio(@NotNull String trackId, boolean isEnabled, @NotNull Continuation<? super Unit> $completion) {
        this.shouldSubscribeToAudio = isEnabled;
        Object object = this.connection.sendOverApiDataChannel(new PreferLayerAudio(trackId, this.shouldSubscribeToAudio), false, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object setVideo(@NotNull HMSSimulcastLayer layer, @NotNull String trackId, @NotNull Continuation<? super PreferStateResponse> $completion) {
        this.videoSimulcastLayer = layer;
        String string = this.videoSimulcastLayer.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return this.connection.sendOverApiDataChannel(new PreferLayer(trackId, string), true, $completion);
    }

    public final boolean compareNative(@NotNull MediaStream with) {
        Intrinsics.checkNotNullParameter((Object)with, (String)"with");
        return Intrinsics.areEqual((Object)this.getNativeStream(), (Object)with);
    }
}

