/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.audio;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.audio.BluetoothErrorType;
import live.hms.video.media.settings.HMSAudioTrackSettings;
import live.hms.video.media.settings.HMSTrackSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Llive/hms/video/audio/BluetoothPermissionHandler;", "", "hmsTrackSettings", "Llive/hms/video/media/settings/HMSTrackSettings;", "<init>", "(Llive/hms/video/media/settings/HMSTrackSettings;)V", "getHmsTrackSettings", "()Llive/hms/video/media/settings/HMSTrackSettings;", "BLUETOOTH_CONNECT_PERMISSION", "", "getBLUETOOTH_CONNECT_PERMISSION", "()Ljava/lang/String;", "hasPermission", "", "context", "Landroid/content/Context;", "permission", "hasBluetoothError", "Llive/hms/video/audio/BluetoothErrorType;", "isDeviceAndroid12AndAbove", "isTargetingAndroid12AndAbove", "lib_release"})
public final class BluetoothPermissionHandler {
    @NotNull
    private final HMSTrackSettings hmsTrackSettings;
    @NotNull
    private final String BLUETOOTH_CONNECT_PERMISSION;

    public BluetoothPermissionHandler(@NotNull HMSTrackSettings hmsTrackSettings) {
        Intrinsics.checkNotNullParameter((Object)hmsTrackSettings, (String)"hmsTrackSettings");
        this.hmsTrackSettings = hmsTrackSettings;
        this.BLUETOOTH_CONNECT_PERMISSION = "android.permission.BLUETOOTH_CONNECT";
    }

    @NotNull
    public final HMSTrackSettings getHmsTrackSettings() {
        return this.hmsTrackSettings;
    }

    @NotNull
    public final String getBLUETOOTH_CONNECT_PERMISSION() {
        return this.BLUETOOTH_CONNECT_PERMISSION;
    }

    private final boolean hasPermission(Context context, String permission) {
        return context.checkPermission(permission, Process.myPid(), Process.myUid()) == 0;
    }

    @Nullable
    public final BluetoothErrorType hasBluetoothError(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean noBluetoothPermission = !this.hasPermission(context, "android.permission.BLUETOOTH");
        BluetoothErrorType error = null;
        HMSAudioTrackSettings hMSAudioTrackSettings = this.hmsTrackSettings.getAudioSettings();
        boolean bl = hMSAudioTrackSettings != null ? hMSAudioTrackSettings.getDisableInternalAudioManager() : false;
        if (bl) {
            error = null;
        } else if (noBluetoothPermission) {
            error = BluetoothErrorType.NO_BLUETOOTH_PERMISSON;
        }
        return error;
    }

    private final boolean isDeviceAndroid12AndAbove() {
        return Build.VERSION.SDK_INT > 30;
    }

    private final boolean isTargetingAndroid12AndAbove(Context context) {
        return context.getApplicationInfo().targetSdkVersion > 30;
    }
}

