/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.database;

import android.content.Context;
import androidx.room.Database;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import androidx.room.TypeConverters;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteDatabase;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.database.converters.TypeConverter;
import live.hms.video.database.dao.AnalyticsEventsDao;
import live.hms.video.database.entity.AnalyticsEntityModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b!\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Llive/hms/video/database/EventsDatabase;", "Landroidx/room/RoomDatabase;", "<init>", "()V", "logDao", "Llive/hms/video/database/dao/AnalyticsEventsDao;", "Companion", "lib_release"})
@Database(entities={AnalyticsEntityModel.class}, version=4, exportSchema=true)
@TypeConverters(value={TypeConverter.class})
public abstract class EventsDatabase
extends RoomDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TABLE_NAME = "analytics_table";
    @NotNull
    private static final Migration MIGRATION_1_2 = new Migration(){

        public void migrate(SupportSQLiteDatabase database) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            database.execSQL("ALTER TABLE analytics_table ADD COLUMN isQa INTEGER DEFAULT 0 NOT NULL");
        }
    };
    @NotNull
    private static final Migration MIGRATION_2_3 = new Migration(){

        public void migrate(SupportSQLiteDatabase database) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            database.execSQL("CREATE TABLE IF NOT EXISTS `temp_analytics_table` (`timestamp` INTEGER NOT NULL, `eventId` TEXT NOT NULL, `payload` TEXT NOT NULL, `eventName` TEXT NOT NULL, `token` TEXT NOT NULL, `isQa` INTEGER NOT NULL, `peerId` TEXT, `role` TEXT, `joinedAt` INTEGER, `leftAt` INTEGER, `roomName` TEXT, `sessionStartedAt` INTEGER, `userData` TEXT, `userName` TEXT, `templateId` TEXT, `sessionId` TEXT, PRIMARY KEY(`eventId`))");
            database.execSQL("INSERT INTO `temp_analytics_table` (timestamp, eventId, payload, eventName, token, isQa, peerId, role, joinedAt, leftAt, roomName, sessionStartedAt, userData, userName, templateId, sessionId) SELECT timestamp as timeStamp,eventId as eventId,payload as payload,eventName as eventName,token as token,isQa as isQa,peerId as peerId,null as role,null as joinedAt,null as leftAt,null as roomName,null as sessionStartedAt,null as userData,null as userName,null as templateId,sessionId as sessionId FROM analytics_table ");
            database.execSQL("DROP TABLE analytics_table");
            database.execSQL("ALTER TABLE `temp_analytics_table` RENAME TO analytics_table");
        }
    };
    @NotNull
    private static final Migration MIGRATION_3_4 = new Migration(){

        public void migrate(SupportSQLiteDatabase database) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            database.execSQL("ALTER TABLE analytics_table ADD COLUMN `websocketUrl` TEXT");
        }
    };
    @Nullable
    private static volatile EventsDatabase INSTANCE;

    @NotNull
    public abstract AnalyticsEventsDao logDao();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Llive/hms/video/database/EventsDatabase$Companion;", "", "<init>", "()V", "TABLE_NAME", "", "MIGRATION_1_2", "Landroidx/room/migration/Migration;", "getMIGRATION_1_2", "()Landroidx/room/migration/Migration;", "MIGRATION_2_3", "getMIGRATION_2_3", "MIGRATION_3_4", "getMIGRATION_3_4", "INSTANCE", "Llive/hms/video/database/EventsDatabase;", "getInstance", "context", "Landroid/content/Context;", "dbName", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Migration getMIGRATION_1_2() {
            return MIGRATION_1_2;
        }

        @NotNull
        public final Migration getMIGRATION_2_3() {
            return MIGRATION_2_3;
        }

        @NotNull
        public final Migration getMIGRATION_3_4() {
            return MIGRATION_3_4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final EventsDatabase getInstance(@NotNull Context context, @NotNull String dbName) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
            EventsDatabase eventsDatabase = INSTANCE;
            if (eventsDatabase != null) {
                EventsDatabase it = eventsDatabase;
                boolean bl = false;
                return it;
            }
            Companion $this$getInstance_u24lambda_u242 = this;
            boolean bl = false;
            Companion companion = $this$getInstance_u24lambda_u242;
            synchronized (companion) {
                boolean bl2 = false;
                Migration[] migrationArray = new Migration[]{$this$getInstance_u24lambda_u242.getMIGRATION_1_2(), $this$getInstance_u24lambda_u242.getMIGRATION_2_3(), $this$getInstance_u24lambda_u242.getMIGRATION_3_4()};
                INSTANCE = (EventsDatabase)Room.databaseBuilder((Context)context, EventsDatabase.class, (String)dbName).addMigrations(migrationArray).build();
                EventsDatabase eventsDatabase2 = INSTANCE;
                Intrinsics.checkNotNull((Object)((Object)eventsDatabase2));
                EventsDatabase eventsDatabase3 = eventsDatabase2;
                return eventsDatabase3;
            }
        }

        public static /* synthetic */ EventsDatabase getInstance$default(Companion companion, Context context, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = EventsDatabase.TABLE_NAME;
            }
            return companion.getInstance(context, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

