/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J)\u0010\u0016\u001a\u00020\u00122!\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00120\u0018J\u0006\u0010\u001c\u001a\u00020\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0015\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006\u001e"}, d2={"Llive/hms/video/utils/NetworkConnectionHelper;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "manager", "Landroid/net/ConnectivityManager;", "callback", "Landroid/net/ConnectivityManager$NetworkCallback;", "wifiNetworkHandle", "", "cellularNetworkHandle", "isWifiConnected", "", "()Z", "isCellularConnected", "updateNetworkInfo", "", "network", "Landroid/net/Network;", "isConnected", "start", "onStatusChange", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "connected", "stop", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nNetworkConnectionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkConnectionHelper.kt\nlive/hms/video/utils/NetworkConnectionHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class NetworkConnectionHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectivityManager manager;
    @Nullable
    private ConnectivityManager.NetworkCallback callback;
    @NotNull
    private String wifiNetworkHandle;
    @NotNull
    private String cellularNetworkHandle;
    @NotNull
    private static final String TAG = "NetworkConnectionHelper";

    public NetworkConnectionHelper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        this.manager = (ConnectivityManager)object;
        this.wifiNetworkHandle = "";
        this.cellularNetworkHandle = "";
    }

    private final boolean isWifiConnected() {
        return !StringsKt.isBlank((CharSequence)this.wifiNetworkHandle);
    }

    private final boolean isCellularConnected() {
        return !StringsKt.isBlank((CharSequence)this.cellularNetworkHandle);
    }

    private final void updateNetworkInfo(Network network) {
        NetworkCapabilities info = this.manager.getNetworkCapabilities(network);
        if (info == null) {
            if (Intrinsics.areEqual((Object)this.wifiNetworkHandle, (Object)network.toString())) {
                this.wifiNetworkHandle = "";
            }
            if (Intrinsics.areEqual((Object)this.cellularNetworkHandle, (Object)network.toString())) {
                this.cellularNetworkHandle = "";
            }
        } else {
            String string = info.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String infoStr = string3;
            if (StringsKt.contains$default((CharSequence)infoStr, (CharSequence)"wifi", (boolean)false, (int)2, null)) {
                this.wifiNetworkHandle = network.toString();
            }
            if (infoStr.contentEquals("cellular")) {
                this.cellularNetworkHandle = network.toString();
            }
        }
    }

    private final boolean isConnected() {
        return this.isWifiConnected() || this.isCellularConnected();
    }

    /*
     * WARNING - void declaration
     */
    public final void start(@NotNull Function1<? super Boolean, Unit> onStatusChange) {
        void $this$start_u24lambda_u241;
        ConnectivityManager.NetworkCallback networkCallback;
        ConnectivityManager.NetworkCallback it;
        Intrinsics.checkNotNullParameter(onStatusChange, (String)"onStatusChange");
        ConnectivityManager.NetworkCallback networkCallback2 = this.callback;
        if (networkCallback2 != null) {
            it = networkCallback2;
            boolean bl = false;
            this.stop();
        }
        NetworkRequest request = new NetworkRequest.Builder().build();
        it = networkCallback = new ConnectivityManager.NetworkCallback(this, onStatusChange){
            final /* synthetic */ NetworkConnectionHelper this$0;
            final /* synthetic */ Function1<Boolean, Unit> $onStatusChange;
            {
                this.this$0 = $receiver;
                this.$onStatusChange = $onStatusChange;
            }

            public void onAvailable(Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                super.onAvailable(network);
                boolean previousIsConnected = NetworkConnectionHelper.access$isConnected(this.this$0);
                NetworkConnectionHelper.access$updateNetworkInfo(this.this$0, network);
                if (!previousIsConnected && NetworkConnectionHelper.access$isConnected(this.this$0)) {
                    this.$onStatusChange.invoke((Object)NetworkConnectionHelper.access$isConnected(this.this$0));
                }
            }

            public void onLost(Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                super.onLost(network);
                NetworkConnectionHelper.access$updateNetworkInfo(this.this$0, network);
                this.$onStatusChange.invoke((Object)NetworkConnectionHelper.access$isConnected(this.this$0));
            }
        };
        NetworkConnectionHelper networkConnectionHelper = this;
        boolean bl = false;
        this.manager.registerNetworkCallback(request, (ConnectivityManager.NetworkCallback)$this$start_u24lambda_u241);
        networkConnectionHelper.callback = networkCallback;
    }

    public final void stop() {
        ConnectivityManager.NetworkCallback networkCallback = this.callback;
        Intrinsics.checkNotNull((Object)networkCallback);
        this.manager.unregisterNetworkCallback(networkCallback);
        this.callback = null;
    }

    public static final /* synthetic */ boolean access$isConnected(NetworkConnectionHelper $this) {
        return $this.isConnected();
    }

    public static final /* synthetic */ void access$updateNetworkInfo(NetworkConnectionHelper $this, Network network) {
        $this.updateNetworkInfo(network);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llive/hms/video/utils/NetworkConnectionHelper$Companion;", "", "<init>", "()V", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

