/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk.managers;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import live.hms.video.sdk.HMSAudioListener;
import live.hms.video.sdk.SDKStore;
import live.hms.video.sdk.managers.IManager;
import live.hms.video.sdk.models.HMSLocalPeer;
import live.hms.video.sdk.models.HMSNotifications;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.sdk.models.HMSSpeaker;
import live.hms.video.sdk.models.HMSSpeakerServerResponse;
import live.hms.video.sdk.models.SDKUpdate;
import live.hms.video.sdk.models.enums.HMSPeerUpdate;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0018B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Llive/hms/video/sdk/managers/ActiveSpeakerManager;", "Llive/hms/video/sdk/managers/IManager;", "Llive/hms/video/sdk/models/HMSNotifications$SpeakerList;", "Ljava/io/Closeable;", "store", "Llive/hms/video/sdk/SDKStore;", "<init>", "(Llive/hms/video/sdk/SDKStore;)V", "getStore", "()Llive/hms/video/sdk/SDKStore;", "audioObserver", "Llive/hms/video/sdk/HMSAudioListener;", "getAudioObserver", "()Llive/hms/video/sdk/HMSAudioListener;", "setAudioObserver", "(Llive/hms/video/sdk/HMSAudioListener;)V", "currentDominantSpeaker", "Llive/hms/video/sdk/models/HMSPeer;", "manage", "", "Llive/hms/video/sdk/models/SDKUpdate;", "params", "close", "", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nActiveSpeakerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActiveSpeakerManager.kt\nlive/hms/video/sdk/managers/ActiveSpeakerManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,74:1\n1557#2:75\n1628#2,3:76\n37#3,2:79\n*S KotlinDebug\n*F\n+ 1 ActiveSpeakerManager.kt\nlive/hms/video/sdk/managers/ActiveSpeakerManager\n*L\n32#1:75\n32#1:76,3\n32#1:79,2\n*E\n"})
public final class ActiveSpeakerManager
implements IManager<HMSNotifications.SpeakerList>,
Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SDKStore store;
    @Nullable
    private HMSAudioListener audioObserver;
    @Nullable
    private HMSPeer currentDominantSpeaker;
    @NotNull
    private static final String TAG = "ActiveSpeakerManager";

    public ActiveSpeakerManager(@NotNull SDKStore store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.store = store;
    }

    @Override
    @NotNull
    public SDKStore getStore() {
        return this.store;
    }

    @Nullable
    public final HMSAudioListener getAudioObserver() {
        return this.audioObserver;
    }

    public final void setAudioObserver(@Nullable HMSAudioListener hMSAudioListener) {
        this.audioObserver = hMSAudioListener;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<SDKUpdate> manage(@NotNull HMSNotifications.SpeakerList params) {
        HMSLocalPeer localPeer;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        HMSAudioListener hMSAudioListener = this.audioObserver;
        if (hMSAudioListener != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = params.getSpeakers();
            HMSAudioListener hMSAudioListener2 = hMSAudioListener;
            boolean $i$f$map = false;
            void var5_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                HMSSpeakerServerResponse hMSSpeakerServerResponse = (HMSSpeakerServerResponse)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toHmsSpeaker$lib_release(this.getStore()));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            hMSAudioListener2.onAudioLevelUpdate(thisCollection$iv.toArray(new HMSSpeaker[0]));
        }
        List updates2 = new ArrayList();
        HMSLocalPeer hMSLocalPeer = localPeer = this.getStore().getLocalPeer();
        if (hMSLocalPeer != null) {
            HMSLocalPeer it = hMSLocalPeer;
            boolean bl = false;
            if (params.getSpeakers().isEmpty()) {
                updates2.add(new SDKUpdate.Peer(HMSPeerUpdate.NO_DOMINANT_SPEAKER, localPeer));
                this.currentDominantSpeaker = null;
            } else {
                HMSPeer hMSPeer;
                HMSSpeakerServerResponse dominantSpeaker = params.getSpeakers().get(0);
                HMSPeer hMSPeer2 = hMSPeer = Intrinsics.areEqual((Object)dominantSpeaker.getPeerId(), (Object)localPeer.getPeerID()) ? (HMSPeer)localPeer : this.getStore().getPeerById(dominantSpeaker.getPeerId());
                if (hMSPeer != null) {
                    HMSPeer peer = hMSPeer;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)peer, (Object)this.currentDominantSpeaker)) {
                        updates2.add(new SDKUpdate.Peer(HMSPeerUpdate.BECAME_DOMINANT_SPEAKER, peer));
                        this.currentDominantSpeaker = peer;
                    }
                } else {
                    HMSLogger.e(TAG, "onActiveSpeakerInfoReceived: no peer found for " + dominantSpeaker + ", store=" + this.getStore());
                }
            }
        } else {
            HMSLogger.e(TAG, "Local Peer is null");
        }
        return updates2;
    }

    @Override
    public void close() {
        this.audioObserver = null;
        this.currentDominantSpeaker = null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llive/hms/video/sdk/managers/ActiveSpeakerManager$Companion;", "", "<init>", "()V", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

