/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.signal.init;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.factories.OkHttpFactory;
import live.hms.video.signal.init.InitConfig;
import live.hms.video.utils.GsonUtils;
import live.hms.video.utils.HMSAgentOs;
import live.hms.video.utils.HMSLogger;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J2\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\b\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Llive/hms/video/signal/init/InitService;", "", "<init>", "()V", "TAG", "", "makeInitRequest", "Lokhttp3/Request;", "endpoint", "token", "region", "hmsAgentOs", "Llive/hms/video/utils/HMSAgentOs;", "fetchInitConfig", "Llive/hms/video/signal/init/InitConfig;", "(Ljava/lang/String;Ljava/lang/String;Llive/hms/video/utils/HMSAgentOs;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib_release"})
public final class InitService {
    @NotNull
    public static final InitService INSTANCE = new InitService();
    @NotNull
    private static final String TAG = "InitService";

    private InitService() {
    }

    private final Request makeInitRequest(String endpoint, String token, String region, HMSAgentOs hmsAgentOs) {
        String agentUrlEncoded = hmsAgentOs.getUserAgentUrlEncoded();
        String url = endpoint + '?' + agentUrlEncoded;
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)region)).toString()).length() > 0) {
            url = url + "&region=" + ((Object)StringsKt.trim((CharSequence)region)).toString();
        }
        Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + token).addHeader("Accept-Type", "application/json").build();
        HMSLogger.d(TAG, "makeInitRequest: request=" + request);
        return request;
    }

    static /* synthetic */ Request makeInitRequest$default(InitService initService, String string, String string2, String string3, HMSAgentOs hMSAgentOs, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "";
        }
        return initService.makeInitRequest(string, string2, string3, hMSAgentOs);
    }

    @Nullable
    public final Object fetchInitConfig(@NotNull String token, @NotNull String region, @NotNull HMSAgentOs hmsAgentOs, @NotNull String endpoint, @NotNull Continuation<? super InitConfig> $completion) {
        Request request = this.makeInitRequest(endpoint, token, region, hmsAgentOs);
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        OkHttpFactory.INSTANCE.getClient().newCall(request).enqueue(new Callback((CompletableDeferred<InitConfig>)deferred){
            final /* synthetic */ CompletableDeferred<InitConfig> $deferred;
            {
                this.$deferred = $deferred;
            }

            public void onFailure(Call call2, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                HMSLogger.INSTANCE.e("InitService", "fetchInitConfig: " + e.getMessage(), e);
                String string = e.getMessage();
                if (string == null) {
                    string = "";
                }
                HMSException ex = ErrorFactory.APIErrors.EndpointUnreachable$default(ErrorFactory.APIErrors.INSTANCE, ErrorFactory.Action.INIT, string, e, null, 8, null);
                this.$deferred.completeExceptionally((Throwable)ex);
            }

            public void onResponse(Call call2, Response response) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                HMSLogger.d("InitService", "fetchInitConfig: response=" + response);
                if (response.code() != 200) {
                    HMSException ex = ErrorFactory.APIErrors.HTTPError$default(ErrorFactory.APIErrors.INSTANCE, response.code(), ErrorFactory.Action.INIT, "Received " + response.message(), null, null, 24, null);
                    this.$deferred.completeExceptionally((Throwable)ex);
                    return;
                }
                Object object = response.body();
                if (object == null || (object = object.string()) == null) {
                    object = "";
                }
                Object body = object;
                try {
                    InitConfig config = (InitConfig)GsonUtils.INSTANCE.getGson().fromJson((String)body, InitConfig.class);
                    HMSLogger.d("InitService", "fetchInitConfig: config=" + config);
                    Intrinsics.checkNotNull((Object)config);
                    this.$deferred.complete((Object)config);
                }
                catch (Exception e) {
                    String string = e.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    HMSException ex = ErrorFactory.GenericErrors.JsonParsingFailed$default(ErrorFactory.GenericErrors.INSTANCE, ErrorFactory.Action.INIT, (String)body, string, e, null, 16, null);
                    HMSLogger.INSTANCE.e("InitService", "fetchInitConfig: " + ex.getMessage(), ex);
                    this.$deferred.completeExceptionally((Throwable)ex);
                }
            }
        });
        return deferred.await($completion);
    }

    public static /* synthetic */ Object fetchInitConfig$default(InitService initService, String string, String string2, HMSAgentOs hMSAgentOs, String string3, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            string3 = "https://prod-init.100ms.live/init";
        }
        return initService.fetchInitConfig(string, string2, hMSAgentOs, string3, (Continuation<? super InitConfig>)continuation);
    }
}

