/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.factories.noisecancellation;

import android.content.Context;
import java.io.InputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.factories.noisecancellation.AvailabilityStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\r\u001a\u00020\u0006J\b\u0010\u000e\u001a\u00020\u0006H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0006R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Llive/hms/video/factories/noisecancellation/NoiseCancellationStatusChecker;", "", "context", "Landroid/content/Context;", "isFlagEnabled", "Lkotlin/Function0;", "", "isEnabledFromTemplate", "<init>", "(Landroid/content/Context;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "modelPath", "", "modelName", "enabledFromDashboard", "enabledFromDashboardInternal", "libraryPresent", "getLibraryPresent", "()Z", "libraryPresent$delegate", "Lkotlin/Lazy;", "getModelStream", "Ljava/io/InputStream;", "isNoiseCancellationAvailable", "Llive/hms/video/factories/noisecancellation/AvailabilityStatus;", "enableWebrtcNoiseSuppression", "lib_release"})
public final class NoiseCancellationStatusChecker {
    @NotNull
    private final Function0<Boolean> isFlagEnabled;
    @NotNull
    private final Function0<Boolean> isEnabledFromTemplate;
    @NotNull
    private final String modelPath;
    @NotNull
    private final String modelName;
    @NotNull
    private final Lazy libraryPresent$delegate;

    public NoiseCancellationStatusChecker(@NotNull Context context, @NotNull Function0<Boolean> isFlagEnabled, @NotNull Function0<Boolean> isEnabledFromTemplate) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(isFlagEnabled, (String)"isFlagEnabled");
        Intrinsics.checkNotNullParameter(isEnabledFromTemplate, (String)"isEnabledFromTemplate");
        this.isFlagEnabled = isFlagEnabled;
        this.isEnabledFromTemplate = isEnabledFromTemplate;
        this.modelPath = "hms/";
        this.modelName = "100ms_noise_cancellation_model";
        this.libraryPresent$delegate = LazyKt.lazy(() -> NoiseCancellationStatusChecker.libraryPresent_delegate$lambda$0(context, this));
    }

    public final boolean enabledFromDashboard() {
        return this.enabledFromDashboardInternal();
    }

    private final boolean enabledFromDashboardInternal() {
        return Intrinsics.areEqual((Object)this.isFlagEnabled.invoke(), (Object)true) && Intrinsics.areEqual((Object)this.isEnabledFromTemplate.invoke(), (Object)true);
    }

    public final boolean getLibraryPresent() {
        Lazy lazy = this.libraryPresent$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final InputStream getModelStream(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        InputStream inputStream = context.getResources().getAssets().open(this.modelPath + this.modelName);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"open(...)");
        return inputStream;
    }

    @NotNull
    public final AvailabilityStatus isNoiseCancellationAvailable() {
        AvailabilityStatus availabilityStatus;
        if (!this.getLibraryPresent()) {
            availabilityStatus = new AvailabilityStatus.NotAvailable("Add the import for live.100ms:hms-noise-cancellation-android:$version to enable noise cancellation.");
        } else {
            boolean bl = this.enabledFromDashboardInternal();
            if (bl) {
                availabilityStatus = AvailabilityStatus.Available.INSTANCE;
            } else if (!bl) {
                availabilityStatus = new AvailabilityStatus.NotAvailable("Noise Cancellation is disabled in the 100ms dashboard. Enable it there to turn it on.");
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return availabilityStatus;
    }

    public final boolean enableWebrtcNoiseSuppression() {
        return !Intrinsics.areEqual((Object)this.isNoiseCancellationAvailable(), (Object)AvailabilityStatus.Available.INSTANCE);
    }

    private static final boolean libraryPresent_delegate$lambda$0(Context $context, NoiseCancellationStatusChecker this$0) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object[] objectArray = $context.getResources().getAssets().list(this$0.modelPath);
        return objectArray != null ? ArraysKt.contains((Object[])objectArray, (Object)this$0.modelName) : false;
    }
}

