/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.diagnostics;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import live.hms.video.diagnostics.models.DiagnosticTokenResponse;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.factories.OkHttpFactory;
import live.hms.video.utils.GsonUtils;
import live.hms.video.utils.HMSLogger;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0002J\"\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0086@\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Llive/hms/video/diagnostics/DiagnosticTokenService;", "", "<init>", "()V", "TAG", "", "makeDiagnosticTokenRequest", "Lokhttp3/Request;", "region", "userId", "getDiagnosticRoomToken", "Llive/hms/video/diagnostics/models/DiagnosticTokenResponse;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib_release"})
public final class DiagnosticTokenService {
    @NotNull
    public static final DiagnosticTokenService INSTANCE = new DiagnosticTokenService();
    @NotNull
    private static final String TAG = "GetDiagnosticTokenService";

    private DiagnosticTokenService() {
    }

    private final Request makeDiagnosticTokenRequest(String region, String userId) {
        String url = "https://api.100ms.live/v2/diagnostics/token";
        CharSequence charSequence = region;
        if (!(charSequence == null || charSequence.length() == 0)) {
            url = url + "?region=" + region;
        }
        Request request = new Request.Builder().url(url).addHeader("Accept-Type", "application/json").build();
        HMSLogger.d(TAG, "Request to get diagnostic token: " + request);
        return request;
    }

    @Nullable
    public final Object getDiagnosticRoomToken(@Nullable String region, @Nullable String userId, @NotNull Continuation<? super DiagnosticTokenResponse> $completion) {
        Request request = this.makeDiagnosticTokenRequest(region, userId);
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        OkHttpFactory.INSTANCE.getClient().newCall(request).enqueue(new Callback((CompletableDeferred<DiagnosticTokenResponse>)deferred){
            final /* synthetic */ CompletableDeferred<DiagnosticTokenResponse> $deferred;
            {
                this.$deferred = $deferred;
            }

            public void onFailure(Call call2, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                HMSLogger.INSTANCE.e("GetDiagnosticTokenService", String.valueOf(e.getMessage()), e);
                String string = e.getMessage();
                if (string == null) {
                    string = "";
                }
                HMSException ex = ErrorFactory.APIErrors.EndpointUnreachable$default(ErrorFactory.APIErrors.INSTANCE, ErrorFactory.Action.DIAGNOSTICS, string, e, null, 8, null);
                this.$deferred.completeExceptionally((Throwable)ex);
            }

            public void onResponse(Call call2, Response response) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                HMSLogger.d("GetDiagnosticTokenService", "response=" + response);
                if (response.code() != 200) {
                    HMSException ex = ErrorFactory.APIErrors.HTTPError$default(ErrorFactory.APIErrors.INSTANCE, response.code(), ErrorFactory.Action.DIAGNOSTICS, "Received " + response.message(), null, null, 24, null);
                    this.$deferred.completeExceptionally((Throwable)ex);
                    return;
                }
                Object object = response.body();
                if (object == null || (object = object.string()) == null) {
                    object = "";
                }
                Object body = object;
                try {
                    DiagnosticTokenResponse response2 = (DiagnosticTokenResponse)GsonUtils.INSTANCE.getGson().fromJson((String)body, DiagnosticTokenResponse.class);
                    HMSLogger.d("GetDiagnosticTokenService", "Response :: " + response2);
                    Intrinsics.checkNotNull((Object)response2);
                    this.$deferred.complete((Object)response2);
                }
                catch (Exception e) {
                    String string = e.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    HMSException ex = ErrorFactory.GenericErrors.JsonParsingFailed$default(ErrorFactory.GenericErrors.INSTANCE, ErrorFactory.Action.DIAGNOSTICS, (String)body, string, e, null, 16, null);
                    HMSLogger.INSTANCE.e("GetDiagnosticTokenService", "Diagnostic token Service: " + ex.getMessage(), ex);
                    this.$deferred.completeExceptionally((Throwable)ex);
                }
            }
        });
        return deferred.await($completion);
    }
}

