/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.RectF;
import android.view.Display;
import android.view.WindowManager;
import androidx.core.math.MathUtils;
import hms.webrtc.RendererCommon;
import hms.webrtc.RtpParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import live.hms.video.error.HMSException;
import live.hms.video.media.settings.HMSLayer;
import live.hms.video.media.settings.HMSVideoTrackSettings;
import live.hms.video.sdk.models.DegradationPreference;
import live.hms.video.sdk.models.role.HMSRole;
import live.hms.video.sdk.models.role.LayerParams;
import live.hms.video.sdk.models.role.PublishParams;
import live.hms.video.sdk.models.role.Simulcast;
import live.hms.video.sdk.models.role.VideoSimulcastLayersParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ!\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0000\u00a2\u0006\u0002\b\u0016J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004J%\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b$J\u0016\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0004J\u0018\u0010(\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010,JG\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010.2\b\u00100\u001a\u0004\u0018\u00010\u00042\b\u00101\u001a\u0004\u0018\u00010\u00042\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u0012H\u0000\u00a2\u0006\u0004\b5\u00106J\u0019\u00107\u001a\u0004\u0018\u0001082\b\u00109\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b:J\u0012\u0010;\u001a\u00020\u00122\n\u0010<\u001a\u00060=j\u0002`>JW\u0010?\u001a\u0004\u0018\u00010.2\b\u0010@\u001a\u0004\u0018\u00010.2\u0006\u0010A\u001a\u00020\u00042\u0006\u0010B\u001a\u00020\u00042\b\u00100\u001a\u0004\u0018\u00010\u00042\b\u00101\u001a\u0004\u0018\u00010\u00042\u0006\u0010C\u001a\u00020\u00122\u0006\u0010D\u001a\u00020\u00042\u0006\u0010E\u001a\u00020FH\u0000\u00a2\u0006\u0004\bG\u0010HJ\u000e\u0010I\u001a\u00020\u0012*\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Llive/hms/video/utils/HMSUtils;", "", "()V", "MAX_SCREENSHARE_SIZE", "", "TAG", "", "addAndConvertBuffers", "", "a1", "", "a1Limit", "a2", "a2Limit", "applySizeConstraint", "Landroid/graphics/Point;", "actualSize", "didSimulcastLayerChangeHappen", "", "prevRole", "Llive/hms/video/sdk/models/role/HMSRole;", "newRole", "didSimulcastLayerChangeHappen$lib_release", "getBatteryPercentage", "context", "Landroid/content/Context;", "getDeviceWidthAndHeight", "getOrientation", "getSurfaceOrientation", "surfaceOrientation", "getVideoEncodingParameter", "", "Lhms/webrtc/RtpParameters$Encoding;", "hmsVideoTrackSettings", "Llive/hms/video/media/settings/HMSVideoTrackSettings;", "isScreenShare", "getVideoEncodingParameter$lib_release", "hasOrientationChange", "currentOrientation", "oldOrientation", "isSimulcastEnabledFromPolicy", "mapHmsDegradationPreference", "Lhms/webrtc/RtpParameters$DegradationPreference;", "degradationPreference", "Llive/hms/video/sdk/models/DegradationPreference;", "normalizedToCameraSensor", "Landroid/graphics/RectF;", "normalisedRect", "captureWidth", "captureHeight", "cropSensorWidth", "cropSensorHeight", "needCameraCrop", "normalizedToCameraSensor$lib_release", "(Landroid/graphics/RectF;Ljava/lang/Integer;Ljava/lang/Integer;IIZ)Landroid/graphics/RectF;", "ridToHMSLayerMapper", "Llive/hms/video/media/settings/HMSLayer;", "rid", "ridToHMSLayerMapper$lib_release", "shouldRetry", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "viewToNormalized", "transformRect", "viewWidth", "viewHeight", "mirrorMode", "rotationAngle", "scaleType", "Lhms/webrtc/RendererCommon$ScalingType;", "viewToNormalized$lib_release", "(Landroid/graphics/RectF;IILjava/lang/Integer;Ljava/lang/Integer;ZILhms/webrtc/RendererCommon$ScalingType;)Landroid/graphics/RectF;", "isRoleSimulcast", "lib_release"})
@SourceDebugExtension(value={"SMAP\nHMSUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HMSUtils.kt\nlive/hms/video/utils/HMSUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,342:1\n1#2:343\n1855#3,2:344\n*S KotlinDebug\n*F\n+ 1 HMSUtils.kt\nlive/hms/video/utils/HMSUtils\n*L\n134#1:344,2\n*E\n"})
public final class HMSUtils {
    @NotNull
    public static final HMSUtils INSTANCE = new HMSUtils();
    @NotNull
    private static final String TAG = "HMSUtils";
    private static final int MAX_SCREENSHARE_SIZE = 1920;

    private HMSUtils() {
    }

    public final int getOrientation(@NotNull Context context) {
        int n;
        Integer n2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        WindowManager windowManager = object instanceof WindowManager ? (WindowManager)object : null;
        Integer n3 = n2 = windowManager != null && (windowManager = windowManager.getDefaultDisplay()) != null ? Integer.valueOf(windowManager.getRotation()) : null;
        int n4 = 1;
        if (n3 != null && n3 == n4) {
            n = 90;
        } else {
            Integer n5 = n2;
            n4 = 2;
            if (n5 != null && n5 == n4) {
                n = 180;
            } else {
                Integer n6 = n2;
                n4 = 3;
                n = n6 != null && n6 == n4 ? 270 : 0;
            }
        }
        return n;
    }

    public final boolean hasOrientationChange(int currentOrientation, int oldOrientation) {
        return currentOrientation != oldOrientation && Math.abs(currentOrientation - oldOrientation) != 180;
    }

    public final boolean shouldRetry(@NotNull Exception ex) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        return ex instanceof HMSException ? ArraysKt.contains((Object[])(objectArray = new Integer[]{2003, 1003}), (Object)((HMSException)ex).getCode()) || StringsKt.startsWith$default((String)String.valueOf(((HMSException)ex).getCode()), (String)"5", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)String.valueOf(((HMSException)ex).getCode()), (String)"429", (boolean)false, (int)2, null) : false;
    }

    @NotNull
    public final byte[] addAndConvertBuffers(@NotNull short[] a1, int a1Limit, @NotNull short[] a2, int a2Limit) {
        Intrinsics.checkNotNullParameter((Object)a1, (String)"a1");
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a2");
        int size = Math.max(a1Limit, a2Limit);
        if (size < 0) {
            return new byte[0];
        }
        byte[] buff = new byte[size * 2];
        for (int i = 0; i < size; ++i) {
            int sum = 0;
            int n = i >= a1Limit ? a2[i] : (sum = i >= a2Limit ? a1[i] : a1[i] + a2[i]);
            if (sum > Short.MAX_VALUE) {
                sum = Short.MAX_VALUE;
            }
            if (sum < Short.MIN_VALUE) {
                sum = Short.MIN_VALUE;
            }
            int byteIndex = i * 2;
            buff[byteIndex] = (byte)(sum & 0xFF);
            buff[byteIndex + 1] = (byte)(sum >> 8 & 0xFF);
        }
        return buff;
    }

    @NotNull
    public final Point getDeviceWidthAndHeight(@NotNull Context context) {
        Display display;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Point size = new Point();
        Object object = context.getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        WindowManager wm = (WindowManager)object;
        Display $this$getDeviceWidthAndHeight_u24lambda_u240 = display = wm.getDefaultDisplay();
        boolean bl = false;
        $this$getDeviceWidthAndHeight_u24lambda_u240.getRealSize(size);
        return size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSimulcastEnabledFromPolicy(boolean isScreenShare, HMSVideoTrackSettings hmsVideoTrackSettings) {
        Collection collection;
        if (isScreenShare) {
            VideoSimulcastLayersParams videoSimulcastLayersParams = hmsVideoTrackSettings.getScreenShareSimulcastLayersParams$lib_release();
            collection = videoSimulcastLayersParams != null ? videoSimulcastLayersParams.getLayers() : null;
            if (collection == null) return true;
            if (collection.isEmpty()) {
                return true;
            }
            boolean bl = false;
            if (bl) return true;
        }
        if (isScreenShare) return false;
        VideoSimulcastLayersParams videoSimulcastLayersParams = hmsVideoTrackSettings.getVideoSimulcastLayersParams$lib_release();
        collection = videoSimulcastLayersParams != null ? videoSimulcastLayersParams.getLayers() : null;
        if (collection == null) return true;
        if (!collection.isEmpty()) return false;
        return true;
    }

    @NotNull
    public final List<RtpParameters.Encoding> getVideoEncodingParameter$lib_release(@NotNull HMSVideoTrackSettings hmsVideoTrackSettings, boolean isScreenShare) {
        List encodingParams;
        block5: {
            ArrayList<LayerParams> simulcastLayers;
            ArrayList<LayerParams> arrayList;
            block4: {
                RtpParameters.Encoding encoding;
                Intrinsics.checkNotNullParameter((Object)hmsVideoTrackSettings, (String)"hmsVideoTrackSettings");
                encodingParams = new ArrayList();
                if (hmsVideoTrackSettings.isSimulcastFeatureFlagEnabled$lib_release() && !this.isSimulcastEnabledFromPolicy(isScreenShare, hmsVideoTrackSettings)) break block4;
                Collection collection = encodingParams;
                RtpParameters.Encoding $this$getVideoEncodingParameter_u24lambda_u241 = encoding = new RtpParameters.Encoding(null, true, null);
                boolean bl = false;
                $this$getVideoEncodingParameter_u24lambda_u241.maxBitrateBps = hmsVideoTrackSettings.getMaxBitRate() * 1000;
                $this$getVideoEncodingParameter_u24lambda_u241.maxFramerate = hmsVideoTrackSettings.getMaxFrameRate();
                collection.add(encoding);
                break block5;
            }
            if (isScreenShare) {
                VideoSimulcastLayersParams videoSimulcastLayersParams = hmsVideoTrackSettings.getScreenShareSimulcastLayersParams$lib_release();
                arrayList = videoSimulcastLayersParams != null ? videoSimulcastLayersParams.getLayers() : null;
            } else {
                VideoSimulcastLayersParams videoSimulcastLayersParams = hmsVideoTrackSettings.getVideoSimulcastLayersParams$lib_release();
                arrayList = videoSimulcastLayersParams != null ? videoSimulcastLayersParams.getLayers() : null;
            }
            ArrayList<LayerParams> arrayList2 = simulcastLayers = arrayList;
            if (arrayList2 == null) break block5;
            Iterable $this$forEach$iv = arrayList2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RtpParameters.Encoding encoding;
                LayerParams layer = (LayerParams)element$iv;
                boolean bl = false;
                Collection collection = encodingParams;
                Float f = layer.getScaleResolutionDownBy();
                RtpParameters.Encoding $this$getVideoEncodingParameter_u24lambda_u243_u24lambda_u242 = encoding = new RtpParameters.Encoding(layer.getRid(), true, f != null ? Double.valueOf(f.floatValue()) : null);
                boolean bl2 = false;
                Integer n = layer.getMaxBitrate();
                $this$getVideoEncodingParameter_u24lambda_u243_u24lambda_u242.maxBitrateBps = (n != null ? n.intValue() : hmsVideoTrackSettings.getMaxBitRate()) * 1000;
                Integer n2 = layer.getMaxFramerate();
                if (n2 == null) {
                    n2 = hmsVideoTrackSettings.getMaxFrameRate();
                }
                $this$getVideoEncodingParameter_u24lambda_u243_u24lambda_u242.maxFramerate = n2;
                collection.add(encoding);
            }
        }
        return encodingParams;
    }

    public static /* synthetic */ List getVideoEncodingParameter$lib_release$default(HMSUtils hMSUtils, HMSVideoTrackSettings hMSVideoTrackSettings, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return hMSUtils.getVideoEncodingParameter$lib_release(hMSVideoTrackSettings, bl);
    }

    @NotNull
    public final Point applySizeConstraint(@NotNull Point actualSize) {
        Intrinsics.checkNotNullParameter((Object)actualSize, (String)"actualSize");
        int width = actualSize.x;
        int height = actualSize.y;
        int maxSize = Math.max(width, height);
        if (maxSize > 1920) {
            float ratio = (float)width / (float)height;
            if (width == maxSize) {
                width = 1920;
                height = (int)(1.0f / ratio * (float)1920);
            } else {
                height = 1920;
                width = (int)((float)1920 * ratio);
            }
            return new Point(width, height);
        }
        return actualSize;
    }

    public final boolean didSimulcastLayerChangeHappen$lib_release(@Nullable HMSRole prevRole, @Nullable HMSRole newRole) {
        return this.isRoleSimulcast(prevRole) != this.isRoleSimulcast(newRole);
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final HMSLayer ridToHMSLayerMapper$lib_release(@Nullable String rid) {
        HMSLayer hMSLayer;
        block6: {
            String string = rid;
            if (string == null) return null;
            switch (string.hashCode()) {
                case 113: {
                    if (string.equals("q")) break;
                    return null;
                }
                case 102: {
                    if (!string.equals("f")) {
                        return null;
                    }
                    break block6;
                }
                case 104: {
                    if (!string.equals("h")) return null;
                    hMSLayer = HMSLayer.MEDIUM;
                    return hMSLayer;
                }
            }
            hMSLayer = HMSLayer.LOW;
            return hMSLayer;
        }
        hMSLayer = HMSLayer.HIGH;
        return hMSLayer;
        return null;
    }

    private final boolean isRoleSimulcast(HMSRole $this$isRoleSimulcast) {
        Object object = $this$isRoleSimulcast;
        Collection collection = object != null && (object = ((HMSRole)object).getPublishParams()) != null && (object = ((PublishParams)object).getSimulcast()) != null && (object = ((Simulcast)object).getVideo()) != null ? ((VideoSimulcastLayersParams)object).getLayers() : null;
        return !(collection == null || collection.isEmpty());
    }

    @Nullable
    public final RectF viewToNormalized$lib_release(@Nullable RectF transformRect, int viewWidth, int viewHeight, @Nullable Integer captureWidth, @Nullable Integer captureHeight, boolean mirrorMode, int rotationAngle, @NotNull RendererCommon.ScalingType scaleType) {
        float f;
        float f2;
        Intrinsics.checkNotNullParameter((Object)scaleType, (String)"scaleType");
        if (transformRect == null || captureWidth == null || captureHeight == null || viewWidth <= 0 || viewHeight <= 0 || transformRect.left < 0.0f || transformRect.top < 0.0f || transformRect.right > (float)viewWidth || transformRect.bottom > (float)viewHeight || rotationAngle % 90 != 0) {
            return null;
        }
        int appliedRotation = rotationAngle > 0 ? rotationAngle % 360 : 360 + rotationAngle % 360;
        RectF normalisedRect = new RectF(transformRect);
        Matrix matrix = new Matrix();
        matrix.postRotate((float)appliedRotation);
        switch (appliedRotation) {
            case 90: 
            case 270: {
                f2 = viewHeight;
                break;
            }
            default: {
                f2 = viewWidth;
            }
        }
        float viewWidthPostRotate = f2;
        switch (appliedRotation) {
            case 90: 
            case 270: {
                f = viewWidth;
                break;
            }
            default: {
                f = viewHeight;
            }
        }
        float viewHeightPostRotate = f;
        float ratioW = viewWidthPostRotate / (float)captureWidth.intValue();
        float ratioH = viewHeightPostRotate / (float)captureHeight.intValue();
        matrix.postScale(1.0f / viewWidthPostRotate, 1.0f / viewHeightPostRotate);
        switch (appliedRotation) {
            case 90: {
                matrix.postTranslate(1.0f, 0.0f);
                break;
            }
            case 180: {
                matrix.postTranslate(1.0f, 1.0f);
                break;
            }
            case 270: {
                matrix.postTranslate(0.0f, 1.0f);
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[scaleType.ordinal()]) {
            case 1: 
            case 2: {
                if (ratioW <= ratioH) {
                    matrix.postScale(ratioW / ratioH, 1.0f, 0.5f, 0.0f);
                    matrix.mapRect(normalisedRect);
                    normalisedRect.right = MathUtils.clamp((float)normalisedRect.right, (float)0.0f, (float)1.0f);
                    normalisedRect.left = MathUtils.clamp((float)normalisedRect.left, (float)0.0f, (float)1.0f);
                    break;
                }
                matrix.postScale(1.0f, ratioH / ratioW, 0.0f, 0.5f);
                matrix.mapRect(normalisedRect);
                normalisedRect.top = MathUtils.clamp((float)normalisedRect.top, (float)0.0f, (float)1.0f);
                normalisedRect.bottom = MathUtils.clamp((float)normalisedRect.bottom, (float)0.0f, (float)1.0f);
                break;
            }
            case 3: {
                if (ratioW <= ratioH) {
                    matrix.postScale(1.0f, ratioH / ratioW);
                    matrix.mapRect(normalisedRect);
                    normalisedRect.top = MathUtils.clamp((float)normalisedRect.top, (float)0.0f, (float)1.0f);
                    normalisedRect.bottom = MathUtils.clamp((float)normalisedRect.bottom, (float)0.0f, (float)1.0f);
                    break;
                }
                matrix.postScale(ratioW / ratioH, 1.0f, 0.5f, 0.0f);
                matrix.mapRect(normalisedRect);
                normalisedRect.right = MathUtils.clamp((float)normalisedRect.right, (float)0.0f, (float)1.0f);
                normalisedRect.left = MathUtils.clamp((float)normalisedRect.left, (float)0.0f, (float)1.0f);
            }
        }
        if (mirrorMode) {
            float tempLeft = normalisedRect.left;
            normalisedRect.left = 1.0f - normalisedRect.right;
            normalisedRect.right = 1.0f - tempLeft;
        }
        return normalisedRect;
    }

    @Nullable
    public final RectF normalizedToCameraSensor$lib_release(@Nullable RectF normalisedRect, @Nullable Integer captureWidth, @Nullable Integer captureHeight, int cropSensorWidth, int cropSensorHeight, boolean needCameraCrop) {
        if (normalisedRect == null || captureWidth == null || captureHeight == null || normalisedRect.left < 0.0f || normalisedRect.top < 0.0f || normalisedRect.width() > 1.0f || normalisedRect.height() > 1.0f) {
            return null;
        }
        RectF sensorRect = new RectF(normalisedRect);
        Matrix matrix = new Matrix();
        int cropWidth = cropSensorWidth;
        int cropHeight = cropSensorHeight;
        if (needCameraCrop) {
            float ratioH;
            float ratioW = cropWidth / captureWidth;
            if (ratioW / (ratioH = (float)(cropHeight / captureHeight)) > 1.0f) {
                matrix.postTranslate((ratioW / ratioH - 1.0f) / 2.0f, 0.0f);
                cropWidth = (int)((float)cropWidth * ratioH / ratioW);
            } else if (ratioW / ratioH < 1.0f) {
                matrix.postTranslate(0.0f, (ratioH / ratioW - 1.0f) / 2.0f);
                cropHeight = (int)((float)cropHeight * ratioW / ratioH);
            }
            matrix.mapRect(sensorRect);
        }
        matrix.setScale((float)cropWidth, (float)cropHeight);
        matrix.mapRect(sensorRect);
        return sensorRect;
    }

    public final int getSurfaceOrientation(int surfaceOrientation) {
        int n;
        switch (surfaceOrientation) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 90;
                break;
            }
            case 2: {
                n = 180;
                break;
            }
            case 3: {
                n = 270;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @Nullable
    public final RtpParameters.DegradationPreference mapHmsDegradationPreference(@Nullable DegradationPreference degradationPreference) {
        RtpParameters.DegradationPreference degradationPreference2;
        DegradationPreference degradationPreference3 = degradationPreference;
        switch (degradationPreference3 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[degradationPreference3.ordinal()]) {
            case 1: {
                degradationPreference2 = RtpParameters.DegradationPreference.DISABLED;
                break;
            }
            case 2: {
                degradationPreference2 = RtpParameters.DegradationPreference.MAINTAIN_FRAMERATE;
                break;
            }
            case 3: {
                degradationPreference2 = RtpParameters.DegradationPreference.MAINTAIN_RESOLUTION;
                break;
            }
            case 4: {
                degradationPreference2 = RtpParameters.DegradationPreference.BALANCED;
                break;
            }
            default: {
                degradationPreference2 = null;
            }
        }
        return degradationPreference2;
    }

    public final int getBatteryPercentage(@NotNull Context context) {
        Intent batteryStatus;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IntentFilter iFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = batteryStatus = context.registerReceiver(null, iFilter);
        int level = intent != null ? intent.getIntExtra("level", -1) : -1;
        Intent intent2 = batteryStatus;
        int scale = intent2 != null ? intent2.getIntExtra("scale", -1) : -1;
        float batteryPct = (float)level / (float)scale;
        return (int)(batteryPct * (float)100);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RendererCommon.ScalingType.values().length];
            try {
                nArray[RendererCommon.ScalingType.SCALE_ASPECT_BALANCED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RendererCommon.ScalingType.SCALE_ASPECT_FILL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RendererCommon.ScalingType.SCALE_ASPECT_FIT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DegradationPreference.values().length];
            try {
                nArray[DegradationPreference.DISABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DegradationPreference.MAINTAIN_FRAMERATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DegradationPreference.MAINTAIN_RESOLUTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DegradationPreference.BALANCED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

