/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.connection;

import android.util.Log;
import hms.webrtc.IceCandidate;
import hms.webrtc.MediaConstraints;
import hms.webrtc.MediaStreamTrack;
import hms.webrtc.PeerConnection;
import hms.webrtc.RTCStatsReport;
import hms.webrtc.RtpSender;
import hms.webrtc.RtpTransceiver;
import hms.webrtc.SdpObserver;
import hms.webrtc.SessionDescription;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import live.hms.video.connection.helpers.HMSSdpObserver;
import live.hms.video.connection.models.HMSConnectionRole;
import live.hms.video.error.ErrorFactory;
import live.hms.video.signal.ISignal;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b \u0018\u0000 @2\u00020\u0001:\u0001@B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\rJ\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0011\u0010&\u001a\u00020'H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J\u0019\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0019\u0010.\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0010\u0010/\u001a\u00020*2\u0006\u00100\u001a\u00020*H\u0002J\u0006\u00101\u001a\u00020\bJ\b\u00102\u001a\u0004\u0018\u00010*J\f\u00103\u001a\b\u0012\u0004\u0012\u00020504J\u0011\u00106\u001a\u000207H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J\u000e\u00108\u001a\u00020\u001e2\u0006\u00109\u001a\u000205J\u0019\u0010:\u001a\u00020'2\u0006\u0010;\u001a\u00020*H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\u000e\u0010=\u001a\u00020'2\u0006\u0010>\u001a\u00020\bJ\u0019\u0010?\u001a\u00020'2\u0006\u0010;\u001a\u00020*H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006A"}, d2={"Llive/hms/video/connection/HMSConnection;", "", "role", "Llive/hms/video/connection/models/HMSConnectionRole;", "signal", "Llive/hms/video/signal/ISignal;", "(Llive/hms/video/connection/models/HMSConnectionRole;Llive/hms/video/signal/ISignal;)V", "_nodeInfo", "", "action", "Llive/hms/video/error/ErrorFactory$Action;", "candidates", "Ljava/util/ArrayList;", "Lhms/webrtc/IceCandidate;", "Lkotlin/collections/ArrayList;", "getCandidates", "()Ljava/util/ArrayList;", "iceConnectionState", "Lhms/webrtc/PeerConnection$IceConnectionState;", "getIceConnectionState", "()Lhms/webrtc/PeerConnection$IceConnectionState;", "nativeConnection", "Lhms/webrtc/PeerConnection;", "getNativeConnection", "()Lhms/webrtc/PeerConnection;", "getRole", "()Llive/hms/video/connection/models/HMSConnectionRole;", "getSignal", "()Llive/hms/video/signal/ISignal;", "addIceCandidate", "", "candidate", "addTransceiver", "Lhms/webrtc/RtpTransceiver;", "track", "Lhms/webrtc/MediaStreamTrack;", "init", "Lhms/webrtc/RtpTransceiver$RtpTransceiverInit;", "close", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createAnswer", "Lhms/webrtc/SessionDescription;", "constraints", "Lhms/webrtc/MediaConstraints;", "(Lhms/webrtc/MediaConstraints;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createOffer", "enableOpusDtx", "sdp", "getNodeInfo", "getRemoteDescription", "getSenders", "", "Lhms/webrtc/RtpSender;", "getStats", "Lhms/webrtc/RTCStatsReport;", "removeTrack", "sender", "setLocalDescription", "description", "(Lhms/webrtc/SessionDescription;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setNodeInfo", "nodeInfo", "setRemoteDescription", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nHMSConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HMSConnection.kt\nlive/hms/video/connection/HMSConnection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n1#2:194\n*E\n"})
public abstract class HMSConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HMSConnectionRole role;
    @NotNull
    private final ISignal signal;
    @NotNull
    private final ErrorFactory.Action action;
    @NotNull
    private final ArrayList<IceCandidate> candidates;
    @NotNull
    private String _nodeInfo;
    @NotNull
    private static final String TAG = "HMSConnection";

    public HMSConnection(@NotNull HMSConnectionRole role, @NotNull ISignal signal) {
        ErrorFactory.Action action;
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        Intrinsics.checkNotNullParameter((Object)signal, (String)"signal");
        this.role = role;
        this.signal = signal;
        switch (WhenMappings.$EnumSwitchMapping$0[this.role.ordinal()]) {
            case 1: {
                action = ErrorFactory.Action.PUBLISH;
                break;
            }
            case 2: {
                action = ErrorFactory.Action.SUBSCRIBE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.action = action;
        this.candidates = new ArrayList();
        this._nodeInfo = "";
    }

    @NotNull
    public final HMSConnectionRole getRole() {
        return this.role;
    }

    @NotNull
    public final ISignal getSignal() {
        return this.signal;
    }

    @NotNull
    public abstract PeerConnection getNativeConnection();

    @NotNull
    public final ArrayList<IceCandidate> getCandidates() {
        return this.candidates;
    }

    @NotNull
    public final PeerConnection.IceConnectionState getIceConnectionState() {
        PeerConnection.IceConnectionState iceConnectionState = this.getNativeConnection().iceConnectionState();
        Intrinsics.checkNotNullExpressionValue((Object)iceConnectionState, (String)"nativeConnection.iceConnectionState()");
        return iceConnectionState;
    }

    @NotNull
    public final String getNodeInfo() {
        return this._nodeInfo;
    }

    public final void setNodeInfo(@NotNull String nodeInfo) {
        Intrinsics.checkNotNullParameter((Object)nodeInfo, (String)"nodeInfo");
        this._nodeInfo = nodeInfo;
        try {
            boolean bl = false;
            Object object = Result.constructor-impl((Object)Log.d((String)"SFUMIGRATION", (String)("NodeInfo: set for class " + nodeInfo + " role :=" + (Object)((Object)this.role))));
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    @Nullable
    public final Object createOffer(@NotNull MediaConstraints constraints, @NotNull Continuation<? super SessionDescription> $completion) {
        HMSLogger.d(TAG, "[role=" + (Object)((Object)this.role) + "] createOffer: constraints=" + constraints);
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        HMSConnectionRole hMSConnectionRole = this.role;
        this.getNativeConnection().createOffer((SdpObserver)new HMSSdpObserver(this, (CompletableDeferred<SessionDescription>)deferred, hMSConnectionRole){
            final /* synthetic */ HMSConnection this$0;
            final /* synthetic */ CompletableDeferred<SessionDescription> $deferred;
            {
                this.this$0 = $receiver;
                this.$deferred = $deferred;
                super($super_call_param$1);
            }

            public void onCreateSuccess(@NotNull SessionDescription sdp) {
                Intrinsics.checkNotNullParameter((Object)sdp, (String)"sdp");
                HMSLogger.d("HMSSdpObserver", "offer created successfully");
                super.onCreateSuccess(sdp);
                SessionDescription mungedSDP = HMSConnection.access$enableOpusDtx(this.this$0, sdp);
                this.$deferred.complete((Object)mungedSDP);
            }

            public void onCreateFailure(@NotNull String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                HMSLogger.e("HMSSdpObserver", "failed to create offer : " + error);
                super.onCreateFailure(error);
                this.$deferred.completeExceptionally((Throwable)ErrorFactory.WebrtcErrors.CreateOfferFailed$default(ErrorFactory.WebrtcErrors.INSTANCE, HMSConnection.access$getAction$p(this.this$0), error, null, null, 12, null));
            }
        }, constraints);
        return deferred.await($completion);
    }

    private final SessionDescription enableOpusDtx(SessionDescription sdp) {
        String string = sdp.description;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdp.description");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"usedtx=1", (boolean)false, (int)2, null)) {
            String string2 = sdp.description;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sdp.description");
            String mungedDescription = StringsKt.replace$default((String)string2, (String)"useinbandfec=1", (String)"useinbandfec=1;usedtx=1", (boolean)false, (int)4, null);
            return new SessionDescription(sdp.type, mungedDescription);
        }
        return sdp;
    }

    @Nullable
    public final Object createAnswer(@NotNull MediaConstraints constraints, @NotNull Continuation<? super SessionDescription> $completion) {
        HMSLogger.INSTANCE.v(TAG, "[role=" + (Object)((Object)this.role) + "] createAnswer: constraints=" + constraints);
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        HMSConnectionRole hMSConnectionRole = this.role;
        this.getNativeConnection().createAnswer((SdpObserver)new HMSSdpObserver((CompletableDeferred<SessionDescription>)deferred, this, hMSConnectionRole){
            final /* synthetic */ CompletableDeferred<SessionDescription> $deferred;
            final /* synthetic */ HMSConnection this$0;
            {
                this.$deferred = $deferred;
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void onCreateSuccess(@NotNull SessionDescription sdp) {
                Intrinsics.checkNotNullParameter((Object)sdp, (String)"sdp");
                super.onCreateSuccess(sdp);
                this.$deferred.complete((Object)sdp);
            }

            public void onCreateFailure(@NotNull String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super.onCreateFailure(error);
                this.$deferred.completeExceptionally((Throwable)ErrorFactory.WebrtcErrors.CreateAnswerFailed$default(ErrorFactory.WebrtcErrors.INSTANCE, HMSConnection.access$getAction$p(this.this$0), error, null, null, 12, null));
            }
        }, constraints);
        return deferred.await($completion);
    }

    @Nullable
    public final Object setLocalDescription(@NotNull SessionDescription description, @NotNull Continuation<? super Unit> $completion) {
        HMSLogger.d(TAG, "[role=" + (Object)((Object)this.role) + "] setLocalDescription with type=" + description.type + " [size=" + description.description.length() + "] description=" + description.description);
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        HMSConnectionRole hMSConnectionRole = this.role;
        this.getNativeConnection().setLocalDescription((SdpObserver)new HMSSdpObserver((CompletableDeferred<Boolean>)deferred, this, hMSConnectionRole){
            final /* synthetic */ CompletableDeferred<Boolean> $deferred;
            final /* synthetic */ HMSConnection this$0;
            {
                this.$deferred = $deferred;
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void onSetSuccess() {
                super.onSetSuccess();
                HMSLogger.d("HMSSdpObserver", "set local offer successfully");
                this.$deferred.complete((Object)true);
            }

            public void onSetFailure(@NotNull String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super.onSetFailure(error);
                HMSLogger.e("HMSSdpObserver", "error in setting local offer : " + error);
                this.$deferred.completeExceptionally((Throwable)ErrorFactory.WebrtcErrors.SetLocalDescriptionFailed$default(ErrorFactory.WebrtcErrors.INSTANCE, HMSConnection.access$getAction$p(this.this$0), error, null, null, 12, null));
            }
        }, description);
        Object object = deferred.await($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object setRemoteDescription(@NotNull SessionDescription description, @NotNull Continuation<? super Unit> $completion) {
        HMSLogger.INSTANCE.v(TAG, "[role=" + (Object)((Object)this.role) + "] setRemoteDescription with type=" + description.type + " [size=" + description.description.length() + "] description=" + description.description);
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        HMSConnectionRole hMSConnectionRole = this.role;
        this.getNativeConnection().setRemoteDescription((SdpObserver)new HMSSdpObserver((CompletableDeferred<Boolean>)deferred, this, hMSConnectionRole){
            final /* synthetic */ CompletableDeferred<Boolean> $deferred;
            final /* synthetic */ HMSConnection this$0;
            {
                this.$deferred = $deferred;
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void onSetSuccess() {
                super.onSetSuccess();
                this.$deferred.complete((Object)true);
            }

            public void onSetFailure(@NotNull String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super.onSetFailure(error);
                this.$deferred.completeExceptionally((Throwable)ErrorFactory.WebrtcErrors.SetRemoteDescriptionFailed$default(ErrorFactory.WebrtcErrors.INSTANCE, HMSConnection.access$getAction$p(this.this$0), error, null, null, 12, null));
            }
        }, description);
        Object object = deferred.await($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final boolean addIceCandidate(@NotNull IceCandidate candidate) {
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        return this.getNativeConnection().addIceCandidate(candidate);
    }

    @NotNull
    public final RtpTransceiver addTransceiver(@NotNull MediaStreamTrack track, @NotNull RtpTransceiver.RtpTransceiverInit init) {
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        Intrinsics.checkNotNullParameter((Object)init, (String)"init");
        RtpTransceiver rtpTransceiver = this.getNativeConnection().addTransceiver(track, init);
        Intrinsics.checkNotNullExpressionValue((Object)rtpTransceiver, (String)"nativeConnection.addTransceiver(track, init)");
        return rtpTransceiver;
    }

    @NotNull
    public final List<RtpSender> getSenders() {
        List list = this.getNativeConnection().getSenders();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"nativeConnection.senders");
        return list;
    }

    public final boolean removeTrack(@NotNull RtpSender sender) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        return this.getNativeConnection().removeTrack(sender);
    }

    @Nullable
    public final SessionDescription getRemoteDescription() {
        return this.getNativeConnection().getRemoteDescription();
    }

    @Nullable
    public final Object getStats(@NotNull Continuation<? super RTCStatsReport> $completion) {
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.getNativeConnection().getStats(arg_0 -> HMSConnection.getStats$lambda$1(deferred, arg_0));
        return deferred.await($completion);
    }

    @Nullable
    public Object close(@NotNull Continuation<? super Unit> $completion) {
        return HMSConnection.close$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object close$suspendImpl(HMSConnection $this, Continuation<? super Unit> $completion) {
        $this.getNativeConnection().close();
        $this.getNativeConnection().dispose();
        return Unit.INSTANCE;
    }

    private static final void getStats$lambda$1(CompletableDeferred $deferred, RTCStatsReport it) {
        Intrinsics.checkNotNullParameter((Object)$deferred, (String)"$deferred");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $deferred.complete((Object)it);
    }

    public static final /* synthetic */ SessionDescription access$enableOpusDtx(HMSConnection $this, SessionDescription sdp) {
        return $this.enableOpusDtx(sdp);
    }

    public static final /* synthetic */ ErrorFactory.Action access$getAction$p(HMSConnection $this) {
        return $this.action;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HMSConnectionRole.values().length];
            try {
                nArray[HMSConnectionRole.PUBLISH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSConnectionRole.SUBSCRIBE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/video/connection/HMSConnection$Companion;", "", "()V", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

