/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.audio.manager;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import live.hms.video.audio.AudioChangeEvent;
import live.hms.video.audio.AudioManagerFocusChangeCallbacks;
import live.hms.video.audio.HMSAudioDeviceInfo;
import live.hms.video.audio.HMSAudioManager;
import live.hms.video.audio.manager.AudioDeviceMapping;
import live.hms.video.audio.manager.AudioManagerCompat;
import live.hms.video.audio.manager.AudioManagerUtil;
import live.hms.video.audio.manager.HMSAudioManagerApi31;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.media.settings.HMSAudioTrackSettings;
import live.hms.video.media.settings.PhoneCallState;
import live.hms.video.sdk.IErrorListener;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ad\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000b*\u0001\u001c\b\u0007\u0018\u00002\u00020\u0001B3\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\"H\u0016J\b\u0010>\u001a\u00020<H\u0002J\b\u0010?\u001a\u00020<H\u0002J\u000e\u0010@\u001a\b\u0012\u0004\u0012\u00020B0AH\u0016J\u000e\u0010C\u001a\b\u0012\u0004\u0012\u00020E0DH\u0016J\b\u0010F\u001a\u00020BH\u0016J\u000e\u0010G\u001a\b\u0012\u0004\u0012\u00020E0DH\u0002J\u0010\u0010H\u001a\u00020<2\u0006\u0010I\u001a\u00020\u000bH\u0002J\u0006\u0010J\u001a\u00020<J\b\u0010K\u001a\u00020$H\u0016J\u0010\u0010L\u001a\u00020<2\u0006\u0010=\u001a\u00020\"H\u0016J\b\u0010M\u001a\u00020<H\u0002J\u0010\u0010N\u001a\u00020<2\u0006\u0010O\u001a\u00020BH\u0016J\u0010\u0010P\u001a\u00020<2\u0006\u0010Q\u001a\u00020RH\u0002J\u0010\u0010S\u001a\u00020<2\u0006\u0010T\u001a\u000200H\u0016J\u0016\u0010U\u001a\u00020<2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020:0DH\u0002J\u0010\u0010W\u001a\u00020<2\u0006\u0010X\u001a\u00020$H\u0002J\u0010\u0010Y\u001a\u00020<2\u0006\u0010X\u001a\u00020$H\u0002J\b\u0010Z\u001a\u00020<H\u0016J\b\u0010[\u001a\u00020<H\u0016J\b\u0010\\\u001a\u00020<H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001b\u0010'\u001a\u00020(8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b)\u0010*R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u000204X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Llive/hms/video/audio/manager/HMSAudioManagerApi31;", "Llive/hms/video/audio/HMSAudioManager;", "context", "Landroid/content/Context;", "analytics", "Llive/hms/video/events/AnalyticsEventsService;", "hmsAudioTrackSettings", "Llive/hms/video/media/settings/HMSAudioTrackSettings;", "audioManagerDeviceChangeListener", "Llive/hms/video/audio/HMSAudioManager$AudioManagerDeviceChangeListener;", "errorListener", "Llive/hms/video/sdk/IErrorListener;", "(Landroid/content/Context;Llive/hms/video/events/AnalyticsEventsService;Llive/hms/video/media/settings/HMSAudioTrackSettings;Llive/hms/video/audio/HMSAudioManager$AudioManagerDeviceChangeListener;Llive/hms/video/sdk/IErrorListener;)V", "TAG", "", "TELEPHONY_LOCK", "", "androidAudioManager", "Llive/hms/video/audio/manager/AudioManagerCompat;", "audioFocusChangeListener", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "getAudioManagerDeviceChangeListener", "()Llive/hms/video/audio/HMSAudioManager$AudioManagerDeviceChangeListener;", "getContext", "()Landroid/content/Context;", "defaultAudioDevice", "Llive/hms/video/audio/manager/AudioManagerUtil$AudioDevice;", "deviceCallback", "live/hms/video/audio/manager/HMSAudioManagerApi31$deviceCallback$1", "Llive/hms/video/audio/manager/HMSAudioManagerApi31$deviceCallback$1;", "getErrorListener", "()Llive/hms/video/sdk/IErrorListener;", "focusChangeCallbacks", "", "Llive/hms/video/audio/AudioManagerFocusChangeCallbacks;", "hasWiredHeadset", "", "getHmsAudioTrackSettings", "()Llive/hms/video/media/settings/HMSAudioTrackSettings;", "mainHandler", "Landroid/os/Handler;", "getMainHandler", "()Landroid/os/Handler;", "mainHandler$delegate", "Lkotlin/Lazy;", "phoneStateChangeListener", "Landroid/telephony/PhoneStateListener;", "savedAudioMode", "", "savedIsMicrophoneMute", "savedIsSpeakerPhoneOn", "state", "Llive/hms/video/audio/HMSAudioManager$AudioManagerState;", "getState", "()Llive/hms/video/audio/HMSAudioManager$AudioManagerState;", "setState", "(Llive/hms/video/audio/HMSAudioManager$AudioManagerState;)V", "userSelectedAudioDevice", "Landroid/media/AudioDeviceInfo;", "addAudioFocusChangeCallback", "", "callback", "createAudioFocusChangeListener", "deInitTelephony", "getAudioDevices", "", "Llive/hms/video/audio/HMSAudioManager$AudioDevice;", "getAudioDevicesInfoList", "", "Llive/hms/video/audio/HMSAudioDeviceInfo;", "getSelectedAudioDevice", "groupAudioDevices", "initTelephony", "onErrorListener", "initialize", "isStarted", "removeAudioFocusChangeCallback", "requestAudioFocus", "selectAudioDevice", "device", "sendAudioChangeEvent", "event", "Llive/hms/video/audio/AudioChangeEvent;", "setAudioMode", "audioMode", "setAutomaticSelection", "availableCommunicationDevices", "setMicrophoneMute", "on", "setSpeakerphoneOn", "start", "stop", "updateAudioDeviceState", "lib_release"})
@RequiresApi(value=31)
@SourceDebugExtension(value={"SMAP\nHMSAudioManagerApi31.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HMSAudioManagerApi31.kt\nlive/hms/video/audio/manager/HMSAudioManagerApi31\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,487:1\n1549#2:488\n1620#2,3:489\n1549#2:492\n1620#2,3:493\n1549#2:496\n1620#2,3:497\n1549#2:500\n1620#2,3:501\n819#2:504\n847#2,2:505\n1549#2:508\n1620#2,3:509\n1549#2:512\n1620#2,3:513\n1#3:507\n*S KotlinDebug\n*F\n+ 1 HMSAudioManagerApi31.kt\nlive/hms/video/audio/manager/HMSAudioManagerApi31\n*L\n275#1:488\n275#1:489,3\n289#1:492\n289#1:493,3\n338#1:496\n338#1:497,3\n386#1:500\n386#1:501,3\n426#1:504\n426#1:505,2\n444#1:508\n444#1:509,3\n463#1:512\n463#1:513,3\n*E\n"})
public final class HMSAudioManagerApi31
implements HMSAudioManager {
    @NotNull
    private final Context context;
    @Nullable
    private final HMSAudioTrackSettings hmsAudioTrackSettings;
    @NotNull
    private final HMSAudioManager.AudioManagerDeviceChangeListener audioManagerDeviceChangeListener;
    @Nullable
    private final IErrorListener errorListener;
    @NotNull
    private final String TAG;
    @NotNull
    private final AudioManagerCompat androidAudioManager;
    @NotNull
    private AudioManagerUtil.AudioDevice defaultAudioDevice;
    @Nullable
    private AudioDeviceInfo userSelectedAudioDevice;
    private int savedAudioMode;
    private boolean savedIsSpeakerPhoneOn;
    private boolean savedIsMicrophoneMute;
    private boolean hasWiredHeadset;
    @NotNull
    private final Object TELEPHONY_LOCK;
    @NotNull
    private final Lazy mainHandler$delegate;
    @NotNull
    private HMSAudioManager.AudioManagerState state;
    @NotNull
    private final deviceCallback.1 deviceCallback;
    @Nullable
    private AudioManager.OnAudioFocusChangeListener audioFocusChangeListener;
    @NotNull
    private final List<AudioManagerFocusChangeCallbacks> focusChangeCallbacks;
    @Nullable
    private PhoneStateListener phoneStateChangeListener;

    public HMSAudioManagerApi31(@NotNull Context context, @NotNull AnalyticsEventsService analytics, @Nullable HMSAudioTrackSettings hmsAudioTrackSettings, @NotNull HMSAudioManager.AudioManagerDeviceChangeListener audioManagerDeviceChangeListener, @Nullable IErrorListener errorListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        Intrinsics.checkNotNullParameter((Object)audioManagerDeviceChangeListener, (String)"audioManagerDeviceChangeListener");
        this.context = context;
        this.hmsAudioTrackSettings = hmsAudioTrackSettings;
        this.audioManagerDeviceChangeListener = audioManagerDeviceChangeListener;
        this.errorListener = errorListener;
        this.TAG = "HMSAudioManagerApi31";
        AudioManagerCompat audioManagerCompat = AudioManagerCompat.create(this.context);
        Intrinsics.checkNotNullExpressionValue((Object)audioManagerCompat, (String)"create(context)");
        this.androidAudioManager = audioManagerCompat;
        this.defaultAudioDevice = AudioManagerUtil.AudioDevice.SPEAKER_PHONE;
        this.savedAudioMode = -2;
        this.TELEPHONY_LOCK = new Object();
        this.mainHandler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Handler>(this){
            final /* synthetic */ HMSAudioManagerApi31 this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Handler invoke() {
                return new Handler(this.this$0.getContext().getMainLooper());
            }
        }));
        this.state = HMSAudioManager.AudioManagerState.UNINITIALIZED;
        this.initialize();
        this.deviceCallback = new AudioDeviceCallback(this){
            final /* synthetic */ HMSAudioManagerApi31 this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void onAudioDevicesAdded(@NotNull AudioDeviceInfo[] addedDevices) {
                Collection<AudioManagerUtil.AudioDevice> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)addedDevices, (String)"addedDevices");
                super.onAudioDevicesAdded(addedDevices);
                AudioDeviceInfo[] audioDeviceInfoArray = addedDevices;
                StringBuilder stringBuilder = new StringBuilder().append("onAudioDevicesAdded :: ");
                String string = HMSAudioManagerApi31.access$getTAG$p(this.this$0);
                boolean $i$f$map = false;
                void var4_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var10_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(AudioDeviceMapping.fromPlatformType(it.getType()));
                }
                collection = (List)destination$iv$iv;
                HMSLogger.d(string, stringBuilder.append(collection).toString());
                HMSAudioManagerApi31.access$updateAudioDeviceState(this.this$0);
            }

            /*
             * WARNING - void declaration
             */
            public void onAudioDevicesRemoved(@NotNull AudioDeviceInfo[] removedDevices) {
                Collection<AudioManagerUtil.AudioDevice> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)removedDevices, (String)"removedDevices");
                super.onAudioDevicesRemoved(removedDevices);
                AudioDeviceInfo[] audioDeviceInfoArray = removedDevices;
                StringBuilder stringBuilder = new StringBuilder().append("onAudioDevicesRemoved :: ");
                String string = HMSAudioManagerApi31.access$getTAG$p(this.this$0);
                boolean $i$f$map = false;
                void var4_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var10_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(AudioDeviceMapping.fromPlatformType(it.getType()));
                }
                collection = (List)destination$iv$iv;
                HMSLogger.d(string, stringBuilder.append(collection).toString());
                HMSAudioManagerApi31.access$updateAudioDeviceState(this.this$0);
            }
        };
        this.focusChangeCallbacks = new ArrayList();
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Nullable
    public final HMSAudioTrackSettings getHmsAudioTrackSettings() {
        return this.hmsAudioTrackSettings;
    }

    @NotNull
    public final HMSAudioManager.AudioManagerDeviceChangeListener getAudioManagerDeviceChangeListener() {
        return this.audioManagerDeviceChangeListener;
    }

    @Nullable
    public final IErrorListener getErrorListener() {
        return this.errorListener;
    }

    private final Handler getMainHandler() {
        Lazy lazy = this.mainHandler$delegate;
        return (Handler)lazy.getValue();
    }

    @NotNull
    protected final HMSAudioManager.AudioManagerState getState() {
        return this.state;
    }

    protected final void setState(@NotNull HMSAudioManager.AudioManagerState audioManagerState) {
        Intrinsics.checkNotNullParameter((Object)((Object)audioManagerState), (String)"<set-?>");
        this.state = audioManagerState;
    }

    @Override
    public void addAudioFocusChangeCallback(@NotNull AudioManagerFocusChangeCallbacks callback2) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        this.focusChangeCallbacks.add(callback2);
    }

    @Override
    public void removeAudioFocusChangeCallback(@NotNull AudioManagerFocusChangeCallbacks callback2) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        this.focusChangeCallbacks.remove(callback2);
    }

    public final void initialize() {
        if (this.state == HMSAudioManager.AudioManagerState.UNINITIALIZED) {
            HMSLogger.d(this.TAG, "Initialized HMSAudioManagerApi31");
            this.savedAudioMode = this.androidAudioManager.getMode();
            this.savedIsSpeakerPhoneOn = this.androidAudioManager.isSpeakerphoneOn();
            this.savedIsMicrophoneMute = this.androidAudioManager.isMicrophoneMute();
            this.hasWiredHeadset = this.androidAudioManager.isWiredHeadsetOn();
            this.state = HMSAudioManager.AudioManagerState.PREINITIALIZED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initTelephony(IErrorListener onErrorListener) {
        if (this.hmsAudioTrackSettings != null && this.getMainHandler() != null && this.hmsAudioTrackSettings.getPhoneCallState() == PhoneCallState.DISABLE_MUTE_ON_VOIP_PHONE_CALL_RING) {
            Object object = this.TELEPHONY_LOCK;
            synchronized (object) {
                boolean bl = false;
                boolean bl2 = this.getMainHandler().post(() -> HMSAudioManagerApi31.initTelephony$lambda$1$lambda$0(this, onErrorListener));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deInitTelephony() {
        if (this.hmsAudioTrackSettings != null && this.getMainHandler() != null && this.phoneStateChangeListener != null && this.hmsAudioTrackSettings.getPhoneCallState() == PhoneCallState.DISABLE_MUTE_ON_VOIP_PHONE_CALL_RING) {
            Object object = this.TELEPHONY_LOCK;
            synchronized (object) {
                boolean bl = false;
                boolean bl2 = this.getMainHandler().post(() -> HMSAudioManagerApi31.deInitTelephony$lambda$3$lambda$2(this));
            }
        }
    }

    @Override
    public void start() {
        HMSLogger.d(this.TAG, "Started");
        this.createAudioFocusChangeListener();
        this.requestAudioFocus();
        if (this.errorListener != null) {
            this.initTelephony(new IErrorListener(this){
                final /* synthetic */ HMSAudioManagerApi31 this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onError(@NotNull HMSException error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    this.this$0.getErrorListener().onError(error);
                }
            });
        }
        this.androidAudioManager.registerAudioDeviceCallback(this.deviceCallback, null);
        this.androidAudioManager.setMicrophoneMute(false);
        this.state = HMSAudioManager.AudioManagerState.RUNNING;
        this.setAudioMode(3);
        this.updateAudioDeviceState();
    }

    private final void createAudioFocusChangeListener() {
        this.audioFocusChangeListener = arg_0 -> HMSAudioManagerApi31.createAudioFocusChangeListener$lambda$4(this, arg_0);
    }

    private final void requestAudioFocus() {
        AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(2).setContentType(1).build();
        AudioFocusRequest.Builder builder = new AudioFocusRequest.Builder(2).setAcceptsDelayedFocusGain(true).setAudioAttributes(audioAttributes);
        AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener = this.audioFocusChangeListener;
        Intrinsics.checkNotNull((Object)onAudioFocusChangeListener);
        AudioFocusRequest audioFocusRequest = builder.setOnAudioFocusChangeListener(onAudioFocusChangeListener).build();
        this.androidAudioManager.audioManager.requestAudioFocus(audioFocusRequest);
    }

    private final void sendAudioChangeEvent(AudioChangeEvent event) {
        for (AudioManagerFocusChangeCallbacks callback2 : this.focusChangeCallbacks) {
            callback2.onAudioFocusChange(event);
        }
    }

    @Override
    public boolean isStarted() {
        return this.state == HMSAudioManager.AudioManagerState.RUNNING;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<HMSAudioManager.AudioDevice> getAudioDevices() {
        void $this$mapTo$iv$iv;
        List<AudioDeviceInfo> list = this.androidAudioManager.getAvailableCommunicationDevices();
        Intrinsics.checkNotNullExpressionValue(list, (String)"androidAudioManager.availableCommunicationDevices");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AudioDeviceInfo audioDeviceInfo = (AudioDeviceInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(AudioDeviceMapping.toHMSMapping(AudioDeviceMapping.fromPlatformType(it.getType())));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public HMSAudioManager.AudioDevice getSelectedAudioDevice() {
        AudioDeviceInfo audioDeviceInfo = this.androidAudioManager.getCommunicationDevice();
        return AudioDeviceMapping.toHMSMapping(AudioDeviceMapping.fromPlatformType(audioDeviceInfo != null ? audioDeviceInfo.getType() : -1));
    }

    /*
     * WARNING - void declaration
     */
    private final List<HMSAudioDeviceInfo> groupAudioDevices() {
        void $this$mapTo$iv$iv;
        List<AudioDeviceInfo> list = this.androidAudioManager.getAvailableCommunicationDevices();
        Intrinsics.checkNotNullExpressionValue(list, (String)"androidAudioManager.availableCommunicationDevices");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AudioDeviceInfo audioDeviceInfo = (AudioDeviceInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            HMSAudioManager.AudioDevice type = AudioDeviceMapping.toHMSMapping(AudioDeviceMapping.fromPlatformType(it.getType()));
            String name = ((Object)it.getProductName()).toString();
            collection.add(new HMSAudioDeviceInfo(type, name));
        }
        List audioDeviceModel = (List)destination$iv$iv;
        return audioDeviceModel;
    }

    @Override
    @NotNull
    public List<HMSAudioDeviceInfo> getAudioDevicesInfoList() {
        return this.groupAudioDevices();
    }

    @Override
    public void setAudioMode(int audioMode) {
        if (this.isStarted()) {
            this.androidAudioManager.setMode(audioMode);
        }
    }

    @Override
    public void stop() {
        this.androidAudioManager.unregisterAudioDeviceCallback(this.deviceCallback);
        if (this.state == HMSAudioManager.AudioManagerState.UNINITIALIZED && this.userSelectedAudioDevice != null) {
            Log.d((String)this.TAG, (String)"Stopping audio manager after selecting audio device but never initializing. This indicates a service spun up solely to set audio device. Therefore skipping audio device reset.");
        } else {
            this.androidAudioManager.clearCommunicationDevice();
            this.setSpeakerphoneOn(this.savedIsSpeakerPhoneOn);
            this.setMicrophoneMute(this.savedIsMicrophoneMute);
            this.androidAudioManager.setMode(this.savedAudioMode);
        }
        this.deInitTelephony();
        this.androidAudioManager.abandonCallAudioFocus();
        Log.d((String)this.TAG, (String)"Abandoned audio focus for VOICE_CALL streams");
        this.state = HMSAudioManager.AudioManagerState.UNINITIALIZED;
        Log.d((String)this.TAG, (String)"Stopped");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void selectAudioDevice(@NotNull HMSAudioManager.AudioDevice device) {
        AudioDeviceInfo audioDeviceInfo;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)device), (String)"device");
        HMSLogger.d(this.TAG, "Manually Selecting " + (Object)((Object)device));
        List<AudioDeviceInfo> list = this.androidAudioManager.getAvailableCommunicationDevices();
        Intrinsics.checkNotNullExpressionValue(list, (String)"androidAudioManager.availableCommunicationDevices");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AudioDeviceInfo audioDeviceInfo2 = (AudioDeviceInfo)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(AudioDeviceMapping.toHMSMapping(AudioDeviceMapping.fromPlatformType(it.getType())));
        }
        CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Object object2 = this;
        if (device == HMSAudioManager.AudioDevice.AUTOMATIC) {
            audioDeviceInfo = null;
        } else {
            Object v5;
            block4: {
                List<AudioDeviceInfo> list2 = this.androidAudioManager.getAvailableCommunicationDevices();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"androidAudioManager.availableCommunicationDevices");
                Iterable iterable2 = list2;
                object = object2;
                Iterable iterable3 = iterable2;
                for (Object e : iterable3) {
                    AudioDeviceInfo it = (AudioDeviceInfo)e;
                    boolean bl = false;
                    boolean bl2 = AudioDeviceMapping.fromPlatformType(it.getType()) == AudioDeviceMapping.toSignalMapping(device);
                    if (!bl2) continue;
                    v5 = e;
                    break block4;
                }
                v5 = null;
            }
            object2 = object;
            audioDeviceInfo = v5;
        }
        ((HMSAudioManagerApi31)object2).userSelectedAudioDevice = audioDeviceInfo;
        this.updateAudioDeviceState();
    }

    private final void setSpeakerphoneOn(boolean on) {
        if (this.androidAudioManager.isSpeakerphoneOn() != on) {
            this.androidAudioManager.setSpeakerphoneOn(on);
        }
    }

    private final void setMicrophoneMute(boolean on) {
        if (this.androidAudioManager.isMicrophoneMute() != on) {
            this.androidAudioManager.setMicrophoneMute(on);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateAudioDeviceState() {
        List<AudioDeviceInfo> list = this.androidAudioManager.getAvailableCommunicationDevices();
        Intrinsics.checkNotNullExpressionValue(list, (String)"androidAudioManager.availableCommunicationDevices");
        List<AudioDeviceInfo> availableCommunicationDevices = list;
        AudioDeviceInfo candidate = this.userSelectedAudioDevice;
        if (candidate != null && candidate.getId() != 0) {
            HMSLogger.d(this.TAG, "Candidate found :: " + (Object)((Object)AudioDeviceMapping.fromPlatformType(candidate.getType())));
            boolean result2 = this.androidAudioManager.setCommunicationDevice(candidate);
            if (result2) {
                void $this$mapTo$iv$iv;
                AudioManagerUtil.AudioDevice signalDeviceMapping = AudioDeviceMapping.fromPlatformType(candidate.getType());
                HMSAudioManager.AudioDevice hmsDeviceMapping = AudioDeviceMapping.toHMSMapping(signalDeviceMapping);
                Iterable $this$map$iv = availableCommunicationDevices;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    AudioDeviceInfo audioDeviceInfo = (AudioDeviceInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(AudioDeviceMapping.toHMSMapping(AudioDeviceMapping.fromPlatformType(it.getType())));
                }
                Set deviceType = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                if (this.state == HMSAudioManager.AudioManagerState.UNINITIALIZED) {
                    return;
                }
                this.audioManagerDeviceChangeListener.onAudioDeviceChanged(hmsDeviceMapping, deviceType);
                this.audioManagerDeviceChangeListener.onAudioDeviceInfoChanged(hmsDeviceMapping, this.groupAudioDevices());
            } else {
                Log.w((String)this.TAG, (String)("Failed to set " + candidate.getId() + " of type " + candidate.getType() + "as communication device. switching to automatic selection"));
                this.setAutomaticSelection(availableCommunicationDevices);
                this.userSelectedAudioDevice = null;
            }
        } else {
            this.setAutomaticSelection(availableCommunicationDevices);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setAutomaticSelection(List<AudioDeviceInfo> availableCommunicationDevices) {
        Iterable $i$f$filterNot22;
        Object element$iv$iv;
        AudioDeviceInfo candidate = null;
        HMSLogger.d(this.TAG, "Automatic selection");
        AudioManagerUtil.AudioDevice[] audioDeviceArray = new AudioManagerUtil.AudioDevice[]{AudioManagerUtil.AudioDevice.BLUETOOTH, AudioManagerUtil.AudioDevice.WIRED_HEADSET, AudioManagerUtil.AudioDevice.SPEAKER_PHONE, AudioManagerUtil.AudioDevice.EARPIECE, AudioManagerUtil.AudioDevice.NONE};
        List searchOrder = CollectionsKt.distinct((Iterable)CollectionsKt.listOf((Object[])audioDeviceArray));
        for (Object deviceType : searchOrder) {
            Collection<Object> collection;
            block9: {
                Iterator $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv = availableCommunicationDevices;
                boolean $i$f$filterNot22 = false;
                Iterable iterable = $this$filterNot$iv;
                Collection<Object> destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                Iterator iterator = $this$filterNotTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv$iv = iterator.next();
                    AudioDeviceInfo it = (AudioDeviceInfo)element$iv$iv;
                    boolean bl = false;
                    CharSequence charSequence = it.getProductName();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"it.productName");
                    if (StringsKt.contains((CharSequence)charSequence, (CharSequence)" Watch", (boolean)true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $i$f$filterNot22 = (List)destination$iv$iv;
                $this$filterNotTo$iv$iv = $i$f$filterNot22.iterator();
                while ($this$filterNotTo$iv$iv.hasNext()) {
                    destination$iv$iv = $this$filterNotTo$iv$iv.next();
                    AudioDeviceInfo it = (AudioDeviceInfo)destination$iv$iv;
                    boolean bl = false;
                    if (!(AudioDeviceMapping.fromPlatformType(it.getType()) == deviceType)) continue;
                    collection = destination$iv$iv;
                    break block9;
                }
                collection = null;
            }
            if ((candidate = (AudioDeviceInfo)collection) == null) continue;
            HMSLogger.d(this.TAG, "Automatically selected -> " + (Object)((Object)AudioDeviceMapping.fromPlatformType(candidate.getType())));
            break;
        }
        if (candidate == null) {
            Collection<AudioManagerUtil.AudioDevice> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object deviceType;
            deviceType = availableCommunicationDevices;
            StringBuilder stringBuilder = new StringBuilder().append("Tried to switch audio devices but could not find suitable device in list of types: ");
            String string = this.TAG;
            boolean $i$f$map = false;
            $i$f$filterNot22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                element$iv$iv = (AudioDeviceInfo)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(AudioDeviceMapping.fromPlatformType(it.getType()));
            }
            collection = (List)destination$iv$iv;
            HMSLogger.e(string, stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, null, null, null, (int)0, null, null, (int)63, null)).toString());
            this.androidAudioManager.clearCommunicationDevice();
        } else {
            HMSLogger.d(this.TAG, "Switching to new device of type " + (Object)((Object)AudioDeviceMapping.fromPlatformType(candidate.getType())));
            boolean result2 = this.androidAudioManager.setCommunicationDevice(candidate);
            if (result2) {
                void $this$mapTo$iv$iv;
                HMSAudioManager.AudioDevice hmsDevice = AudioDeviceMapping.toHMSMapping(AudioDeviceMapping.fromPlatformType(candidate.getType()));
                Iterable $this$map$iv = availableCommunicationDevices;
                boolean $i$f$map = false;
                Iterable it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    AudioDeviceInfo audioDeviceInfo = (AudioDeviceInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(AudioDeviceMapping.toHMSMapping(AudioDeviceMapping.fromPlatformType(it2.getType())));
                }
                Set deviceType = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                this.audioManagerDeviceChangeListener.onAudioDeviceChanged(hmsDevice, deviceType);
                this.audioManagerDeviceChangeListener.onAudioDeviceInfoChanged(hmsDevice, this.groupAudioDevices());
            } else {
                Log.w((String)this.TAG, (String)("Failed to set " + candidate.getId() + " as communication device."));
            }
        }
    }

    private static final void initTelephony$lambda$1$lambda$0(HMSAudioManagerApi31 this$0, IErrorListener $onErrorListener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$onErrorListener, (String)"$onErrorListener");
        if (this$0.phoneStateChangeListener == null) {
            this$0.phoneStateChangeListener = new PhoneStateListener(this$0){
                final /* synthetic */ HMSAudioManagerApi31 this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onCallStateChanged(int state2, @NotNull String phoneNumber) {
                    Intrinsics.checkNotNullParameter((Object)phoneNumber, (String)"phoneNumber");
                    super.onCallStateChanged(state2, phoneNumber);
                    if (state2 == 2) {
                        HMSLogger.d(HMSAudioManagerApi31.access$getTAG$p(this.this$0), "onCallStateChanged: " + (Object)((Object)AudioChangeEvent.PHONE_RINGING));
                        HMSAudioManagerApi31.access$sendAudioChangeEvent(this.this$0, AudioChangeEvent.PHONE_RINGING);
                    }
                }
            };
        }
        Object object = this$0.context.getSystemService("phone");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.telephony.TelephonyManager");
        TelephonyManager telephonyManager = (TelephonyManager)object;
        if (Build.VERSION.SDK_INT >= 30) {
            if (ContextCompat.checkSelfPermission((Context)this$0.context, (String)"android.permission.READ_PHONE_STATE") == 0) {
                telephonyManager.listen(this$0.phoneStateChangeListener, 32);
            } else {
                $onErrorListener.onError(ErrorFactory.ReadPhoneStateError());
            }
        } else {
            telephonyManager.listen(this$0.phoneStateChangeListener, 32);
        }
    }

    private static final void deInitTelephony$lambda$3$lambda$2(HMSAudioManagerApi31 this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = this$0.context.getSystemService("phone");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.telephony.TelephonyManager");
        TelephonyManager telephonyManager = (TelephonyManager)object;
        if (ContextCompat.checkSelfPermission((Context)this$0.context, (String)"android.permission.READ_PHONE_STATE") == 0) {
            telephonyManager.listen(this$0.phoneStateChangeListener, 0);
        }
    }

    private static final void createAudioFocusChangeListener$lambda$4(HMSAudioManagerApi31 this$0, int focusChange) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        HMSLogger.d(this$0.TAG, "onAudioFocusChange: " + focusChange);
        switch (focusChange) {
            case 1: {
                this$0.sendAudioChangeEvent(AudioChangeEvent.AUDIOFOCUS_GAIN);
                this$0.androidAudioManager.clearCommunicationDevice();
                this$0.updateAudioDeviceState();
                break;
            }
            case 2: {
                this$0.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_GAIN_TRANSIENT);
                break;
            }
            case 4: {
                this$0.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_GAIN_EXCLUSIVE);
                break;
            }
            case 3: {
                this$0.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK);
                break;
            }
            case -1: {
                this$0.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_LOSS);
                break;
            }
            case -2: {
                this$0.sendAudioChangeEvent(AudioChangeEvent.AUDIOFOCUS_LOSS_TRANSIENT);
                break;
            }
            case -3: {
                this$0.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK);
                break;
            }
            default: {
                this$0.sendAudioChangeEvent(AudioChangeEvent.DEBUG_INVALID);
            }
        }
    }

    public static final /* synthetic */ String access$getTAG$p(HMSAudioManagerApi31 $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ void access$sendAudioChangeEvent(HMSAudioManagerApi31 $this, AudioChangeEvent event) {
        $this.sendAudioChangeEvent(event);
    }

    public static final /* synthetic */ void access$updateAudioDeviceState(HMSAudioManagerApi31 $this) {
        $this.updateAudioDeviceState();
    }
}

