/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.plugin.video.utils;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.os.Build;
import android.os.Handler;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.media.tracks.HMSLocalVideoTrack;
import live.hms.video.plugin.video.HMSVideoPlugin;
import live.hms.video.plugin.video.HMSVideoPluginType;
import live.hms.video.plugin.video.utils.HMSBitmapUpdateListener;
import live.hms.video.sdk.HMSPluginResultListener;
import live.hms.video.sdk.HMSSDK;
import live.hms.video.sdk.ProcessTimeVariables;
import live.hms.video.sdk.models.HMSLocalPeer;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.YuvFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.TextureBufferImpl;
import org.webrtc.VideoFrame;
import org.webrtc.YuvConverter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00172\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010(\u001a\u00020\u0017H\u0002J\b\u0010)\u001a\u00020\bH\u0016J\b\u0010*\u001a\u00020+H\u0016J\u0011\u0010,\u001a\u00020%H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0018\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u0012H\u0002J\b\u00101\u001a\u000202H\u0016J)\u00103\u001a\u00020%2\u0006\u00104\u001a\u0002052\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u00106\u001a\u0004\u0018\u000102H\u0016\u00a2\u0006\u0002\u00107J\u0010\u00108\u001a\u00020%2\u0006\u00109\u001a\u00020\bH\u0016J\b\u0010:\u001a\u00020%H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006<"}, d2={"Llive/hms/video/plugin/video/utils/HMSBitmapPlugin;", "Llive/hms/video/plugin/video/HMSVideoPlugin;", "hmsSDK", "Llive/hms/video/sdk/HMSSDK;", "hmsBitmapUpdateListener", "Llive/hms/video/plugin/video/utils/HMSBitmapUpdateListener;", "(Llive/hms/video/sdk/HMSSDK;Llive/hms/video/plugin/video/utils/HMSBitmapUpdateListener;)V", "effectsKey", "", "getHmsBitmapUpdateListener", "()Llive/hms/video/plugin/video/utils/HMSBitmapUpdateListener;", "getHmsSDK", "()Llive/hms/video/sdk/HMSSDK;", "imageAspectRatio", "", "inputFrameBitmap", "Landroid/graphics/Bitmap;", "inputHeight", "", "inputTextureBuffer", "Lorg/webrtc/VideoFrame$TextureBuffer;", "inputTimeQueue", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "", "inputWidth", "name", "originalFps", "originalHeight", "originalWidth", "outputListener", "Llive/hms/video/sdk/HMSPluginResultListener;", "startTimeQueue", "surfTextureHelper", "Lorg/webrtc/SurfaceTextureHelper;", "yuvConverter", "Lorg/webrtc/YuvConverter;", "drawOutputBitmapOnFrame", "", "newBitmap", "frameTs", "startTime", "getName", "getPluginType", "Llive/hms/video/plugin/video/HMSVideoPluginType;", "init", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initInputTextureBuffer", "newWidth", "newHeight", "isSupported", "", "processVideoFrame", "inputVideoFrame", "Lorg/webrtc/VideoFrame;", "skipProcessing", "(Lorg/webrtc/VideoFrame;Llive/hms/video/sdk/HMSPluginResultListener;Ljava/lang/Boolean;)V", "setKey", "key", "stop", "Companion", "lib_release"})
public final class HMSBitmapPlugin
implements HMSVideoPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HMSSDK hmsSDK;
    @NotNull
    private final HMSBitmapUpdateListener hmsBitmapUpdateListener;
    @NotNull
    private final YuvConverter yuvConverter;
    @Nullable
    private VideoFrame.TextureBuffer inputTextureBuffer;
    @Nullable
    private SurfaceTextureHelper surfTextureHelper;
    private int inputWidth;
    private int inputHeight;
    private int originalWidth;
    private int originalHeight;
    private int originalFps;
    private float imageAspectRatio;
    @Nullable
    private Bitmap inputFrameBitmap;
    @Nullable
    private String effectsKey;
    @NotNull
    private String name;
    @Nullable
    private HMSPluginResultListener outputListener;
    @NotNull
    private ConcurrentLinkedDeque<Long> startTimeQueue;
    @NotNull
    private ConcurrentLinkedDeque<Long> inputTimeQueue;
    @NotNull
    public static final String TAG = "HMSBitmapPlugin";
    @NotNull
    private static int[] textures = new int[1];
    private static int MIN_API_LEVEL = 21;
    private static final int DEFAULT_BLUR_PERCENTAGE = 75;

    public HMSBitmapPlugin(@NotNull HMSSDK hmsSDK, @NotNull HMSBitmapUpdateListener hmsBitmapUpdateListener) {
        Intrinsics.checkNotNullParameter((Object)hmsSDK, (String)"hmsSDK");
        Intrinsics.checkNotNullParameter((Object)hmsBitmapUpdateListener, (String)"hmsBitmapUpdateListener");
        this.hmsSDK = hmsSDK;
        this.hmsBitmapUpdateListener = hmsBitmapUpdateListener;
        this.yuvConverter = new YuvConverter();
        this.imageAspectRatio = 1.0f;
        this.name = "@100mslive/hms-bitmap-plugin";
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        this.startTimeQueue = new ConcurrentLinkedDeque();
        this.inputTimeQueue = new ConcurrentLinkedDeque();
    }

    @NotNull
    public final HMSSDK getHmsSDK() {
        return this.hmsSDK;
    }

    @NotNull
    public final HMSBitmapUpdateListener getHmsBitmapUpdateListener() {
        return this.hmsBitmapUpdateListener;
    }

    @Override
    @NotNull
    public HMSVideoPluginType getPluginType() {
        return HMSVideoPluginType.TRANSFORM;
    }

    @Override
    public void processVideoFrame(@NotNull VideoFrame inputVideoFrame, @Nullable HMSPluginResultListener outputListener, @Nullable Boolean skipProcessing) {
        Intrinsics.checkNotNullParameter((Object)inputVideoFrame, (String)"inputVideoFrame");
        HMSLogger.INSTANCE.v(TAG, "~~ New input frame received ~~");
        this.outputListener = outputListener;
        long startTime = System.currentTimeMillis();
        this.startTimeQueue.add(startTime);
        this.inputTimeQueue.add(inputVideoFrame.getTimestampNs());
        if (this.surfTextureHelper == null) {
            Object object = this.hmsSDK.getLocalPeer();
            this.surfTextureHelper = object != null && (object = ((HMSLocalPeer)object).getVideoTrack()) != null ? ((HMSLocalVideoTrack)object).getTextureHelper() : null;
        }
        YuvFrame inputYuvFrame = new YuvFrame(inputVideoFrame, 0, inputVideoFrame.getTimestampNs());
        this.inputFrameBitmap = inputYuvFrame.getBitmap();
        long timeAfterBitmapConvertion = System.currentTimeMillis();
        HMSLogger.INSTANCE.i(TAG, "~~ Time taken to convert input to bitmap :: " + (timeAfterBitmapConvertion - startTime) + " ms");
        Bitmap bitmap = this.inputFrameBitmap;
        Intrinsics.checkNotNull((Object)bitmap);
        int n = bitmap.getWidth();
        Bitmap bitmap2 = this.inputFrameBitmap;
        Intrinsics.checkNotNull((Object)bitmap2);
        this.initInputTextureBuffer(n, bitmap2.getHeight());
        Bitmap bitmap3 = this.inputFrameBitmap;
        Intrinsics.checkNotNull((Object)bitmap3);
        this.drawOutputBitmapOnFrame(this.hmsBitmapUpdateListener.onFrame(bitmap3), inputYuvFrame.timestamp, outputListener, startTime);
    }

    @Override
    public void stop() {
        this.originalWidth = 0;
        this.originalHeight = 0;
        this.originalFps = 0;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSupported() {
        return Build.VERSION.SDK_INT >= MIN_API_LEVEL;
    }

    @Override
    @Nullable
    public Object init(@NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final void initInputTextureBuffer(int newWidth, int newHeight) {
        if (this.inputWidth != newWidth || this.inputHeight != newHeight) {
            void $this$initInputTextureBuffer_u24lambda_u240;
            Matrix matrix;
            this.inputWidth = newWidth;
            this.inputHeight = newHeight;
            this.imageAspectRatio = (float)this.inputWidth / (float)this.inputHeight;
            VideoFrame.TextureBuffer textureBuffer = this.inputTextureBuffer;
            if (textureBuffer != null) {
                textureBuffer.release();
            }
            Matrix matrix2 = matrix = new Matrix();
            int n = textures[0];
            VideoFrame.TextureBuffer.Type type = VideoFrame.TextureBuffer.Type.RGB;
            int n2 = this.inputHeight;
            int n3 = this.inputWidth;
            HMSBitmapPlugin hMSBitmapPlugin = this;
            boolean bl = false;
            $this$initInputTextureBuffer_u24lambda_u240.postScale(-1.0f, 1.0f);
            Unit unit = Unit.INSTANCE;
            SurfaceTextureHelper surfaceTextureHelper = this.surfTextureHelper;
            Intrinsics.checkNotNull((Object)surfaceTextureHelper);
            Runnable runnable = null;
            YuvConverter yuvConverter = this.yuvConverter;
            Handler handler = surfaceTextureHelper.getHandler();
            Matrix matrix3 = matrix;
            int n4 = n;
            VideoFrame.TextureBuffer.Type type2 = type;
            int n5 = n2;
            int n6 = n3;
            hMSBitmapPlugin.inputTextureBuffer = (VideoFrame.TextureBuffer)new TextureBufferImpl(n6, n5, type2, n4, matrix3, handler, yuvConverter, runnable);
        }
    }

    private final void drawOutputBitmapOnFrame(Bitmap newBitmap, long frameTs, HMSPluginResultListener outputListener, long startTime) {
        block1: {
            SurfaceTextureHelper surfaceTextureHelper;
            if (newBitmap == null || this.surfTextureHelper == null) break block1;
            SurfaceTextureHelper surfaceTextureHelper2 = this.surfTextureHelper;
            Intrinsics.checkNotNull((Object)surfaceTextureHelper2);
            if (surfaceTextureHelper2.getHandler() != null && (surfaceTextureHelper = this.surfTextureHelper) != null && (surfaceTextureHelper = surfaceTextureHelper.getHandler()) != null) {
                surfaceTextureHelper.post(() -> HMSBitmapPlugin.drawOutputBitmapOnFrame$lambda$1(newBitmap, this, outputListener, frameTs, startTime));
            }
        }
    }

    @Override
    public void setKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        HMSVideoPlugin.DefaultImpls.setKey(this, key);
        this.effectsKey = key;
    }

    private static final void drawOutputBitmapOnFrame$lambda$1(Bitmap $newBitmap, HMSBitmapPlugin this$0, HMSPluginResultListener $outputListener, long $frameTs, long $startTime) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)$newBitmap, (String)"$newBitmap");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9728);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)$newBitmap, (int)0);
            VideoFrame.I420Buffer i420Buf = this$0.yuvConverter.convert(this$0.inputTextureBuffer);
            HMSPluginResultListener hMSPluginResultListener = $outputListener;
            if (hMSPluginResultListener != null) {
                hMSPluginResultListener.onOutputResult(new VideoFrame((VideoFrame.Buffer)i420Buf, 180, $frameTs));
            }
            ProcessTimeVariables processTime = ProcessTimeVariables.INSTANCE;
            processTime.setTimeTakenWithoutML(System.currentTimeMillis() - $startTime);
            HMSPluginResultListener hMSPluginResultListener2 = $outputListener;
            if (hMSPluginResultListener2 == null) break block1;
            hMSPluginResultListener2.onTimeTaken(processTime);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Llive/hms/video/plugin/video/utils/HMSBitmapPlugin$Companion;", "", "()V", "DEFAULT_BLUR_PERCENTAGE", "", "getDEFAULT_BLUR_PERCENTAGE", "()I", "MIN_API_LEVEL", "getMIN_API_LEVEL", "setMIN_API_LEVEL", "(I)V", "TAG", "", "textures", "", "getTextures", "()[I", "setTextures", "([I)V", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final int[] getTextures() {
            return textures;
        }

        public final void setTextures(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            textures = nArray;
        }

        public final int getMIN_API_LEVEL() {
            return MIN_API_LEVEL;
        }

        public final void setMIN_API_LEVEL(int n) {
            MIN_API_LEVEL = n;
        }

        public final int getDEFAULT_BLUR_PERCENTAGE() {
            return DEFAULT_BLUR_PERCENTAGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

