/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.events;

import android.annotation.SuppressLint;
import android.content.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import live.hms.video.database.entity.AnalyticsCluster;
import live.hms.video.database.entity.AnalyticsEntityModel;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.events.IAnalyticsTransport;
import live.hms.video.sdk.OfflineAnalyticsPeerInfo;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.sdk.models.HMSRoom;
import live.hms.video.sdk.models.enums.HMSAnalyticsEventLevel;
import live.hms.video.utils.HMSAgentOs;
import live.hms.video.utils.HMSLogger;
import live.hms.video.viewModels.OfflineAnalyticsManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0018J\b\u0010\u001b\u001a\u00020\u001cH\u0007J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0012J\u000e\u0010 \u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0018JB\u0010!\u001a\u00020\u001c2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Llive/hms/video/events/AnalyticsEventsService;", "", "context", "Landroid/content/Context;", "level", "Llive/hms/video/sdk/models/enums/HMSAnalyticsEventLevel;", "agentOs", "Llive/hms/video/utils/HMSAgentOs;", "isQa", "Lkotlin/Function0;", "", "offlineAnalyticsPeerInfo", "Llive/hms/video/sdk/OfflineAnalyticsPeerInfo;", "(Landroid/content/Context;Llive/hms/video/sdk/models/enums/HMSAnalyticsEventLevel;Llive/hms/video/utils/HMSAgentOs;Lkotlin/jvm/functions/Function0;Llive/hms/video/sdk/OfflineAnalyticsPeerInfo;)V", "offlineAnalyticsManager", "Llive/hms/video/viewModels/OfflineAnalyticsManager;", "pendingEvents", "Ljava/util/Deque;", "Llive/hms/video/events/AnalyticsEvent;", "sessionId", "", "token", "transports", "Ljava/util/ArrayList;", "Llive/hms/video/events/IAnalyticsTransport;", "addTransport", "transport", "flush", "", "flushExistingLogs", "queue", "event", "removeTransport", "updateAnalyticsParams", "hmsPeer", "Llive/hms/video/sdk/models/HMSPeer;", "hmsRoom", "Llive/hms/video/sdk/models/HMSRoom;", "websocketUrl", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nAnalyticsEventsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsEventsService.kt\nlive/hms/video/events/AnalyticsEventsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1855#2,2:167\n*S KotlinDebug\n*F\n+ 1 AnalyticsEventsService.kt\nlive/hms/video/events/AnalyticsEventsService\n*L\n157#1:167,2\n*E\n"})
public final class AnalyticsEventsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private HMSAnalyticsEventLevel level;
    @NotNull
    private final HMSAgentOs agentOs;
    @NotNull
    private final Function0<Boolean> isQa;
    @NotNull
    private final OfflineAnalyticsPeerInfo offlineAnalyticsPeerInfo;
    @NotNull
    private final OfflineAnalyticsManager offlineAnalyticsManager;
    @NotNull
    private String sessionId;
    @NotNull
    private String token;
    @NotNull
    private final ArrayList<IAnalyticsTransport> transports;
    @NotNull
    private final Deque<AnalyticsEvent> pendingEvents;
    @NotNull
    private static final String TAG = "AnalyticsEventsService";
    private static final int cMaxBufferSize = 100;

    public AnalyticsEventsService(@NotNull Context context, @NotNull HMSAnalyticsEventLevel level, @NotNull HMSAgentOs agentOs, @NotNull Function0<Boolean> isQa, @NotNull OfflineAnalyticsPeerInfo offlineAnalyticsPeerInfo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)agentOs, (String)"agentOs");
        Intrinsics.checkNotNullParameter(isQa, (String)"isQa");
        Intrinsics.checkNotNullParameter((Object)offlineAnalyticsPeerInfo, (String)"offlineAnalyticsPeerInfo");
        this.context = context;
        this.level = level;
        this.agentOs = agentOs;
        this.isQa = isQa;
        this.offlineAnalyticsPeerInfo = offlineAnalyticsPeerInfo;
        this.offlineAnalyticsManager = new OfflineAnalyticsManager(this.context, this.agentOs, this.isQa);
        this.sessionId = "";
        this.token = "";
        this.flushExistingLogs();
        this.transports = new ArrayList();
        this.pendingEvents = new ConcurrentLinkedDeque();
    }

    public final boolean addTransport(@NotNull IAnalyticsTransport transport) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        return this.transports.add(transport);
    }

    public final boolean removeTransport(@NotNull IAnalyticsTransport transport) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        return this.transports.remove(transport);
    }

    @NotNull
    public final synchronized AnalyticsEventsService queue(@NotNull AnalyticsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getLevel().ordinal() <= this.level.ordinal()) {
            HMSLogger.d(TAG, event + " queued");
            this.pendingEvents.addLast(event);
            if (this.pendingEvents.size() > 100) {
                AnalyticsEvent removedEvent = this.pendingEvents.pollFirst();
                HMSLogger.d(TAG, "Max buffer size reached, removing " + removedEvent + " to accommodate new events");
            }
        }
        return this;
    }

    private final void flushExistingLogs() {
        this.offlineAnalyticsManager.flushExistingLogs(this.context);
    }

    public final void updateAnalyticsParams(@Nullable String token, @Nullable String sessionId, @Nullable HMSPeer hmsPeer, @Nullable HMSRoom hmsRoom, @Nullable String websocketUrl) {
        OfflineAnalyticsPeerInfo offlineAnalyticsPeerInfo;
        String it;
        String string = token;
        if (string != null) {
            it = string;
            boolean bl = false;
            this.token = it;
        }
        String string2 = sessionId;
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            this.sessionId = it;
        }
        OfflineAnalyticsPeerInfo $this$updateAnalyticsParams_u24lambda_u242 = offlineAnalyticsPeerInfo = this.offlineAnalyticsPeerInfo;
        boolean bl = false;
        $this$updateAnalyticsParams_u24lambda_u242.updateWithPeer(hmsPeer);
        $this$updateAnalyticsParams_u24lambda_u242.updateWithRoom(hmsRoom);
        $this$updateAnalyticsParams_u24lambda_u242.updateWithToken(token);
        if (websocketUrl != null) {
            $this$updateAnalyticsParams_u24lambda_u242.setWebsocketUrl(websocketUrl);
        }
    }

    public static /* synthetic */ void updateAnalyticsParams$default(AnalyticsEventsService analyticsEventsService2, String string, String string2, HMSPeer hMSPeer, HMSRoom hMSRoom, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            hMSPeer = null;
        }
        if ((n & 8) != 0) {
            hMSRoom = null;
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        analyticsEventsService2.updateAnalyticsParams(string, string2, hMSPeer, hMSRoom, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"HardwareIds"})
    public final synchronized void flush() {
        if (this.pendingEvents.isEmpty()) {
            return;
        }
        if (this.transports.isEmpty()) {
            HMSLogger.INSTANCE.w(TAG, "No valid signalling api found to flush analytics, trying to send via REST API");
            for (AnalyticsEvent events : this.pendingEvents) {
                AnalyticsEntityModel analyticsEntityModel;
                AnalyticsEvent event = this.pendingEvents.peek();
                if (event == null) continue;
                boolean bl = false;
                long l = event.getTimestamp();
                String string = this.agentOs.getUniqueEventId(event);
                String string2 = this.agentOs.getDeviceId(this.context);
                String string3 = event.getName();
                HashMap<String, Object> hashMap = event.getProperties();
                String string4 = this.token;
                String string5 = this.offlineAnalyticsPeerInfo.getWebsocketUrl();
                if (string5 == null) {
                    string5 = "";
                }
                AnalyticsCluster analyticsCluster = new AnalyticsCluster(string5);
                AnalyticsEntityModel $this$flush_u24lambda_u244_u24lambda_u243 = analyticsEntityModel = new AnalyticsEntityModel(l, string, string2, null, hashMap, string3, string4, false, null, analyticsCluster, 392, null);
                boolean bl2 = false;
                $this$flush_u24lambda_u244_u24lambda_u243.setAnalyticsPeer(this.offlineAnalyticsPeerInfo.getAnalyticsPeer());
                AnalyticsEntityModel logEntityModel = analyticsEntityModel;
                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, logEntityModel, event, null){
                    int label;
                    final /* synthetic */ AnalyticsEventsService this$0;
                    final /* synthetic */ AnalyticsEntityModel $logEntityModel;
                    final /* synthetic */ AnalyticsEvent $event;
                    {
                        this.this$0 = $receiver;
                        this.$logEntityModel = $logEntityModel;
                        this.$event = $event;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = AnalyticsEventsService.access$getOfflineAnalyticsManager$p(this.this$0).flushLog(this.$logEntityModel, (Continuation<? super Boolean>)((Continuation)this));
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                if (isSuccess = ((Boolean)v0).booleanValue()) {
                                    AnalyticsEventsService.access$getPendingEvents$p(this.this$0).remove(this.$event);
                                } else {
                                    AnalyticsEventsService.access$getOfflineAnalyticsManager$p(this.this$0).persistLog(this.$logEntityModel);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        } else {
            HMSLogger.d(TAG, "Sending analytics via websocket");
            Deque<AnalyticsEvent> deque = this.pendingEvents;
            synchronized (deque) {
                boolean bl = false;
                while (!((Collection)this.pendingEvents).isEmpty()) {
                    AnalyticsEvent event;
                    AnalyticsEvent analyticsEvent = event = this.pendingEvents.pollFirst();
                    if (analyticsEvent == null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)analyticsEvent, (String)"event");
                    AnalyticsEvent it = event;
                    boolean bl3 = false;
                    Iterable $this$forEach$iv = this.transports;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IAnalyticsTransport it2 = (IAnalyticsTransport)element$iv;
                        boolean bl4 = false;
                        it2.event(event);
                    }
                    BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
                        int label;
                        final /* synthetic */ AnalyticsEventsService this$0;
                        final /* synthetic */ AnalyticsEvent $event;
                        {
                            this.this$0 = $receiver;
                            this.$event = $event;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    OfflineAnalyticsManager offlineAnalyticsManager = AnalyticsEventsService.access$getOfflineAnalyticsManager$p(this.this$0);
                                    HMSAgentOs hMSAgentOs = AnalyticsEventsService.access$getAgentOs$p(this.this$0);
                                    AnalyticsEvent analyticsEvent = this.$event;
                                    Intrinsics.checkNotNullExpressionValue((Object)analyticsEvent, (String)"event");
                                    this.label = 1;
                                    Object object3 = offlineAnalyticsManager.deleteLogById(hMSAgentOs.getUniqueEventId(analyticsEvent), (Continuation<? super Unit>)((Continuation)this));
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public static final /* synthetic */ OfflineAnalyticsManager access$getOfflineAnalyticsManager$p(AnalyticsEventsService $this) {
        return $this.offlineAnalyticsManager;
    }

    public static final /* synthetic */ Deque access$getPendingEvents$p(AnalyticsEventsService $this) {
        return $this.pendingEvents;
    }

    public static final /* synthetic */ HMSAgentOs access$getAgentOs$p(AnalyticsEventsService $this) {
        return $this.agentOs;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Llive/hms/video/events/AnalyticsEventsService$Companion;", "", "()V", "TAG", "", "cMaxBufferSize", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

