/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.streams;

import android.app.Notification;
import android.content.Context;
import android.content.Intent;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.factories.HMSPeerConnectionFactory;
import live.hms.video.factories.MediaConstraintsFactory;
import live.hms.video.media.capturers.HMSAudioCapturer;
import live.hms.video.media.capturers.HMSCameraCapturer;
import live.hms.video.media.capturers.HMSCapturer;
import live.hms.video.media.capturers.HMSScreenCapturer;
import live.hms.video.media.settings.HMSAudioTrackSettings;
import live.hms.video.media.settings.HMSVideoTrackSettings;
import live.hms.video.plugin.video.HMSVideoPlugin;
import live.hms.video.plugin.video.HMSVideoPluginsManager;
import live.hms.video.sdk.HMSActionResultListener;
import live.hms.video.sdk.models.enums.AudioMixingMode;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.IdHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;
import org.webrtc.voiceengine.WebRtcAudioUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004J\u0006\u0010\u0017\u001a\u00020\nJ\u001a\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\f\u0018\u00010\u0019j\n\u0012\u0004\u0012\u00020\f\u0018\u0001`\u001aJ@\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0(J\u001e\u0010)\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0015J\u001e\u0010/\u001a\u0002002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010,\u001a\u0002012\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u00102\u001a\u0002032\u0006\u0010\u001f\u001a\u00020+2\b\b\u0002\u00104\u001a\u00020\u0015J@\u00105\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020+2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u00106\u001a\u0002012\b\u00107\u001a\u0004\u0018\u00010&2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\n0(J\u000e\u00109\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Llive/hms/video/media/streams/HMSStreamFactory;", "", "()V", "TAG", "", "pluginsManager", "Llive/hms/video/plugin/video/HMSVideoPluginsManager;", "videoSource", "Lorg/webrtc/VideoSource;", "addPlugin", "", "plugin", "Llive/hms/video/plugin/video/HMSVideoPlugin;", "resultListener", "Llive/hms/video/sdk/HMSActionResultListener;", "inputFrameRate", "", "pluginFrameRate", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "isEffectsSdkEnabled", "", "effectsKey", "clean", "getPlugins", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "makeAudioShareCapturer", "Llive/hms/video/media/capturers/HMSCapturer;", "context", "Landroid/content/Context;", "peerConnectionFactory", "Llive/hms/video/factories/HMSPeerConnectionFactory;", "audioMixingMode", "Llive/hms/video/sdk/models/enums/AudioMixingMode;", "mediaProjectionPermissionResultData", "Landroid/content/Intent;", "audioShareNotification", "Landroid/app/Notification;", "endAudioShare", "Lkotlin/Function0;", "makeLocalAudioTrack", "Lorg/webrtc/AudioTrack;", "Lorg/webrtc/PeerConnectionFactory;", "settings", "Llive/hms/video/media/settings/HMSAudioTrackSettings;", "enableWebrtcNoiseSuppressor", "makeLocalVideoCapturer", "Llive/hms/video/media/capturers/HMSCameraCapturer;", "Llive/hms/video/media/settings/HMSVideoTrackSettings;", "makeLocalVideoTrack", "Lorg/webrtc/VideoTrack;", "isScreenShare", "makeScreenShareCapturer", "hmsVideoTrackSettings", "screenShareNotification", "endScreenShare", "removePlugin", "lib_release"})
public final class HMSStreamFactory {
    @NotNull
    public static final HMSStreamFactory INSTANCE = new HMSStreamFactory();
    @NotNull
    private static final String TAG = "HMSStreamHelper";
    private static VideoSource videoSource;
    @Nullable
    private static HMSVideoPluginsManager pluginsManager;

    private HMSStreamFactory() {
    }

    @NotNull
    public final AudioTrack makeLocalAudioTrack(@NotNull PeerConnectionFactory peerConnectionFactory, @NotNull HMSAudioTrackSettings settings, boolean enableWebrtcNoiseSuppressor) {
        Intrinsics.checkNotNullParameter((Object)peerConnectionFactory, (String)"peerConnectionFactory");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        WebRtcAudioUtils.setWebRtcBasedAcousticEchoCanceler((boolean)true);
        WebRtcAudioUtils.setWebRtcBasedAutomaticGainControl((boolean)true);
        WebRtcAudioUtils.setWebRtcBasedNoiseSuppressor((enableWebrtcNoiseSuppressor && settings.getEnableNoiseSupression() ? 1 : 0) != 0);
        AudioSource source = peerConnectionFactory.createAudioSource(MediaConstraintsFactory.INSTANCE.makeLocalAudioTrackConstraints(settings, enableWebrtcNoiseSuppressor));
        String trackId = IdHelper.INSTANCE.makeAudioMediaStreamTrackId();
        AudioTrack track = peerConnectionFactory.createAudioTrack(trackId, source);
        track.setVolume(settings.getVolume());
        HMSLogger.d(TAG, "Initialized local AudioTrack with id=" + trackId);
        Intrinsics.checkNotNullExpressionValue((Object)track, (String)"track");
        return track;
    }

    @NotNull
    public final VideoTrack makeLocalVideoTrack(@NotNull PeerConnectionFactory peerConnectionFactory, boolean isScreenShare) {
        Intrinsics.checkNotNullParameter((Object)peerConnectionFactory, (String)"peerConnectionFactory");
        VideoSource videoSource = peerConnectionFactory.createVideoSource(isScreenShare);
        Intrinsics.checkNotNullExpressionValue((Object)videoSource, (String)"peerConnectionFactory.cr\u2026ideoSource(isScreenShare)");
        HMSStreamFactory.videoSource = videoSource;
        String trackId = IdHelper.INSTANCE.makeVideoMediaStreamTrackId();
        VideoSource videoSource2 = HMSStreamFactory.videoSource;
        if (videoSource2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"videoSource");
            videoSource2 = null;
        }
        VideoTrack track = peerConnectionFactory.createVideoTrack(trackId, videoSource2);
        HMSLogger.d(TAG, "Initialized local VideoTrack with id=" + trackId);
        Intrinsics.checkNotNullExpressionValue((Object)track, (String)"track");
        return track;
    }

    public static /* synthetic */ VideoTrack makeLocalVideoTrack$default(HMSStreamFactory hMSStreamFactory, PeerConnectionFactory peerConnectionFactory, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return hMSStreamFactory.makeLocalVideoTrack(peerConnectionFactory, bl);
    }

    @NotNull
    public final HMSCameraCapturer makeLocalVideoCapturer(@NotNull Context context, @NotNull HMSVideoTrackSettings settings, @NotNull AnalyticsEventsService analyticsEventsService2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService2, (String)"analyticsEventsService");
        VideoSource videoSource = HMSStreamFactory.videoSource;
        if (videoSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"videoSource");
            videoSource = null;
        }
        return new HMSCameraCapturer(context, videoSource, settings, analyticsEventsService2);
    }

    @NotNull
    public final HMSCapturer makeScreenShareCapturer(@NotNull Context context, @NotNull PeerConnectionFactory peerConnectionFactory, @Nullable Intent mediaProjectionPermissionResultData, @NotNull HMSVideoTrackSettings hmsVideoTrackSettings, @Nullable Notification screenShareNotification, @NotNull Function0<Unit> endScreenShare) {
        VideoSource videoSource;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)peerConnectionFactory, (String)"peerConnectionFactory");
        Intrinsics.checkNotNullParameter((Object)hmsVideoTrackSettings, (String)"hmsVideoTrackSettings");
        Intrinsics.checkNotNullParameter(endScreenShare, (String)"endScreenShare");
        if (HMSStreamFactory.videoSource == null) {
            VideoSource videoSource2 = peerConnectionFactory.createVideoSource(false);
            Intrinsics.checkNotNullExpressionValue((Object)videoSource2, (String)"peerConnectionFactory.createVideoSource(false)");
            HMSStreamFactory.videoSource = videoSource2;
        }
        if ((videoSource = HMSStreamFactory.videoSource) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"videoSource");
            videoSource = null;
        }
        return new HMSScreenCapturer(context, videoSource, mediaProjectionPermissionResultData, hmsVideoTrackSettings, screenShareNotification, endScreenShare);
    }

    @NotNull
    public final HMSCapturer makeAudioShareCapturer(@NotNull Context context, @NotNull HMSPeerConnectionFactory peerConnectionFactory, @NotNull AudioMixingMode audioMixingMode, @Nullable Intent mediaProjectionPermissionResultData, @Nullable Notification audioShareNotification, @NotNull Function0<Unit> endAudioShare) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)peerConnectionFactory, (String)"peerConnectionFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)audioMixingMode), (String)"audioMixingMode");
        Intrinsics.checkNotNullParameter(endAudioShare, (String)"endAudioShare");
        return new HMSAudioCapturer(context, peerConnectionFactory, audioMixingMode, mediaProjectionPermissionResultData, audioShareNotification, endAudioShare);
    }

    public final void addPlugin(@NotNull HMSVideoPlugin plugin, @NotNull HMSActionResultListener resultListener, int inputFrameRate, int pluginFrameRate, @NotNull AnalyticsEventsService analyticsEventsService2, boolean isEffectsSdkEnabled, @NotNull String effectsKey) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)resultListener, (String)"resultListener");
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService2, (String)"analyticsEventsService");
        Intrinsics.checkNotNullParameter((Object)effectsKey, (String)"effectsKey");
        if ((!isEffectsSdkEnabled || ((CharSequence)effectsKey).length() == 0) && (Intrinsics.areEqual((Object)plugin.getName(), (Object)"@100mslive/hms-blur-filter") || Intrinsics.areEqual((Object)plugin.getName(), (Object)"@100mslive/hms-virtual-background"))) {
            resultListener.onError(ErrorFactory.GenericErrors.Unknown$default(ErrorFactory.GenericErrors.INSTANCE, ErrorFactory.Action.PLUGIN, "Effects SDK plugin needs to be enabled from dashboard. Please contact sales `sales@100ms.live` ", null, null, 12, null));
            return;
        }
        if (Intrinsics.areEqual((Object)plugin.getName(), (Object)"@100mslive/hms-blur-filter") || Intrinsics.areEqual((Object)plugin.getName(), (Object)"@100mslive/hms-virtual-background")) {
            plugin.setKey(effectsKey);
        }
        if (pluginsManager == null) {
            HMSLogger.INSTANCE.i("HMSVideoPluginsManager", "initializing plugin manager");
            VideoSource videoSource = HMSStreamFactory.videoSource;
            if (videoSource == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"videoSource");
                videoSource = null;
            }
            HMSVideoPluginsManager hMSVideoPluginsManager = pluginsManager = new HMSVideoPluginsManager(videoSource, analyticsEventsService2);
            Intrinsics.checkNotNull((Object)hMSVideoPluginsManager);
            hMSVideoPluginsManager.setInputFps(inputFrameRate);
        }
        try {
            HMSVideoPluginsManager hMSVideoPluginsManager = pluginsManager;
            if (hMSVideoPluginsManager != null) {
                hMSVideoPluginsManager.addPlugin(plugin, resultListener, pluginFrameRate);
            }
        }
        catch (HMSException err) {
            HMSLogger.INSTANCE.i("HMSVideoPluginsManager", " Adding plugin " + plugin + " getting error:" + err);
            throw err;
        }
    }

    public final void removePlugin(@NotNull HMSVideoPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        try {
            HMSVideoPluginsManager hMSVideoPluginsManager = pluginsManager;
            if (hMSVideoPluginsManager != null) {
                hMSVideoPluginsManager.removePlugin(plugin);
            }
        }
        catch (HMSException err) {
            HMSLogger.INSTANCE.i("HMSVideoPluginsManager", " Removing plugin " + plugin + " getting error: " + err);
            throw err;
        }
    }

    @Nullable
    public final ArrayList<HMSVideoPlugin> getPlugins() {
        ArrayList<HMSVideoPlugin> plugins = null;
        try {
            HMSVideoPluginsManager hMSVideoPluginsManager = pluginsManager;
            plugins = hMSVideoPluginsManager != null ? hMSVideoPluginsManager.getPlugins() : null;
        }
        catch (HMSException err) {
            HMSLogger.INSTANCE.i("HMSVideoPluginsManager", " List of plugins call giving error: " + err);
            throw err;
        }
        return plugins;
    }

    public final void clean() {
        HMSVideoPluginsManager hMSVideoPluginsManager = pluginsManager;
        if (hMSVideoPluginsManager != null) {
            hMSVideoPluginsManager.clean();
        }
        pluginsManager = null;
    }
}

